/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.server.api.AbstractMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class SubstringMatchingRule
extends AbstractMatchingRule
implements MatchingRule {
    public abstract ByteString normalizeSubstring(ByteSequence var1) throws DirectoryException;

    public boolean valueMatchesSubstring(ByteSequence value, ByteSequence subInitial, List<ByteSequence> subAnyElements, ByteSequence subFinal) {
        int pos;
        int valueLength = value.length();
        if (subInitial != null) {
            int initialLength = subInitial.length();
            if (initialLength > valueLength) {
                return false;
            }
            for (pos = 0; pos < initialLength; ++pos) {
                if (subInitial.byteAt(pos) == value.byteAt(pos)) continue;
                return false;
            }
        }
        if (subAnyElements != null && !subAnyElements.isEmpty()) {
            for (ByteSequence element : subAnyElements) {
                int anyLength = element.length();
                if (anyLength == 0) continue;
                int end = valueLength - anyLength;
                boolean match = false;
                while (pos <= end) {
                    if (element.byteAt(0) == value.byteAt(pos)) {
                        boolean subMatch = true;
                        for (int i = 1; i < anyLength; ++i) {
                            if (element.byteAt(i) == value.byteAt(pos + i)) continue;
                            subMatch = false;
                            break;
                        }
                        if (subMatch) {
                            match = subMatch;
                            break;
                        }
                    }
                    ++pos;
                }
                if (match) {
                    pos += anyLength;
                    continue;
                }
                return false;
            }
        }
        if (subFinal != null) {
            int finalLength = subFinal.length();
            if (valueLength - finalLength < pos) {
                return false;
            }
            pos = valueLength - finalLength;
            int i = 0;
            while (i < finalLength) {
                if (subFinal.byteAt(i) != value.byteAt(pos)) {
                    return false;
                }
                ++i;
                ++pos;
            }
        }
        return true;
    }
}

