/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.LinkedList;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.DecodingException;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.server.AbstractConfigListenerAdaptor;
import org.opends.server.admin.server.ConstraintViolationException;
import org.opends.server.admin.server.DNBuilder;
import org.opends.server.admin.server.ServerConstraintHandler;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.server.ServerManagedObjectAddListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigAddListenerAdaptor<S extends Configuration>
extends AbstractConfigListenerAdaptor
implements ConfigAddListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ServerManagedObject<? extends S> cachedManagedObject;
    private final InstantiableRelationDefinition<?, S> instantiableRelation;
    private final SetRelationDefinition<?, S> setRelation;
    private final ServerManagedObjectAddListener<S> listener;
    private final OptionalRelationDefinition<?, S> optionalRelation;
    private final ManagedObjectPath<?, ?> path;

    public ConfigAddListenerAdaptor(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, S> relation, ServerManagedObjectAddListener<S> listener) {
        this.path = path;
        this.instantiableRelation = relation;
        this.optionalRelation = null;
        this.setRelation = null;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    public ConfigAddListenerAdaptor(ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, S> relation, ServerManagedObjectAddListener<S> listener) {
        this.path = path;
        this.optionalRelation = relation;
        this.instantiableRelation = null;
        this.setRelation = null;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    public ConfigAddListenerAdaptor(ManagedObjectPath<?, ?> path, SetRelationDefinition<?, S> relation, ServerManagedObjectAddListener<S> listener) {
        this.path = path;
        this.instantiableRelation = null;
        this.optionalRelation = null;
        this.setRelation = relation;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        ConfigChangeResult result;
        if (this.optionalRelation != null) {
            ManagedObjectPath<?, S> childPath = this.path.child(this.optionalRelation);
            DN expectedDN = DNBuilder.create(childPath);
            if (!configEntry.getDN().equals(expectedDN)) {
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }
        }
        if ((result = this.listener.applyConfigurationAdd(this.cachedManagedObject)).getResultCode() == ResultCode.SUCCESS) {
            ManagedObjectDefinition<?, S> d = this.cachedManagedObject.getManagedObjectDefinition();
            for (Constraint constraint : d.getAllConstraints()) {
                for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                    try {
                        handler.performPostAdd(this.cachedManagedObject);
                    }
                    catch (ConfigException e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean configAddIsAcceptable(ConfigEntry configEntry, MessageBuilder unacceptableReason) {
        DN dn = configEntry.getDN();
        AttributeValue av = dn.getRDN().getAttributeValue(0);
        String name = av.getValue().toString().trim();
        try {
            ManagedObjectPath<?, S> childPath;
            if (this.instantiableRelation != null) {
                childPath = this.path.child(this.instantiableRelation, name);
            } else if (this.setRelation != null) {
                try {
                    childPath = this.path.child(this.setRelation, name);
                }
                catch (IllegalArgumentException e) {
                    throw new DefinitionDecodingException(this.setRelation.getChildDefinition(), DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION);
                }
            } else {
                childPath = this.path.child(this.optionalRelation);
                DN expectedDN = DNBuilder.create(childPath);
                if (!dn.equals(expectedDN)) {
                    return true;
                }
            }
            ServerManagementContext context = ServerManagementContext.getInstance();
            this.cachedManagedObject = context.decode(childPath, configEntry, configEntry);
        }
        catch (DecodingException e) {
            unacceptableReason.append(e.getMessageObject());
            return false;
        }
        try {
            this.cachedManagedObject.ensureIsUsable();
        }
        catch (ConstraintViolationException e) {
            this.generateUnacceptableReason(e.getMessages(), unacceptableReason);
            return false;
        }
        LinkedList<Message> reasons = new LinkedList<Message>();
        if (this.listener.isConfigurationAddAcceptable(this.cachedManagedObject, reasons)) {
            return true;
        }
        this.generateUnacceptableReason(reasons, unacceptableReason);
        return false;
    }

    ServerManagedObjectAddListener<S> getServerManagedObjectAddListener() {
        return this.listener;
    }
}

