/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.doc;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.messages.Message;
import org.opends.server.admin.ACIPropertyDefinition;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IPAddressMaskPropertyDefinition;
import org.opends.server.admin.IPAddressPropertyDefinition;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.LDAPProfile;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelationOption;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.std.meta.RootCfgDefn;
import org.opends.server.types.InitializationException;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.EmbeddedUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigGuideGeneration {
    private static final String ACI_SYNTAX_REL_URL = "/page/ACISyntax";
    private static final String DURATION_SYNTAX_REL_URL = "/page/DefinitionDuration";
    private final String CSS_FILE = "opends-config.css";
    private final String MAIN_FILE = "index.html";
    private final String INHERITANCE_TREE_FILE = "ManagedObjectInheritanceTree.html";
    private final String RELATION_TREE_FILE = "ManagedObjectRelationTree.html";
    private final String MO_LIST_FILE = "ManagedObjectList.html";
    private final String PROPERTIES_INDEX_FILE = "PropertiesIndex.html";
    private final String WELCOME_FILE = "welcome.html";
    private final String MAINTOP_FILE = "maintop.html";
    private final String INDEX_FILE = "index.html";
    private static final String CONFIG_GUIDE_DIR = "opends_config_guide";
    private final String MAIN_FRAME = "mainFrame";
    private final TreeMap<String, RelationDefinition> topRelList = new TreeMap();
    private final TreeMap<String, RelationDefinition> relList = new TreeMap();
    private final TreeMap<String, TreeMap<String, RelationDefinition>> catTopRelList = new TreeMap();
    private final TreeMap<String, AbstractManagedObjectDefinition> moList = new TreeMap();
    private final TreeMap<String, AbstractManagedObjectDefinition> topMoList = new TreeMap();
    private final TreeMap<String, TreeMap<String, AbstractManagedObjectDefinition>> catTopMoList = new TreeMap();
    private final int ind = 0;
    private StringBuffer htmlBuff = new StringBuffer();
    private static String generationDir;
    private static boolean ldapMapping;
    private static String opendsWiki;
    private static String opendsHome;
    private static String aciSyntaxPage;
    private static String durationSyntaxPage;
    private boolean inList = false;
    private int listLevel = 0;

    public static void main(String[] args) {
        Properties properties = System.getProperties();
        generationDir = properties.getProperty("GenerationDir");
        if (generationDir == null) {
            generationDir = System.getProperty("java.io.tmpdir") + File.separator + CONFIG_GUIDE_DIR;
        }
        try {
            new File(generationDir).mkdir();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Generation directory is : " + generationDir);
        if (properties.getProperty("LdapMapping") != null) {
            ldapMapping = true;
        }
        if ((opendsWiki = properties.getProperty("OpendsWiki")) == null) {
            opendsWiki = "https://www.opends.org/wiki";
        }
        aciSyntaxPage = opendsWiki + ACI_SYNTAX_REL_URL;
        durationSyntaxPage = opendsWiki + DURATION_SYNTAX_REL_URL;
        opendsHome = properties.getProperty("OpendsHome");
        if (opendsHome == null) {
            opendsHome = "http://www.opends.org";
        }
        ConfigGuideGeneration myGen = new ConfigGuideGeneration();
        myGen.generate();
    }

    private void generate() {
        this.init();
        this.genManagedObjectRelationTree(this.catTopRelList);
        this.genManagedObjectInheritanceTree(this.catTopMoList);
        this.genAllManagedObject(this.topMoList);
        this.genManagedObjectList(this.moList);
        this.genPropertiesIndex();
        this.genIndexPage();
        this.genMainTopPage();
        this.genWelcomePage();
    }

    private void init() {
        RootCfgDefn rootCfg = RootCfgDefn.getInstance();
        for (RelationDefinition<?, ?> rel : rootCfg.getAllRelationDefinitions()) {
            this.topRelList.put(rel.getChildDefinition().getName(), rel);
        }
        EmbeddedUtils.initializeForClientUse();
        try {
            ClassLoaderProvider.getInstance().enable();
        }
        catch (InitializationException e) {
            System.err.println("ERROR : Cannot enable the client-side class loader.");
            e.printStackTrace();
            System.exit(1);
        }
        ClassPropertyDefinition.setAllowClassValidation(false);
        AttributeTypePropertyDefinition.setCheckSchema(false);
        TopCfgDefn topCfg = TopCfgDefn.getInstance();
        Collection topObjects = topCfg.getChildren();
        for (AbstractManagedObjectDefinition abstractManagedObjectDefinition : topObjects) {
            if (abstractManagedObjectDefinition.getName().equals("")) continue;
            this.topMoList.put(abstractManagedObjectDefinition.getName(), abstractManagedObjectDefinition);
        }
        for (RelationDefinition relationDefinition : this.topRelList.values()) {
            AbstractManagedObjectDefinition mo = relationDefinition.getChildDefinition();
            Collection<Tag> tags = mo.getAllTags();
            for (Tag tag : tags) {
                TreeMap catMap = this.catTopRelList.get(tag.getName());
                if (catMap == null) {
                    catMap = new TreeMap();
                    this.catTopRelList.put(tag.getName(), catMap);
                }
                catMap.put(mo.getName(), relationDefinition);
            }
        }
        for (AbstractManagedObjectDefinition abstractManagedObjectDefinition : this.topMoList.values()) {
            Collection<Tag> tags = abstractManagedObjectDefinition.getAllTags();
            for (Tag tag : tags) {
                TreeMap catMap = this.catTopMoList.get(tag.getName());
                if (catMap == null) {
                    catMap = new TreeMap();
                    this.catTopMoList.put(tag.getName(), catMap);
                }
                catMap.put(abstractManagedObjectDefinition.getName(), abstractManagedObjectDefinition);
            }
        }
    }

    private void genManagedObjectInheritanceTree(TreeMap<String, TreeMap<String, AbstractManagedObjectDefinition>> list) {
        this.htmlHeader(DynamicConstants.PRODUCT_NAME + " " + "Configuration Reference - Inheritance View");
        this.tabMenu("ManagedObjectInheritanceTree.html");
        this.viewHelp("This view represents the inheritance relationships between configuration components.");
        this.jumpSection();
        for (String catName : list.keySet()) {
            this.heading3(this.getFriendlyName(catName));
            TreeMap<String, AbstractManagedObjectDefinition> catList = list.get(catName);
            for (AbstractManagedObjectDefinition mo : catList.values()) {
                if (this.relList.get(mo.getName()) != null && this.relList.get(mo.getName()).hasOption(RelationOption.HIDDEN)) continue;
                this.paragraph(this.getLink(mo.getUserFriendlyName().toString(), mo.getName() + ".html", "mainFrame"));
                if (!mo.hasChildren()) continue;
                this.genMoInheritanceTree(this.makeMOTreeMap(mo.getChildren()));
            }
        }
        this.htmlFooter();
        this.generateFile("ManagedObjectInheritanceTree.html");
    }

    private void genMoInheritanceTree(TreeMap<String, AbstractManagedObjectDefinition> catList) {
        this.beginList();
        for (AbstractManagedObjectDefinition mo : catList.values()) {
            this.link(mo.getUserFriendlyName().toString(), mo.getName() + ".html", "mainFrame");
            if (!mo.hasChildren()) continue;
            this.genMoInheritanceTree(this.makeMOTreeMap(mo.getChildren()));
        }
        this.endList();
    }

    private void jumpSection() {
        this.htmlBuff.append("<p class=\"category-index\"><strong>Jump To:</strong><br>\n");
        String[] catNames = this.catTopMoList.keySet().toArray(new String[0]);
        for (int ii = 0; ii < catNames.length; ++ii) {
            if (ii != 0) {
                this.htmlBuff.append(", ");
            }
            String catFriendlyName = this.getFriendlyName(catNames[ii]);
            this.htmlBuff.append(this.getLink(catFriendlyName, "#" + catFriendlyName));
        }
        this.htmlBuff.append("</p>\n");
    }

    private void genManagedObjectRelationTree(TreeMap<String, TreeMap<String, RelationDefinition>> list) {
        this.htmlHeader(DynamicConstants.PRODUCT_NAME + " Configuration Reference - Structure View");
        this.tabMenu("ManagedObjectRelationTree.html");
        this.viewHelp("This view represents the structural relationships between components and indicates how certain components can exist only within container components.");
        this.jumpSection();
        for (String catName : list.keySet()) {
            this.heading3(this.getFriendlyName(catName));
            TreeMap<String, RelationDefinition> catList = list.get(catName);
            this.genMORelationTree(catList);
        }
        this.htmlFooter();
        this.generateFile("ManagedObjectRelationTree.html");
    }

    private void genMORelationTree(TreeMap<String, RelationDefinition> list) {
        for (RelationDefinition rel : list.values()) {
            AbstractManagedObjectDefinition childMo = rel.getChildDefinition();
            AbstractManagedObjectDefinition<?, ?> parentMo = rel.getParentDefinition();
            if (this.relList.put(childMo.getName(), rel) != null || rel.hasOption(RelationOption.HIDDEN)) continue;
            String linkStr = this.getLink(childMo.getUserFriendlyName().toString(), childMo.getName() + ".html", "mainFrame");
            String fromStr = "";
            if (!parentMo.getName().equals("")) {
                fromStr = " (from " + this.getLink(parentMo.getUserFriendlyName().toString(), parentMo.getName() + ".html", "mainFrame") + ")";
            }
            if (!this.inList) {
                this.paragraph(linkStr + fromStr);
            } else {
                this.bullet(linkStr + fromStr);
            }
            this.genMORelationSubTree(this.makeRelTreeMap(childMo.getAllRelationDefinitions()));
            if (!childMo.hasChildren()) continue;
            for (AbstractManagedObjectDefinition mo : childMo.getChildren()) {
                this.genMORelationSubTree(this.makeRelTreeMap(mo.getAllRelationDefinitions()));
            }
        }
    }

    private void genMORelationSubTree(TreeMap<String, RelationDefinition> list) {
        if (!list.values().isEmpty()) {
            this.beginList();
            this.genMORelationTree(list);
            this.endList();
        }
    }

    private void genAllManagedObject(TreeMap<String, AbstractManagedObjectDefinition> list) {
        for (AbstractManagedObjectDefinition mo : list.values()) {
            if (this.relList.get(mo.getName()) != null && this.relList.get(mo.getName()).hasOption(RelationOption.HIDDEN)) continue;
            this.moList.put(mo.getName(), mo);
            this.genManagedObject(mo);
            if (!mo.hasChildren()) continue;
            this.genAllManagedObject(this.makeMOTreeMap(mo.getChildren()));
        }
    }

    private void genManagedObject(AbstractManagedObjectDefinition mo) {
        this.homeLink();
        String title = mo.getUserFriendlyName().toString();
        this.htmlHeader(DynamicConstants.PRODUCT_NAME + " - " + title);
        this.heading2(title);
        if (mo.hasChildren()) {
            this.paragraph("Note: this is an abstract component, that cannot be instantiated.", TextStyle.ITALIC);
        }
        this.paragraph(mo.getSynopsis());
        this.paragraph(mo.getDescription());
        if (mo.hasChildren()) {
            this.heading3("Direct Subcomponents");
            this.paragraph("The following " + mo.getUserFriendlyPluralName() + " are available in the server :");
            this.beginList();
            TreeMap<String, AbstractManagedObjectDefinition> children = this.makeMOTreeMap(mo.getChildren());
            for (AbstractManagedObjectDefinition child : children.values()) {
                this.link(child.getUserFriendlyName().toString(), child.getName() + ".html");
            }
            this.endList();
            this.paragraph("These " + mo.getUserFriendlyPluralName() + " inherit from the properties described below.");
        }
        if (!mo.getParent().isTop()) {
            this.heading3("Parent Component");
            this.paragraph("The " + mo.getUserFriendlyName() + " component inherits from the " + this.getLink(mo.getParent().getUserFriendlyName().toString(), mo.getParent().getName() + ".html"));
        }
        this.generateRelationsSection(mo);
        if (ldapMapping) {
            this.newline();
            this.horizontalLine();
            this.newline();
            this.paragraph("This page describes the " + mo.getUserFriendlyName() + ":");
            this.beginList();
            this.link("Properties", "#Properties");
            this.link("LDAP Mapping", "#LDAP Mapping");
            this.endList();
            this.newline();
        }
        this.heading3("Properties");
        this.paragraph("A description of each property follows.");
        this.newline();
        TreeMap<String, PropertyDefinition> basicProps = new TreeMap<String, PropertyDefinition>();
        TreeMap<String, PropertyDefinition> advancedProps = new TreeMap<String, PropertyDefinition>();
        Collection<PropertyDefinition<?>> props = mo.getAllPropertyDefinitions();
        for (PropertyDefinition<?> propertyDefinition : props) {
            if (propertyDefinition.hasOption(PropertyOption.ADVANCED)) {
                advancedProps.put(propertyDefinition.getName(), propertyDefinition);
                continue;
            }
            basicProps.put(propertyDefinition.getName(), propertyDefinition);
        }
        this.propertiesLinkTable(basicProps, advancedProps);
        if (basicProps.size() > 0) {
            this.heading4("Basic Properties");
            for (PropertyDefinition<?> propertyDefinition : basicProps.values()) {
                this.generateProperty(mo, propertyDefinition);
                this.newline();
            }
            this.newline();
        }
        if (advancedProps.size() > 0) {
            this.heading4("Advanced Properties");
            for (PropertyDefinition<?> propertyDefinition : advancedProps.values()) {
                this.generateProperty(mo, propertyDefinition);
                this.newline();
            }
            this.newline();
        }
        if (ldapMapping) {
            this.genLdapMapping(mo);
        }
        this.htmlFooter();
        this.generateFile(mo.getName() + ".html");
    }

    private TreeMap<String, PropertyDefinition> getPropertyList(AbstractManagedObjectDefinition mo) {
        Collection<PropertyDefinition> props = mo.getAllPropertyDefinitions();
        return this.makePropTreeMap(props);
    }

    private void homeLink() {
        this.htmlBuff.append("<div style=\"font-size:11px;margin-top:-10px;margin-bottom:-10px; text-align:right\"><a href=\"index.html\" target=\"_top\">Configuration Reference Home</a></div>");
    }

    private void generateRelationsSection(AbstractManagedObjectDefinition mo) {
        TreeMap componentList;
        Collection<RelationDefinition<?, ?>> compRels = mo.getRelationDefinitions();
        Collection reverseCompRels = mo.getReverseRelationDefinitions();
        Collection<AggregationPropertyDefinition<?, ?>> aggregProps = mo.getAggregationPropertyDefinitions();
        Collection<AggregationPropertyDefinition<?, ?>> reverseAggregProps = mo.getReverseAggregationPropertyDefinitions();
        boolean isCompRelsEmpty = true;
        if (!compRels.isEmpty()) {
            for (RelationDefinition<?, ?> rel : compRels) {
                if (rel.hasOption(RelationOption.HIDDEN)) continue;
                isCompRelsEmpty = false;
            }
        }
        boolean isReverseCompRelsEmpty = true;
        if (!reverseCompRels.isEmpty()) {
            for (RelationDefinition rel : reverseCompRels) {
                if (rel.hasOption(RelationOption.HIDDEN) || rel.getParentDefinition().getName().equals("")) continue;
                isReverseCompRelsEmpty = false;
            }
        }
        boolean isReverseAggregPropsEmpty = true;
        if (!reverseAggregProps.isEmpty()) {
            for (AggregationPropertyDefinition<?, ?> aggregationPropertyDefinition : reverseAggregProps) {
                AbstractManagedObjectDefinition<?, ?> abstractManagedObjectDefinition = aggregationPropertyDefinition.getManagedObjectDefinition();
                Collection<RelationDefinition<?, ?>> rels = abstractManagedObjectDefinition.getAllReverseRelationDefinitions();
                for (RelationDefinition<?, ?> rel : rels) {
                    if (rel.hasOption(RelationOption.HIDDEN)) continue;
                    isReverseAggregPropsEmpty = false;
                }
            }
        }
        if (!isCompRelsEmpty || !aggregProps.isEmpty()) {
            this.heading3("Relations From this Component");
        }
        if (!isCompRelsEmpty) {
            this.paragraph("The following components have a direct COMPOSITION relation FROM " + mo.getUserFriendlyPluralName() + " :");
            for (RelationDefinition relationDefinition : compRels) {
                if (relationDefinition.hasOption(RelationOption.HIDDEN)) continue;
                this.beginList();
                AbstractManagedObjectDefinition abstractManagedObjectDefinition = relationDefinition.getChildDefinition();
                this.link(abstractManagedObjectDefinition.getUserFriendlyName().toString(), abstractManagedObjectDefinition.getName() + ".html");
                this.endList();
            }
        }
        if (!aggregProps.isEmpty()) {
            this.paragraph("The following components have a direct AGGREGATION relation FROM " + mo.getUserFriendlyPluralName() + " :");
            componentList = new TreeMap();
            for (AggregationPropertyDefinition<?, ?> aggregationPropertyDefinition : aggregProps) {
                InstantiableRelationDefinition<?, ?> rel = aggregationPropertyDefinition.getRelationDefinition();
                AbstractManagedObjectDefinition childRel2 = rel.getChildDefinition();
                componentList.put(childRel2.getName(), childRel2);
            }
            for (AbstractManagedObjectDefinition abstractManagedObjectDefinition : componentList.values()) {
                this.beginList();
                this.link(abstractManagedObjectDefinition.getUserFriendlyName().toString(), abstractManagedObjectDefinition.getName() + ".html");
                this.endList();
            }
        }
        if (!isReverseCompRelsEmpty || !isReverseAggregPropsEmpty) {
            this.heading3("Relations To this Component");
        }
        if (!mo.getReverseRelationDefinitions().isEmpty() && !isReverseCompRelsEmpty) {
            this.paragraph("The following components have a direct COMPOSITION relation TO " + mo.getUserFriendlyPluralName() + " :");
            for (RelationDefinition relationDefinition : reverseCompRels) {
                this.beginList();
                AbstractManagedObjectDefinition<?, ?> abstractManagedObjectDefinition = relationDefinition.getParentDefinition();
                this.link(abstractManagedObjectDefinition.getUserFriendlyName().toString(), abstractManagedObjectDefinition.getName() + ".html");
                this.endList();
            }
        }
        if (!isReverseAggregPropsEmpty) {
            this.paragraph("The following components have a direct AGGREGATION relation TO " + mo.getUserFriendlyPluralName() + " :");
            componentList = new TreeMap();
            for (AggregationPropertyDefinition<?, ?> aggregationPropertyDefinition : reverseAggregProps) {
                AbstractManagedObjectDefinition<?, ?> fromMo = aggregationPropertyDefinition.getManagedObjectDefinition();
                componentList.put(fromMo.getName(), fromMo);
            }
            for (AbstractManagedObjectDefinition abstractManagedObjectDefinition : componentList.values()) {
                this.beginList();
                this.link(abstractManagedObjectDefinition.getUserFriendlyName().toString(), abstractManagedObjectDefinition.getName() + ".html");
                this.endList();
            }
        }
    }

    private void generateProperty(AbstractManagedObjectDefinition mo, PropertyDefinition prop) {
        this.paragraph(this.getAnchor(prop.getName()) + prop.getName(), TextStyle.STANDARD, "propertyname");
        this.startTable();
        this.tableRow("Description", (prop.getSynopsis() != null ? prop.getSynopsis().toString() + " " : "") + (prop.getDescription() != null ? prop.getDescription().toString() : ""));
        String defValueStr = this.getDefaultBehaviorString(prop);
        this.tableRow("Default Value", defValueStr);
        this.tableRow("Allowed Values", this.getSyntaxStr(prop));
        this.tableRow("Multi-valued", prop.hasOption(PropertyOption.MULTI_VALUED) ? "Yes" : "No");
        if (prop.hasOption(PropertyOption.MANDATORY)) {
            this.tableRow("Required", "Yes");
        } else {
            this.tableRow("Required", "No");
        }
        String action = "None";
        if (prop.getAdministratorAction() != null) {
            Message synopsis = prop.getAdministratorAction().getSynopsis();
            AdministratorAction.Type actionType = prop.getAdministratorAction().getType();
            String actionStr = "";
            if (actionType == AdministratorAction.Type.COMPONENT_RESTART) {
                actionStr = "The " + mo.getUserFriendlyName() + " must be disabled and re-enabled for changes to this setting " + "to take effect";
            } else if (actionType == AdministratorAction.Type.SERVER_RESTART) {
                actionStr = "Restart the server";
            } else if (actionType == AdministratorAction.Type.NONE) {
                actionStr = "None";
            }
            String dot = actionStr.equals("") ? "" : ". ";
            action = actionStr + (synopsis != null ? dot + synopsis : "");
        }
        this.tableRow("Admin Action Required", action);
        if (prop.hasOption(PropertyOption.ADVANCED)) {
            this.tableRow("Advanced Property", "Yes");
        } else {
            this.tableRow("Advanced Property", "No");
        }
        if (prop.hasOption(PropertyOption.READ_ONLY)) {
            this.tableRow("Read-only", "Yes");
        } else {
            this.tableRow("Read-only", "No");
        }
        this.endTable();
    }

    private void propertiesLinkTable(TreeMap<String, PropertyDefinition> basicProps, TreeMap<String, PropertyDefinition> advancedProps) {
        this.htmlBuff.append("<table border=\"0\" cellspacing=\"0\" class=\"jump-table\">\n  <tr>\n    <th>Basic Properties:</th>\n    <th>Advanced Properties:</th>\n  </tr>\n");
        PropertyDefinition[] basicPropsArray = basicProps.values().toArray(new PropertyDefinition[0]);
        PropertyDefinition[] advancedPropsArray = advancedProps.values().toArray(new PropertyDefinition[0]);
        for (int ii = 0; ii < basicPropsArray.length || ii < advancedPropsArray.length; ++ii) {
            String basicPropName = ii < basicPropsArray.length ? basicPropsArray[ii].getName() : null;
            String advancedPropName = ii < advancedPropsArray.length ? advancedPropsArray[ii].getName() : null;
            String basicHtmlCell = "";
            if (basicPropName != null) {
                basicHtmlCell = "  <td>&darr;&nbsp;<a href=\"#" + basicPropName + "\">" + basicPropName + "</a></td>\n";
            } else if (basicPropsArray.length == 0 && ii == 0) {
                basicHtmlCell = "  <td>&nbsp;None</td>\n";
            } else if (ii >= basicPropsArray.length) {
                basicHtmlCell = "  <td></td>\n";
            }
            String advancedHtmlCell = "";
            if (advancedPropName != null) {
                advancedHtmlCell = "  <td>&darr;&nbsp;<a href=\"#" + advancedPropName + "\">" + advancedPropName + "</a></td>\n";
            } else if (advancedPropsArray.length == 0 && ii == 0) {
                advancedHtmlCell = "  <td>&nbsp;None</td>\n";
            }
            this.htmlBuff.append("<tr>\n");
            this.htmlBuff.append(basicHtmlCell + advancedHtmlCell);
            this.htmlBuff.append("</tr>\n");
        }
        this.htmlBuff.append("</table>\n");
    }

    private void genLdapMapping(AbstractManagedObjectDefinition mo) {
        this.heading3("LDAP Mapping");
        this.paragraph("Each configuration property can be mapped to a specific LDAP attribute under the \"cn=config\" entry. The mappings that follow are provided for information only. In general, you should avoid changing the server configuration by manipulating the LDAP attributes directly.");
        this.startTable();
        LDAPProfile ldapProfile = LDAPProfile.getInstance();
        this.tableRow("Base DN", this.getBaseDN(mo, ldapProfile));
        this.tableRow("objectclass name", ldapProfile.getObjectClass(mo));
        if (mo.getParent().getName() != null) {
            String superior = "";
            if (mo.getParent().getName().equals("top")) {
                superior = "top";
            } else if (this.moList.get(mo.getParent().getName()) != null) {
                superior = ldapProfile.getObjectClass(this.moList.get(mo.getParent().getName()));
            } else {
                System.err.println("Error: managed object " + mo.getName() + " not found.");
            }
            this.tableRow("objectclass superior", superior);
        } else {
            System.err.println("Error: objectclass superior not found for " + mo.getName());
        }
        this.endTable();
        this.newline();
        this.startTable();
        this.tableRow("Property", "LDAP attribute");
        for (PropertyDefinition prop : this.getPropertyList(mo).values()) {
            this.tableRow(prop.getName(), ldapProfile.getAttributeName(mo, prop));
        }
        this.endTable();
    }

    private void genManagedObjectList(TreeMap<String, AbstractManagedObjectDefinition> list) {
        this.htmlHeader(DynamicConstants.PRODUCT_NAME + " Configuration Reference - Components View");
        this.tabMenu("ManagedObjectList.html");
        this.viewHelp("This view provides a list of all configuration components, in alphabetical order.");
        this.newline();
        StringBuffer moPointers = new StringBuffer();
        String lettersPointers = "";
        String firstChar = ".";
        for (AbstractManagedObjectDefinition mo : list.values()) {
            if (!mo.getName().startsWith(firstChar)) {
                firstChar = mo.getName().substring(0, 1);
                String letter = firstChar.toUpperCase();
                moPointers.append(this.getAnchor(letter) + this.getHeading2(letter));
                lettersPointers = lettersPointers + this.getLink(letter, "#" + letter) + " ";
            }
            moPointers.append("<p> " + this.getLink(mo.getUserFriendlyName().toString(), mo.getName() + ".html", "mainFrame") + "</p>\n");
        }
        this.paragraph(lettersPointers);
        this.htmlBuff.append(moPointers);
        this.htmlFooter();
        this.generateFile("ManagedObjectList.html");
    }

    private void genPropertiesIndex() {
        TreeSet<String> propMoList = new TreeSet<String>();
        for (AbstractManagedObjectDefinition mo : this.moList.values()) {
            for (PropertyDefinition propertyDefinition : mo.getPropertyDefinitions()) {
                propMoList.add(propertyDefinition.getName() + "," + propertyDefinition.getManagedObjectDefinition().getName());
            }
        }
        String lettersPointers = "";
        String firstChar = ".";
        for (String string : propMoList) {
            String[] propMoArray = string.split(",");
            String propName = propMoArray[0];
            AbstractManagedObjectDefinition mo = this.moList.get(propMoArray[1]);
            if (!propName.startsWith(firstChar)) {
                firstChar = propName.substring(0, 1);
                String letter = firstChar.toUpperCase();
                this.htmlBuff.append(this.getAnchor(letter) + this.getHeading2(letter));
                lettersPointers = lettersPointers + this.getLink(letter, "#" + letter) + " ";
            }
            String propLink = this.getLink(propName, mo.getName() + ".html" + "#" + propName, "mainFrame");
            String moLink = this.getLink(mo.getUserFriendlyName().toString(), mo.getName() + ".html", "mainFrame", "#666");
            this.paragraph(propLink + "  [ " + moLink + " ]");
        }
        String indexBody = this.htmlBuff.toString();
        this.htmlBuff = new StringBuffer();
        this.htmlHeader(DynamicConstants.PRODUCT_NAME + " Configuration Reference - Properties View");
        this.tabMenu("PropertiesIndex.html");
        this.viewHelp("This view provides a list of all configuration properties, in alphabetical order, and indicates the configuration component to which each property applies.");
        this.newline();
        this.paragraph(lettersPointers);
        this.htmlBuff.append(indexBody);
        this.htmlFooter();
        this.generateFile("PropertiesIndex.html");
    }

    private void genWelcomePage() {
        this.htmlHeader(DynamicConstants.PRODUCT_NAME + " Configuration Reference - Welcome");
        this.heading2("About This Reference");
        this.paragraph("This reference describes the " + DynamicConstants.PRODUCT_NAME + " configuration properties that can be manipulated " + "with the dsconfig command.");
        this.paragraph("Configuration components are grouped according to the area of the server in which they are used, as follows:");
        this.beginList();
        for (String catName : this.catTopMoList.keySet()) {
            this.bullet(this.getFriendlyName(catName));
        }
        this.endList();
        this.paragraph("For ease of reference, the configuration is described on multiple tabs. These tabs provide alternative views of the configuration components:");
        this.beginList();
        this.bullet("The <strong>Inheritance</strong> view represents the inheritance relationships between configuration components. A sub-component inherits all of the properties of its parent component.");
        this.bullet("The <strong>Structure</strong> view represents the structural relationships between components and indicates how certain components can exist only within container components. When a container component is deleted, all of the components within it are also deleted.");
        this.bullet("The <strong>Components</strong> view provides an alphabetical list of all configuration components.");
        this.bullet("The <strong>Properties</strong> view provides an alphabetical list of all configuration properties, and indicates the configuration component to which each property applies.");
        this.endList();
        this.newline();
        this.paragraph("When you set up " + DynamicConstants.PRODUCT_NAME + ", certain components are created in the " + "configuration by default. These components are configured with " + "specific values, which are not necessarily the same as the " + "\"default values\" of new components that you create using dsconfig. " + "The \"default values\" listed in this document refer to the values " + "of the new components that you create using dsconfig.");
        this.htmlFooter();
        this.generateFile("welcome.html");
    }

    private void genMainTopPage() {
        this.htmlHeader(DynamicConstants.PRODUCT_NAME + " Configuration Reference - Main Top");
        this.htmlBuff.append("<div class=\"breadcrumb\"><span class=\"pageactions\"><a href=\"" + opendsWiki + "\" target=\"_parent\">" + "<span style=\"font-size: 12px;\">&laquo;&nbsp;&nbsp;</span>" + "Back to " + DynamicConstants.PRODUCT_NAME + " Wiki</a></span>&nbsp;&nbsp;</div>\n");
        this.htmlBuff.append("<table class=\"titletable\" cellspacing=\"0\" width=\"100%\">\n");
        this.htmlBuff.append("<tbody><tr>\n");
        this.htmlBuff.append("  <td><h2>" + DynamicConstants.PRODUCT_NAME + " Configuration Reference</h2></td>\n");
        this.htmlBuff.append("  <td valign=\"bottom\" width=\"10%\"><a href=\"" + opendsHome + "\" target=\"_parent\">" + "<img src=\"opends_logo_sm.png\" alt=\"OpenDS Logo\" align=\"bottom\" " + "border=\"0\" height=\"33\" width=\"104\"></a></td>\n");
        this.htmlBuff.append("</tr>\n");
        this.htmlBuff.append("</tbody></table>\n");
        this.htmlFooter();
        this.generateFile("maintop.html");
    }

    private void genIndexPage() {
        this.htmlBuff.append(this.getHtmlHeader(DynamicConstants.PRODUCT_NAME + " Configuration Reference"));
        this.htmlBuff.append("<frameset rows=\"80,*\" framespacing=\"1\" frameborder=\"yes\" border=\"1\" bordercolor=\"#333333\">\n");
        this.htmlBuff.append("  <frame src=\"maintop.html\" name=\"topFrame\" id=\"topFrame\" border=\"1\" title=\"topFrame\" scrolling=\"no\">\n");
        this.htmlBuff.append("  <frameset cols=\"375,*\" frameborder=\"yes\" border=\"1\" framespacing=\"1\">\n");
        this.htmlBuff.append("     <frame src=\"ManagedObjectInheritanceTree.html\" name=\"leftFrame\" id=\"leftFrame\" title=\"leftFrame\" scrolling=\"auto\">\n");
        this.htmlBuff.append("     <frame src=\"welcome.html\" name=\"mainFrame\" id=\"mainFrame\" title=\"mainFrame\" scrolling=\"auto\">\n");
        this.htmlBuff.append("   </frameset>\n");
        this.htmlBuff.append("</frameset>\n");
        this.htmlBuff.append("<noframes><body>\n");
        this.htmlBuff.append("</body>\n");
        this.htmlBuff.append("</noframes>\n");
        this.htmlBuff.append("</html>\n");
        this.generateFile("index.html");
    }

    private String getBaseDN(AbstractManagedObjectDefinition mo, LDAPProfile ldapProfile) {
        RelationDefinition rel = this.relList.get(mo.getName());
        if (rel != null) {
            String baseDn = ldapProfile.getRelationRDNSequence(rel);
            if (!baseDn.equals("")) {
                return baseDn;
            }
            return this.getBaseDN(rel.getParentDefinition(), ldapProfile);
        }
        if (this.moList.get(mo.getParent().getName()) != null) {
            return this.getBaseDN(this.moList.get(mo.getParent().getName()), ldapProfile);
        }
        System.err.println("Error: Base DN not found for " + mo.getName());
        return null;
    }

    private String getSyntaxStr(PropertyDefinition prop) {
        PropertyDefinitionVisitor<String, Void> visitor = new PropertyDefinitionVisitor<String, Void>(){

            @Override
            public String visitACI(ACIPropertyDefinition prop, Void p) {
                return ConfigGuideGeneration.this.getLink("An ACI Syntax", aciSyntaxPage);
            }

            @Override
            public String visitAggregation(AggregationPropertyDefinition prop, Void p) {
                InstantiableRelationDefinition rel = prop.getRelationDefinition();
                String linkStr = ConfigGuideGeneration.this.getLink(rel.getUserFriendlyName().toString(), rel.getName() + ".html");
                return "The DN of any " + linkStr + ". " + (prop.getSourceConstraintSynopsis() != null ? prop.getSourceConstraintSynopsis().toString() : "");
            }

            @Override
            public String visitAttributeType(AttributeTypePropertyDefinition prop, Void p) {
                return "The name of an attribute type defined in the server schema.";
            }

            @Override
            public String visitBoolean(BooleanPropertyDefinition prop, Void p) {
                return "true" + ConfigGuideGeneration.this.getNewLine() + "false";
            }

            @Override
            public String visitClass(ClassPropertyDefinition prop, Void p) {
                String classStr = "A java class that implements or extends the class(es) :";
                for (String clazz : prop.getInstanceOfInterface()) {
                    classStr = classStr + ConfigGuideGeneration.this.getNewLine() + clazz;
                }
                return classStr;
            }

            @Override
            public String visitDN(DNPropertyDefinition prop, Void p) {
                String retStr = "A valid DN.";
                if (prop.getBaseDN() != null) {
                    retStr = retStr + prop.getBaseDN().toString();
                }
                return retStr;
            }

            @Override
            public String visitDuration(DurationPropertyDefinition prop, Void p) {
                String durationStr = "";
                durationStr = durationStr + ConfigGuideGeneration.this.getLink("A duration Syntax", durationSyntaxPage) + ". ";
                if (prop.isAllowUnlimited()) {
                    durationStr = durationStr + "A value of \"-1\" or \"unlimited\" for no limit. ";
                }
                if (prop.getMaximumUnit() != null) {
                    durationStr = durationStr + "Maximum unit is \"" + prop.getMaximumUnit().getLongName() + "\". ";
                }
                long lowerLimitStr = new Double(prop.getBaseUnit().fromMilliSeconds(prop.getLowerLimit())).longValue();
                durationStr = durationStr + "Lower limit is " + lowerLimitStr + " " + prop.getBaseUnit().getLongName() + ". ";
                if (prop.getUpperLimit() != null) {
                    long upperLimitStr = new Double(prop.getBaseUnit().fromMilliSeconds(prop.getUpperLimit())).longValue();
                    durationStr = durationStr + "Upper limit is " + upperLimitStr + " " + prop.getBaseUnit().getLongName() + ". ";
                }
                return durationStr;
            }

            @Override
            public String visitEnum(EnumPropertyDefinition prop, Void p) {
                String enumStr = "";
                Class en = prop.getEnumClass();
                for (Object cst : en.getEnumConstants()) {
                    enumStr = enumStr + cst.toString();
                    if (prop.getValueSynopsis((Enum)cst) != null) {
                        enumStr = enumStr + " - " + prop.getValueSynopsis((Enum)cst).toString();
                    }
                    enumStr = enumStr + ConfigGuideGeneration.this.getNewLine() + ConfigGuideGeneration.this.getNewLine();
                }
                return enumStr;
            }

            @Override
            public String visitInteger(IntegerPropertyDefinition prop, Void p) {
                String intStr = "An integer value.";
                intStr = intStr + " Lower value is " + prop.getLowerLimit() + ".";
                if (prop.getUpperLimit() != null) {
                    intStr = intStr + " Upper value is " + prop.getUpperLimit() + " .";
                }
                if (prop.isAllowUnlimited()) {
                    intStr = intStr + " A value of \"-1\" or \"unlimited\" for no limit.";
                }
                if (prop.getUnitSynopsis() != null) {
                    intStr = intStr + " Unit is " + prop.getUnitSynopsis() + ".";
                }
                return intStr;
            }

            @Override
            public String visitIPAddress(IPAddressPropertyDefinition prop, Void p) {
                return "An IP address";
            }

            @Override
            public String visitIPAddressMask(IPAddressMaskPropertyDefinition prop, Void p) {
                return "An IP address mask";
            }

            @Override
            public String visitSize(SizePropertyDefinition prop, Void p) {
                String sizeStr = "A positive integer representing a size.";
                if (prop.getLowerLimit() != 0L) {
                    sizeStr = sizeStr + " Lower value is " + prop.getLowerLimit() + ".";
                }
                if (prop.getUpperLimit() != null) {
                    sizeStr = sizeStr + " Upper value is " + prop.getUpperLimit() + " .";
                }
                if (prop.isAllowUnlimited()) {
                    sizeStr = sizeStr + " A value of \"-1\" or \"unlimited\" for no limit.";
                }
                return sizeStr;
            }

            @Override
            public String visitString(StringPropertyDefinition prop, Void p) {
                String retStr = "A String";
                if (prop.getPatternSynopsis() != null) {
                    retStr = prop.getPatternSynopsis().toString();
                }
                return retStr;
            }

            @Override
            public String visitUnknown(PropertyDefinition prop, Void p) {
                return "Unknown";
            }
        };
        return prop.accept(visitor, null);
    }

    private String getDefaultBehaviorString(PropertyDefinition prop) {
        DefaultBehaviorProvider defaultBehav = prop.getDefaultBehaviorProvider();
        String defValueStr = "";
        if (defaultBehav instanceof UndefinedDefaultBehaviorProvider) {
            defValueStr = "None";
        } else if (defaultBehav instanceof DefinedDefaultBehaviorProvider) {
            DefinedDefaultBehaviorProvider defBehav = (DefinedDefaultBehaviorProvider)defaultBehav;
            Iterator<String> it = defBehav.getDefaultValues().iterator();
            while (it.hasNext()) {
                String str = it.next();
                defValueStr = defValueStr + str + (it.hasNext() ? "\n" : "");
            }
        } else if (defaultBehav instanceof AliasDefaultBehaviorProvider) {
            AliasDefaultBehaviorProvider aliasBehav = (AliasDefaultBehaviorProvider)defaultBehav;
            defValueStr = aliasBehav.getSynopsis().toString();
        } else if (defaultBehav instanceof RelativeInheritedDefaultBehaviorProvider) {
            RelativeInheritedDefaultBehaviorProvider relativBehav = (RelativeInheritedDefaultBehaviorProvider)defaultBehav;
            defValueStr = this.getDefaultBehaviorString(relativBehav.getManagedObjectDefinition().getPropertyDefinition(relativBehav.getPropertyName()));
        } else if (defaultBehav instanceof AbsoluteInheritedDefaultBehaviorProvider) {
            AbsoluteInheritedDefaultBehaviorProvider absoluteBehav = (AbsoluteInheritedDefaultBehaviorProvider)defaultBehav;
            defValueStr = this.getDefaultBehaviorString(absoluteBehav.getManagedObjectDefinition().getPropertyDefinition(absoluteBehav.getPropertyName()));
        }
        return defValueStr;
    }

    private TreeMap<String, AbstractManagedObjectDefinition> makeMOTreeMap(Collection<AbstractManagedObjectDefinition> coll) {
        if (coll == null) {
            return null;
        }
        TreeMap<String, AbstractManagedObjectDefinition> map = new TreeMap<String, AbstractManagedObjectDefinition>();
        for (AbstractManagedObjectDefinition mo : coll) {
            map.put(mo.getName(), mo);
        }
        return map;
    }

    private TreeMap<String, RelationDefinition> makeRelTreeMap(Collection<RelationDefinition> coll) {
        if (coll == null) {
            return null;
        }
        TreeMap<String, RelationDefinition> map = new TreeMap<String, RelationDefinition>();
        for (RelationDefinition rel : coll) {
            map.put(rel.getChildDefinition().getName(), rel);
        }
        return map;
    }

    private TreeMap<String, PropertyDefinition> makePropTreeMap(Collection<PropertyDefinition> coll) {
        if (coll == null) {
            return null;
        }
        TreeMap<String, PropertyDefinition> map = new TreeMap<String, PropertyDefinition>();
        for (PropertyDefinition prop : coll) {
            map.put(prop.getName(), prop);
        }
        return map;
    }

    private void horizontalLine() {
        this.htmlBuff.append("<hr style=\"width: 100%; height: 2px;\">");
    }

    private void endTable() {
        this.htmlBuff.append("</tbody>\n");
        this.htmlBuff.append("</table>\n");
    }

    private void bullet(String str) {
        this.htmlBuff.append("<li>" + str + "</li>\n");
    }

    private void heading2(String string) {
        this.heading(string, 2);
    }

    private void heading3(String string) {
        this.heading(string, 3);
    }

    private void heading4(String string) {
        this.heading(string, 4);
    }

    private void heading(String str, int level) {
        this.htmlBuff.append(this.getHeading(str, level));
    }

    private String getHeading(String str, int level) {
        String strLevel = new Integer(level).toString();
        return "<h" + strLevel + ">" + "<a name=\"" + str + "\"></a>" + str + "</h" + strLevel + ">\n";
    }

    private String getHeading2(String str) {
        return this.getHeading(str, 2);
    }

    private String getAnchor(String str) {
        return "<a name=\"" + str + "\"></a>";
    }

    private void htmlHeader(String pageTitle) {
        this.htmlBuff.append(this.getHtmlHeader(pageTitle) + "<body>\n");
    }

    private String getHtmlHeader(String pageTitle) {
        return "<html>\n<head>\n<meta http-equiv=\"content-type\"\ncontent=\"text/html; charset=ISO-8859-1\">\n<title>" + pageTitle + "</title>\n" + "<link rel=\"stylesheet\" type=\"text/css\"\n" + "href=\"" + "opends-config.css" + "\">\n" + "</head>\n";
    }

    private void tabMenu(String activeTab) {
        this.htmlBuff.append("<div class=\"tabmenu\"> <span><a " + (activeTab.equals("ManagedObjectInheritanceTree.html") ? "class=\"activetab\" " : "") + "href=\"" + "ManagedObjectInheritanceTree.html" + "\"" + " title=\"Inheritance View of Components\">Inheritance</a></span> " + "<span><a " + (activeTab.equals("ManagedObjectRelationTree.html") ? "class=\"activetab\" " : "") + "href=\"" + "ManagedObjectRelationTree.html" + "\"" + " title=\"Relational View of Components\">Structure</a></span> " + "<span><a " + (activeTab.equals("ManagedObjectList.html") ? "class=\"activetab\" " : "") + "href=\"" + "ManagedObjectList.html" + "\"" + " title=\"Alphabetical Index of Components\">Components</a></span> " + "<span><a " + (activeTab.equals("PropertiesIndex.html") ? "class=\"activetab\" " : "") + "href=\"" + "PropertiesIndex.html" + "\"" + " title=\"Alphabetical Index of Properties\" >Properties</a></span>" + "</div>" + "\n");
    }

    private String getLink(String str, String link) {
        return this.getLink(str, link, null, null);
    }

    private String getLink(String str, String link, String target) {
        return this.getLink(str, link, target, null);
    }

    private String getLink(String str, String link, String target, String color) {
        return "<a " + (color != null ? "style=\"color:" + color + "\" " : "") + "href=\"" + link + "\"" + (target == null ? "" : " target=\"" + target + "\"") + ">" + str + "</a>";
    }

    private void link(String str, String link) {
        this.link(str, link, null, null);
    }

    private void link(String str, String link, String target) {
        this.link(str, link, target, null);
    }

    private void link(String str, String link, String target, String color) {
        String htmlStr = "";
        if (!this.inList && this.getIndentPixels() > 0) {
            htmlStr = htmlStr + "<div style=\"margin-left: " + this.getIndentPixels() + "px;\">";
        } else if (this.inList) {
            htmlStr = htmlStr + "<li>";
        }
        htmlStr = htmlStr + this.getLink(str, link, target, color);
        if (!this.inList && this.getIndentPixels() > 0) {
            htmlStr = htmlStr + "</div>";
        } else if (this.inList) {
            htmlStr = htmlStr + "</li>";
        }
        if (!this.inList) {
            htmlStr = htmlStr + "<br>";
        }
        this.htmlBuff.append(htmlStr + "\n");
    }

    private void newline() {
        this.htmlBuff.append(this.getNewLine());
    }

    private String getNewLine() {
        return "<br>\n";
    }

    private void paragraph(Message description) {
        if (description != null) {
            this.paragraph(description.toString());
        }
    }

    private void paragraph(String description) {
        this.paragraph(description, TextStyle.STANDARD, null);
    }

    private void paragraph(String description, TextStyle style) {
        this.paragraph(description, style, null);
    }

    private void paragraph(String description, TextStyle style, String pClass) {
        String indentStr = "";
        String styleStr = "";
        String classStr = "";
        if (this.getIndentPixels() > 0) {
            indentStr = "style=\"margin-left: " + this.getIndentPixels() + "px;\"";
        }
        if (style == TextStyle.BOLD) {
            styleStr = "style=\"font-weight: bold;\"";
        } else if (style == TextStyle.ITALIC) {
            styleStr = "style=\"font-style: italic;\"";
        }
        if (pClass != null) {
            classStr = "class=" + pClass;
        }
        this.htmlBuff.append("<p " + indentStr + " " + styleStr + " " + classStr + ">" + description + "</p>\n");
    }

    private int getIndentPixels() {
        return 0;
    }

    private void startTable() {
        this.htmlBuff.append("<table style=\"width: 100%; text-align: left;\"border=\"1\"cellpadding=\"1\"cellspacing=\"0\">\n");
        this.htmlBuff.append("<tbody>\n");
    }

    private String getFriendlyName(String str) {
        String retStr = "";
        String[] words = str.split("\\p{Punct}");
        for (int ii = 0; ii < words.length; ++ii) {
            if (ii > 0) {
                retStr = retStr + " ";
            }
            String word = words[ii];
            String firstChar = word.substring(0, 1).toUpperCase();
            retStr = retStr + firstChar + word.substring(1, word.length());
        }
        return retStr;
    }

    private void tableRow(String ... strings) {
        this.htmlBuff.append("<tr>\n");
        for (int ii = 0; ii < strings.length; ++ii) {
            String string = strings[ii];
            this.htmlBuff.append("<td style=\"vertical-align: top; " + (ii == 0 ? "width: 20%;" : "") + "\">" + string + "<br></td>");
        }
        this.htmlBuff.append("</tr>\n");
    }

    private void beginList() {
        this.inList = true;
        ++this.listLevel;
        this.htmlBuff.append("<ul>\n");
    }

    private void endList() {
        --this.listLevel;
        if (this.listLevel == 0) {
            this.inList = false;
        }
        this.htmlBuff.append("</ul>\n");
    }

    private void htmlFooter() {
        this.htmlBuff.append("</body>\n</html>\n");
    }

    private void viewHelp(String helpStr) {
        this.htmlBuff.append("<p class=\"view-help\" >" + helpStr + "</p>" + "\n");
    }

    private void generateFile(String fileName) {
        try {
            PrintWriter file = new PrintWriter(new FileWriter(generationDir + File.separator + fileName));
            file.write(this.htmlBuff.toString());
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.htmlBuff = new StringBuffer();
    }

    static {
        ldapMapping = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TextStyle {
        STANDARD,
        BOLD,
        ITALIC,
        UNDERLINE,
        FIXED_WIDTH;

    }
}

