/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client;

import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.OperationsException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IllegalManagedObjectNameException
extends OperationsException {
    private static final long serialVersionUID = 7491748228684293291L;
    private final String illegalName;
    private final PropertyDefinition<?> namingPropertyDefinition;

    private static Message createMessage(String illegalName, PropertyDefinition<?> namingPropertyDefinition) {
        if (illegalName.length() == 0) {
            return AdminMessages.ERR_ILLEGAL_MANAGED_OBJECT_NAME_EXCEPTION_EMPTY.get();
        }
        if (illegalName.trim().length() == 0) {
            return AdminMessages.ERR_ILLEGAL_MANAGED_OBJECT_NAME_EXCEPTION_BLANK.get();
        }
        if (namingPropertyDefinition != null) {
            try {
                namingPropertyDefinition.decodeValue(illegalName);
            }
            catch (IllegalPropertyValueStringException e) {
                PropertyDefinitionUsageBuilder builder = new PropertyDefinitionUsageBuilder(true);
                return AdminMessages.ERR_ILLEGAL_MANAGED_OBJECT_NAME_EXCEPTION_SYNTAX.get(illegalName, namingPropertyDefinition.getName(), builder.getUsage(namingPropertyDefinition));
            }
        }
        return AdminMessages.ERR_ILLEGAL_MANAGED_OBJECT_NAME_EXCEPTION_OTHER.get(illegalName);
    }

    public IllegalManagedObjectNameException(String illegalName) {
        this(illegalName, (PropertyDefinition<?>)null);
    }

    public IllegalManagedObjectNameException(String illegalName, PropertyDefinition<?> namingPropertyDefinition) {
        super(IllegalManagedObjectNameException.createMessage(illegalName, namingPropertyDefinition));
        this.illegalName = illegalName;
        this.namingPropertyDefinition = namingPropertyDefinition;
    }

    public String getIllegalName() {
        return this.illegalName;
    }

    public PropertyDefinition<?> getNamingPropertyDefinition() {
        return this.namingPropertyDefinition;
    }
}

