/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.upgrader.Build;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBuildManager {
    private static final Logger LOG = Logger.getLogger(RemoteBuildManager.class.getName());
    private Application app;
    private URL buildListUrl;
    private Proxy proxy;
    private String proxyUserName;
    private char[] proxyPw;

    public RemoteBuildManager(Application app, URL url, Proxy proxy) {
        this.app = app;
        this.buildListUrl = url;
        this.proxy = proxy;
    }

    public URL getBaseContext() {
        return this.buildListUrl;
    }

    public List<Build> listBuilds(InputStream in) throws IOException {
        String dailyBuildsPage = this.downloadDailyBuildsPage(in);
        return Collections.unmodifiableList(RemoteBuildsPageParser.parseBuildList(dailyBuildsPage));
    }

    public InputStream getDailyBuildsInputStream(Component c, Object o) throws IOException {
        InputStream in;
        URLConnection conn = this.proxy == null ? this.buildListUrl.openConnection() : this.buildListUrl.openConnection(this.proxy);
        String proxyAuthString = this.createProxyAuthString();
        if (proxyAuthString != null) {
            conn.setRequestProperty("Proxy-Authorization", "Basic " + proxyAuthString);
        }
        if (c != null) {
            ProgressMonitorInputStream pmis = new ProgressMonitorInputStream(c, o, conn.getInputStream());
            ProgressMonitor pm = pmis.getProgressMonitor();
            pm.setMaximum(conn.getContentLength());
            in = pmis;
        } else {
            in = conn.getInputStream();
        }
        return in;
    }

    private String downloadDailyBuildsPage(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder builder = new StringBuilder();
        while (null != (line = reader.readLine())) {
            builder.append(line).append('\n');
        }
        return builder.toString();
    }

    public void download(Build build, File destination) throws IOException {
        this.download(build.getUrl(), destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(URL url, File destination) throws IOException {
        URLConnection conn = null;
        conn = this.proxy == null ? url.openConnection() : url.openConnection(this.proxy);
        String proxyAuthString = this.createProxyAuthString();
        if (proxyAuthString != null) {
            conn.setRequestProperty("Proxy-Authorization", "Basic " + proxyAuthString);
        }
        InputStream is = null;
        FileOutputStream fos = null;
        if (destination.exists() && !destination.delete()) {
            throw new IOException("Could not overwrite existing file " + Utils.getPath(destination));
        }
        Utils.createFile(destination);
        try {
            is = conn.getInputStream();
            int length = conn.getContentLength();
            fos = new FileOutputStream(destination);
            int i = 0;
            int bytesRead = 0;
            byte[] buf = new byte[1024];
            this.app.notifyListeners(0, QuickSetupMessages.INFO_BUILD_MANAGER_DOWNLOADING_BUILD.get(), null);
            while ((i = is.read(buf)) != -1) {
                fos.write(buf, 0, i);
                if (this.app == null) continue;
                bytesRead += i;
                if (length <= 0) continue;
                int progress = bytesRead * 100 / length;
                this.app.notifyListeners(0, QuickSetupMessages.INFO_BUILD_MANAGER_DOWNLOADING_BUILD_PROGRESS.get(String.valueOf(progress)), null);
            }
            this.app.notifyListeners(0, QuickSetupMessages.INFO_BUILD_MANAGER_DOWNLOADING_BUILD_DONE.get(), null);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxyUserName(String user) {
        this.proxyUserName = user;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyPassword(char[] pw) {
        this.proxyPw = pw;
    }

    public char[] getProxyPassword() {
        return this.proxyPw;
    }

    private String createProxyAuthString() {
        return RemoteBuildManager.createAuthenticationString(this.getProxyUserName(), this.getProxyPassword());
    }

    private static String createAuthenticationString(String user, char[] pw) {
        String s = null;
        if (user != null && pw != null) {
            StringBuilder sb = new StringBuilder().append(user).append(":").append(pw);
            s = Base64.encode(sb.toString().getBytes());
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoteBuildsPageParser {
        private RemoteBuildsPageParser() {
        }

        public static List<Build> parseBuildList(String page) {
            ArrayList<Build> builds = new ArrayList<Build>();
            if (page != null) {
                BufferedReader reader = new BufferedReader(new StringReader(page));
                try {
                    String line;
                    while (null != (line = reader.readLine())) {
                        if (RemoteBuildsPageParser.isComment(line)) continue;
                        try {
                            Build build = RemoteBuildsPageParser.parseBuildLine(line);
                            builds.add(build);
                        }
                        catch (IllegalArgumentException iae) {
                            StringBuilder msg = new StringBuilder().append("Error parsing line '").append(line).append("': ").append(iae.getMessage());
                            LOG.log(Level.INFO, msg.toString());
                        }
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "error", e);
                }
            } else {
                LOG.log(Level.WARNING, "build list page is null");
            }
            return builds;
        }

        private static boolean isComment(String line) {
            return line != null && line.startsWith("#");
        }

        private static Build parseBuildLine(String line) throws IllegalArgumentException {
            URL downloadUrl;
            String displayName = null;
            String downloadUrlString = null;
            String categoryString = null;
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.hasMoreTokens()) {
                displayName = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                downloadUrlString = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                categoryString = st.nextToken();
            }
            if (displayName == null || downloadUrlString == null || categoryString == null) {
                StringBuilder msg = new StringBuilder().append("Line '").append(line).append("' is incomplete or is not correctly delimited").append("with tab characters");
                throw new IllegalArgumentException(msg.toString());
            }
            try {
                downloadUrl = new URL(downloadUrlString);
            }
            catch (MalformedURLException e) {
                StringBuilder msg = new StringBuilder().append("URL '").append(downloadUrlString).append("' is invalid");
                throw new IllegalArgumentException(msg.toString());
            }
            Build.Category category = Build.Category.fromString(categoryString);
            if (category == null) {
                StringBuilder msg = new StringBuilder().append("Category '").append(categoryString).append("' is invalid; must be one of ");
                for (Build.Category c : EnumSet.allOf(Build.Category.class)) {
                    msg.append("'").append(c.getKey()).append("' ");
                }
                throw new IllegalArgumentException(msg.toString());
            }
            return new Build(displayName, downloadUrl, category);
        }
    }
}

