/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.opends.messages.Message;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.CurrentInstallStatus;
import org.opends.quicksetup.ProgressDescriptor;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.event.ButtonActionListener;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.ButtonsPanel;
import org.opends.quicksetup.ui.CurrentStepPanel;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupErrorPanel;
import org.opends.quicksetup.ui.StepsPanel;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.ProgressMessageFormatter;

public class QuickSetupDialog {
    private static final Logger LOG = Logger.getLogger(QuickSetupDialog.class.getName());
    private JFrame frame;
    private QuickSetupErrorPanel installedPanel;
    private JPanel framePanel;
    private StepsPanel stepsPanel;
    private CurrentStepPanel currentStepPanel;
    private ButtonsPanel buttonsPanel;
    private WizardStep displayedStep;
    private CurrentInstallStatus installStatus;
    private HashSet<ButtonActionListener> buttonListeners = new HashSet();
    private GuiApplication application;
    private QuickSetup quickSetup;
    private boolean forceToDisplay;

    public QuickSetupDialog(GuiApplication app, CurrentInstallStatus installStatus, QuickSetup qs) {
        if (app == null) {
            throw new IllegalArgumentException("application cannot be null");
        }
        this.application = app;
        this.installStatus = installStatus;
        this.quickSetup = qs;
        this.frame = new JFrame(String.valueOf(this.application.getFrameTitle()));
        this.frame.getContentPane().add(this.getFramePanel());
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                QuickSetupDialog.this.application.windowClosing(QuickSetupDialog.this, e);
            }
        });
        this.frame.setDefaultCloseOperation(0);
        Utilities.setFrameIcon(this.frame);
    }

    public void packAndShow() {
        this.frame.pack();
        int minWidth = (int)this.frame.getPreferredSize().getWidth();
        int minHeight = (int)this.frame.getPreferredSize().getHeight();
        Utilities.centerOnScreen(this.frame);
        this.setFocusOnButton(this.application.getInitialFocusButtonName());
        this.frame.addComponentListener(new MinimumSizeComponentListener(this.frame, minWidth, minHeight));
        this.frame.setVisible(true);
    }

    public void forceToDisplay() {
        this.forceToDisplay = true;
        this.framePanel = null;
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().add(this.getFramePanel());
        this.frame.pack();
        Utilities.centerOnScreen(this.frame);
        this.setFocusOnButton(ButtonName.NEXT);
    }

    public void setDisplayedStep(WizardStep step, UserData userData) {
        this.displayedStep = step;
        this.getButtonsPanel().updateButtons(step);
        this.getStepsPanel().setDisplayedStep(step, userData);
        this.getCurrentStepPanel().setDisplayedStep(step, userData);
    }

    public WizardStep getDisplayedStep() {
        return this.displayedStep;
    }

    public void displayProgress(ProgressDescriptor descriptor) {
        this.getCurrentStepPanel().displayProgress(descriptor);
        ProgressStep status = descriptor.getProgressStep();
        if (status.isLast()) {
            this.setButtonEnabled(ButtonName.CLOSE, true);
        }
    }

    public void displayError(Message msg, Message title) {
        Utilities.displayError(this.getFrame(), msg, title);
    }

    public boolean displayConfirmation(Message msg, Message title) {
        return Utilities.displayConfirmation(this.getFrame(), msg, title);
    }

    public Object getFieldValue(FieldName fieldName) {
        return this.getCurrentStepPanel().getFieldValue(fieldName);
    }

    public ProgressMessageFormatter getFormatter() {
        return this.getCurrentStepPanel().getProgressPanel().getFormatter();
    }

    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        this.getCurrentStepPanel().displayFieldInvalid(fieldName, invalid);
    }

    public void addButtonActionListener(ButtonActionListener l) {
        this.getButtonsPanel().addButtonActionListener(l);
        this.getInstalledPanel().addButtonActionListener(l);
        this.getCurrentStepPanel().addButtonActionListener(l);
        this.buttonListeners.add(l);
    }

    public void workerStarted() {
        Runnable r = new Runnable(){

            public void run() {
                QuickSetupDialog.this.displayWorkingProgressImage(true);
                QuickSetupDialog.this.setButtonEnabled(ButtonName.NEXT, false);
                QuickSetupDialog.this.setButtonEnabled(ButtonName.PREVIOUS, false);
                QuickSetupDialog.this.setButtonEnabled(ButtonName.FINISH, false);
            }
        };
        this.runOnEventThread(r);
    }

    public void workerFinished() {
        Runnable r = new Runnable(){

            public void run() {
                QuickSetupDialog.this.displayWorkingProgressImage(false);
                QuickSetupDialog.this.setButtonEnabled(ButtonName.NEXT, true);
                QuickSetupDialog.this.setButtonEnabled(ButtonName.PREVIOUS, true);
                QuickSetupDialog.this.setButtonEnabled(ButtonName.FINISH, true);
            }
        };
        this.runOnEventThread(r);
    }

    public void workerMessage(String msg) {
    }

    public void finished(boolean successful) {
        this.setButtonEnabled(ButtonName.CLOSE, true);
        if (!successful) {
            // empty if block
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setButtonEnabled(ButtonName buttonName, boolean enable) {
        this.getButton(buttonName).setEnabled(enable);
    }

    private JPanel getFramePanel() {
        if (this.framePanel == null) {
            this.framePanel = this.application.createFramePanel(this);
        }
        return this.framePanel;
    }

    public StepsPanel getStepsPanel() {
        if (this.stepsPanel == null) {
            this.stepsPanel = new StepsPanel(this.application);
            this.stepsPanel.setQuickSetup(this.quickSetup);
        }
        return this.stepsPanel;
    }

    public CurrentStepPanel getCurrentStepPanel() {
        if (this.currentStepPanel == null) {
            this.currentStepPanel = new CurrentStepPanel(this.application, this.quickSetup);
        }
        return this.currentStepPanel;
    }

    public ButtonsPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new ButtonsPanel(this.application);
            this.buttonsPanel.setQuickSetup(this.quickSetup);
        }
        return this.buttonsPanel;
    }

    private JButton getButton(ButtonName buttonName) {
        JButton button = this.isInstalled() && !this.forceToDisplay ? (buttonName == ButtonName.QUIT ? this.getInstalledPanel().getQuitButton() : (buttonName == ButtonName.CONTINUE_INSTALL ? this.getInstalledPanel().getContinueInstallButton() : this.getButtonsPanel().getButton(buttonName))) : this.getButtonsPanel().getButton(buttonName);
        return button;
    }

    public void setFocusOnButton(ButtonName buttonName) {
        JButton button = this.getButton(buttonName);
        if (button != null) {
            button.requestFocusInWindow();
        } else {
            LOG.log(Level.INFO, "Focus requested for unknown button '" + (Object)((Object)buttonName) + "'");
        }
    }

    public void setDefaultButton(ButtonName buttonName) {
        this.getFrame().getRootPane().setDefaultButton(this.getButton(buttonName));
    }

    private void runOnEventThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private boolean isInstalled() {
        return this.installStatus.isInstalled();
    }

    public QuickSetupErrorPanel getInstalledPanel() {
        if (this.installedPanel == null) {
            this.installedPanel = new QuickSetupErrorPanel(this.application, this.installStatus);
            this.installedPanel.setQuickSetup(this.quickSetup);
        }
        return this.installedPanel;
    }

    public void notifyButtonEvent(ButtonName buttonName) {
        ButtonEvent be = new ButtonEvent(this, buttonName);
        for (ButtonActionListener li : this.buttonListeners) {
            li.buttonActionPerformed(be);
        }
    }

    private void displayWorkingProgressImage(boolean display) {
        this.getCurrentStepPanel().setCheckingVisible(display);
    }
}

