/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.JavaArguments;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaArgumentsDialog
extends JDialog {
    private static final long serialVersionUID = -7950773258109643264L;
    private JLabel lInitialMemory;
    private JLabel lMaxMemory;
    private JLabel lOtherArguments;
    private JTextField tfInitialMemory;
    private JTextField tfMaxMemory;
    private JTextField tfOtherArguments;
    private JButton cancelButton;
    private JButton okButton;
    private boolean isCancelled = true;
    private Message message;
    private JavaArguments javaArguments;
    private JPanel inputContainer;
    private static final String INPUT_PANEL = "input";
    private static final String CHECKING_PANEL = "checking";
    private boolean isCheckingVisible;
    private final int MAX_VALUE_32_BIT = 2048;
    private static boolean userAgreedWithWebStart;
    private static final String INSTALL_PATH;

    public JavaArgumentsDialog(JFrame parent, JavaArguments javaArguments, Message title, Message message) throws IllegalArgumentException {
        super(parent);
        if (javaArguments == null) {
            throw new IllegalArgumentException("javaArguments cannot be null.");
        }
        if (title == null) {
            throw new IllegalArgumentException("title cannot be null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null.");
        }
        this.setTitle(title.toString());
        this.message = message;
        this.javaArguments = javaArguments;
        this.getContentPane().add(this.createPanel());
        this.pack();
        this.updateContents();
        int minWidth = (int)this.getPreferredSize().getWidth();
        int minHeight = (int)this.getPreferredSize().getHeight();
        this.addComponentListener(new MinimumSizeComponentListener(this, minWidth, minHeight));
        this.getRootPane().setDefaultButton(this.okButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JavaArgumentsDialog.this.cancelClicked();
            }
        });
        this.setDefaultCloseOperation(0);
        Utilities.centerOnComponent(this, parent);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public JavaArguments getJavaArguments() {
        String[] args;
        String sInitialMemory;
        JavaArguments javaArguments = new JavaArguments();
        String sMaxMemory = this.tfMaxMemory.getText().trim();
        if (sMaxMemory.length() > 0) {
            javaArguments.setMaxMemory(Integer.parseInt(sMaxMemory));
        }
        if ((sInitialMemory = this.tfInitialMemory.getText().trim()).length() > 0) {
            javaArguments.setInitialMemory(Integer.parseInt(sInitialMemory));
        }
        if ((args = this.getOtherArguments()).length > 0) {
            javaArguments.setAdditionalArguments(args);
        }
        return javaArguments;
    }

    private String[] getOtherArguments() {
        String sArgs = this.tfOtherArguments.getText().trim();
        if (sArgs.length() > 0) {
            String[] args = sArgs.split(" ");
            ArrayList<String> array = new ArrayList<String>();
            for (String arg : args) {
                if (arg.length() <= 0) continue;
                array.add(arg);
            }
            String[] fArgs = new String[array.size()];
            array.toArray(fArgs);
            return fArgs;
        }
        return new String[0];
    }

    private JPanel createPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBackground(UIFactory.DEFAULT_BACKGROUND);
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        topPanel.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        Insets insets = UIFactory.getCurrentStepPanelInsets();
        insets.bottom = 0;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = 0;
        Message title = QuickSetupMessages.INFO_JAVA_RUNTIME_SETTINGS_TITLE.get();
        JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, title, UIFactory.TextStyle.TITLE);
        l.setOpaque(false);
        topPanel.add((Component)l, gbc);
        JEditorPane instructionsPane = UIFactory.makeHtmlPane(this.message, UIFactory.INSTRUCTIONS_FONT);
        instructionsPane.setOpaque(false);
        instructionsPane.setEditable(false);
        ++gbc.gridy;
        gbc.insets.top = 10;
        topPanel.add((Component)instructionsPane, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.insets.bottom = 10;
        this.inputContainer = new JPanel(new CardLayout());
        this.inputContainer.setOpaque(false);
        this.inputContainer.add(this.createInputPanel(), INPUT_PANEL);
        JPanel checkingPanel = UIFactory.makeJPanel();
        checkingPanel.setLayout(new GridBagLayout());
        checkingPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.WAIT, QuickSetupMessages.INFO_GENERAL_CHECKING_DATA.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), new GridBagConstraints());
        this.inputContainer.add((Component)checkingPanel, CHECKING_PANEL);
        topPanel.add((Component)this.inputContainer, gbc);
        gbc.weighty = 1.0;
        ++gbc.gridy;
        gbc.insets = UIFactory.getEmptyInsets();
        topPanel.add(Box.createVerticalGlue(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        contentPanel.add((Component)topPanel, gbc);
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        contentPanel.add(this.createButtonsPanel(), gbc);
        return contentPanel;
    }

    private Component createInputPanel() {
        JPanel inputPanel = new JPanel(new GridBagLayout());
        inputPanel.setOpaque(false);
        this.lInitialMemory = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_INITIAL_MEMORY_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        this.lInitialMemory.setOpaque(false);
        this.tfInitialMemory = UIFactory.makeJTextField(Message.EMPTY, QuickSetupMessages.INFO_INITIAL_MEMORY_TOOLTIP.get(), 10, UIFactory.TextStyle.TEXTFIELD);
        this.lInitialMemory.setLabelFor(this.tfInitialMemory);
        this.lMaxMemory = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_MAX_MEMORY_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        this.lMaxMemory.setOpaque(false);
        this.tfMaxMemory = UIFactory.makeJTextField(Message.EMPTY, QuickSetupMessages.INFO_MAX_MEMORY_TOOLTIP.get(), 10, UIFactory.TextStyle.TEXTFIELD);
        this.lMaxMemory.setLabelFor(this.tfMaxMemory);
        this.lOtherArguments = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_OTHER_JAVA_ARGUMENTS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        this.lOtherArguments.setOpaque(false);
        this.tfOtherArguments = UIFactory.makeJTextField(Message.EMPTY, QuickSetupMessages.INFO_OTHER_JAVA_ARGUMENTS_TOOLTIP.get(), 30, UIFactory.TextStyle.TEXTFIELD);
        this.lOtherArguments.setLabelFor(this.tfOtherArguments);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        inputPanel.add((Component)this.lInitialMemory, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        inputPanel.add((Component)this.tfInitialMemory, gbc);
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.insets.left = 5;
        JLabel lMb = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_MEGABYTE_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        lMb.setOpaque(false);
        inputPanel.add((Component)lMb, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        inputPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_JAVA_ARGUMENTS_LEAVE_EMPTY.get(), UIFactory.TextStyle.INLINE_HELP), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        inputPanel.add((Component)this.lMaxMemory, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        inputPanel.add((Component)this.tfMaxMemory, gbc);
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.insets.left = 5;
        lMb = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_MEGABYTE_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        lMb.setOpaque(false);
        inputPanel.add((Component)lMb, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        inputPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_JAVA_ARGUMENTS_LEAVE_EMPTY.get(), UIFactory.TextStyle.INLINE_HELP), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        inputPanel.add((Component)this.lOtherArguments, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets.left = 10;
        inputPanel.add((Component)this.tfOtherArguments, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        inputPanel.add(Box.createVerticalGlue(), gbc);
        return inputPanel;
    }

    private Component createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.left = UIFactory.getCurrentStepPanelInsets().left;
        buttonsPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        --gbc.gridwidth;
        gbc.insets.left = 0;
        buttonsPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.okButton = UIFactory.makeJButton(QuickSetupMessages.INFO_OK_BUTTON_LABEL.get(), QuickSetupMessages.INFO_JAVA_ARGUMENTS_OK_BUTTON_TOOLTIP.get());
        buttonsPanel.add((Component)this.okButton, gbc);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                JavaArgumentsDialog.this.okClicked();
            }
        });
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        this.cancelButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get(), QuickSetupMessages.INFO_JAVA_ARGUMENTS_CANCEL_BUTTON_TOOLTIP.get());
        buttonsPanel.add((Component)this.cancelButton, gbc);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                JavaArgumentsDialog.this.cancelClicked();
            }
        });
        return buttonsPanel;
    }

    private void cancelClicked() {
        this.isCancelled = true;
        this.dispose();
    }

    private void okClicked() {
        BackgroundTask<ArrayList<Message>> worker = new BackgroundTask<ArrayList<Message>>(){

            @Override
            public ArrayList<Message> processBackgroundTask() {
                JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lInitialMemory, true);
                JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lMaxMemory, true);
                JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lOtherArguments, true);
                int initialMemory = -1;
                int maxMemory = -1;
                ArrayList<Message> errorMsgs = new ArrayList<Message>();
                try {
                    String sInitialMemory = JavaArgumentsDialog.this.tfInitialMemory.getText().trim();
                    if (sInitialMemory.length() > 0 && (initialMemory = Integer.parseInt(sInitialMemory)) <= 0) {
                        initialMemory = -1;
                        errorMsgs.add(QuickSetupMessages.ERR_INITIAL_MEMORY_VALUE.get());
                        JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lInitialMemory, false);
                    }
                }
                catch (Throwable t) {
                    errorMsgs.add(QuickSetupMessages.ERR_INITIAL_MEMORY_VALUE.get());
                    JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lInitialMemory, false);
                }
                try {
                    String sMaxMemory = JavaArgumentsDialog.this.tfMaxMemory.getText().trim();
                    if (sMaxMemory.length() > 0 && (maxMemory = Integer.parseInt(sMaxMemory)) <= 0) {
                        maxMemory = -1;
                        errorMsgs.add(QuickSetupMessages.ERR_MAX_MEMORY_VALUE.get());
                        JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lMaxMemory, false);
                    }
                }
                catch (Throwable t) {
                    errorMsgs.add(QuickSetupMessages.ERR_MAX_MEMORY_VALUE.get());
                    JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lMaxMemory, false);
                }
                if (maxMemory != -1 && initialMemory != -1 && initialMemory > maxMemory) {
                    errorMsgs.add(QuickSetupMessages.ERR_MAX_MEMORY_BIGGER_THAN_INITIAL_MEMORY.get());
                    JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lMaxMemory, false);
                    JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lInitialMemory, false);
                }
                if (errorMsgs.isEmpty()) {
                    ArrayList allErrors = new ArrayList();
                    JavaArgumentsDialog.this.checkAllArgumentsTogether(initialMemory, maxMemory, allErrors);
                    if (!allErrors.isEmpty()) {
                        ArrayList memoryErrors = new ArrayList();
                        JavaArgumentsDialog.this.checkMemoryArguments(initialMemory, maxMemory, memoryErrors);
                        ArrayList otherErrors = new ArrayList();
                        JavaArgumentsDialog.this.checkOtherArguments(otherErrors);
                        if (!memoryErrors.isEmpty()) {
                            errorMsgs.addAll(memoryErrors);
                            if (!otherErrors.isEmpty()) {
                                errorMsgs.addAll(otherErrors);
                            }
                        } else if (!otherErrors.isEmpty()) {
                            errorMsgs.addAll(otherErrors);
                        } else {
                            JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lInitialMemory, false);
                            JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lMaxMemory, false);
                            JavaArgumentsDialog.this.setValidLater(JavaArgumentsDialog.this.lOtherArguments, false);
                            errorMsgs.add(QuickSetupMessages.ERR_MEMORY_AND_OTHER_ARGUMENTS_NOT_COMPATIBLE.get());
                        }
                    }
                }
                return errorMsgs;
            }

            @Override
            public void backgroundTaskCompleted(ArrayList<Message> returnValue, Throwable throwable) {
                JavaArgumentsDialog.this.setCheckingVisible(false);
                if (throwable != null) {
                    throwable.printStackTrace();
                    JavaArgumentsDialog.this.displayError(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    JavaArgumentsDialog.this.cancelButton.setEnabled(true);
                    JavaArgumentsDialog.this.okButton.setEnabled(true);
                } else {
                    JavaArgumentsDialog.this.cancelButton.setEnabled(true);
                    JavaArgumentsDialog.this.okButton.setEnabled(true);
                    if (returnValue.size() > 0) {
                        JavaArgumentsDialog.this.displayError(Utils.getMessageFromCollection(returnValue, "\n"), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    } else if (JavaArgumentsDialog.this.displayWebStartWarningIfRequired()) {
                        JavaArgumentsDialog.this.isCancelled = false;
                        JavaArgumentsDialog.this.dispose();
                    }
                }
            }
        };
        this.setCheckingVisible(true);
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        worker.startBackgroundTask();
    }

    private void displayError(Message msg, Message title) {
        Utilities.displayError(this, msg, title);
        this.toFront();
    }

    private boolean displayConfirmationDialog(Message msg, Message title) {
        this.toFront();
        return Utilities.displayConfirmation(this, msg, title);
    }

    private void updateContents() {
        if (this.javaArguments.getInitialMemory() > 0) {
            this.tfInitialMemory.setText(String.valueOf(this.javaArguments.getInitialMemory()));
        } else {
            this.tfInitialMemory.setText("");
        }
        if (this.javaArguments.getMaxMemory() > 0) {
            this.tfMaxMemory.setText(String.valueOf(this.javaArguments.getMaxMemory()));
        } else {
            this.tfMaxMemory.setText("");
        }
        if (this.javaArguments.getAdditionalArguments() != null) {
            StringBuilder sb = new StringBuilder();
            for (String arg : this.javaArguments.getAdditionalArguments()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(arg);
            }
            this.tfOtherArguments.setText(sb.toString());
        } else {
            this.tfOtherArguments.setText("");
        }
    }

    private void setValidLater(final JComponent comp, final boolean valid) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIFactory.setTextStyle(comp, valid ? UIFactory.TextStyle.PRIMARY_FIELD_VALID : UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
            }
        });
    }

    private void setCheckingVisible(boolean visible) {
        if (visible != this.isCheckingVisible && this.inputContainer != null) {
            CardLayout cl = (CardLayout)this.inputContainer.getLayout();
            if (visible) {
                cl.show(this.inputContainer, CHECKING_PANEL);
            } else {
                cl.show(this.inputContainer, INPUT_PANEL);
            }
            this.isCheckingVisible = visible;
        }
    }

    public static void main(String[] args) {
        try {
            JavaArguments javaArgs = new JavaArguments();
            javaArgs.setInitialMemory(100);
            javaArgs.setMaxMemory(99);
            javaArgs.setAdditionalArguments(new String[]{"", "-client", "-XX"});
            JavaArgumentsDialog dlg = new JavaArgumentsDialog(new JFrame(), javaArgs, Message.raw("my title", new Object[0]), Message.raw("Set the java arguments for the test command-line.", new Object[0]));
            dlg.pack();
            dlg.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void checkOptions(String options, Collection<Message> errorMsgs, JLabel l, Message errorMsg) {
        this.checkOptions(options, errorMsgs, new JLabel[]{l}, errorMsg);
    }

    private void checkOptions(String options, Collection<Message> errorMsgs, JLabel[] ls, Message errorMsg) {
        if (!Utils.isWebStart()) {
            String javaHome = System.getProperty("java.home");
            if (javaHome == null || javaHome.length() == 0) {
                javaHome = System.getenv("OPENDS_JAVA_HOME");
            }
            if (!Utils.supportsOption(options, javaHome, INSTALL_PATH)) {
                for (JLabel l : ls) {
                    this.setValidLater(l, false);
                }
                errorMsgs.add(errorMsg);
            }
        }
    }

    private Message getMemoryErrorMessage(Message msg, int memValue) {
        if (memValue < 2048) {
            return msg;
        }
        MessageBuilder mb = new MessageBuilder();
        mb.append(msg);
        mb.append("  ");
        mb.append(QuickSetupMessages.ERR_MEMORY_32_BIT_LIMIT.get());
        return mb.toMessage();
    }

    private void checkMemoryArguments(int initialMemory, int maxMemory, Collection<Message> errorMsgs) {
        this.setValidLater(this.lInitialMemory, true);
        this.setValidLater(this.lMaxMemory, true);
        if (initialMemory != -1) {
            if (maxMemory != -1) {
                Message msg = this.getMemoryErrorMessage(QuickSetupMessages.ERR_MEMORY_VALUE_EXTENDED.get(JavaArguments.getInitialMemoryGenericArgument(), JavaArguments.getMaxMemoryGenericArgument()), maxMemory);
                String sMemory = JavaArguments.getInitialMemoryArgument(initialMemory) + " " + JavaArguments.getMaxMemoryArgument(maxMemory);
                this.checkOptions(sMemory, errorMsgs, new JLabel[]{this.lInitialMemory, this.lMaxMemory}, msg);
            } else {
                Message msg = this.getMemoryErrorMessage(QuickSetupMessages.ERR_INITIAL_MEMORY_VALUE_EXTENDED.get(JavaArguments.getInitialMemoryGenericArgument()), initialMemory);
                this.checkOptions(JavaArguments.getInitialMemoryArgument(initialMemory), errorMsgs, this.lInitialMemory, msg);
            }
        } else if (maxMemory != -1) {
            Message msg = this.getMemoryErrorMessage(QuickSetupMessages.ERR_MAX_MEMORY_VALUE_EXTENDED.get(JavaArguments.getInitialMemoryGenericArgument()), maxMemory);
            this.checkOptions(JavaArguments.getMaxMemoryArgument(maxMemory), errorMsgs, this.lMaxMemory, msg);
        }
    }

    private void checkAllArgumentsTogether(int initialMemory, int maxMemory, Collection<Message> errorMsgs) {
        this.setValidLater(this.lInitialMemory, true);
        this.setValidLater(this.lMaxMemory, true);
        this.setValidLater(this.lOtherArguments, true);
        ArrayList<JLabel> ls = new ArrayList<JLabel>();
        StringBuilder sb = new StringBuilder();
        if (initialMemory != -1) {
            if (maxMemory != -1) {
                String sMemory = JavaArguments.getInitialMemoryArgument(initialMemory) + " " + JavaArguments.getMaxMemoryArgument(maxMemory);
                sb.append(sMemory);
                ls.add(this.lInitialMemory);
                ls.add(this.lMaxMemory);
            } else {
                sb.append(JavaArguments.getInitialMemoryArgument(initialMemory));
                ls.add(this.lInitialMemory);
            }
        } else if (maxMemory != -1) {
            sb.append(JavaArguments.getMaxMemoryArgument(maxMemory));
            ls.add(this.lMaxMemory);
        }
        String[] otherArgs = this.getOtherArguments();
        if (otherArgs.length > 0) {
            ls.add(this.lOtherArguments);
            for (String arg : otherArgs) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(arg);
            }
        }
        if (sb.length() > 0) {
            this.checkOptions(sb.toString(), errorMsgs, ls.toArray(new JLabel[0]), QuickSetupMessages.ERR_GENERIC_JAVA_ARGUMENT.get(sb.toString()));
        }
    }

    private void checkOtherArguments(Collection<Message> errorMsgs) {
        this.setValidLater(this.lOtherArguments, true);
        ArrayList<JLabel> ls = new ArrayList<JLabel>();
        StringBuilder sb = new StringBuilder();
        String[] otherArgs = this.getOtherArguments();
        if (otherArgs.length > 0) {
            ls.add(this.lOtherArguments);
            for (String arg : otherArgs) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(arg);
            }
        }
        if (sb.length() > 0) {
            this.checkOptions(sb.toString(), errorMsgs, this.lOtherArguments, QuickSetupMessages.ERR_GENERIC_JAVA_ARGUMENT.get(sb.toString()));
        }
    }

    private boolean displayWebStartWarningIfRequired() {
        JavaArguments args;
        boolean returnValue = true;
        if (!(!Utils.isWebStart() || userAgreedWithWebStart || (args = this.getJavaArguments()).equals(this.javaArguments) || args.getInitialMemory() == -1 && args.getMaxMemory() == -1 && args.getAdditionalArguments().length <= 0)) {
            userAgreedWithWebStart = returnValue = this.displayConfirmationDialog(QuickSetupMessages.INFO_JAVA_ARGUMENTS_CANNOT_BE_CHECKED_IN_WEBSTART.get(), QuickSetupMessages.INFO_CONFIRMATION_TITLE.get());
        }
        return returnValue;
    }

    static {
        INSTALL_PATH = Utils.getInstallPathFromClasspath();
    }
}

