/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.Configuration;
import org.opends.quicksetup.CurrentInstallStatus;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmUninstallPanel
extends QuickSetupStepPanel {
    private static final Logger LOG = Logger.getLogger(ConfirmUninstallPanel.class.getName());
    private static final long serialVersionUID = 81730510134697056L;
    private Set<String> outsideDbs;
    private Set<String> outsideLogs;
    private HashMap<FieldName, JCheckBox> hmCbs = new HashMap();

    public ConfirmUninstallPanel(GuiApplication application, CurrentInstallStatus installStatus) {
        super(application);
    }

    @Override
    public Object getFieldValue(FieldName fieldName) {
        Serializable value = null;
        switch (fieldName) {
            case EXTERNAL_DB_DIRECTORIES: {
                HashSet<String> s1 = new HashSet<String>();
                if (this.outsideDbs.size() > 0 && this.getCheckBox(FieldName.EXTERNAL_DB_DIRECTORIES).isSelected()) {
                    s1.addAll(this.outsideDbs);
                }
                value = s1;
                break;
            }
            case EXTERNAL_LOG_FILES: {
                HashSet<String> s2 = new HashSet<String>();
                if (this.outsideLogs.size() > 0 && this.getCheckBox(FieldName.EXTERNAL_LOG_FILES).isSelected()) {
                    s2.addAll(this.outsideLogs);
                }
                value = s2;
                break;
            }
            default: {
                JCheckBox cb = this.getCheckBox(fieldName);
                value = new Boolean(cb.isSelected());
            }
        }
        return value;
    }

    @Override
    protected Message getTitle() {
        return AdminToolMessages.INFO_CONFIRM_UNINSTALL_PANEL_TITLE.get();
    }

    @Override
    protected Component createInputPanel() {
        FieldName[] fieldNames = new FieldName[]{FieldName.REMOVE_LIBRARIES_AND_TOOLS, FieldName.REMOVE_DATABASES, FieldName.REMOVE_LOGS, FieldName.REMOVE_CONFIGURATION_AND_SCHEMA, FieldName.REMOVE_BACKUPS, FieldName.REMOVE_LDIFS};
        Message[] labels = new Message[]{AdminToolMessages.INFO_REMOVE_LIBRARIES_AND_TOOLS_LABEL.get(), AdminToolMessages.INFO_REMOVE_DATABASES_LABEL.get(), AdminToolMessages.INFO_REMOVE_LOGS_LABEL.get(), AdminToolMessages.INFO_REMOVE_SCHEMA_AND_CONFIGURATION_LABEL.get(), AdminToolMessages.INFO_REMOVE_BACKUPS_LABEL.get(), AdminToolMessages.INFO_REMOVE_LDIFS_LABEL.get()};
        Message[] tooltips = new Message[]{AdminToolMessages.INFO_REMOVE_LIBRARIES_AND_TOOLS_TOOLTIP.get(), AdminToolMessages.INFO_REMOVE_DATABASES_TOOLTIP.get(), AdminToolMessages.INFO_REMOVE_LOGS_TOOLTIP.get(), AdminToolMessages.INFO_REMOVE_SCHEMA_AND_CONFIGURATION_TOOLTIP.get(), AdminToolMessages.INFO_REMOVE_BACKUPS_TOOLTIP.get(), AdminToolMessages.INFO_REMOVE_LDIFS_TOOLTIP.get()};
        for (int i = 0; i < fieldNames.length; ++i) {
            JCheckBox cb = UIFactory.makeJCheckBox(labels[i], tooltips[i], UIFactory.TextStyle.INSTRUCTIONS);
            cb.setSelected(true);
            this.hmCbs.put(fieldNames[i], cb);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        gbc.anchor = 17;
        p.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_SERVER_PATH_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), gbc);
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        p.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, Message.raw(Utils.getInstallPathFromClasspath(), new Object[0]), UIFactory.TextStyle.INSTRUCTIONS), gbc);
        FieldName[] names = new FieldName[]{FieldName.REMOVE_LIBRARIES_AND_TOOLS, FieldName.REMOVE_DATABASES, FieldName.REMOVE_LOGS, FieldName.REMOVE_CONFIGURATION_AND_SCHEMA, FieldName.REMOVE_BACKUPS, FieldName.REMOVE_LDIFS};
        for (int i = 0; i < names.length; ++i) {
            gbc.gridwidth = -1;
            p.add(Box.createHorizontalGlue(), gbc);
            gbc.insets.left = 0;
            gbc.gridwidth = 0;
            gbc.insets.left = 5;
            p.add((Component)this.getCheckBox(names[i]), gbc);
        }
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets.left = 0;
        panel.add((Component)p, gbc);
        Installation installation = Installation.getLocal();
        Configuration config = installation.getCurrentConfiguration();
        try {
            this.outsideDbs = config.getOutsideDbs();
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "Unable to determin outside databases", ioe);
        }
        try {
            this.outsideLogs = config.getOutsideLogs();
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "Unable to determin outside logs", ioe);
        }
        gbc.insets.top = 10;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        if (this.outsideDbs.size() > 0) {
            JPanel dbPanel = this.createDbPanel();
            panel.add((Component)dbPanel, gbc);
        }
        if (this.outsideLogs.size() > 0) {
            JPanel logPanel = this.createLogPanel();
            panel.add((Component)logPanel, gbc);
        }
        this.addVerticalGlue(panel);
        return panel;
    }

    @Override
    protected Message getInstructions() {
        return AdminToolMessages.INFO_CONFIRM_UNINSTALL_PANEL_INSTRUCTIONS.get();
    }

    private JPanel createDbPanel() {
        JCheckBox cbOutsideDbs = UIFactory.makeJCheckBox(AdminToolMessages.INFO_DELETE_OUTSIDE_DBS_LABEL.get(), AdminToolMessages.INFO_DELETE_OUTSIDE_DBS_TOOLTIP.get(), UIFactory.TextStyle.INSTRUCTIONS);
        cbOutsideDbs.setSelected(true);
        this.hmCbs.put(FieldName.EXTERNAL_DB_DIRECTORIES, cbOutsideDbs);
        return this.createOutsidePathPanel(cbOutsideDbs, this.outsideDbs, AdminToolMessages.INFO_DELETE_OUTSIDE_DBS_MSG.get());
    }

    private JPanel createLogPanel() {
        JCheckBox cbOutsideLogs = UIFactory.makeJCheckBox(AdminToolMessages.INFO_DELETE_OUTSIDE_LOGS_LABEL.get(), AdminToolMessages.INFO_DELETE_OUTSIDE_LOGS_TOOLTIP.get(), UIFactory.TextStyle.INSTRUCTIONS);
        cbOutsideLogs.setSelected(true);
        this.hmCbs.put(FieldName.EXTERNAL_LOG_FILES, cbOutsideLogs);
        return this.createOutsidePathPanel(cbOutsideLogs, this.outsideLogs, AdminToolMessages.INFO_DELETE_OUTSIDE_LOGS_MSG.get());
    }

    private JPanel createOutsidePathPanel(JCheckBox cb, Set<String> paths, Message msg) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, msg, UIFactory.TextStyle.INSTRUCTIONS), gbc);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (String path : paths) {
            listModel.addElement(path);
        }
        JList list = UIFactory.makeJList(UIFactory.TextStyle.INSTRUCTIONS);
        list.setModel(listModel);
        list.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        list.setVisibleRowCount(Math.min(3, listModel.getSize()));
        JScrollPane scroll = new JScrollPane(list);
        scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        gbc.insets.left = 35;
        panel.add((Component)scroll, gbc);
        gbc.insets.left = 0;
        panel.add((Component)cb, gbc);
        return panel;
    }

    private JCheckBox getCheckBox(FieldName fieldName) {
        JCheckBox cb = this.hmCbs.get((Object)fieldName);
        if (cb == null) {
            throw new IllegalArgumentException("The FieldName " + (Object)((Object)fieldName) + " has no checkbox associated.");
        }
        return cb;
    }
}

