/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.ResetUserPasswordTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class ResetUserPasswordPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 8733172823605832626L;
    private JLabel dn = Utilities.createDefaultLabel();
    private JLabel name = Utilities.createDefaultLabel();
    private JLabel lPassword = Utilities.createPrimaryLabel();
    private JLabel lConfirmPassword = Utilities.createPrimaryLabel();
    private JPasswordField password = Utilities.createPasswordField(25);
    private JPasswordField confirmPassword = Utilities.createPasswordField(25);
    private BasicNode node;
    private BrowserController controller;

    public ResetUserPasswordPanel() {
        this.createLayout();
    }

    public void setValue(BasicNode node, BrowserController controller) {
        this.node = node;
        this.controller = controller;
        this.setPrimaryValid(this.lPassword);
        this.setPrimaryValid(this.lConfirmPassword);
        this.dn.setText(node.getDN());
        this.name.setText(node.getDisplayName());
        this.password.setText("");
        this.confirmPassword.setText("");
        this.packParentDialog();
    }

    public Component getPreferredFocusComponent() {
        return this.password;
    }

    public void okClicked() {
        ArrayList<Message> errors = new ArrayList<Message>();
        this.setPrimaryValid(this.lPassword);
        this.setPrimaryValid(this.lConfirmPassword);
        String pwd1 = new String(this.password.getPassword());
        String pwd2 = new String(this.confirmPassword.getPassword());
        if (pwd1.length() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NEW_PASSWORD_REQUIRED.get());
            this.setPrimaryInvalid(this.lPassword);
        } else if (!pwd1.equals(pwd2)) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_PASSWORD_DO_NOT_MATCH.get());
            this.setPrimaryInvalid(this.lPassword);
            this.setPrimaryInvalid(this.lConfirmPassword);
        }
        if (errors.size() == 0) {
            ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_TITLE.get(), this.getInfo());
            ResetUserPasswordTask newTask = new ResetUserPasswordTask(this.getInfo(), dlg, this.node, this.controller, this.password.getPassword());
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.size() == 0) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_RESETTING_USER_PASSWORD_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_RESETTING_USER_PASSWORD_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_RESETTING_USER_PASSWORD_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_RESETTING_USER_PASSWORD_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_RESETTING_USER_PASSWORD_ERROR_DETAILS.get(), null, dlg);
                Utilities.getParentDialog(this).setVisible(false);
                dlg.setVisible(true);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_TITLE.get();
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        Message[] strings = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_DN_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_NAME_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_PWD_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_CONFIRM_LABEL.get()};
        JLabel[] labels = new JLabel[]{null, null, this.lPassword, this.lConfirmPassword};
        Component[] comps = new Component[]{this.dn, this.name, this.password, this.confirmPassword};
        for (int i = 0; i < strings.length; ++i) {
            if (labels[i] == null) {
                labels[i] = Utilities.createPrimaryLabel(strings[i]);
            } else {
                labels[i].setText(strings[i].toString());
            }
            gbc.gridx = 0;
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            this.add((Component)labels[i], gbc);
            gbc.insets.left = 10;
            ++gbc.gridx;
            gbc.weightx = 1.0;
            this.add(comps[i], gbc);
            gbc.insets.top = 10;
            ++gbc.gridy;
        }
        this.addBottomGlue(gbc);
    }
}

