/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opends.guitools.controlpanel.datamodel.MonitoringAttributes;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringAttributesViewPanel<T>
extends StatusGenericPanel {
    private static final long serialVersionUID = 6462932163745559L;
    private LinkedHashSet<T> selectedAttributes = new LinkedHashSet();
    private LinkedHashSet<T> monitoringAttributes;
    private boolean isCancelled = true;
    private JCheckBox[] checkboxes = new JCheckBox[0];
    private JButton selectAll;
    private JButton selectNone;

    public static MonitoringAttributesViewPanel<String> createStringInstance(LinkedHashSet<String> attributes) {
        return new MonitoringAttributesViewPanel<String>(attributes);
    }

    public static MonitoringAttributesViewPanel<MonitoringAttributes> createMonitoringAttributesInstance(LinkedHashSet<MonitoringAttributes> attributes) {
        return new MonitoringAttributesViewPanel<MonitoringAttributes>(attributes);
    }

    public static MonitoringAttributesViewPanel<Message> createMessageInstance(LinkedHashSet<Message> attributes) {
        return new MonitoringAttributesViewPanel<Message>(attributes);
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    protected MonitoringAttributesViewPanel(LinkedHashSet<T> attributes) {
        this.monitoringAttributes = new LinkedHashSet();
        this.monitoringAttributes.addAll(attributes);
        this.createLayout();
    }

    public void setSelectedAttributes(Collection<T> selectedAttributes) {
        int i = 0;
        for (Object attribute : this.monitoringAttributes) {
            this.checkboxes[i].setSelected(selectedAttributes.contains(attribute));
            ++i;
        }
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        this.add((Component)Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OPERATION_VIEW_LABEL.get()), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets.top = 10;
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        checkBoxPanel.setOpaque(false);
        JScrollPane scroll = Utilities.createBorderLessScrollBar(checkBoxPanel);
        ScrollPaneBorderListener.createFullBorderListener(scroll);
        this.checkboxes = new JCheckBox[this.monitoringAttributes.size()];
        int i = 0;
        for (Object attribute : this.monitoringAttributes) {
            Message m = this.getMessage(attribute);
            this.checkboxes[i] = Utilities.createCheckBox(m);
            ++i;
        }
        this.selectAll = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SELECT_ALL_BUTTON.get());
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                for (JCheckBox cb : MonitoringAttributesViewPanel.this.checkboxes) {
                    cb.setSelected(true);
                }
            }
        });
        this.selectNone = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CLEAR_SELECTION_BUTTON.get());
        this.selectNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                for (JCheckBox cb : MonitoringAttributesViewPanel.this.checkboxes) {
                    cb.setSelected(false);
                }
            }
        });
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 3;
        gbc.fill = 1;
        this.add((Component)scroll, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.left = 10;
        gbc.gridheight = 1;
        this.add((Component)this.selectAll, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        this.add((Component)this.selectNone, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        int preferredViewHeight = -1;
        for (JCheckBox cb : this.checkboxes) {
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            checkBoxPanel.add((Component)cb, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            checkBoxPanel.add(Box.createHorizontalGlue(), gbc);
            gbc.insets.top = 10;
            ++gbc.gridy;
            if (gbc.gridy != 15) continue;
            preferredViewHeight = checkBoxPanel.getPreferredSize().height;
        }
        if (preferredViewHeight < 0) {
            preferredViewHeight = checkBoxPanel.getPreferredSize().height;
        }
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        checkBoxPanel.add(Box.createVerticalGlue(), gbc);
        scroll.getViewport().setPreferredSize(new Dimension(checkBoxPanel.getPreferredSize().width + 15, preferredViewHeight));
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_VIEW_OPTIONS_TITLE.get();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.checkboxes[0];
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.isCancelled = true;
        }
    }

    @Override
    public void okClicked() {
        this.selectedAttributes.clear();
        int i = 0;
        for (Object operation : this.monitoringAttributes) {
            if (this.checkboxes[i].isSelected()) {
                this.selectedAttributes.add(operation);
            }
            ++i;
        }
        if (this.selectedAttributes.isEmpty()) {
            ArrayList<Message> errors = new ArrayList<Message>();
            errors.add(AdminToolMessages.INFO_CTRL_PANEL_NO_OPERATION_SELECTED.get());
            super.displayErrorDialog(errors);
        } else {
            this.isCancelled = false;
            super.closeClicked();
        }
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.OK_CANCEL;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public LinkedHashSet<T> getAttributes() {
        return this.selectedAttributes;
    }

    protected Message getMessage(T operation) {
        Message m = operation instanceof MonitoringAttributes ? ((MonitoringAttributes)operation).getMessage() : (operation instanceof Message ? (Message)operation : Message.raw(operation.toString(), new Object[0]));
        return m;
    }
}

