/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalBorders;
import org.opends.guitools.controlpanel.util.Utilities;

public class ColorAndFontConstants {
    public static final Color foreground = UIManager.getColor("TextField.foreground");
    public static final Color background;
    private static Color toggleButtonColor;
    public static final Border textAreaBorder;
    public static final Color buttonForeground;
    public static final Color categoryForeground;
    public static final Color expanderForeground;
    public static final Color greyBackground;
    public static final Color defaultBorderColor;
    public static final Color gridColor;
    public static final Color tableForeground;
    public static final Color tableBackground;
    public static final Color treeForeground;
    public static final Color treeBackground;
    public static final Color mouseOverBackground;
    public static final Color validFontColor;
    public static final Color mouseOverForeground;
    public static final Color pressedBackground;
    public static final Color pressedForeground;
    public static final Font defaultFont;
    public static final Font expanderFont;
    public static final Font inlineHelpFont;
    public static final Font headerFont;
    public static final Font errorTitleFont;
    public static final Font categoryFont;
    public static final Color topAccordionBorderColor;
    public static final Font primaryFont;
    public static final Font treeFont;
    public static final Font tableFont;
    public static final Font titleFont;
    public static final Color invalidFontColor;
    public static final Font primaryInvalidFont;
    public static final Font invalidFont;
    public static final Font progressFont;
    public static final Font outputFont;

    public static void initialize() {
    }

    static {
        Color bg = Color.white;
        try {
            bg = foreground.getGreen() + foreground.getRed() + foreground.getBlue() > 600 ? UIManager.getColor("TextField.background") : Color.white;
            toggleButtonColor = UIManager.getColor("ToggleButton.background");
            if (toggleButtonColor == null) {
                toggleButtonColor = new Color(200, 200, 200);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        Border border = null;
        try {
            JScrollPane scroll = new JScrollPane();
            border = scroll.getBorder();
            if (border instanceof MetalBorders.ScrollPaneBorder) {
                border = null;
            }
        }
        catch (Throwable t) {
            border = null;
        }
        if (border == null) {
            border = new MetalBorders.Flush3DBorder();
        }
        textAreaBorder = border;
        background = bg;
        buttonForeground = UIManager.getColor("Button.foreground");
        categoryForeground = foreground;
        expanderForeground = foreground;
        greyBackground = Utilities.isWindows() ? UIManager.getColor("MenuBar.background") : UIManager.getColor("Panel.background");
        defaultBorderColor = Utilities.deriveColorHSB(toggleButtonColor, 0.0f, 0.0f, -0.2f);
        gridColor = Utilities.isMacOS() ? defaultBorderColor : UIManager.getColor("Table.gridColor");
        tableForeground = foreground;
        tableBackground = background;
        treeForeground = foreground;
        treeBackground = background;
        mouseOverBackground = UIManager.getColor("TextField.selectionBackground");
        validFontColor = foreground;
        mouseOverForeground = UIManager.getColor("TextField.selectionForeground");
        pressedBackground = Utilities.deriveColorHSB(mouseOverBackground, 0.0f, 0.0f, -0.2f);
        pressedForeground = Utilities.deriveColorHSB(mouseOverForeground, 0.0f, 0.0f, 0.2f);
        defaultFont = UIManager.getFont("Label.font");
        expanderFont = defaultFont.deriveFont(1);
        inlineHelpFont = defaultFont.deriveFont((float)(defaultFont.getSize() - 2));
        headerFont = UIManager.getFont("TableHeader.font").deriveFont(1);
        errorTitleFont = defaultFont.deriveFont(1).deriveFont(13.0f);
        categoryFont = UIManager.getFont("Label.font").deriveFont(1);
        topAccordionBorderColor = Utilities.deriveColorHSB(toggleButtonColor, 0.0f, 0.0f, 0.2f);
        primaryFont = defaultFont.deriveFont(1);
        treeFont = UIManager.getFont("Tree.font");
        tableFont = UIManager.getFont("Table.font");
        titleFont = defaultFont.deriveFont(1).deriveFont(14.0f);
        invalidFontColor = Color.red;
        primaryInvalidFont = primaryFont.deriveFont(2);
        invalidFont = defaultFont.deriveFont(2);
        progressFont = UIManager.getFont("EditorPane.font");
        outputFont = Font.decode("Monospaced-PLAIN-12");
    }
}

