/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.BinaryAttributeEditorPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.Schema;

public class BinaryValuePanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 2536360199438858665L;
    private JLabel lBase64;
    private JTextField base64;
    private JLabel attrName;
    private JLabel imagePreview;
    private JLabel lImage = Utilities.createDefaultLabel();
    private byte[] lastBytes;
    private static final Logger LOG = Logger.getLogger(BinaryValuePanel.class.getName());

    public BinaryValuePanel() {
        this.createLayout();
    }

    public void setValue(final String attr, final byte[] bytes) {
        boolean launchBackground = this.lastBytes != bytes;
        this.lastBytes = bytes;
        BackgroundTask<Void> worker = new BackgroundTask<Void>(){

            @Override
            public Void processBackgroundTask() throws Throwable {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                BinaryValuePanel.this.attrName.setText(attr);
                Schema schema = BinaryValuePanel.this.getInfo().getServerDescriptor().getSchema();
                if (Utilities.hasImageSyntax(attr, schema)) {
                    BinaryAttributeEditorPanel.updateImage(BinaryValuePanel.this.lImage, bytes);
                    BinaryValuePanel.this.lBase64.setVisible(false);
                    BinaryValuePanel.this.base64.setVisible(false);
                    BinaryValuePanel.this.imagePreview.setVisible(true);
                } else {
                    BinaryValuePanel.this.lImage.setIcon(null);
                    BinaryValuePanel.this.lImage.setText("");
                    BinaryValuePanel.this.imagePreview.setVisible(false);
                    BinaryValuePanel.this.lBase64.setVisible(true);
                    BinaryValuePanel.this.base64.setVisible(true);
                    BinaryAttributeEditorPanel.updateBase64(BinaryValuePanel.this.base64, bytes);
                }
                return null;
            }

            @Override
            public void backgroundTaskCompleted(Void returnValue, Throwable t) {
                BinaryValuePanel.this.displayMainPanel();
                BinaryValuePanel.this.packParentDialog();
                if (t != null) {
                    LOG.log(Level.WARNING, "Error reading binary contents: " + t, t);
                }
            }
        };
        if (launchBackground) {
            this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_READING_SUMMARY.get());
            worker.startBackgroundTask();
        } else {
            this.attrName.setText(attr);
        }
    }

    public Component getPreferredFocusComponent() {
        return this.base64;
    }

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.CLOSE;
    }

    public void okClicked() {
    }

    public boolean requiresScroll() {
        return true;
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_VIEW_BINARY_ATTRIBUTE_TITLE.get();
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        JLabel l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_NAME_LABEL.get());
        this.add((Component)l, gbc);
        ++gbc.gridx;
        gbc.insets.left = 10;
        gbc.fill = 0;
        this.attrName = Utilities.createDefaultLabel();
        this.add((Component)this.attrName, gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        this.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.gridx = 0;
        this.lBase64 = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_VALUE_IN_BASE_64_LABEL.get());
        this.add((Component)this.lBase64, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.base64 = Utilities.createLongTextField();
        this.add((Component)this.base64, gbc);
        this.imagePreview = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_IMAGE_PREVIEW_LABEL.get());
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.imagePreview, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.top = 5;
        this.add((Component)this.lImage, gbc);
        this.addBottomGlue(gbc);
    }
}

