/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewEntryTask
extends Task {
    private Entry newEntry;
    private String ldif;
    private Set<String> backendSet = new HashSet<String>();
    private BasicNode parentNode;
    private BrowserController controller;
    private DN dn;
    private boolean useAdminCtx = false;

    public NewEntryTask(ControlPanelInfo info, ProgressDialog dlg, Entry newEntry, String ldif, BasicNode parentNode, BrowserController controller) {
        super(info, dlg);
        this.newEntry = newEntry;
        this.ldif = ldif;
        this.parentNode = parentNode;
        this.controller = controller;
        this.dn = newEntry.getDN();
        for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
            for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                if (!this.dn.isDescendantOf(baseDN.getDn())) continue;
                this.backendSet.add(backend.getBackendID());
            }
        }
    }

    @Override
    public Task.Type getType() {
        return Task.Type.NEW_ENTRY;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_ENTRY_TASK_DESCRIPTION.get(this.dn.toString());
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (!this.isServerRunning() && this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public boolean regenerateDescriptor() {
        return false;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            InitialLdapContext ctx;
            if (this.parentNode != null) {
                ctx = this.controller.findConnectionForDisplayedEntry(this.parentNode);
                this.useAdminCtx = this.controller.isConfigurationNode(this.parentNode);
            } else {
                ctx = this.getInfo().getDirContext();
                this.useAdminCtx = true;
            }
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute objectclass = new BasicAttribute("objectClass");
            for (String oc : this.newEntry.getObjectClasses().values()) {
                objectclass.add(oc);
            }
            attrs.put(objectclass);
            for (Attribute attr : this.newEntry.getAttributes()) {
                String attrName = attr.getNameWithOptions();
                LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
                Iterator<AttributeValue> it = attr.iterator();
                while (it.hasNext()) {
                    values.add(it.next());
                }
                BasicAttribute a = new BasicAttribute(attrName);
                for (AttributeValue value : values) {
                    a.add(value.getValue().toByteArray());
                }
                attrs.put(a);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewEntryTask.this.printEquivalentCommand();
                    NewEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_ENTRY.get(NewEntryTask.this.dn.toString()), ColorAndFontConstants.progressFont));
                }
            });
            ctx.createSubcontext(Utilities.getJNDIName(this.newEntry.getDN().toString()), (Attributes)attrs);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    boolean entryInserted = false;
                    if (NewEntryTask.this.parentNode != null) {
                        boolean isReallyParentNode = false;
                        try {
                            DN parentDN = DN.decode(NewEntryTask.this.parentNode.getDN());
                            isReallyParentNode = parentDN.equals(NewEntryTask.this.newEntry.getDN().getParent());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            isReallyParentNode = false;
                        }
                        if (isReallyParentNode) {
                            NewEntryTask.this.insertNode(NewEntryTask.this.parentNode, NewEntryTask.this.newEntry.getDN(), NewEntryTask.this.isBaseDN(NewEntryTask.this.newEntry.getDN()));
                            entryInserted = true;
                        }
                    }
                    if (!entryInserted) {
                        int nRootChildren;
                        BasicNode root = (BasicNode)NewEntryTask.this.controller.getTreeModel().getRoot();
                        BasicNode realParentNode = NewEntryTask.this.findParentNode(NewEntryTask.this.newEntry.getDN(), root);
                        if (realParentNode != null) {
                            NewEntryTask.this.insertNode(realParentNode, NewEntryTask.this.newEntry.getDN(), false);
                        } else if (NewEntryTask.this.isBaseDN(NewEntryTask.this.newEntry.getDN()) && (nRootChildren = NewEntryTask.this.controller.getTreeModel().getChildCount(NewEntryTask.this.controller.getTreeModel().getRoot())) > 1) {
                            NewEntryTask.this.insertNode(root, NewEntryTask.this.newEntry.getDN(), true);
                        }
                    }
                }
            });
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    private void printEquivalentCommand() {
        String[] lines;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(this.useAdminCtx, true)));
        args.add(this.getNoPropertiesFileArgument());
        args.add("--defaultAdd");
        String equiv = NewEntryTask.getEquivalentCommandLine(this.getCommandLinePath("ldapmodify"), args);
        StringBuilder sb = new StringBuilder();
        sb.append(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_CREATE_ENTRY.get() + "<br><b>");
        sb.append(equiv);
        sb.append("<br>");
        for (String line : lines = this.ldif.split("\n")) {
            sb.append(this.obfuscateLDIFLine(line));
            sb.append("<br>");
        }
        sb.append("</b><br>");
        this.getProgressDialog().appendProgressHtml(Utilities.applyFont(sb.toString(), ColorAndFontConstants.progressFont));
    }

    private BasicNode findParentNode(DN dn, BasicNode root) {
        BasicNode parentNode = null;
        int nRootChildren = this.controller.getTreeModel().getChildCount(root);
        for (int i = 0; i < nRootChildren; ++i) {
            BasicNode node = (BasicNode)this.controller.getTreeModel().getChild(root, i);
            try {
                DN nodeDN = DN.decode(node.getDN());
                if (!dn.isDescendantOf(nodeDN)) continue;
                if (dn.getNumComponents() == nodeDN.getNumComponents() + 1) {
                    parentNode = node;
                    break;
                }
                parentNode = this.findParentNode(dn, node);
                break;
            }
            catch (Throwable t) {
                throw new RuntimeException("Unexpected error: " + t, t);
            }
        }
        return parentNode;
    }

    private void insertNode(BasicNode parentNode, DN dn, boolean isSuffix) {
        TreePath newPath;
        BrowserNodeInfo nodeInfo;
        TreePath parentPath = new TreePath(this.controller.getTreeModel().getPathToRoot(parentNode));
        if (parentPath != null && (nodeInfo = this.controller.getNodeInfoFromPath(parentPath)) != null && (newPath = isSuffix ? this.controller.addSuffix(dn.toString(), parentNode.getDN()) : this.controller.notifyEntryAdded(this.controller.getNodeInfoFromPath(parentPath), dn.toString())) != null) {
            this.controller.getTree().setSelectionPath(newPath);
            this.controller.getTree().scrollPathToVisible(newPath);
        }
    }

    private boolean isBaseDN(DN dn) {
        boolean isBaseDN = false;
        for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
            for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                if (!baseDN.getDn().equals(dn)) continue;
                isBaseDN = true;
                break;
            }
            if (!isBaseDN) continue;
            break;
        }
        return isBaseDN;
    }
}

