/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.tools.ManageTasks;
import org.opends.server.tools.tasks.TaskEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelTaskTask
extends Task {
    private Set<String> backendSet = new HashSet<String>();
    private List<TaskEntry> tasks;

    public CancelTaskTask(ControlPanelInfo info, ProgressDialog dlg, List<TaskEntry> tasks) {
        super(info, dlg);
        for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
            this.backendSet.add(backend.getBackendID());
        }
        this.tasks = new ArrayList<TaskEntry>(tasks);
    }

    @Override
    public Task.Type getType() {
        return Task.Type.MODIFY_ENTRY;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_CANCEL_TASK_DESCRIPTION.get();
    }

    @Override
    public boolean regenerateDescriptor() {
        return true;
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    private ArrayList<String> getCommandLineArguments(TaskEntry task) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--cancel");
        args.add(task.getId());
        args.addAll(this.getConnectionCommandLineArguments());
        args.add(this.getNoPropertiesFileArgument());
        return args;
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (!this.isServerRunning() && this.state == Task.State.RUNNING) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            final int totalNumber = this.tasks.size();
            int numberCanceled = 0;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CancelTaskTask.this.getProgressDialog().getProgressBar().setIndeterminate(true);
                }
            });
            for (final TaskEntry task : this.tasks) {
                final ArrayList<String> arguments = this.getCommandLineArguments(task);
                final boolean isFirst = numberCanceled == 0;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (isFirst) {
                            CancelTaskTask.this.getProgressDialog().appendProgressHtml("<br><br>");
                        }
                        ArrayList<String> args = new ArrayList<String>();
                        args.addAll(CancelTaskTask.this.getObfuscatedCommandLineArguments(arguments));
                        CancelTaskTask.this.printEquivalentCommandLine(CancelTaskTask.this.getCommandLinePath("manage-tasks"), args, AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_CANCEL_TASK.get(task.getId()));
                    }
                });
                String[] args = new String[arguments.size()];
                arguments.toArray(args);
                this.returnCode = ManageTasks.mainTaskInfo(args, System.in, this.outPrintStream, this.errorPrintStream, false);
                if (this.returnCode != 0) break;
                final int fNumberCanceled = ++numberCanceled;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (fNumberCanceled == 1) {
                            CancelTaskTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                        }
                        CancelTaskTask.this.getProgressDialog().getProgressBar().setValue(fNumberCanceled * 100 / totalNumber);
                    }
                });
            }
            this.state = this.returnCode != 0 ? Task.State.FINISHED_WITH_ERROR : Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }
}

