/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.types.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDescriptor
extends AbstractIndexDescriptor {
    private SortedSet<LocalDBIndexCfgDefn.IndexType> types = new TreeSet<LocalDBIndexCfgDefn.IndexType>();
    private boolean isDatabaseIndex;
    private int entryLimit;
    private AttributeType attr;
    private int hashCode;

    public IndexDescriptor(String name, AttributeType attr, BackendDescriptor backend, SortedSet<LocalDBIndexCfgDefn.IndexType> types, int entryLimit) {
        super(name, backend);
        this.attr = attr;
        this.types.addAll(types);
        this.isDatabaseIndex = this.isDatabaseIndex(name);
        this.entryLimit = entryLimit;
        this.recalculateHashCode();
    }

    public AttributeType getAttributeType() {
        return this.attr;
    }

    @Override
    public int compareTo(AbstractIndexDescriptor o) {
        return this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public SortedSet<LocalDBIndexCfgDefn.IndexType> getTypes() {
        return new TreeSet<LocalDBIndexCfgDefn.IndexType>(this.types);
    }

    public boolean isDatabaseIndex() {
        return this.isDatabaseIndex;
    }

    private boolean isDatabaseIndex(String name) {
        return name.equalsIgnoreCase("dn2id") || name.equalsIgnoreCase("id2children") || name.equalsIgnoreCase("id2subtree");
    }

    public boolean equals(Object o) {
        boolean equals;
        boolean bl = equals = o == this;
        if (!equals && (equals = o instanceof IndexDescriptor)) {
            IndexDescriptor index = (IndexDescriptor)o;
            boolean bl2 = equals = index.getName().equalsIgnoreCase(this.getName()) && index.isDatabaseIndex() == this.isDatabaseIndex() && index.getTypes().equals(this.getTypes()) && index.getEntryLimit() == this.getEntryLimit();
            if (equals && this.getBackend() != null && index.getBackend() != null) {
                equals = this.getBackend().getBackendID().equals(index.getBackend().getBackendID());
            }
        }
        return equals;
    }

    public int getEntryLimit() {
        return this.entryLimit;
    }

    @Override
    protected void recalculateHashCode() {
        StringBuilder sb = new StringBuilder();
        for (LocalDBIndexCfgDefn.IndexType t : this.types) {
            sb.append((Object)((Object)t) + ",");
        }
        if (this.getBackend() != null) {
            sb.append(this.getBackend().getBackendID());
        }
        this.hashCode = (this.getName() + sb + this.entryLimit).hashCode();
    }
}

