/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.browser;

import java.util.ArrayList;
import java.util.Set;
import javax.naming.InterruptedNamingException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.browser.AbstractNodeTask;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.browser.ReferralLimitExceededException;
import org.opends.guitools.controlpanel.browser.SearchAbandonException;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.messages.AdminToolMessages;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.RDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRefresher
extends AbstractNodeTask {
    BrowserController controller;
    State state;
    boolean recursive;
    SearchResult localEntry;
    SearchResult remoteEntry;
    LDAPURL remoteUrl;
    boolean isLeafNode;
    ArrayList<SearchResult> childEntries = new ArrayList();
    boolean differential;
    Exception exception;
    Object exceptionArg;

    public NodeRefresher(BasicNode node, BrowserController ctlr, SearchResult localEntry, boolean recursive) {
        super(node);
        this.controller = ctlr;
        this.state = State.QUEUED;
        this.recursive = recursive;
        this.localEntry = localEntry;
    }

    public SearchResult getLocalEntry() {
        return this.localEntry;
    }

    public SearchResult getRemoteEntry() {
        return this.remoteEntry;
    }

    public LDAPURL getRemoteUrl() {
        return this.remoteUrl;
    }

    public boolean isLeafNode() {
        return this.isLeafNode;
    }

    public ArrayList<SearchResult> getChildEntries() {
        return this.childEntries;
    }

    public boolean isDifferential() {
        return this.differential;
    }

    public Exception getException() {
        return this.exception;
    }

    public Object getExceptionArg() {
        return this.exceptionArg;
    }

    public SearchResult getDisplayedEntry() {
        SearchResult result = this.controller.getFollowReferrals() && this.remoteEntry != null ? this.remoteEntry : this.localEntry;
        return result;
    }

    public LDAPURL getDisplayedUrl() {
        LDAPURL result = this.controller.getFollowReferrals() && this.remoteUrl != null ? this.remoteUrl : this.controller.findUrlForLocalEntry(this.getNode());
        return result;
    }

    public boolean isInFinalState() {
        return this.state == State.FINISHED || this.state == State.CANCELLED || this.state == State.FAILED || this.state == State.INTERRUPTED;
    }

    @Override
    public void run() {
        final BasicNode node = this.getNode();
        try {
            boolean checkExpand = false;
            if (this.localEntry == null) {
                this.changeStateTo(State.READING_LOCAL_ENTRY);
                this.runReadLocalEntry();
            }
            if (this.controller.getFollowReferrals() && NodeRefresher.isReferralEntry(this.localEntry)) {
                this.changeStateTo(State.SOLVING_REFERRAL);
                this.runSolveReferral();
            }
            if (node.isLeaf()) {
                this.changeStateTo(State.DETECTING_CHILDREN);
                this.runDetectChildren();
            }
            if (this.controller.nodeIsExpanded(node) && this.recursive) {
                this.changeStateTo(State.SEARCHING_CHILDREN);
                this.runSearchChildren();
            } else if (!(!this.recursive || node.isLeaf() && this.isLeafNode)) {
                node.setRefreshNeededOnExpansion(true);
                checkExpand = true;
            }
            this.changeStateTo(State.FINISHED);
            if (checkExpand && this.mustAutomaticallyExpand(node)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NodeRefresher.this.controller.expandNode(node);
                    }
                });
            }
        }
        catch (NamingException ne) {
            this.exception = ne;
            this.exceptionArg = null;
        }
        catch (SearchAbandonException x) {
            this.exception = x.getException();
            this.exceptionArg = x.getArg();
            try {
                this.changeStateTo(x.getState());
            }
            catch (SearchAbandonException searchAbandonException) {
                // empty catch block
            }
        }
    }

    private boolean useCustomFilter() {
        return !this.controller.getFilter().equals("(|(objectClass=*)(objectClass=ldapsubentry))");
    }

    private void searchForCustomFilter(BasicNode node, InitialLdapContext ctx) throws NamingException {
        SearchControls ctls = this.controller.getBasicSearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"1.1"});
        ctls.setCountLimit(1L);
        NamingEnumeration<SearchResult> s = ctx.search((Name)new LdapName(node.getDN()), this.controller.getFilter(), ctls);
        if (!s.hasMoreElements()) {
            throw new NameNotFoundException("Entry " + node.getDN() + " does not verify filter " + this.controller.getFilter());
        }
    }

    private void searchForCustomFilter(String dn, InitialLdapContext ctx) throws NamingException {
        SearchControls ctls = this.controller.getBasicSearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[0]);
        ctls.setCountLimit(1L);
        NamingEnumeration<SearchResult> s = ctx.search((Name)new LdapName(dn), this.controller.getFilter(), ctls);
        if (!s.hasMoreElements()) {
            throw new NameNotFoundException("Entry " + dn + " does not verify filter " + this.controller.getFilter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReadLocalEntry() throws SearchAbandonException {
        BasicNode node = this.getNode();
        InitialLdapContext ctx = null;
        try {
            ctx = this.controller.findConnectionForLocalEntry(node);
            if (this.useCustomFilter()) {
                this.searchForCustomFilter(node, ctx);
            }
            SearchControls ctls = this.controller.getBasicSearchControls();
            ctls.setReturningAttributes(this.controller.getAttrsForRedSearch());
            ctls.setSearchScope(0);
            NamingEnumeration<SearchResult> s = ctx.search((Name)new LdapName(node.getDN()), this.controller.getObjectSearchFilter(), ctls);
            if (s.hasMore()) {
                this.localEntry = s.next();
                this.localEntry.setName(node.getDN());
            }
            if (this.localEntry == null) {
                throw new NameNotFoundException("Can't find entry: " + node.getDN());
            }
            this.throwAbandonIfNeeded(null);
        }
        catch (NamingException x) {
            this.throwAbandonIfNeeded(x);
        }
        finally {
            if (ctx != null) {
                this.controller.releaseLDAPConnection(ctx);
            }
        }
    }

    private void runSolveReferral() throws SearchAbandonException, NamingException {
        int hopCount;
        String[] referral = this.getNode().getReferral();
        for (hopCount = 0; referral != null && hopCount < 10; ++hopCount) {
            this.readRemoteEntry(referral);
            referral = BrowserController.getReferral(this.remoteEntry);
        }
        if (referral != null) {
            this.throwAbandonIfNeeded(new ReferralLimitExceededException(AdminToolMessages.ERR_REFERRAL_LIMIT_EXCEEDED.get(hopCount)));
        }
    }

    /*
     * Exception decompiling
     */
    private void readRemoteEntry(String[] referral) throws SearchAbandonException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean mustAutomaticallyExpand(BasicNode node) {
        boolean mustAutomaticallyExpand = false;
        if (this.controller.isAutomaticExpand()) {
            int nLevels = 0;
            for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
                ++nLevels;
            }
            mustAutomaticallyExpand = nLevels <= 4;
        }
        return mustAutomaticallyExpand;
    }

    private void runDetectChildren() throws SearchAbandonException, NamingException {
        if (this.controller.isShowContainerOnly() || !this.isNumSubOrdinatesUsable()) {
            this.runDetectChildrenManually();
        } else {
            SearchResult entry = this.getDisplayedEntry();
            this.isLeafNode = BrowserController.getNumSubOrdinates(entry) == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDetectChildrenManually() throws SearchAbandonException {
        BasicNode parentNode = this.getNode();
        InitialLdapContext ctx = null;
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            SearchControls ctls = this.controller.getBasicSearchControls();
            ctls.setCountLimit(1L);
            String[] attrs = new String[]{"1.1"};
            ctls.setReturningAttributes(attrs);
            if (this.useCustomFilter()) {
                ctls.setSearchScope(2);
            } else {
                ctls.setSearchScope(0);
            }
            ctx = this.controller.findConnectionForDisplayedEntry(parentNode);
            searchResults = ctx.search((Name)new LdapName(this.controller.findBaseDNForChildEntries(parentNode)), this.controller.getChildSearchFilter(), ctls);
            this.throwAbandonIfNeeded(null);
            this.isLeafNode = !searchResults.hasMoreElements();
            if (ctx != null) {
                this.controller.releaseLDAPConnection(ctx);
            }
        }
        catch (NamingException x) {
            this.throwAbandonIfNeeded(x);
        }
        finally {
            if (ctx != null) {
                this.controller.releaseLDAPConnection(ctx);
            }
        }
    }

    private boolean isNumSubOrdinatesUsable() throws NamingException {
        boolean result;
        SearchResult entry = this.getDisplayedEntry();
        int numSubOrdinates = BrowserController.getNumSubOrdinates(entry);
        if (numSubOrdinates == 0) {
            LDAPURL url = this.getDisplayedUrl();
            result = !this.controller.getNumSubordinateHacker().contains(url);
        } else {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runSearchChildren() throws SearchAbandonException {
        block29: {
            InitialLdapContext ctx = null;
            BasicNode parentNode = this.getNode();
            parentNode.setSizeLimitReached(false);
            try {
                int parentComponents;
                SearchControls ctls = this.controller.getBasicSearchControls();
                if (this.useCustomFilter()) {
                    ctls.setSearchScope(2);
                } else {
                    ctls.setSearchScope(1);
                }
                ctls.setReturningAttributes(this.controller.getAttrsForRedSearch());
                ctx = this.controller.findConnectionForDisplayedEntry(parentNode);
                String parentDn = this.controller.findBaseDNForChildEntries(parentNode);
                try {
                    DN dn = DN.decode(parentDn);
                    parentComponents = dn.getNumComponents();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error decoding dn: " + parentDn + " . " + t, t);
                }
                NamingEnumeration<SearchResult> entries = ctx.search((Name)new LdapName(parentDn), this.controller.getChildSearchFilter(), ctls);
                while (entries.hasMore()) {
                    SearchResult r = entries.next();
                    if (r.getName().length() == 0) continue;
                    String name = this.unquoteRelativeName(r.getName()) + "," + parentDn;
                    boolean add = false;
                    if (this.useCustomFilter()) {
                        DN dn = null;
                        try {
                            dn = DN.decode(name);
                            add = dn.getNumComponents() == parentComponents + 1;
                        }
                        catch (Throwable t) {
                            throw new RuntimeException("Error decoding dns: " + t, t);
                        }
                        if (!add) {
                            RDN[] rdns = new RDN[parentComponents + 1];
                            int diff = dn.getNumComponents() - rdns.length;
                            for (int i = 0; i < rdns.length; ++i) {
                                rdns[i] = dn.getRDN(i + diff);
                            }
                            final DN parentToAddDN = new DN(rdns);
                            boolean mustAddParent = true;
                            for (SearchResult addedEntry : this.childEntries) {
                                try {
                                    DN addedDN = DN.decode(addedEntry.getName());
                                    if (!addedDN.equals(parentToAddDN)) continue;
                                    mustAddParent = false;
                                    break;
                                }
                                catch (Throwable t) {
                                    throw new RuntimeException("Error decoding dn: " + addedEntry.getName() + " . " + t, t);
                                }
                            }
                            if (mustAddParent) {
                                final boolean[] resultValue = new boolean[]{true};
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            for (int i = 0; i < NodeRefresher.this.getNode().getChildCount(); ++i) {
                                                BasicNode node = (BasicNode)NodeRefresher.this.getNode().getChildAt(i);
                                                try {
                                                    DN dn = DN.decode(node.getDN());
                                                    if (!dn.equals(parentToAddDN)) continue;
                                                    resultValue[0] = false;
                                                    break;
                                                }
                                                catch (Throwable t) {
                                                    throw new RuntimeException("Error decoding dn: " + node.getDN() + " . " + t, t);
                                                }
                                            }
                                        }
                                    });
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                mustAddParent = resultValue[0];
                            }
                            if (mustAddParent) {
                                SearchResult parentResult = this.searchManuallyEntry(ctx, parentToAddDN.toString());
                                this.childEntries.add(parentResult);
                            }
                        }
                    } else {
                        add = true;
                    }
                    if (add) {
                        r.setName(name);
                        this.childEntries.add(r);
                        if (this.childEntries.size() >= 20) {
                            this.changeStateTo(State.SEARCHING_CHILDREN);
                            this.childEntries.clear();
                        }
                    }
                    this.throwAbandonIfNeeded(null);
                }
                if (ctx != null) {
                    this.controller.releaseLDAPConnection(ctx);
                }
            }
            catch (SizeLimitExceededException slee) {
                parentNode.setSizeLimitReached(true);
            }
            catch (NamingException x) {
                this.throwAbandonIfNeeded(x);
                break block29;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (ctx != null) {
                    this.controller.releaseLDAPConnection(ctx);
                }
            }
        }
    }

    private SearchResult searchManuallyEntry(InitialLdapContext ctx, String dn) throws NamingException {
        SearchResult sr = null;
        SearchControls ctls = this.controller.getBasicSearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(this.controller.getAttrsForRedSearch());
        NamingEnumeration<SearchResult> entries = ctx.search((Name)new LdapName(dn), this.controller.getObjectSearchFilter(), ctls);
        while (entries.hasMore()) {
            sr = entries.next();
            sr.setName(dn);
        }
        return sr;
    }

    private void changeStateTo(State newState) throws SearchAbandonException {
        State oldState = this.state;
        this.state = newState;
        try {
            this.controller.invokeRefreshTaskDidProgress(this, oldState, newState);
        }
        catch (InterruptedException x) {
            this.throwAbandonIfNeeded(x);
        }
    }

    private void throwAbandonIfNeeded(Exception x) throws SearchAbandonException {
        SearchAbandonException tax = null;
        if (x != null) {
            tax = x instanceof InterruptedException || x instanceof InterruptedNamingException ? new SearchAbandonException(State.INTERRUPTED, x, null) : new SearchAbandonException(State.FAILED, x, null);
        } else if (this.isCancelled()) {
            tax = new SearchAbandonException(State.CANCELLED, null, null);
        }
        if (tax != null) {
            throw tax;
        }
    }

    private String unquoteRelativeName(String name) {
        if (name.length() > 0 && name.charAt(0) == '\"') {
            if (name.charAt(name.length() - 1) == '\"') {
                return name.substring(1, name.length() - 1);
            }
            return name.substring(1);
        }
        return name;
    }

    void dump() {
        System.out.println("=============");
        System.out.println("         node: " + this.getNode().getDN());
        System.out.println("    recursive: " + this.recursive);
        System.out.println(" differential: " + this.differential);
        System.out.println("        state: " + (Object)((Object)this.state));
        System.out.println("   localEntry: " + this.localEntry);
        System.out.println("  remoteEntry: " + this.remoteEntry);
        System.out.println("    remoteUrl: " + this.remoteUrl);
        System.out.println("   isLeafNode: " + this.isLeafNode);
        System.out.println("    exception: " + this.exception);
        System.out.println(" exceptionArg: " + this.exceptionArg);
        System.out.println("=============");
    }

    static boolean isReferralEntry(SearchResult entry) throws NamingException {
        boolean result = false;
        Set<String> ocValues = ConnectionUtils.getValues(entry, "objectClass");
        if (ocValues != null) {
            for (String value : ocValues) {
                boolean isReferral = value.equalsIgnoreCase("referral");
                if (!isReferral) continue;
                result = ConnectionUtils.getFirstValue(entry, "ref") != null;
                break;
            }
        }
        return result;
    }

    private int getJNDIScope(LDAPURL url) {
        int scope;
        if (url.getScope() != null) {
            switch (url.getScope()) {
                case BASE_OBJECT: {
                    scope = 0;
                    break;
                }
                case WHOLE_SUBTREE: {
                    scope = 2;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    scope = 1;
                    break;
                }
                case SINGLE_LEVEL: {
                    scope = 1;
                    break;
                }
                default: {
                    scope = 0;
                    break;
                }
            }
        } else {
            scope = 0;
        }
        return scope;
    }

    private String getJNDIFilter(LDAPURL url) {
        String filter = url.getRawFilter();
        if (filter == null) {
            filter = this.controller.getObjectSearchFilter();
        }
        return filter;
    }

    private void checkLoopInReferral(LDAPURL url, String referral) throws SearchAbandonException {
        boolean checkSucceeded = true;
        try {
            DN dn1 = DN.decode(this.getNode().getDN());
            DN dn2 = url.getBaseDN();
            if (dn2.isAncestorOf(dn1)) {
                String host = url.getHost();
                int port = url.getPort();
                String adminHost = ConnectionUtils.getHostName(this.controller.getConfigurationConnection());
                int adminPort = ConnectionUtils.getPort(this.controller.getConfigurationConnection());
                boolean bl = checkSucceeded = port != adminPort || !adminHost.equalsIgnoreCase(host);
                if (checkSucceeded) {
                    String hostUserData = ConnectionUtils.getHostName(this.controller.getUserDataConnection());
                    int portUserData = ConnectionUtils.getPort(this.controller.getUserDataConnection());
                    checkSucceeded = port != portUserData || !hostUserData.equalsIgnoreCase(host);
                }
            }
        }
        catch (OpenDsException odse) {
            // empty catch block
        }
        if (!checkSucceeded) {
            throw new SearchAbandonException(State.FAILED, new ReferralLimitExceededException(AdminToolMessages.ERR_CTRL_PANEL_REFERRAL_LOOP.get(url.getRawBaseDN())), referral);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        QUEUED,
        READING_LOCAL_ENTRY,
        SOLVING_REFERRAL,
        DETECTING_CHILDREN,
        SEARCHING_CHILDREN,
        FINISHED,
        CANCELLED,
        INTERRUPTED,
        FAILED;

    }
}

