/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.opends.admin.ads.util.BlindHostnameVerifier;
import org.opends.admin.ads.util.BlindTrustManager;
import org.opends.admin.ads.util.TrustedSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionUtils {
    private static final int DEFAULT_LDAP_CONNECT_TIMEOUT = 30000;
    private static final String STARTTLS_PROPERTY = "org.opends.connectionutils.isstarttls";
    private static final Logger LOG = Logger.getLogger(ConnectionUtils.class.getName());

    private ConnectionUtils() {
    }

    public static InitialLdapContext createLdapContext(String ldapURL, String dn, String pwd, int timeout, Hashtable<String, String> env) throws NamingException {
        env = env != null ? new Hashtable<String, String>(env) : new Hashtable();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        if (timeout >= 1) {
            env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(timeout));
        }
        if (dn != null) {
            env.put("java.naming.security.principal", dn);
        }
        if (pwd != null) {
            env.put("java.naming.security.credentials", pwd);
        }
        final Object[] pair = new Object[]{null, null};
        final Hashtable<String, String> fEnv = env;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    pair[0] = new InitialLdapContext(fEnv, null);
                }
                catch (NamingException ne) {
                    pair[1] = ne;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    pair[1] = t;
                }
            }
        });
        t.setDaemon(true);
        return ConnectionUtils.getInitialLdapContext(t, pair, timeout);
    }

    public static InitialLdapContext createLdapsContext(String ldapsURL, String dn, String pwd, int timeout, Hashtable<String, String> env, TrustManager trustManager, KeyManager keyManager) throws NamingException {
        env = env != null ? new Hashtable<String, String>(env) : new Hashtable();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapsURL);
        env.put("java.naming.ldap.factory.socket", TrustedSocketFactory.class.getName());
        if (dn != null) {
            env.put("java.naming.security.principal", dn);
        }
        if (pwd != null) {
            env.put("java.naming.security.credentials", pwd);
        }
        if (trustManager == null) {
            trustManager = new BlindTrustManager();
        }
        final Object[] pair = new Object[]{null, null};
        final Hashtable<String, String> fEnv = env;
        final TrustManager fTrustManager = trustManager;
        final KeyManager fKeyManager = keyManager;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    TrustedSocketFactory.setCurrentThreadTrustManager(fTrustManager, fKeyManager);
                    pair[0] = new InitialLdapContext(fEnv, null);
                }
                catch (NamingException ne) {
                    pair[1] = ne;
                }
                catch (RuntimeException re) {
                    pair[1] = re;
                }
            }
        });
        t.setDaemon(true);
        return ConnectionUtils.getInitialLdapContext(t, pair, timeout);
    }

    public static InitialLdapContext cloneInitialLdapContext(final InitialLdapContext ctx, int timeout, TrustManager trustManager, KeyManager keyManager) throws NamingException {
        Hashtable<?, ?> env = ctx.getEnvironment();
        Control[] ctls = ctx.getConnectControls();
        Control[] newCtls = null;
        if (ctls != null) {
            newCtls = new Control[ctls.length];
            for (int i = 0; i < ctls.length; ++i) {
                newCtls[i] = ctls[i];
            }
        }
        final Object[] pair = new Object[]{null, null};
        final Hashtable<?, ?> fEnv = env;
        final TrustManager fTrustManager = trustManager;
        final KeyManager fKeyManager = keyManager;
        final Control[] fNewCtls = newCtls;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    if (ConnectionUtils.isSSL(ctx) || ConnectionUtils.isStartTLS(ctx)) {
                        TrustedSocketFactory.setCurrentThreadTrustManager(fTrustManager, fKeyManager);
                    }
                    pair[0] = new InitialLdapContext(fEnv, fNewCtls);
                }
                catch (NamingException ne) {
                    pair[1] = ne;
                }
                catch (RuntimeException re) {
                    pair[1] = re;
                }
            }
        });
        return ConnectionUtils.getInitialLdapContext(t, pair, timeout);
    }

    public static InitialLdapContext createStartTLSContext(String ldapURL, String dn, String pwd, int timeout, Hashtable<String, String> env, TrustManager trustManager, KeyManager keyManager, HostnameVerifier verifier) throws NamingException {
        if (trustManager == null) {
            trustManager = new BlindTrustManager();
        }
        if (verifier == null) {
            verifier = new BlindHostnameVerifier();
        }
        env = env != null ? new Hashtable<String, String>(env) : new Hashtable();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        env.put("java.naming.security.authentication", "none");
        final Object[] pair = new Object[]{null, null};
        final Hashtable<String, String> fEnv = env;
        final String fDn = dn;
        final String fPwd = pwd;
        final TrustManager fTrustManager = trustManager;
        final KeyManager fKeyManager = keyManager;
        final HostnameVerifier fVerifier = verifier;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    InitialLdapContext result = new InitialLdapContext(fEnv, null);
                    StartTlsResponse tls = (StartTlsResponse)result.extendedOperation(new StartTlsRequest());
                    tls.setHostnameVerifier(fVerifier);
                    try {
                        tls.negotiate(new TrustedSocketFactory(fTrustManager, fKeyManager));
                    }
                    catch (IOException x) {
                        CommunicationException xx = new CommunicationException("Failed to negotiate Start TLS operation");
                        xx.initCause(x);
                        result.close();
                        throw xx;
                    }
                    result.addToEnvironment(ConnectionUtils.STARTTLS_PROPERTY, "true");
                    if (fDn != null) {
                        result.addToEnvironment("java.naming.security.authentication", "simple");
                        result.addToEnvironment("java.naming.security.principal", fDn);
                        if (fPwd != null) {
                            result.addToEnvironment("java.naming.security.credentials", fPwd);
                        }
                        result.reconnect(null);
                    }
                    pair[0] = result;
                }
                catch (NamingException ne) {
                    pair[1] = ne;
                }
                catch (RuntimeException re) {
                    pair[1] = re;
                }
            }
        });
        t.setDaemon(true);
        return ConnectionUtils.getInitialLdapContext(t, pair, timeout);
    }

    public static String getLdapUrl(InitialLdapContext ctx) {
        String s = null;
        try {
            s = (String)ctx.getEnvironment().get("java.naming.provider.url");
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "Naming exception getting environment of " + ctx, ne);
        }
        return s;
    }

    public static String getHostName(InitialLdapContext ctx) {
        String s = null;
        try {
            URI ldapURL = new URI(ConnectionUtils.getLdapUrl(ctx));
            s = ldapURL.getHost();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error getting host: " + t, t);
        }
        return s;
    }

    public static int getPort(InitialLdapContext ctx) {
        int port = -1;
        try {
            URI ldapURL = new URI(ConnectionUtils.getLdapUrl(ctx));
            port = ldapURL.getPort();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error getting port: " + t, t);
        }
        return port;
    }

    public static String getHostPort(InitialLdapContext ctx) {
        return ConnectionUtils.getHostName(ctx) + ":" + ConnectionUtils.getPort(ctx);
    }

    public static String getBindDN(InitialLdapContext ctx) {
        String bindDN = null;
        try {
            bindDN = (String)ctx.getEnvironment().get("java.naming.security.principal");
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "Naming exception getting environment of " + ctx, ne);
        }
        return bindDN;
    }

    public static String getBindPassword(InitialLdapContext ctx) {
        String bindPwd = null;
        try {
            bindPwd = (String)ctx.getEnvironment().get("java.naming.security.credentials");
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "Naming exception getting environment of " + ctx, ne);
        }
        return bindPwd;
    }

    public static boolean isSSL(InitialLdapContext ctx) {
        boolean isSSL = false;
        String s = null;
        try {
            s = ConnectionUtils.getLdapUrl(ctx);
            isSSL = s.toLowerCase().startsWith("ldaps");
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error getting if is SSL " + t, t);
        }
        return isSSL;
    }

    public static boolean isStartTLS(InitialLdapContext ctx) {
        boolean isStartTLS = false;
        try {
            isStartTLS = "true".equalsIgnoreCase((String)ctx.getEnvironment().get(STARTTLS_PROPERTY));
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "Naming exception getting environment of " + ctx, ne);
        }
        return isStartTLS;
    }

    public static boolean canConnectAsAdministrativeUser(String ldapUrl, String dn, String pwd) {
        boolean canConnectAsAdministrativeUser = false;
        try {
            InitialLdapContext ctx = ldapUrl.toLowerCase().startsWith("ldap:") ? ConnectionUtils.createLdapContext(ldapUrl, dn, pwd, ConnectionUtils.getDefaultLDAPTimeout(), null) : ConnectionUtils.createLdapsContext(ldapUrl, dn, pwd, ConnectionUtils.getDefaultLDAPTimeout(), null, null, null);
            canConnectAsAdministrativeUser = ConnectionUtils.connectedAsAdministrativeUser(ctx);
        }
        catch (NamingException ne) {
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unexpected throwable.", t);
        }
        return canConnectAsAdministrativeUser;
    }

    public static boolean connectedAsAdministrativeUser(InitialLdapContext ctx) {
        boolean connectedAsAdministrativeUser = false;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setCountLimit(1L);
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(new String[]{"1.1"});
            ctx.search("cn=config", "objectclass=*", searchControls);
            connectedAsAdministrativeUser = true;
        }
        catch (NamingException ne) {
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unexpected throwable.", t);
        }
        return connectedAsAdministrativeUser;
    }

    private static InitialLdapContext getInitialLdapContext(Thread t, Object[] pair, int timeout) throws NamingException {
        try {
            if (timeout > 0) {
                t.start();
                t.join(timeout);
            } else {
                t.run();
            }
        }
        catch (InterruptedException x) {
            // empty catch block
        }
        boolean throwException = false;
        if (timeout > 0 && t.isAlive()) {
            t.interrupt();
            try {
                t.join(2000L);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
            throwException = true;
        }
        if (pair[0] == null && pair[1] == null) {
            throwException = true;
        }
        if (throwException) {
            ConnectException x = new ConnectException("Connection timed out");
            CommunicationException xx = new CommunicationException("Connection timed out");
            xx.initCause(x);
            throw xx;
        }
        if (pair[1] != null) {
            if (pair[1] instanceof NamingException) {
                throw (NamingException)pair[1];
            }
            if (pair[1] instanceof RuntimeException) {
                throw (RuntimeException)pair[1];
            }
            if (pair[1] instanceof Throwable) {
                throw new IllegalStateException("Unexpected throwable occurred", (Throwable)pair[1]);
            }
        }
        return (InitialLdapContext)pair[0];
    }

    public static int getDefaultLDAPTimeout() {
        return 30000;
    }

    public static String getHostNameForLdapUrl(String host) {
        if (host != null && host.indexOf(":") != -1) {
            if (!(host = host.trim()).startsWith("[")) {
                host = "[" + host;
            }
            if (!host.endsWith("]")) {
                host = host + "]";
            }
        }
        return host;
    }

    public static String getLDAPUrl(String host, int port, boolean useSSL) {
        host = ConnectionUtils.getHostNameForLdapUrl(host);
        String ldapUrl = useSSL ? "ldaps://" + host + ":" + port : "ldap://" + host + ":" + port;
        return ldapUrl;
    }

    public static boolean isCertificateException(Throwable t) {
        boolean returnValue = false;
        while (!returnValue && t != null) {
            returnValue = t instanceof SSLHandshakeException || t instanceof GeneralSecurityException;
            t = t.getCause();
        }
        return returnValue;
    }

    public static String getFirstValue(SearchResult entry, String attrName) throws NamingException {
        Attribute attr;
        String v = null;
        Attributes attrs = entry.getAttributes();
        if (attrs != null && (attr = attrs.get(attrName)) != null && attr.size() > 0) {
            Object o = attr.get();
            v = o instanceof String ? (String)o : String.valueOf(o);
        }
        return v;
    }

    public static Set<String> getValues(SearchResult entry, String attrName) throws NamingException {
        Attribute attr;
        HashSet<String> values = new HashSet<String>();
        Attributes attrs = entry.getAttributes();
        if (attrs != null && (attr = attrs.get(attrName)) != null) {
            for (int i = 0; i < attr.size(); ++i) {
                values.add((String)attr.get(i));
            }
        }
        return values;
    }
}

