/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.opends.server.util.Platform;

public class ApplicationKeyManager
implements X509KeyManager {
    private static final Logger LOG = Logger.getLogger(ApplicationKeyManager.class.getName());
    private X509KeyManager keyManager = null;

    public ApplicationKeyManager(KeyStore keystore, char[] password) {
        KeyManagerFactory kmf = null;
        String userSpecifiedAlgo = System.getProperty("org.opends.admin.keymanageralgo");
        String userSpecifiedProvider = System.getProperty("org.opends.admin.keymanagerprovider");
        if (userSpecifiedAlgo == null && Platform.isVendor("IBM")) {
            userSpecifiedAlgo = "IbmX509";
        }
        if (userSpecifiedProvider == null && Platform.isVendor("IBM")) {
            userSpecifiedProvider = "IBMJSSE2";
        }
        String[] preferredProvider = new String[]{userSpecifiedProvider, "SunJSSE", null, null};
        String[] preferredAlgo = new String[]{userSpecifiedAlgo, "SunX509", "SunX509", TrustManagerFactory.getDefaultAlgorithm()};
        block5: for (int i = 0; i < preferredProvider.length && this.keyManager == null; ++i) {
            String provider = preferredProvider[i];
            String algo = preferredAlgo[i];
            if (algo == null) continue;
            try {
                kmf = provider != null ? KeyManagerFactory.getInstance(algo, provider) : KeyManagerFactory.getInstance(algo);
                kmf.init(keystore, password);
                KeyManager[] kms = kmf.getKeyManagers();
                for (int j = 0; j < kms.length; ++j) {
                    if (!(kms[i] instanceof X509KeyManager)) continue;
                    this.keyManager = (X509KeyManager)kms[j];
                    continue block5;
                }
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.WARNING, "Error with the algorithm", e);
                continue;
            }
            catch (KeyStoreException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
                continue;
            }
            catch (UnrecoverableKeyException e) {
                LOG.log(Level.WARNING, "Error with the key", e);
                continue;
            }
            catch (NoSuchProviderException e) {
                LOG.log(Level.WARNING, "Error with the provider", e);
            }
        }
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.keyManager != null) {
            return this.keyManager.chooseClientAlias(keyType, issuers, socket);
        }
        return null;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.keyManager != null) {
            return this.keyManager.chooseServerAlias(keyType, issuers, socket);
        }
        return null;
    }

    public X509Certificate[] getCertificateChain(String alias) {
        if (this.keyManager != null) {
            return this.keyManager.getCertificateChain(alias);
        }
        return null;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (this.keyManager != null) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }
        return null;
    }

    public PrivateKey getPrivateKey(String alias) {
        if (this.keyManager != null) {
            return this.keyManager.getPrivateKey(alias);
        }
        return null;
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (this.keyManager != null) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }
        return null;
    }
}

