/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.PreferredConnection;
import org.opends.admin.ads.util.ServerLoader;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyCache {
    private ADSContext adsContext;
    private ApplicationTrustManager trustManager;
    private String dn;
    private String pwd;
    private Set<ServerDescriptor> servers = new HashSet<ServerDescriptor>();
    private Set<SuffixDescriptor> suffixes = new HashSet<SuffixDescriptor>();
    private LinkedHashSet<PreferredConnection> preferredConnections = new LinkedHashSet();
    private TopologyCacheFilter filter = new TopologyCacheFilter();
    private final boolean isMultiThreaded = true;
    private static final int MULTITHREAD_TIMEOUT = 90000;
    private static final Logger LOG = Logger.getLogger(TopologyCache.class.getName());

    public TopologyCache(ADSContext adsContext, ApplicationTrustManager trustManager) {
        this.adsContext = adsContext;
        this.trustManager = trustManager;
        this.dn = ConnectionUtils.getBindDN(adsContext.getDirContext());
        this.pwd = ConnectionUtils.getBindPassword(adsContext.getDirContext());
    }

    public void reloadTopology() throws TopologyCacheException {
        this.suffixes.clear();
        this.servers.clear();
        try {
            Set<Map<ADSContext.ServerProperty, Object>> adsServers = this.adsContext.readServerRegistry();
            HashSet<ServerLoader> threadSet = new HashSet<ServerLoader>();
            for (Map<ADSContext.ServerProperty, Object> serverProperties : adsServers) {
                ServerLoader t = this.getServerLoader(serverProperties);
                t.start();
                threadSet.add(t);
            }
            this.joinThreadSet(threadSet);
            HashMap<LdapName, HashSet<SuffixDescriptor>> hmSuffixes = new HashMap<LdapName, HashSet<SuffixDescriptor>>();
            for (ServerLoader loader : threadSet) {
                ServerDescriptor descriptor = loader.getServerDescriptor();
                for (ReplicaDescriptor replica : descriptor.getReplicas()) {
                    LOG.log(Level.INFO, "Handling replica with dn: " + replica.getSuffix().getDN());
                    boolean suffixFound = false;
                    LdapName dn = new LdapName(replica.getSuffix().getDN());
                    HashSet<SuffixDescriptor> sufs = (HashSet<SuffixDescriptor>)hmSuffixes.get(dn);
                    if (sufs != null) {
                        Iterator it = sufs.iterator();
                        while (it.hasNext() && !suffixFound) {
                            SuffixDescriptor suffix = (SuffixDescriptor)it.next();
                            Iterator<String> it2 = suffix.getReplicationServers().iterator();
                            while (it2.hasNext() && !suffixFound) {
                                if (!replica.getReplicationServers().contains(it2.next())) continue;
                                suffixFound = true;
                                Set<ReplicaDescriptor> replicas = suffix.getReplicas();
                                replicas.add(replica);
                                suffix.setReplicas(replicas);
                                replica.setSuffix(suffix);
                            }
                        }
                    }
                    if (suffixFound) continue;
                    if (sufs == null) {
                        sufs = new HashSet<SuffixDescriptor>();
                        hmSuffixes.put(dn, sufs);
                    }
                    sufs.add(replica.getSuffix());
                    this.suffixes.add(replica.getSuffix());
                }
                this.servers.add(descriptor);
            }
            if (this.getFilter().searchMonitoringInformation()) {
                this.readReplicationMonitoring();
            }
        }
        catch (ADSContextException ade) {
            throw new TopologyCacheException(ade);
        }
        catch (Throwable t) {
            throw new TopologyCacheException(TopologyCacheException.Type.BUG, t);
        }
    }

    public ApplicationTrustManager getTrustManager() {
        return this.trustManager;
    }

    private void readReplicationMonitoring() {
        HashSet<ReplicaDescriptor> replicasToUpdate = new HashSet<ReplicaDescriptor>();
        for (ServerDescriptor server : this.getServers()) {
            for (ReplicaDescriptor replica : server.getReplicas()) {
                if (!replica.isReplicated()) continue;
                replicasToUpdate.add(replica);
            }
        }
        for (ServerDescriptor server : this.getServers()) {
            if (server.isReplicationServer()) {
                HashSet<ReplicaDescriptor> candidateReplicas = new HashSet<ReplicaDescriptor>();
                String repServer = server.getReplicationServerHostPort();
                block5: for (SuffixDescriptor suffix : this.getSuffixes()) {
                    Set<String> repServers = suffix.getReplicationServers();
                    for (String r : repServers) {
                        if (!r.equalsIgnoreCase(repServer)) continue;
                        candidateReplicas.addAll(suffix.getReplicas());
                        continue block5;
                    }
                }
                if (!candidateReplicas.isEmpty()) {
                    HashSet<ReplicaDescriptor> updatedReplicas = new HashSet<ReplicaDescriptor>();
                    try {
                        this.updateReplicas(server, candidateReplicas, updatedReplicas);
                    }
                    catch (NamingException ne) {
                        server.setLastException(new TopologyCacheException(TopologyCacheException.Type.GENERIC_READING_SERVER, (Throwable)ne));
                    }
                    replicasToUpdate.removeAll(updatedReplicas);
                }
            }
            if (!replicasToUpdate.isEmpty()) continue;
            break;
        }
    }

    public void setPreferredConnections(LinkedHashSet<PreferredConnection> cnx) {
        this.preferredConnections.clear();
        this.preferredConnections.addAll(cnx);
    }

    public LinkedHashSet<PreferredConnection> getPreferredConnections() {
        return new LinkedHashSet<PreferredConnection>(this.preferredConnections);
    }

    public Set<ServerDescriptor> getServers() {
        HashSet<ServerDescriptor> copy = new HashSet<ServerDescriptor>();
        copy.addAll(this.servers);
        return copy;
    }

    public Set<SuffixDescriptor> getSuffixes() {
        HashSet<SuffixDescriptor> copy = new HashSet<SuffixDescriptor>();
        copy.addAll(this.suffixes);
        return copy;
    }

    public TopologyCacheFilter getFilter() {
        return this.filter;
    }

    private void joinThreadSet(Set<ServerLoader> threadSet) {
        Date startDate = new Date();
        for (ServerLoader t : threadSet) {
            long timeToJoin = 90000L - System.currentTimeMillis() + startDate.getTime();
            try {
                if (timeToJoin > 0L) {
                    t.join(90000L);
                }
            }
            catch (InterruptedException ie) {
                LOG.log(Level.INFO, ie + " caught and ignored", ie);
            }
            if (!t.isAlive()) continue;
            t.interrupt();
        }
        Date endDate = new Date();
        long workingTime = endDate.getTime() - startDate.getTime();
        LOG.log(Level.INFO, "Loading ended at " + workingTime + " ms");
    }

    private ServerLoader getServerLoader(Map<ADSContext.ServerProperty, Object> serverProperties) {
        return new ServerLoader(serverProperties, this.dn, this.pwd, this.trustManager == null ? null : this.trustManager.createCopy(), this.getPreferredConnections(), this.getFilter());
    }

    public ADSContext getAdsContext() {
        return this.adsContext;
    }

    public LinkedHashSet<Message> getErrorMessages() {
        HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
        Set<ServerDescriptor> servers = this.getServers();
        LinkedHashSet<Message> exceptionMsgs = new LinkedHashSet<Message>();
        for (ServerDescriptor server : servers) {
            TopologyCacheException e = server.getLastException();
            if (e == null) continue;
            exceptions.add(e);
        }
        block5: for (TopologyCacheException e : exceptions) {
            switch (e.getType()) {
                case NOT_GLOBAL_ADMINISTRATOR: {
                    exceptionMsgs.add(QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get());
                    continue block5;
                }
                case GENERIC_CREATING_CONNECTION: {
                    if (e.getCause() != null && Utils.isCertificateException(e.getCause())) {
                        exceptionMsgs.add(QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(e.getHostPort(), e.getCause().getMessage()));
                        continue block5;
                    }
                    exceptionMsgs.add(Utils.getMessage(e));
                    continue block5;
                }
            }
            exceptionMsgs.add(Utils.getMessage(e));
        }
        return exceptionMsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReplicas(ServerDescriptor replicationServer, Collection<ReplicaDescriptor> candidateReplicas, Collection<ReplicaDescriptor> updatedReplicas) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"approx-older-change-not-synchronized-millis", "missing-changes", "domain-name", "server-id"});
        String filter = "(missing-changes=*)";
        LdapName jndiName = new LdapName("cn=monitor");
        InitialContext ctx = null;
        try {
            ServerLoader loader = this.getServerLoader(replicationServer.getAdsProperties());
            ctx = loader.createContext();
            NamingEnumeration<SearchResult> monitorEntries = ((InitialDirContext)ctx).search(jndiName, filter, ctls);
            while (monitorEntries.hasMore()) {
                SearchResult sr = monitorEntries.next();
                String dn = ConnectionUtils.getFirstValue(sr, "domain-name");
                int replicaId = -1;
                try {
                    replicaId = new Integer(ConnectionUtils.getFirstValue(sr, "server-id"));
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Unexpected error reading replica ID: " + t, t);
                }
                for (ReplicaDescriptor replica : candidateReplicas) {
                    if (!Utils.areDnsEqual(dn, replica.getSuffix().getDN()) || !replica.isReplicated() || replica.getReplicationId() != replicaId) continue;
                    try {
                        replica.setAgeOfOldestMissingChange(new Long(ConnectionUtils.getFirstValue(sr, "approx-older-change-not-synchronized-millis")));
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Unexpected error reading age of oldest change: " + t, t);
                    }
                    try {
                        replica.setMissingChanges(new Integer(ConnectionUtils.getFirstValue(sr, "missing-changes")));
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Unexpected error reading missing changes: " + t, t);
                    }
                    updatedReplicas.add(replica);
                }
            }
        }
        catch (NameNotFoundException nse) {
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }
}

