/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.SubCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubCommandArgumentParser {
    private Argument usageArgument;
    private boolean longArgumentsCaseSensitive;
    private HashMap<Character, Argument> globalShortIDMap;
    private HashMap<String, Argument> globalArgumentMap;
    private HashMap<String, Argument> globalLongIDMap;
    private HashMap<String, SubCommand> subCommands;
    private LinkedList<Argument> globalArgumentList;
    private OutputStream usageOutputStream;
    private String mainClassName;
    private String toolDescription;
    private String[] rawArguments;
    private SubCommand subCommand;

    public SubCommandArgumentParser(String string, String string2, boolean bl) {
        this.mainClassName = string;
        this.toolDescription = string2;
        this.longArgumentsCaseSensitive = bl;
        this.globalArgumentList = new LinkedList();
        this.globalArgumentMap = new HashMap();
        this.globalShortIDMap = new HashMap();
        this.globalLongIDMap = new HashMap();
        this.subCommands = new HashMap();
        this.rawArguments = null;
        this.subCommand = null;
        this.usageArgument = null;
        this.usageOutputStream = null;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public String getToolDescription() {
        return this.toolDescription;
    }

    public boolean longArgumentsCaseSensitive() {
        return this.longArgumentsCaseSensitive;
    }

    public LinkedList<Argument> getGlobalArgumentList() {
        return this.globalArgumentList;
    }

    public boolean hasGlobalArgument(String string) {
        return this.globalArgumentMap.containsKey(string);
    }

    public Argument getGlobalArgument(String string) {
        return this.globalArgumentMap.get(string);
    }

    public HashMap<Character, Argument> getGlobalArgumentsByShortID() {
        return this.globalShortIDMap;
    }

    public boolean hasGlobalArgumentWithShortID(Character c) {
        return this.globalShortIDMap.containsKey(c);
    }

    public Argument getGlobalArgumentForShortID(Character c) {
        return this.globalShortIDMap.get(c);
    }

    public HashMap<String, Argument> getGlobalArgumentsByLongID() {
        return this.globalLongIDMap;
    }

    public boolean hasGlobalArgumentWithLongID(String string) {
        return this.globalLongIDMap.containsKey(string);
    }

    public Argument getGlobalArgumentForLongID(String string) {
        return this.globalLongIDMap.get(string);
    }

    public HashMap<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }

    public boolean hasSubCommand(String string) {
        return this.subCommands.containsKey(string);
    }

    public SubCommand getSubCommand(String string) {
        return this.subCommands.get(string);
    }

    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    public String[] getRawArguments() {
        return this.rawArguments;
    }

    /*
     * WARNING - void declaration
     */
    public void addGlobalArgument(Argument argument) throws ArgumentException {
        void var4_12;
        String string;
        String string2 = argument.getName();
        if (this.globalArgumentMap.containsKey(string2)) {
            int n = 5505110;
            String string22 = MessageHandler.getMessage(n, string2);
            throw new ArgumentException(n, string22);
        }
        for (SubCommand object22 : this.subCommands.values()) {
            if (object22.getArgumentForName(string2) == null) continue;
            int n = 5505111;
            String string3 = MessageHandler.getMessage(n, string2, object22.getName());
            throw new ArgumentException(n, string3);
        }
        Character c = argument.getShortIdentifier();
        if (c != null) {
            if (this.globalShortIDMap.containsKey(c)) {
                String string4 = this.globalShortIDMap.get(c).getName();
                int n = 5505112;
                String string5 = MessageHandler.getMessage(n, String.valueOf(c), string2, string4);
                throw new ArgumentException(n, string5);
            }
            for (Object object : this.subCommands.values()) {
                if (((SubCommand)object).getArgument(c) == null) continue;
                String string6 = ((SubCommand)object).getName();
                String string7 = ((SubCommand)object).getArgument(c).getName();
                int n = 5505113;
                String string8 = MessageHandler.getMessage(n, String.valueOf(c), string2, string7, string6);
                throw new ArgumentException(n, string8);
            }
        }
        if ((string = argument.getLongIdentifier()) != null) {
            if (!this.longArgumentsCaseSensitive) {
                String string9 = StaticUtils.toLowerCase(string);
            }
            if (this.globalLongIDMap.containsKey(var4_12)) {
                Object object;
                object = this.globalLongIDMap.get(var4_12).getName();
                int n = 5505114;
                String string10 = MessageHandler.getMessage(n, var4_12, string2, object);
                throw new ArgumentException(n, string10);
            }
            for (SubCommand subCommand : this.subCommands.values()) {
                if (subCommand.getArgument((String)var4_12) == null) continue;
                String string11 = subCommand.getName();
                String string12 = subCommand.getArgument((String)var4_12).getName();
                int n = 5505115;
                String string13 = MessageHandler.getMessage(n, var4_12, string2, string12, string11);
                throw new ArgumentException(n, string13);
            }
        }
        if (c != null) {
            this.globalShortIDMap.put(c, argument);
        }
        if (var4_12 != null) {
            this.globalLongIDMap.put((String)var4_12, argument);
        }
        this.globalArgumentList.add(argument);
    }

    public void setUsageArgument(Argument argument) {
        this.usageArgument = argument;
        this.usageOutputStream = System.out;
    }

    public void setUsageArgument(Argument argument, OutputStream outputStream) {
        this.usageArgument = argument;
        this.usageOutputStream = outputStream;
    }

    void addSubCommand(SubCommand subCommand) {
        this.subCommands.put(StaticUtils.toLowerCase(subCommand.getName()), subCommand);
    }

    public void parseArguments(String[] stringArray) throws ArgumentException {
        this.parseArguments(stringArray, null);
    }

    public void parseArguments(String[] stringArray, String string, boolean bl) throws ArgumentException {
        Properties properties;
        block2: {
            this.rawArguments = stringArray;
            properties = null;
            try {
                Properties properties2 = new Properties();
                FileInputStream fileInputStream = new FileInputStream(string);
                properties2.load(fileInputStream);
                fileInputStream.close();
                properties = properties2;
            }
            catch (Exception exception) {
                if (!bl) break block2;
                int n = 5505116;
                String string2 = MessageHandler.getMessage(n, String.valueOf(string), StaticUtils.stackTraceToSingleLineString(exception));
                throw new ArgumentException(n, string2, exception);
            }
        }
        this.parseArguments(stringArray, properties);
    }

    public void parseArguments(String[] stringArray, Properties properties) throws ArgumentException {
        Object object;
        this.rawArguments = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            int n2;
            String object3 = stringArray[i];
            if (object3.equals("--")) {
                int object4 = 5505117;
                object = MessageHandler.getMessage(object4, object3);
                throw new ArgumentException(object4, (String)object);
            }
            if (object3.startsWith("--")) {
                Argument n12;
                String bl = object3.substring(2);
                object = null;
                n2 = bl.indexOf(61);
                if (n2 >= 0) {
                    if (n2 == 0) {
                        int exception = 5505117;
                        String n7 = MessageHandler.getMessage(exception, object3);
                        throw new ArgumentException(exception, n7);
                    }
                    object = bl.substring(n2 + 1);
                    bl = bl.substring(0, n2);
                }
                if (!this.longArgumentsCaseSensitive) {
                    bl = StaticUtils.toLowerCase(bl);
                }
                if ((n12 = this.globalLongIDMap.get(bl)) == null) {
                    if (this.subCommand == null) {
                        int stringBuilder = 5505118;
                        String string = MessageHandler.getMessage(stringBuilder, bl);
                        throw new ArgumentException(stringBuilder, string);
                    }
                    n12 = this.subCommand.getArgument(bl);
                    if (n12 == null) {
                        int n8 = 5505119;
                        String string = MessageHandler.getMessage(n8, bl);
                        throw new ArgumentException(n8, string);
                    }
                }
                n12.setPresent(true);
                if (this.usageArgument != null && this.usageArgument.getName().equals(n12.getName())) {
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception string) {
                        // empty catch block
                    }
                    return;
                }
                if (n12.needsValue()) {
                    StringBuilder string;
                    if (object == null) {
                        if (i + 1 == n) {
                            int string2 = 5505120;
                            String string3 = MessageHandler.getMessage(string2, bl);
                            throw new ArgumentException(string2, string3);
                        }
                        object = stringArray[++i];
                    }
                    if (!n12.valueIsAcceptable((String)object, string = new StringBuilder())) {
                        int n3 = 5505121;
                        object2 = MessageHandler.getMessage(n3, object, bl, string.toString());
                        throw new ArgumentException(n3, (String)object2);
                    }
                    if (n12.hasValue() && !n12.isMultiValued()) {
                        int n4 = 5505122;
                        object2 = MessageHandler.getMessage(n4, bl);
                        throw new ArgumentException(n4, (String)object2);
                    }
                    n12.addValue((String)object);
                    continue;
                }
                if (object == null) continue;
                int n13 = 5505123;
                String string = MessageHandler.getMessage(n13, bl);
                throw new ArgumentException(n13, string);
            }
            if (object3.startsWith("-")) {
                if (object3.equals("-")) {
                    int bl = 5505124;
                    object = MessageHandler.getMessage(bl);
                    throw new ArgumentException(bl, (String)object);
                }
                char c = object3.charAt(1);
                object = object3.length() > 2 ? object3.substring(2) : null;
                Argument argument = this.globalShortIDMap.get(Character.valueOf(c));
                if (argument == null) {
                    if (this.subCommand == null) {
                        int stringBuilder = 5505125;
                        String n14 = MessageHandler.getMessage(stringBuilder, String.valueOf(c));
                        throw new ArgumentException(stringBuilder, n14);
                    }
                    argument = this.subCommand.getArgument(Character.valueOf(c));
                    if (argument == null) {
                        int n15 = 5505126;
                        String j = MessageHandler.getMessage(n15, String.valueOf(c));
                        throw new ArgumentException(n15, j);
                    }
                }
                argument.setPresent(true);
                if (this.usageArgument != null && this.usageArgument.getName().equals(argument.getName())) {
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception string) {
                        // empty catch block
                    }
                    return;
                }
                if (argument.needsValue()) {
                    StringBuilder stringBuilder;
                    if (object == null) {
                        if (i + 1 == n) {
                            int string = 5505127;
                            String string4 = MessageHandler.getMessage(string, String.valueOf(c));
                            throw new ArgumentException(string, string4);
                        }
                        object = stringArray[++i];
                    }
                    if (!argument.valueIsAcceptable((String)object, stringBuilder = new StringBuilder())) {
                        int n5 = 5505128;
                        String string = MessageHandler.getMessage(n5, object, String.valueOf(c), stringBuilder.toString());
                        throw new ArgumentException(n5, string);
                    }
                    if (argument.hasValue() && !argument.isMultiValued()) {
                        int n6 = 5505129;
                        String string = MessageHandler.getMessage(n6, String.valueOf(c));
                        throw new ArgumentException(n6, string);
                    }
                    argument.addValue((String)object);
                    continue;
                }
                if (object == null) continue;
                int n7 = ((String)object).length();
                for (int j = 0; j < n7; ++j) {
                    char string6 = ((String)object).charAt(j);
                    object2 = this.globalShortIDMap.get(Character.valueOf(string6));
                    if (object2 == null) {
                        if (this.subCommand == null) {
                            int n8 = 5505125;
                            String string = MessageHandler.getMessage(n8, String.valueOf(c));
                            throw new ArgumentException(n8, string);
                        }
                        object2 = this.subCommand.getArgument(Character.valueOf(string6));
                        if (object2 == null) {
                            int n9 = 5505126;
                            String string = MessageHandler.getMessage(n9, String.valueOf(c));
                            throw new ArgumentException(n9, string);
                        }
                    }
                    if (((Argument)object2).needsValue()) {
                        int n10 = 5505130;
                        String string = MessageHandler.getMessage(n10, String.valueOf(c), object, String.valueOf(string6));
                        throw new ArgumentException(n10, string);
                    }
                    ((Argument)object2).setPresent(true);
                    if (this.usageArgument == null || !this.usageArgument.getName().equals(((Argument)object2).getName())) continue;
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                continue;
            }
            String string = object3;
            if (!this.longArgumentsCaseSensitive) {
                string = StaticUtils.toLowerCase(object3);
            }
            if ((object = this.subCommands.get(string)) == null) {
                n2 = 5505131;
                String string5 = MessageHandler.getMessage(n2, object3);
                throw new ArgumentException(n2, string5);
            }
            if (this.subCommand == null) {
                this.subCommand = object;
                continue;
            }
            n2 = 5505132;
            String string6 = MessageHandler.getMessage(n2, object3, this.subCommand.getName());
            throw new ArgumentException(n2, string6);
        }
        for (Argument argument : this.globalArgumentList) {
            if (argument.isPresent() || !argument.needsValue()) continue;
            boolean bl = false;
            if (properties != null && argument.getPropertyName() != null && (object = properties.getProperty(argument.getPropertyName())) != null) {
                argument.addValue((String)object);
                bl = true;
            }
            if (!bl && argument.getDefaultValue() != null) {
                argument.addValue(argument.getDefaultValue());
                bl = true;
            }
            if (bl || !argument.isRequired()) continue;
            int n11 = 5505133;
            String string = MessageHandler.getMessage(n11, argument.getName());
            throw new ArgumentException(n11, string);
        }
        if (this.subCommand != null) {
            for (Argument argument : this.subCommand.getArguments()) {
                if (argument.isPresent() || !argument.needsValue()) continue;
                boolean bl = false;
                if (properties != null && argument.getPropertyName() != null && (object = properties.getProperty(argument.getPropertyName())) != null) {
                    argument.addValue((String)object);
                    bl = true;
                }
                if (!bl && argument.getDefaultValue() != null) {
                    argument.addValue(argument.getDefaultValue());
                    bl = true;
                }
                if (bl || !argument.isRequired()) continue;
                int n12 = 5505133;
                String string = MessageHandler.getMessage(n12, argument.getName());
                throw new ArgumentException(n12, string);
            }
        }
    }

    public void getFullUsage(StringBuilder stringBuilder) {
        String string;
        String string2;
        if (this.toolDescription != null && this.toolDescription.length() > 0) {
            stringBuilder.append(StaticUtils.wrapText(this.toolDescription, 79));
            stringBuilder.append(ServerConstants.EOL);
        }
        if ((string2 = System.getProperty("org.opends.server.scriptName")) == null || string2.length() == 0) {
            stringBuilder.append("Usage:  java ");
            stringBuilder.append(this.mainClassName);
        } else {
            stringBuilder.append("Usage:  ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(" {subcommand} {options}");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Global Options:");
        stringBuilder.append(ServerConstants.EOL);
        for (Argument object : this.globalArgumentList) {
            Object object2;
            if (object.isHidden()) continue;
            if (object.needsValue()) {
                String string3 = object.getValuePlaceholder();
                object2 = object == null ? " {value}" : " " + string3;
            } else {
                object2 = "";
            }
            Character c = object.getShortIdentifier();
            if (c != null) {
                stringBuilder.append("     -");
                stringBuilder.append(c);
                stringBuilder.append((String)object2);
                string = object.getLongIdentifier();
                if (string == null) continue;
                stringBuilder.append("  or  --");
                stringBuilder.append(string);
                stringBuilder.append((String)object2);
                continue;
            }
            string = object.getLongIdentifier();
            if (string == null) continue;
            stringBuilder.append("     --");
            stringBuilder.append(string);
            stringBuilder.append((String)object2);
        }
        stringBuilder.append(ServerConstants.EOL);
        for (SubCommand subCommand : this.subCommands.values()) {
            stringBuilder.append(subCommand.getName());
            stringBuilder.append(" Subcommand Options:");
            stringBuilder.append(ServerConstants.EOL);
            for (Argument argument : subCommand.getArguments()) {
                String string4;
                Object object;
                if (argument.isHidden()) continue;
                if (argument.needsValue()) {
                    object = argument.getValuePlaceholder();
                    string = argument == null ? " {value}" : " " + (String)object;
                } else {
                    string = "";
                }
                object = argument.getShortIdentifier();
                if (object != null) {
                    stringBuilder.append("     -");
                    stringBuilder.append(object);
                    stringBuilder.append(string);
                    string4 = argument.getLongIdentifier();
                    if (string4 != null) {
                        stringBuilder.append("  or  --");
                        stringBuilder.append(string4);
                        stringBuilder.append(string);
                    }
                } else {
                    string4 = argument.getLongIdentifier();
                    if (string4 != null) {
                        stringBuilder.append("     --");
                        stringBuilder.append(string4);
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append(ServerConstants.EOL);
            }
        }
    }

    public void getSubCommandUsage(StringBuilder stringBuilder, SubCommand subCommand) {
        String string;
        String string2;
        Character c;
        String string3 = System.getProperty("org.opends.server.scriptName");
        if (string3 == null || string3.length() == 0) {
            stringBuilder.append("Usage:  java ");
            stringBuilder.append(this.mainClassName);
        } else {
            stringBuilder.append("Usage:  ");
            stringBuilder.append(string3);
        }
        stringBuilder.append(" ");
        stringBuilder.append(subCommand.getName());
        stringBuilder.append(" {options}");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("             where {options} include:");
        for (Argument argument : this.globalArgumentList) {
            if (argument.isHidden()) continue;
            c = argument.getShortIdentifier();
            if (c != null) {
                stringBuilder.append("-");
                stringBuilder.append(c.charValue());
                if (argument.needsValue()) {
                    stringBuilder.append(" ");
                    stringBuilder.append(argument.getValuePlaceholder());
                }
                if ((string2 = argument.getLongIdentifier()) != null) {
                    stringBuilder.append("   or   --");
                    stringBuilder.append(string2);
                    if (argument.needsValue()) {
                        stringBuilder.append(" ");
                        stringBuilder.append(argument.getValuePlaceholder());
                    }
                }
                stringBuilder.append(ServerConstants.EOL);
            } else {
                string2 = argument.getLongIdentifier();
                if (string2 != null) {
                    stringBuilder.append("--");
                    stringBuilder.append(string2);
                    if (argument.needsValue()) {
                        stringBuilder.append(" ");
                        stringBuilder.append(argument.getValuePlaceholder());
                    }
                    stringBuilder.append(ServerConstants.EOL);
                }
            }
            string2 = argument.getDescription();
            if (string2.length() <= 75) {
                stringBuilder.append("    ");
                stringBuilder.append(string2);
                stringBuilder.append(ServerConstants.EOL);
            } else {
                string = string2;
                while (string.length() > 75) {
                    int n = string.lastIndexOf(32, 75);
                    if (n > 0) {
                        stringBuilder.append("    ");
                        stringBuilder.append(string.substring(0, n).trim());
                        string = string.substring(n + 1).trim();
                        stringBuilder.append(ServerConstants.EOL);
                        continue;
                    }
                    n = string.indexOf(32);
                    if (n > 0) {
                        stringBuilder.append("    ");
                        stringBuilder.append(string.substring(0, n).trim());
                        string = string.substring(n + 1).trim();
                        stringBuilder.append(ServerConstants.EOL);
                        continue;
                    }
                    stringBuilder.append("    ");
                    stringBuilder.append(string);
                    string = "";
                    stringBuilder.append(ServerConstants.EOL);
                }
                if (string.length() > 0) {
                    stringBuilder.append("    ");
                    stringBuilder.append(string);
                    stringBuilder.append(ServerConstants.EOL);
                }
            }
            stringBuilder.append(ServerConstants.EOL);
        }
        for (Argument argument : subCommand.getArguments()) {
            if (argument.isHidden()) continue;
            c = argument.getShortIdentifier();
            if (c != null) {
                int n = stringBuilder.length();
                stringBuilder.append("-");
                stringBuilder.append(c.charValue());
                if (argument.needsValue()) {
                    stringBuilder.append(" ");
                    stringBuilder.append(argument.getValuePlaceholder());
                }
                if ((string = argument.getLongIdentifier()) != null) {
                    int n2;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append("or   --");
                    stringBuilder2.append(string);
                    if (argument.needsValue()) {
                        stringBuilder2.append(" ");
                        stringBuilder2.append(argument.getValuePlaceholder());
                    }
                    if ((n2 = stringBuilder.length() - n + 2 + stringBuilder2.length()) > 80) {
                        stringBuilder.append(ServerConstants.EOL);
                        stringBuilder.append(stringBuilder2.toString());
                    } else {
                        stringBuilder.append("  ");
                        stringBuilder.append(stringBuilder2.toString());
                    }
                }
                stringBuilder.append(ServerConstants.EOL);
            } else {
                string2 = argument.getLongIdentifier();
                if (string2 != null) {
                    stringBuilder.append("--");
                    stringBuilder.append(string2);
                    if (argument.needsValue()) {
                        stringBuilder.append(" ");
                        stringBuilder.append(argument.getValuePlaceholder());
                    }
                    stringBuilder.append(ServerConstants.EOL);
                }
            }
            string2 = argument.getDescription();
            if (string2.length() <= 74) {
                stringBuilder.append("     ");
                stringBuilder.append(string2);
                stringBuilder.append(ServerConstants.EOL);
                continue;
            }
            string = string2;
            while (string.length() > 74) {
                int n = string.lastIndexOf(32, 74);
                if (n > 0) {
                    stringBuilder.append("     ");
                    stringBuilder.append(string.substring(0, n).trim());
                    string = string.substring(n + 1).trim();
                    stringBuilder.append(ServerConstants.EOL);
                    continue;
                }
                n = string.indexOf(32);
                if (n > 0) {
                    stringBuilder.append("     ");
                    stringBuilder.append(string.substring(0, n).trim());
                    string = string.substring(n + 1).trim();
                    stringBuilder.append(ServerConstants.EOL);
                    continue;
                }
                stringBuilder.append("     ");
                stringBuilder.append(string);
                string = "";
                stringBuilder.append(ServerConstants.EOL);
            }
            if (string.length() <= 0) continue;
            stringBuilder.append("     ");
            stringBuilder.append(string);
            stringBuilder.append(ServerConstants.EOL);
        }
    }

    public String getUsage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.subCommand == null) {
            this.getFullUsage(stringBuilder);
        } else {
            this.getSubCommandUsage(stringBuilder, this.subCommand);
        }
        return stringBuilder.toString();
    }

    public void getUsage(OutputStream outputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.subCommand == null) {
            this.getFullUsage(stringBuilder);
        } else {
            this.getSubCommandUsage(stringBuilder, this.subCommand);
        }
        outputStream.write(StaticUtils.getBytes(stringBuilder.toString()));
    }
}

