/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.util.Iterator;
import java.util.LinkedList;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Argument {
    private boolean isHidden;
    private boolean isMultiValued;
    private boolean isPresent;
    private boolean isRequired;
    private boolean needsValue;
    private Character shortIdentifier;
    private int descriptionID;
    private LinkedList<String> values;
    private String defaultValue;
    private String description;
    private String longIdentifier;
    private String name;
    private String propertyName;
    private String valuePlaceholder;

    protected Argument(String string, Character c, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4, String string5, int n, Object ... objectArray) throws ArgumentException {
        this.name = string;
        this.shortIdentifier = c;
        this.longIdentifier = string2;
        this.isRequired = bl;
        this.isMultiValued = bl2;
        this.needsValue = bl3;
        this.valuePlaceholder = string3;
        this.defaultValue = string4;
        this.propertyName = string5;
        this.descriptionID = n;
        this.description = MessageHandler.getMessage(n, objectArray);
        if (c == null && string2 == null) {
            int n2 = 5505059;
            String string6 = MessageHandler.getMessage(n2, string);
            throw new ArgumentException(n2, string6);
        }
        if (bl3 && string3 == null) {
            int n3 = 5505060;
            String string7 = MessageHandler.getMessage(n3, string);
            throw new ArgumentException(n3, string7);
        }
        this.values = new LinkedList();
        this.isPresent = false;
        this.isHidden = false;
    }

    public String getName() {
        return this.name;
    }

    public Character getShortIdentifier() {
        return this.shortIdentifier;
    }

    public String getLongIdentifier() {
        return this.longIdentifier;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean bl) {
        this.isRequired = bl;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void setPresent(boolean bl) {
        this.isPresent = bl;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public void setMultiValued(boolean bl) {
        this.isMultiValued = bl;
    }

    public boolean needsValue() {
        return this.needsValue;
    }

    public void setNeedsValue(boolean bl) {
        this.needsValue = bl;
    }

    public String getValuePlaceholder() {
        return this.valuePlaceholder;
    }

    public void setValuePlaceholder(String string) {
        this.valuePlaceholder = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public int getDescriptionID() {
        return this.descriptionID;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    public String getValue() {
        if (this.values.isEmpty()) {
            return this.defaultValue;
        }
        return this.values.getFirst();
    }

    public LinkedList<String> getValues() {
        return this.values;
    }

    public int getIntValue() throws ArgumentException {
        int n;
        if (this.values.isEmpty()) {
            int n2 = 5505061;
            String string = MessageHandler.getMessage(n2, this.name);
            throw new ArgumentException(n2, string);
        }
        Iterator iterator = this.values.iterator();
        String string = (String)iterator.next();
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            int n3 = 5505062;
            String string2 = MessageHandler.getMessage(n3, string, this.name);
            throw new ArgumentException(n3, string2, exception);
        }
        if (iterator.hasNext()) {
            int n4 = 5505063;
            String string3 = MessageHandler.getMessage(n4, this.name);
            throw new ArgumentException(n4, string3);
        }
        return n;
    }

    public LinkedList<Integer> getIntValues() throws ArgumentException {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (String string : this.values) {
            try {
                linkedList.add(Integer.valueOf(string));
            }
            catch (Exception exception) {
                int n = 5505062;
                String string2 = MessageHandler.getMessage(n, string, this.name);
                throw new ArgumentException(n, string2, exception);
            }
        }
        return linkedList;
    }

    public boolean getBooleanValue() throws ArgumentException {
        boolean bl;
        if (this.values.isEmpty()) {
            int n = 5505064;
            String string = MessageHandler.getMessage(n, this.name);
            throw new ArgumentException(n, string);
        }
        Iterator iterator = this.values.iterator();
        String string = StaticUtils.toLowerCase((String)iterator.next());
        if (string.equals("true") || string.equals("yes") || string.equals("on") || string.equals("1")) {
            bl = true;
        } else if (string.equals("false") || string.equals("no") || string.equals("off") || string.equals("0")) {
            bl = false;
        } else {
            int n = 5505065;
            String string2 = MessageHandler.getMessage(n, string, this.name);
            throw new ArgumentException(n, string2);
        }
        if (iterator.hasNext()) {
            int n = 5505066;
            String string3 = MessageHandler.getMessage(n, this.name);
            throw new ArgumentException(n, string3);
        }
        return bl;
    }

    public abstract boolean valueIsAcceptable(String var1, StringBuilder var2);

    public void addValue(String string) {
        this.values.add(string);
    }

    public void clearValues() {
        this.values.clear();
    }
}

