/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.OutputStream;
import org.opends.server.loggers.Debug;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public final class MultiOutputStream
extends OutputStream {
    private static final String CLASS_NAME = "org.opends.server.util.MultiOutputStream";
    private final OutputStream[] targetStreams;

    public MultiOutputStream(OutputStream ... outputStreamArray) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(outputStreamArray)));
        Validator.ensureNotNull(outputStreamArray);
        this.targetStreams = outputStreamArray;
    }

    public void close() {
        assert (Debug.debugEnter(CLASS_NAME, "close", new String[0]));
        for (OutputStream outputStream : this.targetStreams) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "close", exception));
            }
        }
    }

    public void flush() {
        assert (Debug.debugEnter(CLASS_NAME, "flush", new String[0]));
        for (OutputStream outputStream : this.targetStreams) {
            try {
                outputStream.flush();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "flush", exception));
            }
        }
    }

    public void write(byte[] byArray) {
        assert (Debug.debugEnter(CLASS_NAME, "write", "byte[" + byArray.length + "]"));
        for (OutputStream outputStream : this.targetStreams) {
            try {
                outputStream.write(byArray);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "write", exception));
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        assert (Debug.debugEnter(CLASS_NAME, "write", "byte[" + byArray.length + "]"));
        for (OutputStream outputStream : this.targetStreams) {
            try {
                outputStream.write(byArray, n, n2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "write", exception));
            }
        }
    }

    public void write(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "write", StaticUtils.byteToHex((byte)n)));
        for (OutputStream outputStream : this.targetStreams) {
            try {
                outputStream.write(n);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "write", exception));
            }
        }
    }
}

