/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import org.opends.server.loggers.Debug;
import org.opends.server.types.DN;
import org.opends.server.types.RDN;
import org.opends.server.util.ChangeOperationType;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.Validator;

public final class ModifyDNChangeRecordEntry
extends ChangeRecordEntry {
    private static final String CLASS_NAME = "org.opends.server.util.ModifyDNChangeRecordEntry";
    private final RDN newRDN;
    private final DN newSuperiorDN;
    private final boolean deleteOldRDN;

    public ModifyDNChangeRecordEntry(DN dN, RDN rDN, boolean bl, DN dN2) {
        super(dN);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(dN2), String.valueOf(rDN), String.valueOf(bl)));
        Validator.ensureNotNull(rDN);
        this.newSuperiorDN = dN2;
        this.newRDN = rDN;
        this.deleteOldRDN = bl;
    }

    public RDN getNewRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getNewRDN", new String[0]));
        return this.newRDN;
    }

    public DN getNewSuperiorDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getNewSuperiorDN", new String[0]));
        return this.newSuperiorDN;
    }

    public boolean deleteOldRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "deleteOldRDN", new String[0]));
        return this.deleteOldRDN;
    }

    public ChangeOperationType getChangeOperationType() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeOperationType", new String[0]));
        return ChangeOperationType.MODIFY_DN;
    }
}

