/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.DN;
import org.opends.server.util.ChangeOperationType;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModifyChangeRecordEntry
extends ChangeRecordEntry {
    private static final String CLASS_NAME = "org.opends.server.util.ModifyChangeRecordEntry";
    private final List<LDAPModification> modifications;

    public ModifyChangeRecordEntry(DN dN, Collection<LDAPModification> collection) {
        super(dN);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(collection)));
        Validator.ensureNotNull(collection);
        this.modifications = new ArrayList<LDAPModification>(collection);
    }

    public List<LDAPModification> getModifications() {
        assert (Debug.debugEnter(CLASS_NAME, "getModifications", new String[0]));
        return Collections.unmodifiableList(this.modifications);
    }

    @Override
    public ChangeOperationType getChangeOperationType() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeOperationType", new String[0]));
        return ChangeOperationType.MODIFY;
    }
}

