/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.opends.server.loggers.Debug;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.RDN;
import org.opends.server.util.Base64;
import org.opends.server.util.LDIFException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFWriter {
    private static final String CLASS_NAME = "org.opends.server.util.LDIFWriter";
    private BufferedWriter writer;
    private LDIFExportConfig exportConfig;
    private static final Pattern SPLIT_NEWLINE = Pattern.compile("\\r?\\n");

    public LDIFWriter(LDIFExportConfig lDIFExportConfig) throws IOException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(lDIFExportConfig)));
        Validator.ensureNotNull(lDIFExportConfig);
        this.exportConfig = lDIFExportConfig;
        this.writer = lDIFExportConfig.getWriter();
    }

    public void writeComment(String string, int n) throws IOException {
        String[] stringArray;
        assert (Debug.debugEnter(CLASS_NAME, "writeComment", String.valueOf(string), String.valueOf(n)));
        Validator.ensureNotNull(string);
        for (String string2 : stringArray = SPLIT_NEWLINE.split(string)) {
            if (n <= 0) {
                this.writer.write("# ");
                this.writer.write(string2);
                this.writer.newLine();
                continue;
            }
            int n2 = n - 2;
            if (string2.length() <= n2) {
                this.writer.write("# ");
                this.writer.write(string2);
                this.writer.newLine();
                continue;
            }
            int n3 = 0;
            block1: while (n3 < string2.length()) {
                if (n3 + n2 >= string2.length()) {
                    this.writer.write("# ");
                    this.writer.write(string2.substring(n3));
                    this.writer.newLine();
                    n3 = string2.length();
                    continue;
                }
                int n4 = n3 + n2;
                for (int i = n4 - 1; i > n3; --i) {
                    if (string2.charAt(i) != ' ') continue;
                    this.writer.write("# ");
                    this.writer.write(string2.substring(n3, i));
                    this.writer.newLine();
                    n3 = i + 1;
                    continue block1;
                }
                this.writer.write("# ");
                this.writer.write(string2.substring(n3, n4));
                this.writer.newLine();
                n3 = n4;
            }
        }
    }

    public boolean writeEntries(Collection<Entry> collection) throws IOException, LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "writeEntry", String.valueOf(collection)));
        boolean bl = true;
        Iterator<Entry> iterator = collection.iterator();
        while (bl && iterator.hasNext()) {
            bl = this.writeEntry(iterator.next());
        }
        return bl;
    }

    public boolean writeEntry(Entry entry) throws IOException, LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "writeEntry", String.valueOf(entry)));
        Validator.ensureNotNull(entry);
        return entry.toLDIF(this.exportConfig);
    }

    public void writeAddChangeRecord(Entry entry) throws IOException {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "writeAddChangeRecord", String.valueOf(entry)));
        Validator.ensureNotNull(entry);
        BufferedWriter bufferedWriter = this.exportConfig.getWriter();
        int n = this.exportConfig.getWrapColumn();
        boolean bl = n > 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder, StaticUtils.getBytes(entry.getDN().toString()));
        LDIFWriter.writeLDIFLine(stringBuilder, bufferedWriter, bl, n);
        StringBuilder stringBuilder2 = new StringBuilder("changetype: add");
        LDIFWriter.writeLDIFLine(stringBuilder2, bufferedWriter, bl, n);
        for (String object2 : entry.getObjectClasses().values()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("objectClass: ");
            ((StringBuilder)object).append(object2);
            LDIFWriter.writeLDIFLine((StringBuilder)object, bufferedWriter, bl, n);
        }
        for (AttributeType attributeType : entry.getUserAttributes().keySet()) {
            object = entry.getUserAttribute(attributeType);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                StringBuilder stringBuilder3 = new StringBuilder(attribute.getName());
                for (String string : attribute.getOptions()) {
                    stringBuilder3.append(";");
                    stringBuilder3.append(string);
                }
                for (AttributeValue attributeValue : attribute.getValues()) {
                    StringBuilder stringBuilder4 = new StringBuilder();
                    stringBuilder4.append((CharSequence)stringBuilder3);
                    LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder4, attributeValue.getValueBytes());
                    LDIFWriter.writeLDIFLine(stringBuilder4, bufferedWriter, bl, n);
                }
            }
        }
        bufferedWriter.newLine();
    }

    public void writeDeleteChangeRecord(Entry entry, boolean bl) throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "writeDeleteChangeRecord", String.valueOf(entry), String.valueOf(bl)));
        Validator.ensureNotNull(entry);
        BufferedWriter bufferedWriter = this.exportConfig.getWriter();
        int n = this.exportConfig.getWrapColumn();
        boolean bl2 = n > 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder, StaticUtils.getBytes(entry.getDN().toString()));
        LDIFWriter.writeLDIFLine(stringBuilder, bufferedWriter, bl2, n);
        StringBuilder stringBuilder2 = new StringBuilder("changetype: delete");
        LDIFWriter.writeLDIFLine(stringBuilder2, bufferedWriter, bl2, n);
        if (bl) {
            Object object;
            for (String object2 : entry.getObjectClasses().values()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("# objectClass: ");
                ((StringBuilder)object).append(object2);
                LDIFWriter.writeLDIFLine((StringBuilder)object, bufferedWriter, bl2, n);
            }
            for (AttributeType attributeType : entry.getUserAttributes().keySet()) {
                object = entry.getUserAttribute(attributeType);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    StringBuilder stringBuilder3 = new StringBuilder();
                    stringBuilder3.append("# ");
                    stringBuilder3.append(attribute.getName());
                    for (String string : attribute.getOptions()) {
                        stringBuilder3.append(";");
                        stringBuilder3.append(string);
                    }
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        StringBuilder stringBuilder4 = new StringBuilder();
                        stringBuilder4.append((CharSequence)stringBuilder3);
                        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder4, attributeValue.getValueBytes());
                        LDIFWriter.writeLDIFLine(stringBuilder4, bufferedWriter, bl2, n);
                    }
                }
            }
        }
        bufferedWriter.newLine();
    }

    public void writeModifyChangeRecord(DN dN, List<Modification> list) throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "writeModifyChangeRecord", String.valueOf(dN), String.valueOf(list)));
        Validator.ensureNotNull(dN, list);
        if (list.isEmpty()) {
            return;
        }
        BufferedWriter bufferedWriter = this.exportConfig.getWriter();
        int n = this.exportConfig.getWrapColumn();
        boolean bl = n > 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder, StaticUtils.getBytes(dN.toString()));
        LDIFWriter.writeLDIFLine(stringBuilder, bufferedWriter, bl, n);
        StringBuilder stringBuilder2 = new StringBuilder("changetype: modify");
        LDIFWriter.writeLDIFLine(stringBuilder2, bufferedWriter, bl, n);
        Iterator<Modification> iterator = list.iterator();
        block6: while (iterator.hasNext()) {
            Modification modification = iterator.next();
            Attribute attribute = modification.getAttribute();
            StringBuilder stringBuilder3 = new StringBuilder(attribute.getName());
            for (String string : attribute.getOptions()) {
                stringBuilder3.append(";");
                stringBuilder3.append(string);
            }
            String string = stringBuilder3.toString();
            StringBuilder charSequence2 = new StringBuilder();
            switch (modification.getModificationType()) {
                case ADD: {
                    charSequence2.append("add: ");
                    charSequence2.append(string);
                    break;
                }
                case DELETE: {
                    charSequence2.append("delete: ");
                    charSequence2.append(string);
                    break;
                }
                case REPLACE: {
                    charSequence2.append("replace: ");
                    charSequence2.append(string);
                    break;
                }
                case INCREMENT: {
                    charSequence2.append("increment: ");
                    charSequence2.append(string);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            LDIFWriter.writeLDIFLine(charSequence2, bufferedWriter, bl, n);
            for (AttributeValue attributeValue : attribute.getValues()) {
                StringBuilder stringBuilder4 = new StringBuilder();
                stringBuilder4.append(string);
                LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder4, attributeValue.getValueBytes());
                LDIFWriter.writeLDIFLine(stringBuilder4, bufferedWriter, bl, n);
            }
            if (iterator.hasNext()) {
                bufferedWriter.write("-");
                bufferedWriter.newLine();
                continue;
            }
            bufferedWriter.newLine();
        }
    }

    public void writeModifyDNChangeRecord(DN dN, RDN rDN, boolean bl, DN dN2) throws IOException {
        StringBuilder stringBuilder;
        assert (Debug.debugEnter(CLASS_NAME, "writeModifyDNChangeRecord", String.valueOf(dN), String.valueOf(rDN), String.valueOf(bl), String.valueOf(dN2)));
        Validator.ensureNotNull(dN, rDN);
        BufferedWriter bufferedWriter = this.exportConfig.getWriter();
        int n = this.exportConfig.getWrapColumn();
        boolean bl2 = n > 1;
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder2, StaticUtils.getBytes(dN.toString()));
        LDIFWriter.writeLDIFLine(stringBuilder2, bufferedWriter, bl2, n);
        if (dN2 == null) {
            stringBuilder = new StringBuilder("changetype: modrdn");
            LDIFWriter.writeLDIFLine(stringBuilder, bufferedWriter, bl2, n);
        } else {
            stringBuilder = new StringBuilder("changetype: moddn");
            LDIFWriter.writeLDIFLine(stringBuilder, bufferedWriter, bl2, n);
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append("newrdn");
        LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder, StaticUtils.getBytes(rDN.toString()));
        LDIFWriter.writeLDIFLine(stringBuilder, bufferedWriter, bl2, n);
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append("deleteoldrdn: ");
        stringBuilder3.append(bl ? "1" : "0");
        LDIFWriter.writeLDIFLine(stringBuilder3, bufferedWriter, bl2, n);
        if (dN2 != null) {
            StringBuilder stringBuilder4 = new StringBuilder();
            stringBuilder4.append("newsuperior");
            LDIFWriter.appendLDIFSeparatorAndValue(stringBuilder4, StaticUtils.getBytes(dN2.toString()));
            LDIFWriter.writeLDIFLine(stringBuilder4, bufferedWriter, bl2, n);
        }
        bufferedWriter.newLine();
    }

    public void flush() throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "flush", new String[0]));
        this.writer.flush();
    }

    public void close() throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "close", new String[0]));
        this.writer.flush();
        this.writer.close();
    }

    public static void appendLDIFSeparatorAndValue(StringBuilder stringBuilder, byte[] byArray) {
        assert (Debug.debugEnter(CLASS_NAME, "appendLDIFSeparatorAndValue", "java.lang.StringBuilder", String.valueOf(byArray)));
        Validator.ensureNotNull(stringBuilder, byArray);
        if (byArray == null || byArray.length == 0) {
            stringBuilder.append(": ");
            return;
        }
        if (StaticUtils.needsBase64Encoding(byArray)) {
            stringBuilder.append(":: ");
            stringBuilder.append(Base64.encode(byArray));
        } else {
            stringBuilder.append(": ");
            try {
                stringBuilder.append(new String(byArray, "UTF-8"));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "appendLDIFSeparatorAndValue", exception));
                stringBuilder.append(new String(byArray));
            }
        }
    }

    public static void writeLDIFLine(StringBuilder stringBuilder, BufferedWriter bufferedWriter, boolean bl, int n) throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "writeLDIFLine", String.valueOf(stringBuilder), String.valueOf(bufferedWriter), String.valueOf(bl), String.valueOf(n)));
        Validator.ensureNotNull(stringBuilder, bufferedWriter);
        int n2 = stringBuilder.length();
        if (bl && n2 > n) {
            bufferedWriter.write(stringBuilder.substring(0, n));
            bufferedWriter.newLine();
            for (int i = n; i < n2; i += n - 1) {
                int n3 = Math.min(n - 1, n2 - i);
                bufferedWriter.write(32);
                bufferedWriter.write(stringBuilder.substring(i, i + n3));
                bufferedWriter.newLine();
            }
        } else {
            bufferedWriter.write(stringBuilder.toString());
            bufferedWriter.newLine();
        }
    }
}

