/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.Base64;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.LDIFException;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.ModifyDNChangeRecordEntry;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFReader {
    private static final String CLASS_NAME = "org.opends.server.util.LDIFReader";
    private BufferedReader reader;
    private byte[] buffer;
    private LDIFImportConfig importConfig;
    private LinkedList<StringBuilder> lastEntryBodyLines;
    private LinkedList<StringBuilder> lastEntryHeaderLines;
    private long entriesIgnored;
    private long entriesRead;
    private long entriesRejected;
    private long lastEntryLineNumber;
    private long lineNumber;
    private PluginConfigManager pluginConfigManager;

    public LDIFReader(LDIFImportConfig lDIFImportConfig) throws IOException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(lDIFImportConfig)));
        Validator.ensureNotNull(lDIFImportConfig);
        this.importConfig = lDIFImportConfig;
        this.reader = lDIFImportConfig.getReader();
        this.buffer = new byte[4096];
        this.entriesRead = 0L;
        this.entriesIgnored = 0L;
        this.entriesRejected = 0L;
        this.lineNumber = 0L;
        this.lastEntryLineNumber = -1L;
        this.lastEntryBodyLines = new LinkedList();
        this.lastEntryHeaderLines = new LinkedList();
        this.pluginConfigManager = DirectoryServer.getPluginConfigManager();
    }

    public Entry readEntry() throws IOException, LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "readEntry", new String[0]));
        return this.readEntry(this.importConfig.validateSchema());
    }

    public Entry readEntry(boolean bl) throws IOException, LDIFException {
        StringBuilder stringBuilder;
        Entry entry;
        DN dN;
        LinkedList<StringBuilder> linkedList;
        assert (Debug.debugEnter(CLASS_NAME, "readEntry", new String[0]));
        while (true) {
            LDIFPluginResult lDIFPluginResult;
            if ((linkedList = this.readEntryLines()) == null) {
                return null;
            }
            this.lastEntryBodyLines = linkedList;
            this.lastEntryHeaderLines = new LinkedList();
            dN = this.readDN(linkedList);
            if (dN == null) continue;
            if (!this.importConfig.includeEntry(dN)) {
                assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_READ, DebugLogSeverity.INFO, CLASS_NAME, "readEntry", "Skipping entry " + String.valueOf(dN) + " because the DN is not one that should be " + "included based on the include and exclude " + "branches."));
                ++this.entriesRead;
                ++this.entriesIgnored;
                continue;
            }
            ++this.entriesRead;
            HashMap<ObjectClass, String> hashMap = new HashMap<ObjectClass, String>();
            HashMap<AttributeType, List<Attribute>> hashMap2 = new HashMap<AttributeType, List<Attribute>>();
            HashMap<AttributeType, List<Attribute>> hashMap3 = new HashMap<AttributeType, List<Attribute>>();
            try {
                for (StringBuilder exception : linkedList) {
                    this.readAttribute(linkedList, exception, dN, hashMap, hashMap2, hashMap3);
                }
            }
            catch (LDIFException lDIFException) {
                ++this.entriesRejected;
                throw lDIFException;
            }
            entry = new Entry(dN, hashMap, hashMap2, hashMap3);
            assert (Debug.debugProtocolElementRead(CLASS_NAME, "readEntry", entry));
            try {
                if (!this.importConfig.includeEntry(entry)) {
                    assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_READ, DebugLogSeverity.INFO, CLASS_NAME, "readEntry", "Skipping entry " + String.valueOf(dN) + " because the DN is not one that should be " + "included based on the include and exclude " + "filters."));
                    ++this.entriesIgnored;
                    continue;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "readEntry", exception));
                int n = 5505046;
                String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), this.lastEntryLineNumber, String.valueOf(exception));
                throw new LDIFException(n, string, this.lastEntryLineNumber, true, exception);
            }
            if (!this.importConfig.invokeImportPlugins() || (lDIFPluginResult = this.pluginConfigManager.invokeLDIFImportPlugins(this.importConfig, entry)).continueEntryProcessing()) break;
            ++this.entriesIgnored;
        }
        if (bl && !entry.conformsToSchema(null, false, stringBuilder = new StringBuilder())) {
            int n = 5439505;
            String string = MessageHandler.getMessage(n, String.valueOf(dN), this.lastEntryLineNumber, stringBuilder.toString());
            this.logToRejectWriter(linkedList, string);
            ++this.entriesRejected;
            throw new LDIFException(n, string, this.lastEntryLineNumber, true);
        }
        return entry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChangeRecordEntry readChangeRecord(boolean bl) throws IOException, LDIFException {
        LinkedList<StringBuilder> linkedList;
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "readChangeRecord", new String[0]));
        do {
            if ((linkedList = this.readEntryLines()) != null) continue;
            return null;
        } while ((dN = this.readDN(linkedList)) == null);
        String string = this.readChangeType(linkedList);
        ChangeRecordEntry changeRecordEntry = null;
        if (string != null) {
            if (string.equals("add")) {
                return this.parseAddChangeRecordEntry(dN, linkedList);
            }
            if (string.equals("delete")) {
                return this.parseDeleteChangeRecordEntry(dN, linkedList);
            }
            if (string.equals("modify")) {
                return this.parseModifyChangeRecordEntry(dN, linkedList);
            }
            if (string.equals("modrdn")) {
                return this.parseModifyDNChangeRecordEntry(dN, linkedList);
            }
            if (string.equals("moddn")) {
                return this.parseModifyDNChangeRecordEntry(dN, linkedList);
            }
            int n = 5505054;
            String string2 = MessageHandler.getMessage(n, string, "add, delete, modify, moddn, modrdn");
            throw new LDIFException(n, string2, this.lastEntryLineNumber, false);
        }
        if (bl) {
            return this.parseAddChangeRecordEntry(dN, linkedList);
        }
        int n = 5505054;
        String string3 = MessageHandler.getMessage(n, null, "add, delete, modify, moddn, modrdn");
        throw new LDIFException(n, string3, this.lastEntryLineNumber, false);
    }

    private LinkedList<StringBuilder> readEntryLines() throws IOException, LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "readEntryLines", new String[0]));
        LinkedList<StringBuilder> linkedList = new LinkedList<StringBuilder>();
        int n = -1;
        while (true) {
            String string = this.reader.readLine();
            ++this.lineNumber;
            if (string == null) {
                if (!linkedList.isEmpty()) break;
                this.reader = this.importConfig.nextReader();
                if (this.reader == null) {
                    return null;
                }
                return this.readEntryLines();
            }
            if (string.length() == 0) {
                if (!linkedList.isEmpty()) break;
                continue;
            }
            if (string.charAt(0) == '#') continue;
            if (string.charAt(0) == ' ' || string.charAt(0) == '\t') {
                if (n >= 0) {
                    linkedList.get(n).append(string.substring(1));
                    continue;
                }
                int n2 = 0x530005;
                String string2 = MessageHandler.getMessage(n2, this.lineNumber, string);
                this.logToRejectWriter(linkedList, string2);
                throw new LDIFException(n2, string2, this.lineNumber, false);
            }
            if (linkedList.isEmpty()) {
                this.lastEntryLineNumber = this.lineNumber;
            }
            linkedList.add(new StringBuilder(string));
            ++n;
        }
        return linkedList;
    }

    private DN readDN(LinkedList<StringBuilder> linkedList) throws LDIFException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "readDN", String.valueOf(linkedList)));
        if (linkedList.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = linkedList.remove();
        this.lastEntryHeaderLines.add(stringBuilder);
        int n2 = stringBuilder.indexOf(":");
        if (n2 <= 0) {
            int n3 = 5439494;
            String string = MessageHandler.getMessage(n3, this.lastEntryLineNumber, stringBuilder.toString());
            this.logToRejectWriter(linkedList, string);
            throw new LDIFException(n3, string, this.lastEntryLineNumber, true);
        }
        String string = StaticUtils.toLowerCase(stringBuilder.substring(0, n2));
        if (string.equals("version")) {
            return this.readDN(linkedList);
        }
        if (!string.equals("dn")) {
            int n4 = 5439495;
            String string2 = MessageHandler.getMessage(n4, this.lastEntryLineNumber, stringBuilder.toString());
            this.logToRejectWriter(linkedList, string2);
            throw new LDIFException(n4, string2, this.lastEntryLineNumber, true);
        }
        int n5 = stringBuilder.length();
        if (n2 == n5 - 1) {
            return DN.nullDN();
        }
        if (stringBuilder.charAt(n2 + 1) == ':') {
            String string3;
            int n6;
            for (n6 = n2 + 2; n6 < n5 && stringBuilder.charAt(n6) == ' '; ++n6) {
            }
            String string4 = stringBuilder.substring(n6);
            try {
                string3 = new String(Base64.decode(string4), "UTF-8");
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "readDN", exception));
                int n7 = 5439499;
                String string5 = MessageHandler.getMessage(n7, this.lastEntryLineNumber, stringBuilder, String.valueOf(exception));
                this.logToRejectWriter(linkedList, string5);
                throw new LDIFException(n7, string5, this.lastEntryLineNumber, true, exception);
            }
            try {
                return DN.decode(string3);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "readDN", directoryException));
                int n8 = 5439497;
                String string6 = MessageHandler.getMessage(n8, this.lastEntryLineNumber, stringBuilder.toString(), directoryException.getErrorMessage());
                this.logToRejectWriter(linkedList, string6);
                throw new LDIFException(n8, string6, this.lastEntryLineNumber, true, directoryException);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "readDN", exception));
                int n9 = 5439497;
                String string7 = MessageHandler.getMessage(n9, this.lastEntryLineNumber, stringBuilder.toString(), String.valueOf(exception));
                this.logToRejectWriter(linkedList, string7);
                throw new LDIFException(n9, string7, this.lastEntryLineNumber, true, exception);
            }
        }
        for (n = n2 + 1; n < n5 && stringBuilder.charAt(n) == ' '; ++n) {
        }
        String string8 = stringBuilder.substring(n);
        try {
            return DN.decode(string8);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "readDN", directoryException));
            int n10 = 5439497;
            String string9 = MessageHandler.getMessage(n10, this.lastEntryLineNumber, stringBuilder.toString(), directoryException.getErrorMessage());
            this.logToRejectWriter(linkedList, string9);
            throw new LDIFException(n10, string9, this.lastEntryLineNumber, true, directoryException);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "readDN", exception));
            int n11 = 5439497;
            String string10 = MessageHandler.getMessage(n11, this.lastEntryLineNumber, stringBuilder.toString(), String.valueOf(exception));
            this.logToRejectWriter(linkedList, string10);
            throw new LDIFException(n11, string10, this.lastEntryLineNumber, true, exception);
        }
    }

    private String readChangeType(LinkedList<StringBuilder> linkedList) throws LDIFException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "readChangeType", String.valueOf(linkedList)));
        if (linkedList.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = linkedList.get(0);
        this.lastEntryHeaderLines.add(stringBuilder);
        int n2 = stringBuilder.indexOf(":");
        if (n2 <= 0) {
            int n3 = 5439494;
            String string = MessageHandler.getMessage(n3, this.lastEntryLineNumber, stringBuilder.toString());
            this.logToRejectWriter(linkedList, string);
            throw new LDIFException(n3, string, this.lastEntryLineNumber, true);
        }
        String string = StaticUtils.toLowerCase(stringBuilder.substring(0, n2));
        if (!string.equals("changetype")) {
            return null;
        }
        linkedList.remove();
        int n4 = stringBuilder.length();
        if (n2 == n4 - 1) {
            int n5 = 5505054;
            String string2 = MessageHandler.getMessage(n5, null, "add, delete, modify, moddn, modrdn");
            throw new LDIFException(n5, string2, this.lastEntryLineNumber, false);
        }
        if (stringBuilder.charAt(n2 + 1) == ':') {
            String string3;
            int n6;
            for (n6 = n2 + 2; n6 < n4 && stringBuilder.charAt(n6) == ' '; ++n6) {
            }
            String string4 = stringBuilder.substring(n6);
            try {
                string3 = new String(Base64.decode(string4), "UTF-8");
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "readChangeType", exception));
                int n7 = 5439499;
                String string5 = MessageHandler.getMessage(n7, this.lastEntryLineNumber, stringBuilder, String.valueOf(exception));
                this.logToRejectWriter(linkedList, string5);
                throw new LDIFException(n7, string5, this.lastEntryLineNumber, true, exception);
            }
            return string3;
        }
        for (n = n2 + 1; n < n4 && stringBuilder.charAt(n) == ' '; ++n) {
        }
        String string6 = stringBuilder.substring(n);
        return string6;
    }

    private void readAttribute(LinkedList<StringBuilder> linkedList, StringBuilder stringBuilder, DN dN, HashMap<ObjectClass, String> hashMap, HashMap<AttributeType, List<Attribute>> hashMap2, HashMap<AttributeType, List<Attribute>> hashMap3) throws LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "readAttribute", String.valueOf(stringBuilder), String.valueOf(dN), String.valueOf(hashMap), String.valueOf(hashMap2), String.valueOf(hashMap3)));
        int n = this.parseColonPosition(linkedList, stringBuilder);
        String string = stringBuilder.substring(0, n);
        Attribute attribute = LDIFReader.parseAttrDescription(string);
        String string2 = attribute.getName();
        String string3 = StaticUtils.toLowerCase(string2);
        LinkedHashSet<String> linkedHashSet = attribute.getOptions();
        ASN1OctetString aSN1OctetString = this.parseSingleValue(linkedList, stringBuilder, dN, n, string2);
        if (string3.equals("objectclass")) {
            if (!this.importConfig.includeObjectClasses()) {
                assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_READ, DebugLogSeverity.VERBOSE, CLASS_NAME, "readAttribute", "Skipping objectclass " + String.valueOf(aSN1OctetString) + " for entry " + String.valueOf(dN) + " due to the import configuration."));
                return;
            }
            String string4 = aSN1OctetString.stringValue();
            String string5 = StaticUtils.toLowerCase(string4);
            ObjectClass objectClass = DirectoryServer.getObjectClass(string5);
            if (objectClass == null) {
                objectClass = DirectoryServer.getDefaultObjectClass(string4);
            }
            if (hashMap.containsKey(objectClass)) {
                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_WARNING, 5308429, String.valueOf(dN), this.lastEntryLineNumber, string4);
            } else {
                hashMap.put(objectClass, string4);
            }
        } else {
            List<Attribute> list;
            AttributeType attributeType = DirectoryServer.getAttributeType(string3);
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType(string2);
            }
            if (!this.importConfig.includeAttribute(attributeType)) {
                assert (Debug.debugMessage(DebugLogCategory.PROTOCOL_READ, DebugLogSeverity.VERBOSE, CLASS_NAME, "readAttribute", "Skipping attribute " + String.valueOf(string2) + " for entry " + String.valueOf(dN) + " due to the import configuration."));
                return;
            }
            AttributeValue attributeValue = new AttributeValue(attributeType, (ByteString)aSN1OctetString);
            if (attributeType.isOperational()) {
                list = hashMap3.get(attributeType);
                if (list == null) {
                    LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>();
                    linkedHashSet2.add(attributeValue);
                    list = new ArrayList<Attribute>();
                    list.add(new Attribute(attributeType, string2, linkedHashSet, linkedHashSet2));
                    hashMap3.put(attributeType, list);
                    return;
                }
            } else {
                list = hashMap2.get(attributeType);
                if (list == null) {
                    LinkedHashSet<AttributeValue> linkedHashSet3 = new LinkedHashSet<AttributeValue>();
                    linkedHashSet3.add(attributeValue);
                    list = new ArrayList<Attribute>();
                    list.add(new Attribute(attributeType, string2, linkedHashSet, linkedHashSet3));
                    hashMap2.put(attributeType, list);
                    return;
                }
            }
            for (Attribute attribute2 : list) {
                if (!attribute2.optionsEqual(linkedHashSet)) continue;
                LinkedHashSet<AttributeValue> linkedHashSet4 = attribute2.getValues();
                if (linkedHashSet4.contains(attributeValue)) {
                    int n2 = 5308430;
                    String string6 = MessageHandler.getMessage(n2, String.valueOf(dN), this.lastEntryLineNumber, string2, aSN1OctetString.stringValue());
                    this.logToRejectWriter(linkedList, string6);
                    throw new LDIFException(n2, string6, this.lastEntryLineNumber, true);
                }
                if (attributeType.isSingleValue() && !linkedHashSet4.isEmpty()) {
                    int n3 = 5439503;
                    String string7 = MessageHandler.getMessage(n3, String.valueOf(dN), this.lastEntryLineNumber, string2);
                    this.logToRejectWriter(linkedList, string7);
                    throw new LDIFException(n3, string7, this.lastEntryLineNumber, true);
                }
                linkedHashSet4.add(attributeValue);
                return;
            }
            LinkedHashSet linkedHashSet5 = new LinkedHashSet();
            linkedHashSet5.add(attributeValue);
            list.add(new Attribute(attributeType, string2, linkedHashSet, linkedHashSet5));
            return;
        }
    }

    private Attribute readSingleValueAttribute(LinkedList<StringBuilder> linkedList, StringBuilder stringBuilder, DN dN, String string) throws LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "readSingleValueAttribute", String.valueOf(linkedList), String.valueOf(stringBuilder), String.valueOf(dN), String.valueOf(string)));
        int n = this.parseColonPosition(linkedList, stringBuilder);
        String string2 = stringBuilder.substring(0, n);
        Attribute attribute = LDIFReader.parseAttrDescription(string2);
        String string3 = attribute.getName();
        String string4 = StaticUtils.toLowerCase(string3);
        if (string != null && !StaticUtils.toLowerCase(string).equals(string4)) {
            int n2 = 5505052;
            String string5 = MessageHandler.getMessage(n2, string4, string);
            throw new LDIFException(n2, string5, this.lastEntryLineNumber, false);
        }
        ASN1OctetString aSN1OctetString = this.parseSingleValue(linkedList, stringBuilder, dN, n, string3);
        AttributeType attributeType = attribute.getAttributeType();
        AttributeValue attributeValue = new AttributeValue(attributeType, (ByteString)aSN1OctetString);
        attribute.getValues().add(attributeValue);
        return attribute;
    }

    public long getLastEntryLineNumber() {
        assert (Debug.debugEnter(CLASS_NAME, "getLastEntryLineNumber", new String[0]));
        return this.lastEntryLineNumber;
    }

    public void rejectLastEntry(String string) {
        block7: {
            assert (Debug.debugEnter(CLASS_NAME, "rejectLastEntry", String.valueOf(string)));
            ++this.entriesRejected;
            BufferedWriter bufferedWriter = this.importConfig.getRejectWriter();
            if (bufferedWriter != null) {
                try {
                    if (string != null && string.length() > 0) {
                        bufferedWriter.write("# ");
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                    for (StringBuilder stringBuilder : this.lastEntryHeaderLines) {
                        bufferedWriter.write(stringBuilder.toString());
                        bufferedWriter.newLine();
                    }
                    for (StringBuilder stringBuilder : this.lastEntryBodyLines) {
                        bufferedWriter.write(stringBuilder.toString());
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.newLine();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "rejectLastEntry", exception)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    public void close() {
        assert (Debug.debugEnter(CLASS_NAME, "close", new String[0]));
        this.importConfig.close();
    }

    private static Attribute parseAttrDescription(String string) {
        LinkedHashSet<String> linkedHashSet;
        String string2;
        assert (Debug.debugEnter(CLASS_NAME, "parseAttributeDescription", String.valueOf(string)));
        int n = string.indexOf(59);
        if (n > 0) {
            String string3;
            string2 = string.substring(0, n);
            linkedHashSet = new LinkedHashSet<String>();
            int n2 = string.indexOf(59, n + 1);
            while (n2 > 0) {
                string3 = string.substring(n + 1, n2);
                if (string3.length() <= 0) continue;
                linkedHashSet.add(string3);
                n = n2;
                n2 = string.indexOf(59, n + 1);
            }
            string3 = string.substring(n + 1);
            if (string3.length() > 0) {
                linkedHashSet.add(string3);
            }
        } else {
            string2 = string;
            linkedHashSet = null;
        }
        String string4 = StaticUtils.toLowerCase(string2);
        AttributeType attributeType = DirectoryServer.getAttributeType(string4);
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string2);
        }
        return new Attribute(attributeType, string2, linkedHashSet, null);
    }

    public long getEntriesRead() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntriesRead", new String[0]));
        return this.entriesRead;
    }

    public long getEntriesIgnored() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntriesIgnored", new String[0]));
        return this.entriesIgnored;
    }

    public long getEntriesRejected() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntriesRejected", new String[0]));
        return this.entriesRejected;
    }

    private ChangeRecordEntry parseModifyDNChangeRecordEntry(DN dN, LinkedList<StringBuilder> linkedList) throws LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "parseModifyDNChangeRecordEntry", String.valueOf(dN), String.valueOf(linkedList), String.valueOf(this.lineNumber)));
        DN dN2 = null;
        RDN rDN = null;
        boolean bl = false;
        if (linkedList.isEmpty()) {
            int n = 5505049;
            String string = MessageHandler.getMessage(n);
            throw new LDIFException(n, string, this.lineNumber, true);
        }
        StringBuilder stringBuilder = linkedList.remove();
        String string = this.getModifyDNAttributeValue(linkedList, stringBuilder, dN, "newrdn");
        try {
            rDN = RDN.decode(string);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "parse", directoryException));
            int n = 5439497;
            String string2 = MessageHandler.getMessage(n, this.lineNumber, stringBuilder.toString(), directoryException.getErrorMessage());
            throw new LDIFException(n, string2, this.lineNumber, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "parse", exception));
            int n = 5439497;
            String string3 = MessageHandler.getMessage(n, this.lineNumber, stringBuilder.toString(), exception.getMessage());
            throw new LDIFException(n, string3, this.lineNumber, true);
        }
        if (linkedList.isEmpty()) {
            int n = 5505050;
            String string4 = MessageHandler.getMessage(n);
            throw new LDIFException(n, string4, this.lineNumber, true);
        }
        ++this.lineNumber;
        stringBuilder = linkedList.remove();
        String string5 = this.getModifyDNAttributeValue(linkedList, stringBuilder, dN, "deleteoldrdn");
        if (string5.equalsIgnoreCase("false") || string5.equalsIgnoreCase("no") || string5.equalsIgnoreCase("0")) {
            bl = false;
        } else if (string5.equalsIgnoreCase("true") || string5.equalsIgnoreCase("yes") || string5.equalsIgnoreCase("1")) {
            bl = true;
        } else {
            int n = 5505051;
            String string6 = MessageHandler.getMessage(n, string5);
            throw new LDIFException(n, string6, this.lineNumber, true);
        }
        if (!linkedList.isEmpty()) {
            ++this.lineNumber;
            stringBuilder = linkedList.remove();
            String string7 = this.getModifyDNAttributeValue(linkedList, stringBuilder, dN, "newsuperior");
            try {
                dN2 = DN.decode(string7);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "parse", directoryException));
                int n = 5439497;
                String string8 = MessageHandler.getMessage(n, this.lineNumber, stringBuilder.toString(), directoryException.getErrorMessage());
                throw new LDIFException(n, string8, this.lineNumber, true);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "parse", exception));
                int n = 5439497;
                String string9 = MessageHandler.getMessage(n, this.lineNumber, stringBuilder.toString(), exception.getMessage());
                throw new LDIFException(n, string9, this.lineNumber, true);
            }
        }
        return new ModifyDNChangeRecordEntry(dN, rDN, bl, dN2);
    }

    private String getModifyDNAttributeValue(LinkedList<StringBuilder> linkedList, StringBuilder stringBuilder, DN dN, String string) throws LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "getModifyDNAttributeValue", String.valueOf(linkedList), String.valueOf(stringBuilder), String.valueOf(dN), String.valueOf(string)));
        Attribute attribute = this.readSingleValueAttribute(linkedList, stringBuilder, dN, string);
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        Object[] objectArray = linkedHashSet.toArray();
        return ((AttributeValue)objectArray[0]).getStringValue();
    }

    private ChangeRecordEntry parseModifyChangeRecordEntry(DN dN, LinkedList<StringBuilder> linkedList) throws LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "parseModifyChangeRecordEntry", String.valueOf(dN), String.valueOf(linkedList), String.valueOf(this.lineNumber)));
        ArrayList<LDAPModification> arrayList = new ArrayList<LDAPModification>();
        while (!linkedList.isEmpty()) {
            Object object;
            ModificationType modificationType = null;
            StringBuilder stringBuilder = linkedList.remove();
            Attribute attribute = this.readSingleValueAttribute(linkedList, stringBuilder, dN, null);
            String string = attribute.getName();
            LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
            String string2 = ((AttributeValue)linkedHashSet.iterator().next()).getStringValue();
            String string3 = StaticUtils.toLowerCase(string);
            if (string3.equals("add")) {
                modificationType = ModificationType.ADD;
            } else if (string3.equals("delete")) {
                modificationType = ModificationType.DELETE;
            } else if (string3.equals("replace")) {
                modificationType = ModificationType.REPLACE;
            } else if (string3.equals("increment")) {
                modificationType = ModificationType.INCREMENT;
            } else {
                int n = 5505053;
                object = MessageHandler.getMessage(n, string, "add, delete, replace, increment");
                throw new LDIFException(n, (String)object, this.lineNumber, true);
            }
            Attribute attribute2 = LDIFReader.parseAttrDescription(string2);
            while (!linkedList.isEmpty() && !(stringBuilder = linkedList.remove()).toString().equals("-")) {
                object = this.readSingleValueAttribute(linkedList, stringBuilder, dN, string2);
                attribute2.getValues().addAll(((Attribute)object).getValues());
            }
            object = new LDAPAttribute(attribute2);
            LDAPModification lDAPModification = new LDAPModification(modificationType, (LDAPAttribute)object);
            arrayList.add(lDAPModification);
        }
        return new ModifyChangeRecordEntry(dN, arrayList);
    }

    private ChangeRecordEntry parseDeleteChangeRecordEntry(DN dN, LinkedList<StringBuilder> linkedList) throws LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "parseDeleteChangeRecordEntry", String.valueOf(dN), String.valueOf(linkedList), String.valueOf(this.lineNumber)));
        if (!linkedList.isEmpty()) {
            int n = 5505048;
            String string = MessageHandler.getMessage(n);
            throw new LDIFException(n, string, this.lineNumber, true);
        }
        return new DeleteChangeRecordEntry(dN);
    }

    private ChangeRecordEntry parseAddChangeRecordEntry(DN dN, LinkedList<StringBuilder> linkedList) throws LDIFException {
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "parseAddChangeRecordEntry", String.valueOf(dN), String.valueOf(linkedList), String.valueOf(this.lineNumber)));
        HashMap<ObjectClass, String> hashMap = new HashMap<ObjectClass, String>();
        HashMap<AttributeType, List<Attribute>> hashMap2 = new HashMap<AttributeType, List<Attribute>>();
        for (StringBuilder serializable2 : linkedList) {
            this.readAttribute(linkedList, serializable2, dN, hashMap, hashMap2, hashMap2);
        }
        AttributeType attributeType = DirectoryServer.getObjectClassAttributeType();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(hashMap.size());
        for (Object object2 : hashMap.values()) {
            AttributeValue attributeValue = new AttributeValue(attributeType, (String)object2);
            linkedHashSet.add(attributeValue);
        }
        Attribute attribute = new Attribute(attributeType, "objectClass", linkedHashSet);
        object2 = new ArrayList(1);
        object2.add(attribute);
        hashMap2.put(attributeType, (List<Attribute>)object2);
        return new AddChangeRecordEntry(dN, hashMap2);
    }

    private int parseColonPosition(LinkedList<StringBuilder> linkedList, StringBuilder stringBuilder) throws LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "parseColonPosition", String.valueOf(linkedList), String.valueOf(this.lineNumber)));
        int n = stringBuilder.indexOf(":");
        if (n <= 0) {
            int n2 = 5439494;
            String string = MessageHandler.getMessage(n2, this.lastEntryLineNumber, stringBuilder.toString());
            this.logToRejectWriter(linkedList, string);
            throw new LDIFException(n2, string, this.lastEntryLineNumber, true);
        }
        return n;
    }

    private ASN1OctetString parseSingleValue(LinkedList<StringBuilder> linkedList, StringBuilder stringBuilder, DN dN, int n, String string) throws LDIFException {
        ASN1OctetString aSN1OctetString;
        assert (Debug.debugEnter(CLASS_NAME, "parseSingleValue", String.valueOf(linkedList), String.valueOf(stringBuilder), String.valueOf(dN), String.valueOf(n), String.valueOf(string)));
        int n2 = stringBuilder.length();
        if (n == n2 - 1) {
            aSN1OctetString = new ASN1OctetString();
        } else {
            int n3;
            char c = stringBuilder.charAt(n + 1);
            if (c == ':') {
                int n4;
                for (n4 = n + 2; n4 < n2 && stringBuilder.charAt(n4) == ' '; ++n4) {
                }
                try {
                    aSN1OctetString = new ASN1OctetString(Base64.decode(stringBuilder.substring(n4)));
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "readAttribute", exception));
                    int n5 = 5439500;
                    String string2 = MessageHandler.getMessage(n5, String.valueOf(dN), this.lastEntryLineNumber, stringBuilder, String.valueOf(exception));
                    this.logToRejectWriter(linkedList, string2);
                    throw new LDIFException(n5, string2, this.lastEntryLineNumber, true, exception);
                }
            }
            if (c == '<') {
                URL uRL;
                int n6;
                for (n6 = n + 2; n6 < n2 && stringBuilder.charAt(n6) == ' '; ++n6) {
                }
                try {
                    uRL = new URL(stringBuilder.substring(n6));
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "readAttribute", exception));
                    int n7 = 5439507;
                    String string3 = MessageHandler.getMessage(n7, String.valueOf(dN), this.lastEntryLineNumber, String.valueOf(string), String.valueOf(exception));
                    this.logToRejectWriter(linkedList, string3);
                    throw new LDIFException(n7, string3, this.lastEntryLineNumber, true, exception);
                }
                InputStream inputStream = null;
                ByteArrayOutputStream byteArrayOutputStream = null;
                try {
                    int n8;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    inputStream = uRL.openConnection().getInputStream();
                    while ((n8 = inputStream.read(this.buffer)) > 0) {
                        byteArrayOutputStream.write(this.buffer, 0, n8);
                    }
                    aSN1OctetString = new ASN1OctetString(byteArrayOutputStream.toByteArray());
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "readAttribute", exception));
                    int n9 = 5439508;
                    String string4 = MessageHandler.getMessage(n9, String.valueOf(dN), this.lastEntryLineNumber, String.valueOf(string), String.valueOf(uRL), String.valueOf(exception));
                    this.logToRejectWriter(linkedList, string4);
                    throw new LDIFException(n9, string4, this.lastEntryLineNumber, true, exception);
                }
                finally {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            for (n3 = n + 1; n3 < n2 && stringBuilder.charAt(n3) == ' '; ++n3) {
            }
            aSN1OctetString = new ASN1OctetString(stringBuilder.substring(n3));
        }
        return aSN1OctetString;
    }

    private void logToRejectWriter(LinkedList<StringBuilder> linkedList, String string) {
        block5: {
            assert (Debug.debugEnter(CLASS_NAME, "logToRejectWriter", String.valueOf(linkedList), String.valueOf(string)));
            BufferedWriter bufferedWriter = this.importConfig.getRejectWriter();
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.write("# ");
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                    for (StringBuilder stringBuilder : linkedList) {
                        bufferedWriter.write(stringBuilder.toString());
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.newLine();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "logToRejectWriter", exception)) break block5;
                    throw new AssertionError();
                }
            }
        }
    }
}

