/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opends.server.loggers.Debug;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.util.ChangeOperationType;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddChangeRecordEntry
extends ChangeRecordEntry {
    private static final String CLASS_NAME = "org.opends.server.util.AddChangeRecordEntry";
    private final List<Attribute> attributes;

    public AddChangeRecordEntry(DN dN, Map<AttributeType, List<Attribute>> map) {
        super(dN);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(map)));
        Validator.ensureNotNull(map);
        this.attributes = new ArrayList<Attribute>(map.size());
        for (List<Attribute> list : map.values()) {
            for (Attribute attribute : list) {
                this.attributes.add(attribute);
            }
        }
    }

    @Override
    public ChangeOperationType getChangeOperationType() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeOperationType", new String[0]));
        return ChangeOperationType.ADD;
    }

    public List<Attribute> getAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", new String[0]));
        return Collections.unmodifiableList(this.attributes);
    }
}

