/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RDN
implements Comparable<RDN> {
    private static final String CLASS_NAME = "org.opends.server.types.RDN";
    private final AttributeType[] attributeTypes;
    private final String[] attributeNames;
    private final AttributeValue[] attributeValues;
    private String normalizedRDN;

    public static RDN create(AttributeType attributeType, AttributeValue attributeValue) {
        return RDN.create(attributeType, attributeType.getNameOrOID(), attributeValue);
    }

    public static RDN create(AttributeType attributeType, String string, AttributeValue attributeValue) {
        Validator.ensureNotNull(attributeType, string, attributeValue);
        AttributeType[] attributeTypeArray = new AttributeType[]{attributeType};
        String[] stringArray = new String[]{string};
        AttributeValue[] attributeValueArray = new AttributeValue[]{attributeValue};
        return new RDN(attributeTypeArray, stringArray, attributeValueArray);
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    private RDN(AttributeType[] attributeTypeArray, String[] stringArray, AttributeValue[] attributeValueArray) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeTypeArray), String.valueOf(stringArray), String.valueOf(attributeValueArray)));
        this.attributeTypes = attributeTypeArray;
        this.attributeNames = stringArray;
        this.attributeValues = attributeValueArray;
    }

    public int getNumValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getNumValues", new String[0]));
        return this.attributeTypes.length;
    }

    public AttributeType getAttributeType(int n) throws IndexOutOfBoundsException {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", new String[0]));
        if (n < 0 || n >= this.attributeTypes.length) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.attributeTypes.length);
        }
        return this.attributeTypes[n];
    }

    public String getAttributeName(int n) throws IndexOutOfBoundsException {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeName", new String[0]));
        if (n < 0 || n >= this.attributeTypes.length) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.attributeTypes.length);
        }
        return this.attributeNames[n];
    }

    public AttributeValue getAttributeValue(int n) throws IndexOutOfBoundsException {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeValue", new String[0]));
        if (n < 0 || n >= this.attributeTypes.length) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.attributeTypes.length);
        }
        return this.attributeValues[n];
    }

    public boolean hasAttributeType(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAttributeType", String.valueOf(attributeType)));
        Validator.ensureNotNull(attributeType);
        for (AttributeType attributeType2 : this.attributeTypes) {
            if (!attributeType2.equals(attributeType)) continue;
            return true;
        }
        return false;
    }

    public AttributeValue getAttributeValue(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeValue", String.valueOf(attributeType)));
        Validator.ensureNotNull(attributeType);
        for (int i = 0; i < this.attributeTypes.length; ++i) {
            if (!this.attributeTypes[i].equals(attributeType)) continue;
            return this.attributeValues[i];
        }
        return null;
    }

    public boolean isMultiValued() {
        assert (Debug.debugEnter(CLASS_NAME, "isMultiValued", new String[0]));
        return this.attributeTypes.length > 1;
    }

    public static RDN valueOf(String string) throws DirectoryException {
        return RDN.decode(string);
    }

    public static RDN decode(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(byteString)));
        Validator.ensureNotNull(byteString);
        return RDN.decode(byteString.stringValue());
    }

    public static RDN decode(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(string)));
        Validator.ensureNotNull(string);
        Builder builder = RDN.createBuilder();
        int n = builder.parse(string, 0, false);
        if (n != -1) {
            int n2 = 196782;
            String string2 = MessageHandler.getMessage(n2, string, n);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n2);
        }
        return builder.getInstance();
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (this == object) {
            return true;
        }
        if (object instanceof RDN) {
            RDN rDN = (RDN)object;
            String string = this.toNormalizedString();
            String string2 = rDN.toNormalizedString();
            return string.equals(string2);
        }
        return false;
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.toNormalizedString().hashCode();
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        Validator.ensureNotNull(stringBuilder);
        stringBuilder.append(this.attributeNames[0]);
        stringBuilder.append("=");
        String string = this.attributeValues[0].getStringValue();
        this.quoteAttributeValue(stringBuilder, string);
        for (int i = 1; i < this.attributeTypes.length; ++i) {
            stringBuilder.append("+");
            stringBuilder.append(this.attributeNames[i]);
            stringBuilder.append("=");
            string = this.attributeValues[i].getStringValue();
            this.quoteAttributeValue(stringBuilder, string);
        }
    }

    public String toNormalizedString() {
        if (this.normalizedRDN == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.attributeNames.length == 1) {
                this.appendNormalizedAVA(stringBuilder, this.attributeTypes[0], this.attributeValues[0]);
            } else {
                int n;
                TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
                for (n = 0; n < this.attributeTypes.length; ++n) {
                    treeMap.put(this.attributeTypes[n].getNameOrOID(), n);
                }
                n = 1;
                for (Integer n2 : treeMap.values()) {
                    if (n == 0) {
                        stringBuilder.append('+');
                    } else {
                        n = 0;
                    }
                    this.appendNormalizedAVA(stringBuilder, this.attributeTypes[n2], this.attributeValues[n2]);
                }
            }
            this.normalizedRDN = stringBuilder.toString();
        }
        return this.normalizedRDN;
    }

    public void toNormalizedString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toNormalizedString", "java.lang.StringBuilder"));
        Validator.ensureNotNull(stringBuilder);
        stringBuilder.append(this.toNormalizedString());
    }

    @Override
    public int compareTo(RDN rDN) {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "compareTo", String.valueOf(rDN)));
        Validator.ensureNotNull(rDN);
        if (this.attributeTypes.length == 1 && rDN.attributeTypes.length == 1) {
            AttributeType attributeType = this.attributeTypes[0];
            AttributeType attributeType2 = rDN.attributeTypes[0];
            AttributeValue attributeValue = this.attributeValues[0];
            AttributeValue attributeValue2 = rDN.attributeValues[0];
            return this.compareAVA(attributeType, attributeValue, attributeType2, attributeValue2);
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        TreeMap<String, Integer> treeMap2 = new TreeMap<String, Integer>();
        for (n = 0; n < this.attributeTypes.length; ++n) {
            treeMap.put(this.attributeTypes[n].getNameOrOID(), n);
        }
        for (n = 0; n < rDN.attributeTypes.length; ++n) {
            treeMap2.put(rDN.attributeTypes[n].getNameOrOID(), n);
        }
        Iterator iterator = treeMap.values().iterator();
        Iterator iterator2 = treeMap2.values().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            AttributeValue attributeValue;
            int n2;
            AttributeType attributeType;
            AttributeValue attributeValue3;
            int n3 = (Integer)iterator.next();
            AttributeType attributeType3 = this.attributeTypes[n3];
            int n4 = this.compareAVA(attributeType3, attributeValue3 = this.attributeValues[n3], attributeType = rDN.attributeTypes[n2 = ((Integer)iterator2.next()).intValue()], attributeValue = rDN.attributeValues[n2]);
            if (n4 == 0) continue;
            return n4;
        }
        if (!iterator.hasNext() && !iterator2.hasNext()) {
            return 0;
        }
        if (!iterator.hasNext()) {
            return -1;
        }
        return 1;
    }

    private int compareAVA(AttributeType attributeType, AttributeValue attributeValue, AttributeType attributeType2, AttributeValue attributeValue2) {
        if (attributeType.equals(attributeType2)) {
            OrderingMatchingRule orderingMatchingRule = attributeType.getOrderingMatchingRule();
            try {
                if (orderingMatchingRule != null) {
                    byte[] byArray = attributeValue.getNormalizedValueBytes();
                    byte[] byArray2 = attributeValue2.getNormalizedValueBytes();
                    return orderingMatchingRule.compare(byArray, byArray2);
                }
                byte[] byArray = attributeValue.getNormalizedValue().value();
                byte[] byArray3 = attributeValue2.getNormalizedValue().value();
                return StaticUtils.compare(byArray, byArray3);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "compareAVA", exception));
                byte[] byArray = attributeValue.getValue().value();
                byte[] byArray4 = attributeValue2.getValue().value();
                return StaticUtils.compare(byArray, byArray4);
            }
        }
        String string = StaticUtils.toLowerCase(attributeType.getNameOrOID());
        String string2 = StaticUtils.toLowerCase(attributeType2.getNameOrOID());
        return string.compareTo(string2);
    }

    private void appendNormalizedAVA(StringBuilder stringBuilder, AttributeType attributeType, AttributeValue attributeValue) {
        StaticUtils.toLowerCase(attributeType.getNameOrOID(), stringBuilder);
        stringBuilder.append('=');
        try {
            this.quoteAttributeValue(stringBuilder, attributeValue.getNormalizedStringValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "toNormalizedString", exception));
            this.quoteAttributeValue(stringBuilder, attributeValue.getStringValue());
        }
    }

    private void quoteAttributeValue(StringBuilder stringBuilder, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "quoteAttributeValue", String.valueOf(string)));
        int n = string.length();
        if (n == 0) {
            return;
        }
        stringBuilder.ensureCapacity(stringBuilder.length() + n);
        char c = string.charAt(0);
        if (c == ' ' || c == '#') {
            stringBuilder.append('\\');
            stringBuilder.append(c);
        } else {
            this.quoteChar(stringBuilder, c);
        }
        for (int i = 1; i < n - 1; ++i) {
            this.quoteChar(stringBuilder, string.charAt(i));
        }
        if (n > 1) {
            c = string.charAt(n - 1);
            if (c == ' ') {
                stringBuilder.append('\\');
                stringBuilder.append(c);
            } else {
                this.quoteChar(stringBuilder, c);
            }
        }
    }

    private void quoteChar(StringBuilder stringBuilder, char c) {
        if (c < ' ' || c > '~') {
            for (byte by : StaticUtils.getBytes(String.valueOf(c))) {
                stringBuilder.append('\\');
                stringBuilder.append(StaticUtils.byteToLowerHex(by));
            }
        } else {
            switch (c) {
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': 
                case '\\': {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c);
        }
    }

    private static int parseAttributeName(String string, int n, StringBuilder stringBuilder) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "parseAttributeName", String.valueOf(string), String.valueOf(n), "java.lang.StringBuilder"));
        boolean bl = DirectoryServer.allowAttributeNameExceptions();
        int n2 = string.length();
        if (n < n2) {
            while (string.charAt(n) == ' ') {
                if (++n != n2) continue;
                int n3 = 6488090;
                String string2 = MessageHandler.getMessage(n3, string);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n3);
            }
        }
        boolean bl2 = false;
        boolean bl3 = false;
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case ' ': {
                    bl3 = true;
                    break;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': {
                    int n11 = 6488092;
                    String string10 = MessageHandler.getMessage(n11, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string10, n11);
                }
                case '-': {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(c);
                        break;
                    }
                    int n12 = 6488094;
                    String string11 = MessageHandler.getMessage(n12, string, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string11, n12);
                }
                case '.': {
                    stringBuilder.append(c);
                    bl2 = true;
                    break;
                }
                case '/': {
                    int n13 = 6488092;
                    String string12 = MessageHandler.getMessage(n13, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string12, n13);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    stringBuilder.append(c);
                    break;
                }
                case ':': 
                case ';': 
                case '<': {
                    int string13 = 6488092;
                    String n15 = MessageHandler.getMessage(string13, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, n15, string13);
                }
                case '=': {
                    bl3 = true;
                    break;
                }
                case '>': 
                case '?': 
                case '@': {
                    int n14 = 6488092;
                    String string2 = MessageHandler.getMessage(n14, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n14);
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    stringBuilder.append(c);
                    break;
                }
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    int string15 = 6488092;
                    String string3 = MessageHandler.getMessage(string15, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, string15);
                }
                case '_': {
                    if (stringBuilder.length() == 0) {
                        int n3 = 6488095;
                        String string4 = MessageHandler.getMessage(n3, string, "ds-cfg-allow-attribute-name-exceptions");
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string4, n3);
                    }
                    if (bl) {
                        stringBuilder.append(c);
                        break;
                    }
                    int n4 = 6488093;
                    String string5 = MessageHandler.getMessage(n4, string, "ds-cfg-allow-attribute-name-exceptions");
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string5, n4);
                }
                case '`': {
                    int n5 = 6488092;
                    String string6 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string6, n5);
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    stringBuilder.append(c);
                    break;
                }
                default: {
                    int n6 = 6488092;
                    String string7 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string7, n6);
                }
            }
            if (bl3) break;
            ++n;
        }
        if (stringBuilder.length() == 0) {
            int n7 = 6488097;
            String string8 = MessageHandler.getMessage(n7, string);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string8, n7);
        }
        if (bl2) {
            boolean bl4;
            boolean bl5;
            boolean bl6 = true;
            int n8 = 0;
            int n9 = stringBuilder.length();
            char c = stringBuilder.charAt(0);
            if (c == 'o' || c == 'O') {
                if (n9 <= 4) {
                    boolean bl7 = false;
                } else {
                    c = stringBuilder.charAt(1);
                    if (!(c != 'i' && c != 'I' || (c = stringBuilder.charAt(2)) != 'd' && c != 'D' || stringBuilder.charAt(3) != '.')) {
                        stringBuilder.delete(0, 4);
                        n9 -= 4;
                    } else {
                        boolean bl8 = false;
                    }
                }
            }
            while (bl5 && n8 < n9) {
                if (StaticUtils.isDigit(c = stringBuilder.charAt(n8++))) {
                    while (bl5 && n8 < n9 && StaticUtils.isDigit(stringBuilder.charAt(n8))) {
                        ++n8;
                    }
                    if (n8 >= n9 || stringBuilder.charAt(n8) == '.') continue;
                    bl5 = false;
                    continue;
                }
                if (c == '.') {
                    if (n8 != 1 && stringBuilder.charAt(n8 - 2) != '.') continue;
                    bl5 = false;
                    continue;
                }
                bl5 = false;
            }
            if (bl5 && stringBuilder.charAt(n9 - 1) == '.') {
                bl4 = false;
            }
            if (!bl4) {
                int n10 = 6488098;
                String string9 = MessageHandler.getMessage(n10, string, stringBuilder.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string9, n10);
            }
        } else if (StaticUtils.isDigit(stringBuilder.charAt(0)) && !bl) {
            int n11 = 6488096;
            String string10 = MessageHandler.getMessage(n11, string, Character.valueOf(stringBuilder.charAt(0)), "ds-cfg-allow-attribute-name-exceptions");
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string10, n11);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int parseAttributeValue(String string, int n, ByteString byteString) throws DirectoryException {
        int n2;
        boolean bl;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        char c;
        assert (Debug.debugEnter(CLASS_NAME, "parseAttributeValue", String.valueOf(string), String.valueOf(n), "java.lang.StringBuilder"));
        int n3 = string.length();
        if (n >= n3) {
            byteString.setValue("");
            return n;
        }
        if ((c = string.charAt(n++)) == '#') {
            int n4;
            StringBuilder stringBuilder3 = new StringBuilder();
            if (n + 2 > n3) {
                int n5 = 6488102;
                String string2 = MessageHandler.getMessage(n5, string);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n5);
            }
            for (n4 = 0; n4 < 2; ++n4) {
                if (!StaticUtils.isHexDigit(c = string.charAt(n++))) {
                    int n6 = 6488103;
                    String string3 = MessageHandler.getMessage(n6, string, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, n6);
                }
                stringBuilder3.append(c);
            }
            while (n < n3) {
                if (StaticUtils.isHexDigit(c = string.charAt(n++))) {
                    stringBuilder3.append(c);
                    if (n >= n3) {
                        n4 = 6488102;
                        String string4 = MessageHandler.getMessage(n4, string);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string4, n4);
                    }
                    if (!StaticUtils.isHexDigit(c = string.charAt(n++))) {
                        n4 = 6488103;
                        String string5 = MessageHandler.getMessage(n4, string, Character.valueOf(c));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string5, n4);
                    }
                    stringBuilder3.append(c);
                    continue;
                }
                if (c != ' ' && c != ',' && c != ';' && c != '+') {
                    n4 = 6488103;
                    String string6 = MessageHandler.getMessage(n4, string, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string6, n4);
                }
                --n;
                break;
            }
            try {
                byteString.setValue(StaticUtils.hexStringToByteArray(stringBuilder3.toString()));
                return n;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "parseAttributeValue", exception));
                int n7 = 6488104;
                String string7 = MessageHandler.getMessage(n7, string, String.valueOf(exception));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string7, n7);
            }
        }
        if (c != '\"') {
            stringBuilder2 = new StringBuilder();
            stringBuilder = new StringBuilder();
            if (c == '\\') {
                bl = true;
            } else {
                bl = false;
                stringBuilder2.append(c);
            }
        } else {
            boolean bl2 = false;
            StringBuilder stringBuilder4 = new StringBuilder();
            while (true) {
                if (n >= n3) {
                    int n8 = 6488105;
                    String string8 = MessageHandler.getMessage(n8, string);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string8, n8);
                }
                c = string.charAt(n++);
                if (bl2) {
                    stringBuilder4.append(c);
                    bl2 = false;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c == '\"') {
                    byteString.setValue(stringBuilder4.toString());
                    return n;
                }
                stringBuilder4.append(c);
            }
        }
        while (true) {
            if (n >= n3) {
                RDN.appendHexChars(string, stringBuilder2, stringBuilder);
                break;
            }
            c = string.charAt(n++);
            if (bl) {
                if (StaticUtils.isHexDigit(c)) {
                    if (n >= n3) {
                        n2 = 6488106;
                        String string9 = MessageHandler.getMessage(n2, string);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string9, n2);
                    }
                    if (!StaticUtils.isHexDigit((char)(n2 = (int)string.charAt(n++)))) {
                        int n9 = 6488106;
                        String string10 = MessageHandler.getMessage(n9, string);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string10, n9);
                    }
                    stringBuilder.append(c);
                    stringBuilder.append((char)n2);
                } else {
                    RDN.appendHexChars(string, stringBuilder2, stringBuilder);
                    stringBuilder2.append(c);
                }
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c == ',' || c == ';' || c == '+') {
                RDN.appendHexChars(string, stringBuilder2, stringBuilder);
                --n;
                break;
            }
            RDN.appendHexChars(string, stringBuilder2, stringBuilder);
            stringBuilder2.append(c);
        }
        if (n > 2 && string.charAt(n - 1) == ' ' && string.charAt(n - 2) != '\\') {
            for (n2 = stringBuilder2.length() - 1; n2 > 0 && stringBuilder2.charAt(n2) == ' '; --n2) {
                stringBuilder2.delete(n2, n2 + '\u0001');
            }
        }
        byteString.setValue(stringBuilder2.toString());
        return n;
    }

    private static void appendHexChars(String string, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws DirectoryException {
        try {
            byte[] byArray = StaticUtils.hexStringToByteArray(stringBuilder2.toString());
            stringBuilder.append(new String(byArray, "UTF-8"));
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "appendHexChars", exception));
            int n = 6488104;
            String string2 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n);
        }
    }

    public static final class Builder {
        private List<AttributeType> attributeTypes;
        private List<String> attributeNames;
        private List<AttributeValue> attributeValues;

        private Builder() {
            this.clear();
        }

        public void append(AttributeType attributeType, AttributeValue attributeValue) throws IllegalArgumentException {
            this.append(attributeType, attributeType.getNameOrOID(), attributeValue);
        }

        public void append(AttributeType attributeType, String string, AttributeValue attributeValue) throws IllegalArgumentException {
            Validator.ensureNotNull(attributeType, string, attributeValue);
            if (this.attributeTypes.contains(attributeType)) {
                throw new IllegalArgumentException("Builder already contains the attribute type " + attributeType.getNameOrOID());
            }
            this.attributeTypes.add(attributeType);
            this.attributeNames.add(string);
            this.attributeValues.add(attributeValue);
        }

        int parse(String string, int n, boolean bl) throws DirectoryException {
            assert (Debug.debugEnter(RDN.CLASS_NAME, "parse", String.valueOf(string), String.valueOf(n)));
            int n2 = this.attributeTypes.size();
            if ((n = this.parseAVA(string, n)) == -1 && !bl && n2 == this.attributeTypes.size()) {
                int n3 = 196779;
                String string2 = MessageHandler.getMessage(n3);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n3);
            }
            while (n != -1 && string.charAt(n) == '+') {
                n2 = this.attributeTypes.size();
                if ((n = this.parseAVA(string, n + 1)) != -1 || n2 != this.attributeTypes.size()) continue;
                int n4 = 196782;
                String string3 = MessageHandler.getMessage(n4, string, n);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, n4);
            }
            return n;
        }

        private int parseAVA(String string, int n) throws DirectoryException {
            char c;
            int n2 = string.length();
            while (n < n2 && (c = string.charAt(n)) == ' ') {
                ++n;
            }
            if (n >= n2) {
                return -1;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if ((n = RDN.parseAttributeName(string, n, stringBuilder)) >= n2) {
                int n3 = 6488099;
                String string2 = MessageHandler.getMessage(n3, string, stringBuilder.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string2, n3);
            }
            c = string.charAt(n);
            while (c == ' ') {
                if (++n >= n2) {
                    int n4 = 6488099;
                    String string3 = MessageHandler.getMessage(n4, string, stringBuilder.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string3, n4);
                }
                c = string.charAt(n);
            }
            if (c == '=') {
                ++n;
            } else {
                int n5 = 6488100;
                String string4 = MessageHandler.getMessage(n5, string, stringBuilder.toString(), Character.valueOf(c), n);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string4, n5);
            }
            while (n < n2 && (c = string.charAt(n)) == ' ') {
                ++n;
            }
            if (n >= n2) {
                String string5 = stringBuilder.toString();
                String string6 = StaticUtils.toLowerCase(string5);
                AttributeType attributeType = DirectoryServer.getAttributeType(string6);
                if (attributeType == null) {
                    attributeType = DirectoryServer.getDefaultAttributeType(string5);
                }
                AttributeValue attributeValue = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                this.append(attributeType, string5, attributeValue);
                return -1;
            }
            ASN1OctetString aSN1OctetString = new ASN1OctetString();
            n = RDN.parseAttributeValue(string, n, aSN1OctetString);
            String string7 = stringBuilder.toString();
            String string8 = StaticUtils.toLowerCase(string7);
            AttributeType attributeType = DirectoryServer.getAttributeType(string8);
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType(string7);
            }
            AttributeValue attributeValue = new AttributeValue(attributeType, (ByteString)aSN1OctetString);
            this.append(attributeType, string7, attributeValue);
            while (n < n2 && (c = string.charAt(n)) == ' ') {
                ++n;
            }
            if (n >= n2) {
                return -1;
            }
            if (c == ',' || c == ';') {
                return n;
            }
            if (c != '+') {
                int n6 = 6488101;
                String string9 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string9, n6);
            }
            return n;
        }

        public void clear() {
            this.attributeTypes = new ArrayList<AttributeType>(3);
            this.attributeValues = new ArrayList<AttributeValue>(3);
            this.attributeNames = new ArrayList<String>(3);
        }

        public boolean isEmpty() {
            return this.attributeTypes.isEmpty();
        }

        public RDN getInstance() throws IllegalStateException {
            int n = this.attributeTypes.size();
            if (n == 0) {
                throw new IllegalStateException("RDN builder is empty");
            }
            AttributeType[] attributeTypeArray = new AttributeType[n];
            String[] stringArray = new String[n];
            AttributeValue[] attributeValueArray = new AttributeValue[n];
            this.attributeTypes.toArray(attributeTypeArray);
            this.attributeNames.toArray(stringArray);
            this.attributeValues.toArray(attributeValueArray);
            return new RDN(attributeTypeArray, stringArray, attributeValueArray);
        }
    }
}

