/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.ObjectClassType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectClass
extends CommonSchemaElements {
    private static final String CLASS_NAME = "org.opends.server.types.ObjectClass";
    private final Set<AttributeType> optionalAttributes;
    private final Set<AttributeType> optionalAttributesChain;
    private final Set<AttributeType> requiredAttributes;
    private final Set<AttributeType> requiredAttributesChain;
    private final ObjectClass superiorClass;
    private final ObjectClassType objectClassType;
    private final boolean isExtensibleObject;

    public ObjectClass(String string, Collection<String> collection, String string2, String string3, ObjectClass objectClass, Set<AttributeType> set, Set<AttributeType> set2, ObjectClassType objectClassType, boolean bl, Map<String, List<String>> map) throws NullPointerException {
        super(string, collection, string2, string3, bl, map);
        HashSet<AttributeType> hashSet;
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(collection), String.valueOf(string2), String.valueOf(string3), String.valueOf(objectClass), String.valueOf(set), String.valueOf(set2), String.valueOf((Object)objectClassType), String.valueOf(bl), String.valueOf(map)));
        this.superiorClass = objectClass;
        this.isExtensibleObject = this.hasName("extensibleobject") || string2.equals("1.3.6.1.4.1.1466.101.120.111");
        this.requiredAttributes = set != null ? Collections.unmodifiableSet(new LinkedHashSet<AttributeType>(set)) : Collections.emptySet();
        if (this.superiorClass == null) {
            this.requiredAttributesChain = this.requiredAttributes;
        } else {
            hashSet = new HashSet<AttributeType>(this.requiredAttributes);
            hashSet.addAll(this.superiorClass.getRequiredAttributeChain());
            this.requiredAttributesChain = Collections.unmodifiableSet(hashSet);
        }
        this.optionalAttributes = set2 != null ? Collections.unmodifiableSet(new LinkedHashSet<AttributeType>(set2)) : Collections.emptySet();
        if (this.superiorClass == null) {
            this.optionalAttributesChain = this.optionalAttributes;
        } else {
            hashSet = new HashSet<AttributeType>(this.optionalAttributes);
            hashSet.addAll(this.superiorClass.getOptionalAttributeChain());
            this.optionalAttributesChain = Collections.unmodifiableSet(hashSet);
        }
        this.objectClassType = objectClassType != null ? objectClassType : ObjectClassType.STRUCTURAL;
    }

    public ObjectClass getSuperiorClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getSuperiorClass", new String[0]));
        return this.superiorClass;
    }

    public boolean isDescendantOf(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "isDescendantOf", String.valueOf(objectClass)));
        if (this.superiorClass == null) {
            return false;
        }
        return this.superiorClass.equals(objectClass) || this.superiorClass.isDescendantOf(objectClass);
    }

    public Set<AttributeType> getRequiredAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequiredAttributes", new String[0]));
        return this.requiredAttributes;
    }

    public Set<AttributeType> getRequiredAttributeChain() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequiredAttributeChain", new String[0]));
        return this.requiredAttributesChain;
    }

    public boolean isRequired(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequired", String.valueOf(attributeType)));
        return this.requiredAttributesChain.contains(attributeType);
    }

    public Set<AttributeType> getOptionalAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getOptionalAttributes", new String[0]));
        return this.optionalAttributes;
    }

    public Set<AttributeType> getOptionalAttributeChain() {
        assert (Debug.debugEnter(CLASS_NAME, "getOptionalAttributeChain", new String[0]));
        return this.optionalAttributesChain;
    }

    public boolean isOptional(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isOptional", String.valueOf(attributeType)));
        if (this.optionalAttributesChain.contains(attributeType)) {
            return true;
        }
        return this.isExtensibleObject && !this.requiredAttributesChain.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequiredOrOptional", String.valueOf(attributeType)));
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    public ObjectClassType getObjectClassType() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClassType", new String[0]));
        return this.objectClassType;
    }

    public boolean isExtensibleObject() {
        assert (Debug.debugEnter(CLASS_NAME, "isExtensibleObject", new String[0]));
        return this.isExtensibleObject;
    }

    @Override
    protected void toStringContent(StringBuilder stringBuilder) {
        String string;
        Iterator<AttributeType> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        if (this.superiorClass != null) {
            stringBuilder.append(" SUP ");
            stringBuilder.append(this.superiorClass.getNameOrOID());
        }
        if (this.objectClassType != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.objectClassType.toString());
        }
        if (!this.requiredAttributes.isEmpty()) {
            iterator = this.requiredAttributes.iterator();
            string = iterator.next().getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" MUST ( ");
                stringBuilder.append(string);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(iterator.next().getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" MUST ");
                stringBuilder.append(string);
            }
        }
        if (!this.optionalAttributes.isEmpty()) {
            iterator = this.optionalAttributes.iterator();
            string = iterator.next().getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" MAY ( ");
                stringBuilder.append(string);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(iterator.next().getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" MAY ");
                stringBuilder.append(string);
            }
        }
    }
}

