/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.api.MatchingRule;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleUse {
    private static final String CLASS_NAME = "org.opends.server.types.MatchingRuleUse";
    private boolean isObsolete;
    private ConcurrentHashMap<String, String> names;
    private CopyOnWriteArraySet<AttributeType> attributes;
    private ConcurrentHashMap<String, CopyOnWriteArrayList<String>> extraProperties;
    private MatchingRule matchingRule;
    private String description;
    private String schemaFile;

    public MatchingRuleUse(MatchingRule matchingRule, ConcurrentHashMap<String, String> concurrentHashMap, String string, boolean bl, CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet, ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(matchingRule), String.valueOf(concurrentHashMap), String.valueOf(string), String.valueOf(bl), String.valueOf(copyOnWriteArraySet), String.valueOf(concurrentHashMap2)));
        this.matchingRule = matchingRule;
        this.names = concurrentHashMap;
        this.description = string;
        this.isObsolete = bl;
        this.attributes = copyOnWriteArraySet;
        this.schemaFile = null;
        this.extraProperties = concurrentHashMap2;
    }

    public MatchingRule getMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRule", new String[0]));
        return this.matchingRule;
    }

    public void setMatchingRule(MatchingRule matchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchingRule", String.valueOf(matchingRule)));
        this.matchingRule = matchingRule;
    }

    public ConcurrentHashMap<String, String> getNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getNames", new String[0]));
        return this.names;
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        if (this.names.isEmpty()) {
            return null;
        }
        return this.names.values().iterator().next();
    }

    public boolean hasName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasName", String.valueOf(string)));
        return this.names.containsKey(string);
    }

    public void setNames(ConcurrentHashMap<String, String> concurrentHashMap) {
        assert (Debug.debugEnter(CLASS_NAME, "setNames", String.valueOf(concurrentHashMap)));
        this.names = concurrentHashMap;
    }

    public void addName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "addName", String.valueOf(string)));
        this.names.put(StaticUtils.toLowerCase(string), string);
    }

    public void removeName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "removeName", String.valueOf(string)));
        this.names.remove(string);
    }

    public String getSchemaFile() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaFile", new String[0]));
        return this.schemaFile;
    }

    public void setSchemaFile(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setSchemaFile", String.valueOf(string)));
        this.schemaFile = string;
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public void setDescription(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setDescription", String.valueOf(string)));
        this.description = string;
    }

    public boolean isObsolete() {
        assert (Debug.debugEnter(CLASS_NAME, "isObsolete", new String[0]));
        return this.isObsolete;
    }

    public void setObsolete(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setObsolete", String.valueOf(bl)));
        this.isObsolete = bl;
    }

    public CopyOnWriteArraySet<AttributeType> getAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", new String[0]));
        return this.attributes;
    }

    public boolean appliesToAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "appliesToAttribute", String.valueOf(attributeType)));
        return this.attributes.contains(attributeType);
    }

    public void setAttributes(CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttributes", String.valueOf(copyOnWriteArraySet)));
        this.attributes = copyOnWriteArraySet;
    }

    public void addAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addAttribute", String.valueOf(attributeType)));
        this.attributes.add(attributeType);
    }

    public void removeAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addAttribute", String.valueOf(attributeType)));
        this.attributes.remove(attributeType);
    }

    public ConcurrentHashMap<String, CopyOnWriteArrayList<String>> getExtraProperties() {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperties", new String[0]));
        return this.extraProperties;
    }

    public CopyOnWriteArrayList<String> getExtraProperty(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperty", String.valueOf(string)));
        return this.extraProperties.get(string);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MatchingRuleUse)) {
            return false;
        }
        return this.matchingRule.equals(((MatchingRuleUse)object).matchingRule);
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.matchingRule.hashCode();
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        String string;
        Iterator<Object> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(bl)));
        stringBuilder.append("( ");
        stringBuilder.append(this.matchingRule.getOID());
        if (!this.names.isEmpty()) {
            iterator = this.names.values().iterator();
            string = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(" NAME ( '");
                stringBuilder.append(string);
                while (iterator.hasNext()) {
                    stringBuilder.append("' '");
                    stringBuilder.append((String)iterator.next());
                }
                stringBuilder.append("' )");
            } else {
                stringBuilder.append(" NAME '");
                stringBuilder.append(string);
                stringBuilder.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            stringBuilder.append(" DESC '");
            stringBuilder.append(this.description);
            stringBuilder.append("'");
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        stringBuilder.append(" APPLIES ");
        iterator = this.attributes.iterator();
        string = ((AttributeType)iterator.next()).getNameOrOID();
        if (iterator.hasNext()) {
            stringBuilder.append("( ");
            stringBuilder.append(string);
            while (iterator.hasNext()) {
                stringBuilder.append(" $ ");
                stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
            }
            stringBuilder.append(" )");
        } else {
            stringBuilder.append(string);
        }
        if (!this.extraProperties.isEmpty()) {
            for (String string2 : this.extraProperties.keySet()) {
                CopyOnWriteArrayList<String> copyOnWriteArrayList = this.extraProperties.get(string2);
                stringBuilder.append(" ");
                stringBuilder.append(string2);
                if (copyOnWriteArrayList.size() == 1) {
                    stringBuilder.append(" '");
                    stringBuilder.append(copyOnWriteArrayList.get(0));
                    stringBuilder.append("'");
                    continue;
                }
                stringBuilder.append(" ( ");
                for (String string3 : copyOnWriteArrayList) {
                    stringBuilder.append("'");
                    stringBuilder.append(string3);
                    stringBuilder.append("' ");
                }
                stringBuilder.append(")");
            }
        }
        if (bl && this.schemaFile != null && !this.extraProperties.containsKey("X-SCHEMA-FILE")) {
            stringBuilder.append(" ");
            stringBuilder.append("X-SCHEMA-FILE");
            stringBuilder.append(" '");
            stringBuilder.append(this.schemaFile);
            stringBuilder.append("'");
        }
        stringBuilder.append(" )");
    }
}

