/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.SearchFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDIFExportConfig {
    private static final String CLASS_NAME = "org.opends.server.types.LDIFExportConfig";
    private boolean compressData;
    private boolean encryptData;
    private boolean hashData;
    private boolean includeObjectClasses;
    private boolean includeOperationalAttributes;
    private boolean invokeExportPlugins;
    private boolean signHash;
    private boolean typesOnly;
    private BufferedWriter writer;
    private ExistingFileBehavior existingFileBehavior;
    private int wrapColumn;
    private List<DN> excludeBranches;
    private List<DN> includeBranches;
    private List<SearchFilter> excludeFilters;
    private List<SearchFilter> includeFilters;
    private OutputStream ldifOutputStream;
    private Set<AttributeType> excludeAttributes;
    private Set<AttributeType> includeAttributes;
    private String ldifFile;

    public LDIFExportConfig(String string, ExistingFileBehavior existingFileBehavior) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf((Object)existingFileBehavior)));
        this.ldifFile = string;
        this.existingFileBehavior = existingFileBehavior;
        this.ldifOutputStream = null;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.compressData = false;
        this.encryptData = false;
        this.hashData = false;
        this.includeObjectClasses = true;
        this.includeOperationalAttributes = true;
        this.invokeExportPlugins = false;
        this.signHash = false;
        this.typesOnly = false;
        this.writer = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
        this.wrapColumn = -1;
    }

    public LDIFExportConfig(OutputStream outputStream) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(outputStream)));
        this.ldifOutputStream = outputStream;
        this.ldifFile = null;
        this.existingFileBehavior = ExistingFileBehavior.FAIL;
        this.excludeBranches = new ArrayList<DN>();
        this.includeBranches = new ArrayList<DN>();
        this.excludeFilters = new ArrayList<SearchFilter>();
        this.includeFilters = new ArrayList<SearchFilter>();
        this.compressData = false;
        this.encryptData = false;
        this.hashData = false;
        this.includeObjectClasses = true;
        this.includeOperationalAttributes = true;
        this.invokeExportPlugins = false;
        this.signHash = false;
        this.typesOnly = false;
        this.writer = null;
        this.excludeAttributes = new HashSet<AttributeType>();
        this.includeAttributes = new HashSet<AttributeType>();
        this.wrapColumn = -1;
    }

    public BufferedWriter getWriter() throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "getWriter", new String[0]));
        if (this.writer == null) {
            Object object;
            if (this.ldifOutputStream == null) {
                switch (this.existingFileBehavior) {
                    case APPEND: {
                        this.ldifOutputStream = new FileOutputStream(this.ldifFile, true);
                        break;
                    }
                    case OVERWRITE: {
                        this.ldifOutputStream = new FileOutputStream(this.ldifFile, false);
                        break;
                    }
                    case FAIL: {
                        object = new File(this.ldifFile);
                        if (((File)object).exists()) {
                            int n = 5505042;
                            String string = MessageHandler.getMessage(n, this.ldifFile);
                            throw new IOException(string);
                        }
                        this.ldifOutputStream = new FileOutputStream(this.ldifFile);
                    }
                }
            }
            object = this.compressData ? new GZIPOutputStream(this.ldifOutputStream) : this.ldifOutputStream;
            if (this.encryptData) {
                // empty if block
            }
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
        }
        return this.writer;
    }

    public boolean invokeExportPlugins() {
        assert (Debug.debugEnter(CLASS_NAME, "invokeExportPlugins", new String[0]));
        return this.invokeExportPlugins;
    }

    public void setInvokeExportPlugins(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setInvokeExportPlugins", String.valueOf(bl)));
        this.invokeExportPlugins = bl;
    }

    public boolean compressData() {
        assert (Debug.debugEnter(CLASS_NAME, "compressData", new String[0]));
        return this.compressData;
    }

    public void setCompressData(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setCompressData", String.valueOf(bl)));
        this.compressData = bl;
    }

    public boolean encryptData() {
        assert (Debug.debugEnter(CLASS_NAME, "encryptData", new String[0]));
        return this.encryptData;
    }

    public void setEncryptData(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setEncryptData", String.valueOf(bl)));
        this.encryptData = bl;
    }

    public boolean hashData() {
        assert (Debug.debugEnter(CLASS_NAME, "hashData", new String[0]));
        return this.hashData;
    }

    public void setHashData(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setHashData", String.valueOf(bl)));
        this.hashData = bl;
    }

    public boolean signHash() {
        assert (Debug.debugEnter(CLASS_NAME, "signHash", new String[0]));
        return this.signHash;
    }

    public void setSignHash(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setSignHash", String.valueOf(bl)));
        this.signHash = bl;
    }

    public boolean typesOnly() {
        assert (Debug.debugEnter(CLASS_NAME, "typesOnly", new String[0]));
        return this.typesOnly;
    }

    public void setTypesOnly(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setTypesOnly", String.valueOf(bl)));
        this.typesOnly = bl;
    }

    public int getWrapColumn() {
        assert (Debug.debugEnter(CLASS_NAME, "getWrapColumn", new String[0]));
        return this.wrapColumn;
    }

    public void setWrapColumn(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setWrapColumn", String.valueOf(n)));
        this.wrapColumn = n;
    }

    public List<DN> getExcludeBranches() {
        assert (Debug.debugEnter(CLASS_NAME, "getExcludeBranches", new String[0]));
        return this.excludeBranches;
    }

    public void setExcludeBranches(List<DN> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setExcludeBranches", String.valueOf(list)));
        this.excludeBranches = list == null ? new ArrayList<DN>(0) : list;
    }

    public List<DN> getIncludeBranches() {
        assert (Debug.debugEnter(CLASS_NAME, "getIncludeBranches", new String[0]));
        return this.includeBranches;
    }

    public void setIncludeBranches(List<DN> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setIncludeBranches", String.valueOf(list)));
        this.includeBranches = list == null ? new ArrayList<DN>(0) : list;
    }

    public boolean includeObjectClasses() {
        assert (Debug.debugEnter(CLASS_NAME, "includeObjectClasses", new String[0]));
        return this.includeObjectClasses;
    }

    public boolean includeOperationalAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "includeOperationalAttributes", new String[0]));
        return this.includeOperationalAttributes;
    }

    public Set<AttributeType> getExcludeAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getExcludeAttributes", new String[0]));
        return this.excludeAttributes;
    }

    public void setExcludeAttributes(Set<AttributeType> set) {
        assert (Debug.debugEnter(CLASS_NAME, "setExcludeAttributes", String.valueOf(set)));
        this.excludeAttributes = set == null ? new HashSet<AttributeType>(0) : set;
    }

    public Set<AttributeType> getIncludeAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getIncludeAttributes", new String[0]));
        return this.includeAttributes;
    }

    public void setIncludeAttributes(Set<AttributeType> set) {
        assert (Debug.debugEnter(CLASS_NAME, "setIncludeAttributes", String.valueOf(set)));
        this.includeAttributes = set == null ? new HashSet<AttributeType>(0) : set;
    }

    public boolean includeAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "includeAttribute", String.valueOf(attributeType)));
        if (!this.excludeAttributes.isEmpty() && this.excludeAttributes.contains(attributeType)) {
            return false;
        }
        if (!this.includeAttributes.isEmpty()) {
            return this.includeAttributes.contains(attributeType);
        }
        return true;
    }

    public List<SearchFilter> getExcludeFilters() {
        assert (Debug.debugEnter(CLASS_NAME, "getExcludeFilters", new String[0]));
        return this.excludeFilters;
    }

    public void setExcludeFilters(List<SearchFilter> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setExcludeFilters", String.valueOf(list)));
        this.excludeFilters = list == null ? new ArrayList<SearchFilter>(0) : list;
    }

    public List<SearchFilter> getIncludeFilters() {
        assert (Debug.debugEnter(CLASS_NAME, "getIncludeFilters", new String[0]));
        return this.includeFilters;
    }

    public void setIncludeFilters(List<SearchFilter> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setIncludeFilters", String.valueOf(list)));
        this.includeFilters = list == null ? new ArrayList<SearchFilter>(0) : list;
    }

    public boolean includeEntry(Entry entry) throws DirectoryException {
        block9: {
            assert (Debug.debugEnter(CLASS_NAME, "includeEntry", String.valueOf(entry)));
            DN dN = entry.getDN();
            if (!this.excludeBranches.isEmpty()) {
                for (DN object : this.excludeBranches) {
                    if (!object.isAncestorOf(dN)) continue;
                    return false;
                }
            }
            if (!this.includeBranches.isEmpty()) {
                for (DN dN2 : this.includeBranches) {
                    if (!dN2.isAncestorOf(dN)) continue;
                    break block9;
                }
                return false;
            }
        }
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter searchFilter : this.excludeFilters) {
                if (!searchFilter.matchesEntry(entry)) continue;
                return false;
            }
        }
        if (!this.includeFilters.isEmpty()) {
            for (SearchFilter searchFilter : this.includeFilters) {
                if (!searchFilter.matchesEntry(entry)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void close() {
        block3: {
            assert (Debug.debugEnter(CLASS_NAME, "close", new String[0]));
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "close", exception)) break block3;
                throw new AssertionError();
            }
        }
    }
}

