/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.InvokableComponent;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DirectoryException;

public class InvokableMethod {
    private static final String CLASS_NAME = "org.opends.server.types.InvokableMethod";
    private boolean retrievesComponentInfo;
    private boolean updatesComponentInfo;
    private ConfigAttribute[] arguments;
    private String description;
    private String name;
    private String returnType;

    public InvokableMethod(String string, String string2, ConfigAttribute[] configAttributeArray, String string3, boolean bl, boolean bl2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(configAttributeArray), String.valueOf(string3), String.valueOf(bl), String.valueOf(bl2)));
        this.name = string;
        this.description = string2;
        this.returnType = string3;
        this.retrievesComponentInfo = bl;
        this.updatesComponentInfo = bl2;
        this.arguments = configAttributeArray == null ? new ConfigAttribute[0] : configAttributeArray;
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return this.name;
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public ConfigAttribute[] getArguments() {
        assert (Debug.debugEnter(CLASS_NAME, "getArguments", new String[0]));
        return this.arguments;
    }

    public String getReturnType() {
        assert (Debug.debugEnter(CLASS_NAME, "getReturnType", new String[0]));
        return this.returnType;
    }

    public boolean retrievesComponentInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "retrievesComponentInfo", new String[0]));
        return this.retrievesComponentInfo;
    }

    public boolean updatesComponentInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "updatesComponentInfo", new String[0]));
        return this.updatesComponentInfo;
    }

    public MBeanOperationInfo toOperationInfo() {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "toOperationInfo", new String[0]));
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[this.arguments.length];
        for (n = 0; n < this.arguments.length; ++n) {
            mBeanParameterInfoArray[n] = this.arguments[n].toJMXParameterInfo();
        }
        n = this.retrievesComponentInfo ? (this.updatesComponentInfo ? 2 : 0) : (this.updatesComponentInfo ? 1 : 3);
        return new MBeanOperationInfo(this.name, this.description, mBeanParameterInfoArray, this.returnType, n);
    }

    public boolean hasSignature(String string, String[] stringArray) {
        assert (Debug.debugEnter(CLASS_NAME, "hasSignature", String.valueOf(string), String.valueOf(stringArray)));
        if (!string.equals(this.name)) {
            return false;
        }
        if (stringArray.length != this.arguments.length) {
            return false;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            MBeanParameterInfo mBeanParameterInfo = this.arguments[i].toJMXParameterInfo();
            if (stringArray[i].equals(mBeanParameterInfo.getType())) continue;
            return false;
        }
        return true;
    }

    public Object invoke(InvokableComponent invokableComponent, Object[] objectArray) throws MBeanException {
        assert (Debug.debugEnter(CLASS_NAME, "invoke", String.valueOf(invokableComponent), String.valueOf(objectArray)));
        try {
            ConfigAttribute[] configAttributeArray = new ConfigAttribute[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                Attribute attribute = new Attribute(this.arguments[i].getName(), objectArray[i]);
                configAttributeArray[i] = this.arguments[i].duplicate();
                configAttributeArray[i].setValue(attribute);
            }
            return invokableComponent.invokeMethod(this.name, configAttributeArray);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "invoke", directoryException));
            throw new MBeanException(directoryException, directoryException.getErrorMessage());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "invoke", exception));
            throw new MBeanException(exception);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.returnType == null) {
            stringBuilder.append("void ");
        } else {
            stringBuilder.append(this.returnType);
        }
        stringBuilder.append(this.name);
        stringBuilder.append('(');
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuilder.append(this.arguments[0].getDataType());
            stringBuilder.append(' ');
            stringBuilder.append(this.arguments[0].getName());
            for (int i = 1; i < this.arguments.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(this.arguments[i].getDataType());
                stringBuilder.append(' ');
                stringBuilder.append(this.arguments[i].getName());
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

