/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.Serializable;
import java.util.ArrayList;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RDN;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DN
implements Comparable<DN>,
Serializable {
    private static final String CLASS_NAME = "org.opends.server.types.DN";
    private static final long serialVersionUID = 1184263456768819888L;
    private final int numComponents;
    private final int offset;
    private final RDN[] rdnComponents;
    private final String normalizedDN;
    private static final DN EMPTY_DN = new DN(new RDN[0], 0, 0);

    public static DN nullDN() {
        return EMPTY_DN;
    }

    public static DN create(RDN ... rDNArray) {
        Validator.ensureNotNull(rDNArray);
        if (rDNArray.length == 0) {
            return DN.nullDN();
        }
        RDN[] rDNArray2 = new RDN[rDNArray.length];
        System.arraycopy(rDNArray, 0, rDNArray2, 0, rDNArray.length);
        return new DN(rDNArray2, 0, rDNArray.length);
    }

    public static DN valueOf(String string) throws DirectoryException {
        return DN.decode(string);
    }

    public static DN decode(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(byteString)));
        if (byteString == null) {
            return DN.nullDN();
        }
        byte[] byArray = byteString.value();
        int n = byArray.length;
        if (n == 0) {
            return DN.nullDN();
        }
        return DN.decode(byteString.stringValue());
    }

    public static DN decode(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(string)));
        if (string == null || string.length() == 0) {
            return DN.nullDN();
        }
        int n = 0;
        RDN.Builder builder = RDN.createBuilder();
        n = builder.parse(string, n, true);
        if (builder.isEmpty()) {
            return DN.nullDN();
        }
        ArrayList<RDN> arrayList = new ArrayList<RDN>(10);
        arrayList.add(builder.getInstance());
        while (n >= 0) {
            ++n;
            builder.clear();
            n = builder.parse(string, n, false);
            arrayList.add(builder.getInstance());
        }
        int n2 = arrayList.size();
        return new DN(arrayList.toArray(new RDN[n2]), 0, n2);
    }

    private DN(RDN[] rDNArray, int n, int n2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(rDNArray), String.valueOf(n)));
        this.rdnComponents = rDNArray;
        this.offset = n;
        this.numComponents = n2;
        this.normalizedDN = this.normalize();
    }

    public DN concat(DN dN) {
        Validator.ensureNotNull(dN);
        if (dN.isNullDN()) {
            return this;
        }
        if (this.isNullDN()) {
            return dN;
        }
        RDN[] rDNArray = new RDN[this.numComponents + dN.numComponents];
        System.arraycopy(dN.rdnComponents, dN.offset, rDNArray, 0, dN.numComponents);
        System.arraycopy(this.rdnComponents, this.offset, rDNArray, dN.numComponents, this.numComponents);
        return new DN(rDNArray, 0, rDNArray.length);
    }

    public DN concat(RDN ... rDNArray) {
        Validator.ensureNotNull(rDNArray);
        if (rDNArray.length == 0) {
            return this;
        }
        RDN[] rDNArray2 = new RDN[rDNArray.length + this.numComponents];
        System.arraycopy(rDNArray, 0, rDNArray2, 0, rDNArray.length);
        System.arraycopy(this.rdnComponents, this.offset, rDNArray2, rDNArray.length, this.numComponents);
        return new DN(rDNArray2, 0, rDNArray2.length);
    }

    public DN getParent() {
        if (this.numComponents <= 1) {
            return null;
        }
        return new DN(this.rdnComponents, this.offset + 1, this.numComponents - 1);
    }

    public DN getLocalName(int n) throws IndexOutOfBoundsException {
        return this.getLocalName(n, this.numComponents);
    }

    public DN getLocalName(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginIndex out of range: " + n);
        }
        if (n2 > this.numComponents) {
            throw new IndexOutOfBoundsException("endIndex out of range: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("beginIndex greater than endIndex");
        }
        if (n == 0 && n2 == this.numComponents) {
            return this;
        }
        int n3 = this.offset + this.numComponents - n2;
        return new DN(this.rdnComponents, n3, n2 - n);
    }

    public int getNumComponents() {
        assert (Debug.debugEnter(CLASS_NAME, "getNumComponents", new String[0]));
        return this.numComponents;
    }

    public RDN getRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRDN", new String[0]));
        if (this.numComponents == 0) {
            return null;
        }
        return this.getRDN(0);
    }

    public RDN getRDN(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index out of range: " + n);
        }
        if (n >= this.numComponents) {
            throw new IndexOutOfBoundsException("index out of range: " + n);
        }
        return this.rdnComponents[this.offset + n];
    }

    public DN getParentDNInSuffix() {
        assert (Debug.debugEnter(CLASS_NAME, "getParentDNInSuffix", new String[0]));
        if (this.numComponents <= 1 || DirectoryServer.isSuffix(this)) {
            return null;
        }
        return this.getParent();
    }

    public boolean isNullDN() {
        assert (Debug.debugEnter(CLASS_NAME, "isNullDN", new String[0]));
        return this.numComponents == 0;
    }

    public boolean isDescendantOf(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "isDescendantOf", String.valueOf(dN)));
        Validator.ensureNotNull(dN);
        int n = this.numComponents - dN.numComponents;
        if (n < 0) {
            return false;
        }
        for (int i = 0; i < dN.numComponents; ++i) {
            if (this.getRDN(i + n).equals(dN.getRDN(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOf(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "isAncestorOf", String.valueOf(dN)));
        Validator.ensureNotNull(dN);
        int n = dN.numComponents - this.numComponents;
        if (n < 0) {
            return false;
        }
        for (int i = 0; i < this.numComponents; ++i) {
            if (this.getRDN(i).equals(dN.getRDN(i + n))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (this == object) {
            return true;
        }
        if (object instanceof DN) {
            DN dN = (DN)object;
            return this.normalizedDN.equals(dN.normalizedDN);
        }
        return false;
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.normalizedDN.hashCode();
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        Validator.ensureNotNull(stringBuilder);
        if (this.numComponents != 0) {
            this.getRDN(0).toString(stringBuilder);
            for (int i = 1; i < this.numComponents; ++i) {
                stringBuilder.append(",");
                this.getRDN(i).toString(stringBuilder);
            }
        }
    }

    public String toNormalizedString() {
        assert (Debug.debugEnter(CLASS_NAME, "toNormalizedString", new String[0]));
        return this.normalizedDN;
    }

    public void toNormalizedString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toNormalizedString", "java.lang.StringBuilder"));
        Validator.ensureNotNull(stringBuilder);
        stringBuilder.append(this.normalizedDN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "compareTo", String.valueOf(this), String.valueOf(dN)));
        Validator.ensureNotNull(dN);
        int n = this.numComponents - 1;
        int n2 = dN.numComponents - 1;
        while (true) {
            if (n >= 0) {
                if (n2 < 0) return 1;
                int n3 = this.getRDN(n).compareTo(dN.getRDN(n2));
                if (n3 != 0) {
                    return n3;
                }
            } else {
                if (n2 < 0) return 0;
                return -1;
            }
            --n;
            --n2;
        }
    }

    private String normalize() {
        if (this.numComponents == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.getRDN(0).toNormalizedString(stringBuilder);
        for (int i = 1; i < this.numComponents; ++i) {
            stringBuilder.append(',');
            this.getRDN(i).toNormalizedString(stringBuilder);
        }
        return stringBuilder.toString();
    }
}

