/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class CryptoManager {
    private static final String CLASS_NAME = "org.opends.server.types.CryptoManager";
    private SecretKey secretKey;
    private String preferredCipher;
    private String preferredDigestAlgorithm;
    private String preferredMACAlgorithm;

    public CryptoManager() throws ConfigException, InitializationException {
        Object object;
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.preferredDigestAlgorithm = "SHA-1";
        this.preferredMACAlgorithm = "HmacSHA1";
        this.preferredCipher = "AES/CBC/PKCS5Padding";
        this.secretKey = new SecretKeySpec(new byte[16], "AES");
        try {
            MessageDigest.getInstance(this.preferredDigestAlgorithm);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            throw new InitializationException(-1, "Can't get preferred digest:  " + StaticUtils.stackTraceToSingleLineString(exception), exception);
        }
        try {
            object = Mac.getInstance(this.preferredMACAlgorithm);
            ((Mac)object).init(this.secretKey);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            throw new InitializationException(-1, "Can't get preferred MAC provider:  " + StaticUtils.stackTraceToSingleLineString(exception), exception);
        }
        try {
            object = Cipher.getInstance(this.preferredCipher);
            ((Cipher)object).init(1, this.secretKey);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            throw new InitializationException(-1, "Can't get preferred cipher:  " + StaticUtils.stackTraceToSingleLineString(exception), exception);
        }
    }

    public SecureRandom getSecureRandom() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecureRandom", new String[0]));
        return new SecureRandom();
    }

    public String getPreferredMessageDigestAlgorithm() {
        assert (Debug.debugEnter(CLASS_NAME, "getPreferredMessageDigestAlgorithm", new String[0]));
        return this.preferredDigestAlgorithm;
    }

    public MessageDigest getPreferredMessageDigest() throws NoSuchAlgorithmException {
        assert (Debug.debugEnter(CLASS_NAME, "getPreferredMessageDigest", new String[0]));
        return MessageDigest.getInstance(this.preferredDigestAlgorithm);
    }

    public MessageDigest getMessageDigest(String string) throws NoSuchAlgorithmException {
        assert (Debug.debugEnter(CLASS_NAME, "getMessageDigest", String.valueOf(string)));
        return MessageDigest.getInstance(string);
    }

    public byte[] digest(byte[] byArray) throws NoSuchAlgorithmException {
        assert (Debug.debugEnter(CLASS_NAME, "digest", "byte[" + byArray.length + "]"));
        return MessageDigest.getInstance(this.preferredDigestAlgorithm).digest(byArray);
    }

    public byte[] digest(String string, byte[] byArray) throws NoSuchAlgorithmException {
        assert (Debug.debugEnter(CLASS_NAME, "digest", String.valueOf(string), "byte[" + byArray.length + "]"));
        return MessageDigest.getInstance(string).digest(byArray);
    }

    public byte[] digest(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "digest", "java.io.InputStream"));
        MessageDigest messageDigest = MessageDigest.getInstance(this.preferredDigestAlgorithm);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            messageDigest.update(byArray, 0, n);
        }
        return messageDigest.digest();
    }

    public byte[] digest(String string, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "digest", "java.io.InputStream"));
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            messageDigest.update(byArray, 0, n);
        }
        return messageDigest.digest();
    }

    public String getPreferredMACAlgorithm() {
        assert (Debug.debugEnter(CLASS_NAME, "getPreferredMessageDigestAlgorithm", new String[0]));
        return this.preferredMACAlgorithm;
    }

    public Mac getPreferredMACProvider() throws NoSuchAlgorithmException, InvalidKeyException {
        assert (Debug.debugEnter(CLASS_NAME, "getPreferredMACProvider", new String[0]));
        Mac mac = Mac.getInstance(this.preferredMACAlgorithm);
        mac.init(this.secretKey);
        return mac;
    }

    public Mac getMACProvider(String string) throws NoSuchAlgorithmException, InvalidKeyException {
        assert (Debug.debugEnter(CLASS_NAME, "getMACProvider", String.valueOf(string)));
        Mac mac = Mac.getInstance(string);
        mac.init(this.secretKey);
        return mac;
    }

    public byte[] mac(byte[] byArray) throws NoSuchAlgorithmException {
        assert (Debug.debugEnter(CLASS_NAME, "mac", "byte[" + byArray.length + "]"));
        return Mac.getInstance(this.preferredMACAlgorithm).doFinal(byArray);
    }

    public byte[] mac(String string, byte[] byArray) throws NoSuchAlgorithmException {
        assert (Debug.debugEnter(CLASS_NAME, "mac", String.valueOf(string), "byte[" + byArray.length + "]"));
        return Mac.getInstance(string).doFinal(byArray);
    }

    public byte[] mac(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "digest", "java.io.InputStream"));
        Mac mac = Mac.getInstance(this.preferredMACAlgorithm);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            mac.update(byArray, 0, n);
        }
        return mac.doFinal();
    }

    public byte[] mac(String string, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "digest", String.valueOf(string), "java.io.InputStream"));
        Mac mac = Mac.getInstance(string);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            mac.update(byArray, 0, n);
        }
        return mac.doFinal();
    }

    public String getPreferredCipherAlgorithm() {
        assert (Debug.debugEnter(CLASS_NAME, "getPreferredCipherAlgorithm", new String[0]));
        return this.preferredCipher;
    }

    public Cipher getPreferredCipher(int n) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        assert (Debug.debugEnter(CLASS_NAME, "getPreferredCipher", String.valueOf(n)));
        Cipher cipher = Cipher.getInstance(this.preferredCipher);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
        cipher.init(n, (Key)this.secretKey, ivParameterSpec);
        return cipher;
    }

    public Cipher getCipher(String string, int n) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        assert (Debug.debugEnter(CLASS_NAME, "getCipher", String.valueOf(string), String.valueOf(n)));
        Cipher cipher = Cipher.getInstance(string);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
        cipher.init(n, (Key)this.secretKey, ivParameterSpec);
        return cipher;
    }

    public byte[] encrypt(byte[] byArray) throws GeneralSecurityException {
        assert (Debug.debugEnter(CLASS_NAME, "encrypt", "byte[" + byArray.length + "]"));
        Cipher cipher = Cipher.getInstance(this.preferredCipher);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
        cipher.init(1, (Key)this.secretKey, ivParameterSpec);
        return cipher.doFinal(byArray);
    }

    public byte[] decrypt(byte[] byArray) throws GeneralSecurityException {
        assert (Debug.debugEnter(CLASS_NAME, "decrypt", "byte[" + byArray.length + "]"));
        Cipher cipher = Cipher.getInstance(this.preferredCipher);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
        cipher.init(2, (Key)this.secretKey, ivParameterSpec);
        return cipher.doFinal(byArray);
    }

    public byte[] encrypt(String string, byte[] byArray) throws GeneralSecurityException {
        assert (Debug.debugEnter(CLASS_NAME, "encrypt", "byte[" + byArray.length + "]"));
        Cipher cipher = Cipher.getInstance(string);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
        cipher.init(1, (Key)this.secretKey, ivParameterSpec);
        return cipher.doFinal(byArray);
    }

    public byte[] decrypt(String string, byte[] byArray) throws GeneralSecurityException {
        assert (Debug.debugEnter(CLASS_NAME, "decrypt", "byte[" + byArray.length + "]"));
        Cipher cipher = Cipher.getInstance(string);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
        cipher.init(2, (Key)this.secretKey, ivParameterSpec);
        return cipher.doFinal(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compress(byte[] byArray, byte[] byArray2) {
        Deflater deflater = new Deflater();
        try {
            deflater.setInput(byArray);
            deflater.finish();
            int n = deflater.deflate(byArray2);
            if (deflater.finished()) {
                int n2 = n;
                return n2;
            }
            int n3 = -1;
            return n3;
        }
        finally {
            deflater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uncompress(byte[] byArray, byte[] byArray2) throws DataFormatException {
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(byArray);
            int n = inflater.inflate(byArray2);
            if (inflater.finished()) {
                int n2 = n;
                return n2;
            }
            int n3 = n;
            while (!inflater.finished()) {
                n3 += inflater.inflate(byArray2);
            }
            int n4 = -n3;
            return n4;
        }
        finally {
            inflater.end();
        }
    }
}

