/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractSequentialList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupDirectory {
    private static final String CLASS_NAME = "org.opends.server.types.BackupDirectory";
    public static final String PROPERTY_BACKEND_CONFIG_DN = "backend_dn";
    private DN configEntryDN;
    private LinkedHashMap<String, BackupInfo> backups;
    private String path;

    public BackupDirectory(String string, DN dN) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(dN)));
        this.path = string;
        this.configEntryDN = dN;
        this.backups = new LinkedHashMap();
    }

    public BackupDirectory(String string, DN dN, LinkedHashMap<String, BackupInfo> linkedHashMap) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(dN), String.valueOf(linkedHashMap)));
        this.path = string;
        this.configEntryDN = dN;
        this.backups = linkedHashMap == null ? new LinkedHashMap() : linkedHashMap;
    }

    public String getPath() {
        assert (Debug.debugEnter(CLASS_NAME, "getPath", new String[0]));
        return this.path;
    }

    public DN getConfigEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigEntryDN", new String[0]));
        return this.configEntryDN;
    }

    public LinkedHashMap<String, BackupInfo> getBackups() {
        assert (Debug.debugEnter(CLASS_NAME, "getBackups", new String[0]));
        return this.backups;
    }

    public BackupInfo getBackupInfo(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getBackupInfo", String.valueOf(string)));
        return this.backups.get(string);
    }

    public BackupInfo getLatestBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "getLatestBackup", new String[0]));
        BackupInfo backupInfo = null;
        for (BackupInfo backupInfo2 : this.backups.values()) {
            if (backupInfo == null) {
                backupInfo = backupInfo2;
                continue;
            }
            if (backupInfo2.getBackupDate().getTime() <= backupInfo.getBackupDate().getTime()) continue;
            backupInfo = backupInfo2;
        }
        return backupInfo;
    }

    public void addBackup(BackupInfo backupInfo) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "addBackup", String.valueOf(backupInfo)));
        String string = backupInfo.getBackupID();
        if (this.backups.containsKey(string)) {
            int n = 262443;
            String string2 = MessageHandler.getMessage(n, string, this.path);
            throw new ConfigException(n, string2);
        }
        this.backups.put(string, backupInfo);
    }

    public void removeBackup(String string) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", String.valueOf(string)));
        if (!this.backups.containsKey(string)) {
            int n = 262444;
            String string2 = MessageHandler.getMessage(n, string, this.path);
            throw new ConfigException(n, string2);
        }
        for (BackupInfo backupInfo : this.backups.values()) {
            if (!backupInfo.dependsOn(string)) continue;
            int n = 262445;
            String string3 = MessageHandler.getMessage(n, string, this.path, backupInfo.getBackupID());
            throw new ConfigException(n, string3);
        }
        this.backups.remove(string);
    }

    public String getDescriptorPath() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescriptorPath", new String[0]));
        return this.path + File.separator + "backup.info";
    }

    public void writeBackupDirectoryDescriptor() throws IOException {
        String exception;
        Object n;
        Object exception2;
        assert (Debug.debugEnter(CLASS_NAME, "writeBackupDirectoryDescriptor", new String[0]));
        File file = new File(this.path);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception3) {
                assert (Debug.debugException(CLASS_NAME, "writeBackupDirectoryDescriptor", exception3));
                int n2 = 262446;
                String string2 = MessageHandler.getMessage(n2, this.path, StaticUtils.stackTraceToSingleLineString(exception3));
                throw new IOException(string2);
            }
        } else if (!file.isDirectory()) {
            int n3 = 262447;
            String string3 = MessageHandler.getMessage(n3, this.path);
            throw new IOException(string3);
        }
        String string4 = this.path + File.separator + "backup.info" + ".new";
        File file2 = new File(string4);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2, false));
        bufferedWriter.write("backend_dn=" + this.configEntryDN.toString());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        for (BackupInfo object32 : this.backups.values()) {
            exception2 = object32.encode();
            n = ((AbstractSequentialList)exception2).iterator();
            while (n.hasNext()) {
                exception = (String)n.next();
                bufferedWriter.write(exception);
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        String string5 = this.path + File.separator + "backup.info";
        File file3 = new File(string5);
        if (file3.exists()) {
            exception2 = (String)string5 + ".save";
            n = new File((String)exception2);
            if (((File)n).exists()) {
                try {
                    ((File)n).delete();
                }
                catch (Exception exception4) {
                    assert (Debug.debugException(CLASS_NAME, "writeBackupDirectoryDescriptor", exception4));
                    int n4 = 262448;
                    String string7 = MessageHandler.getMessage(n4, exception2, StaticUtils.stackTraceToSingleLineString(exception4), string4, string5);
                    throw new IOException(string7);
                }
            }
            try {
                file3.renameTo((File)n);
            }
            catch (Exception exception5) {
                assert (Debug.debugException(CLASS_NAME, "writeBackupDirectoryDescriptor", exception5));
                int n5 = 262449;
                String string = MessageHandler.getMessage(n5, string5, exception2, StaticUtils.stackTraceToSingleLineString(exception5), string4);
                throw new IOException(string);
            }
        }
        try {
            file2.renameTo(file3);
        }
        catch (Exception exception6) {
            assert (Debug.debugException(CLASS_NAME, "writeBackupDirectoryDescriptor", exception6));
            int n6 = 262450;
            exception = MessageHandler.getMessage(n6, string4, string5, StaticUtils.stackTraceToSingleLineString(exception6));
            throw new IOException(exception);
        }
    }

    public static BackupDirectory readBackupDirectoryDescriptor(String string) throws IOException, ConfigException {
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "readBackupDirectoryDescriptor", String.valueOf(string)));
        String string2 = string + File.separator + "backup.info";
        File file = new File(string2);
        if (!file.exists()) {
            int n = 262451;
            String string3 = MessageHandler.getMessage(n, string2);
            throw new ConfigException(n, string3);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string4 = bufferedReader.readLine();
        if (string4 == null || string4.length() == 0) {
            int n = 262452;
            String string5 = MessageHandler.getMessage(n, string2);
            throw new ConfigException(n, string5);
        }
        if (!string4.startsWith(PROPERTY_BACKEND_CONFIG_DN)) {
            int n = 262453;
            String string6 = MessageHandler.getMessage(n, string2, string4);
            throw new ConfigException(n, string6);
        }
        String string7 = string4.substring(PROPERTY_BACKEND_CONFIG_DN.length() + 1);
        try {
            dN = DN.decode(string7);
        }
        catch (DirectoryException directoryException) {
            int n = 262454;
            String string8 = MessageHandler.getMessage(n, string7, directoryException.getErrorMessage());
            throw new ConfigException(n, string8, directoryException);
        }
        catch (Exception exception) {
            int n = 262454;
            String string9 = MessageHandler.getMessage(n, string7, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ConfigException(n, string9, exception);
        }
        BackupDirectory backupDirectory = new BackupDirectory(string, dN);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (true) {
            if ((string4 = bufferedReader.readLine()) == null || string4.length() == 0) {
                if (linkedList.isEmpty()) {
                    if (string4 != null) continue;
                    break;
                }
                BackupInfo backupInfo = BackupInfo.decode(backupDirectory, linkedList);
                backupDirectory.addBackup(backupInfo);
                linkedList.clear();
                if (string4 != null) continue;
                break;
            }
            linkedList.add(string4);
        }
        bufferedReader.close();
        return backupDirectory;
    }
}

