/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeType
extends CommonSchemaElements {
    private static final String CLASS_NAME = "org.opends.server.types.AttributeType";
    private final ApproximateMatchingRule approximateMatchingRule;
    private final AttributeSyntax syntax;
    private final AttributeType superiorType;
    private final AttributeUsage attributeUsage;
    private final boolean isCollective;
    private final boolean isNoUserModification;
    private final boolean isObjectClassType;
    private final boolean isSingleValue;
    private final EqualityMatchingRule equalityMatchingRule;
    private final OrderingMatchingRule orderingMatchingRule;
    private final SubstringMatchingRule substringMatchingRule;

    public AttributeType(String string, Collection<String> collection, String string2, String string3, AttributeType attributeType, AttributeSyntax attributeSyntax, AttributeUsage attributeUsage, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, collection, string2, string3, attributeType, attributeSyntax, null, null, null, null, attributeUsage, bl, bl2, bl3, bl4, null);
    }

    public AttributeType(String string, Collection<String> collection, String string2, String string3, AttributeType attributeType, AttributeSyntax attributeSyntax, ApproximateMatchingRule approximateMatchingRule, EqualityMatchingRule equalityMatchingRule, OrderingMatchingRule orderingMatchingRule, SubstringMatchingRule substringMatchingRule, AttributeUsage attributeUsage, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map<String, List<String>> map) throws NullPointerException {
        super(string, collection, string2, string3, bl3, map);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(collection), String.valueOf(string2), String.valueOf(string3), String.valueOf(attributeType), String.valueOf(attributeSyntax), String.valueOf(approximateMatchingRule), String.valueOf(equalityMatchingRule), String.valueOf(orderingMatchingRule), String.valueOf(substringMatchingRule), String.valueOf((Object)attributeUsage), String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(bl4), String.valueOf(map)));
        this.superiorType = attributeType;
        this.isCollective = bl;
        this.isNoUserModification = bl2;
        this.isSingleValue = bl4;
        this.syntax = attributeSyntax == null ? (attributeType != null ? attributeType.getSyntax() : DirectoryServer.getDefaultAttributeSyntax()) : attributeSyntax;
        this.approximateMatchingRule = approximateMatchingRule == null ? this.syntax.getApproximateMatchingRule() : approximateMatchingRule;
        this.equalityMatchingRule = equalityMatchingRule == null ? this.syntax.getEqualityMatchingRule() : equalityMatchingRule;
        this.orderingMatchingRule = orderingMatchingRule == null ? this.syntax.getOrderingMatchingRule() : orderingMatchingRule;
        this.substringMatchingRule = substringMatchingRule == null ? this.syntax.getSubstringMatchingRule() : substringMatchingRule;
        this.attributeUsage = attributeUsage != null ? attributeUsage : AttributeUsage.USER_APPLICATIONS;
        this.isObjectClassType = string2.equals("2.5.4.0") ? true : this.hasName("objectclass");
    }

    public AttributeType getSuperiorType() {
        assert (Debug.debugEnter(CLASS_NAME, "getSuperiorType", new String[0]));
        return this.superiorType;
    }

    public AttributeSyntax getSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", new String[0]));
        return this.syntax;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return this.syntax.getOID();
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return this.approximateMatchingRule;
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.equalityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.orderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.substringMatchingRule;
    }

    public AttributeUsage getUsage() {
        assert (Debug.debugEnter(CLASS_NAME, "getUsage", new String[0]));
        return this.attributeUsage;
    }

    public boolean isOperational() {
        assert (Debug.debugEnter(CLASS_NAME, "isOperational", new String[0]));
        return this.attributeUsage.isOperational();
    }

    public boolean isCollective() {
        assert (Debug.debugEnter(CLASS_NAME, "isCollective", new String[0]));
        return this.isCollective;
    }

    public boolean isNoUserModification() {
        assert (Debug.debugEnter(CLASS_NAME, "isNoUserModification", new String[0]));
        return this.isNoUserModification;
    }

    public boolean isSingleValue() {
        assert (Debug.debugEnter(CLASS_NAME, "isSingleValue", new String[0]));
        return this.isSingleValue;
    }

    public boolean isObjectClassType() {
        assert (Debug.debugEnter(CLASS_NAME, "isObjectClassType", new String[0]));
        return this.isObjectClassType;
    }

    public ByteString normalize(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalize", String.valueOf(byteString)));
        if (this.equalityMatchingRule == null) {
            int n = 196733;
            String string = MessageHandler.getMessage(n, String.valueOf(byteString), this.getNameOrOID());
            throw new DirectoryException(ResultCode.INAPPROPRIATE_MATCHING, string, n);
        }
        return this.equalityMatchingRule.normalizeValue(byteString);
    }

    public int generateHashCode(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "generateHashCode", String.valueOf(attributeValue)));
        try {
            if (this.equalityMatchingRule == null) {
                ByteString byteString = attributeValue.getNormalizedValue();
                if (byteString == null) {
                    return attributeValue.getValue().hashCode();
                }
                return byteString.hashCode();
            }
            return this.equalityMatchingRule.generateHashCode(attributeValue);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "generateHashCode", exception));
            try {
                return attributeValue.getValue().hashCode();
            }
            catch (Exception exception2) {
                assert (Debug.debugException(CLASS_NAME, "generateHashCode", exception2));
                return 0;
            }
        }
    }

    @Override
    protected void toStringContent(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toStringContent", "java.lang.StringBuilder"));
        if (this.superiorType != null) {
            stringBuilder.append(" SUP ");
            stringBuilder.append(this.superiorType.getNameOrOID());
        }
        if (this.equalityMatchingRule != null) {
            stringBuilder.append(" EQUALITY ");
            stringBuilder.append(this.equalityMatchingRule.getNameOrOID());
        }
        if (this.orderingMatchingRule != null) {
            stringBuilder.append(" ORDERING ");
            stringBuilder.append(this.orderingMatchingRule.getNameOrOID());
        }
        if (this.substringMatchingRule != null) {
            stringBuilder.append(" SUBSTR ");
            stringBuilder.append(this.substringMatchingRule.getNameOrOID());
        }
        if (this.syntax != null) {
            stringBuilder.append(" SYNTAX ");
            stringBuilder.append(this.syntax.getOID());
        }
        if (this.isSingleValue) {
            stringBuilder.append(" SINGLE-VALUE");
        }
        if (this.isCollective) {
            stringBuilder.append(" COLLECTIVE");
        }
        if (this.isNoUserModification) {
            stringBuilder.append(" NO-USER-MODIFICATION");
        }
        if (this.attributeUsage != null) {
            stringBuilder.append(" USAGE ");
            stringBuilder.append(this.attributeUsage.toString());
        }
    }
}

