/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import java.util.Random;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceTag
extends Tag {
    private int percentage = 100;
    private Random random;

    @Override
    public String getName() {
        return "Presence";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n);
    }

    private void initializeInternal(TemplateFile templateFile, String[] stringArray, int n) throws InitializationException {
        this.random = templateFile.getRandom();
        if (stringArray.length != 1) {
            int n2 = 10682903;
            String string = MessageHandler.getMessage(n2, this.getName(), n, 1, stringArray.length);
            throw new InitializationException(n2, string);
        }
        try {
            this.percentage = Integer.parseInt(stringArray[0]);
            if (this.percentage < 0) {
                int n3 = 10682906;
                String string = MessageHandler.getMessage(this.percentage, 0, this.getName(), n);
                throw new InitializationException(n3, string);
            }
            if (this.percentage > 100) {
                int n4 = 10682908;
                String string = MessageHandler.getMessage(this.percentage, 100, this.getName(), n);
                throw new InitializationException(n4, string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            int n5 = 10682907;
            String string = MessageHandler.getMessage(n5, stringArray[0], this.getName(), n);
            throw new InitializationException(n5, string);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        int n = this.random.nextInt(100);
        if (n < this.percentage) {
            return TagResult.SUCCESS_RESULT;
        }
        return TagResult.OMIT_FROM_ENTRY;
    }
}

