/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.AttributeType;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfPresentTag
extends Tag {
    private AttributeType attributeType = null;
    private String assertionValue = null;

    @Override
    public String getName() {
        return "IfPresent";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] stringArray, int n, List<String> list) throws InitializationException {
        if (stringArray.length < 1 || stringArray.length > 2) {
            int n2 = 10682904;
            String string = MessageHandler.getMessage(n2, this.getName(), n, 1, 2, stringArray.length);
            throw new InitializationException(n2, string);
        }
        String string = StaticUtils.toLowerCase(stringArray[0]);
        AttributeType attributeType = DirectoryServer.getAttributeType(string, true);
        if (!branch.hasAttribute(attributeType)) {
            int n3 = 10682905;
            String string2 = MessageHandler.getMessage(n3, stringArray[0], n);
            throw new InitializationException(n3, string2);
        }
        this.assertionValue = stringArray.length == 2 ? stringArray[1] : null;
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] stringArray, int n, List<String> list) throws InitializationException {
        if (stringArray.length < 1 || stringArray.length > 2) {
            int n2 = 10682904;
            String string = MessageHandler.getMessage(n2, this.getName(), n, 1, 2, stringArray.length);
            throw new InitializationException(n2, string);
        }
        String string = StaticUtils.toLowerCase(stringArray[0]);
        AttributeType attributeType = DirectoryServer.getAttributeType(string, true);
        if (!template.hasAttribute(attributeType)) {
            int n3 = 10682905;
            String string2 = MessageHandler.getMessage(n3, stringArray[0], n);
            throw new InitializationException(n3, string2);
        }
        this.assertionValue = stringArray.length == 2 ? stringArray[1] : null;
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        List<TemplateValue> list = templateEntry.getValues(this.attributeType);
        if (list == null || list.isEmpty()) {
            return TagResult.OMIT_FROM_ENTRY;
        }
        if (this.assertionValue == null) {
            return TagResult.SUCCESS_RESULT;
        }
        for (TemplateValue templateValue2 : list) {
            if (!this.assertionValue.equals(templateValue2.getValue().toString())) continue;
            return TagResult.SUCCESS_RESULT;
        }
        return TagResult.OMIT_FROM_ENTRY;
    }
}

