/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTag
extends Tag {
    private boolean sequential = false;
    private File dataFile = null;
    private int nextIndex = 0;
    private Random random = null;
    private String[] fileLines = null;

    @Override
    public String getName() {
        return "File";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n, list);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeInternal(TemplateFile templateFile, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.random = templateFile.getRandom();
        if (stringArray.length < 1 || stringArray.length > 2) {
            int n2 = 10682904;
            String string = MessageHandler.getMessage(n2, this.getName(), n, 1, 2, stringArray.length);
            throw new InitializationException(n2, string);
        }
        this.dataFile = templateFile.getFile(stringArray[0]);
        if (this.dataFile == null || !this.dataFile.exists()) {
            int n3 = 10682963;
            String string = MessageHandler.getMessage(n3, stringArray[0], this.getName(), n);
            throw new InitializationException(n3, string);
        }
        if (stringArray.length == 2) {
            if (stringArray[1].equalsIgnoreCase("sequential")) {
                this.sequential = true;
                this.nextIndex = 0;
            } else {
                if (!stringArray[1].equalsIgnoreCase("random")) {
                    int n4 = 10682964;
                    String string = MessageHandler.getMessage(n4, stringArray[1], this.getName(), n);
                    throw new InitializationException(n4, string);
                }
                this.sequential = false;
            }
        } else {
            this.sequential = false;
        }
        try {
            this.fileLines = templateFile.getFileLines(this.dataFile);
            return;
        }
        catch (IOException iOException) {
            int n5 = 10682965;
            String string = MessageHandler.getMessage(n5, stringArray[0], this.getName(), n, String.valueOf(iOException));
            throw new InitializationException(n5, string, iOException);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        if (this.sequential) {
            templateValue.append(this.fileLines[this.nextIndex++]);
            if (this.nextIndex >= this.fileLines.length) {
                this.nextIndex = 0;
            }
        } else {
            templateValue.append(this.fileLines[this.random.nextInt(this.fileLines.length)]);
        }
        return TagResult.SUCCESS_RESULT;
    }
}

