/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.AttributeType;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueTag
extends Tag {
    private AttributeType attributeType = null;
    private int numCharacters = 0;

    @Override
    public String getName() {
        return "AttributeValue";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] stringArray, int n, List<String> list) throws InitializationException {
        block6: {
            if (stringArray.length < 1 || stringArray.length > 2) {
                int n2 = 10682904;
                String string = MessageHandler.getMessage(n2, this.getName(), n, 1, 2, stringArray.length);
                throw new InitializationException(n2, string);
            }
            String string = StaticUtils.toLowerCase(stringArray[0]);
            this.attributeType = DirectoryServer.getAttributeType(string, true);
            if (!branch.hasAttribute(this.attributeType)) {
                int n3 = 10682905;
                String string2 = MessageHandler.getMessage(n3, stringArray[0], n);
                throw new InitializationException(n3, string2);
            }
            if (stringArray.length == 2) {
                try {
                    this.numCharacters = Integer.parseInt(stringArray[1]);
                    if (this.numCharacters < 0) {
                        int n4 = 10682906;
                        String string3 = MessageHandler.getMessage(n4, this.numCharacters, 0, this.getName(), n);
                        throw new InitializationException(n4, string3);
                    }
                    break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    int n5 = 10682907;
                    String string4 = MessageHandler.getMessage(n5, stringArray[1], this.getName(), n);
                    throw new InitializationException(n5, string4);
                }
            }
            this.numCharacters = 0;
        }
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] stringArray, int n, List<String> list) throws InitializationException {
        block6: {
            if (stringArray.length < 1 || stringArray.length > 2) {
                int n2 = 10682904;
                String string = MessageHandler.getMessage(n2, this.getName(), n, 1, 2, stringArray.length);
                throw new InitializationException(n2, string);
            }
            String string = StaticUtils.toLowerCase(stringArray[0]);
            this.attributeType = DirectoryServer.getAttributeType(string, true);
            if (!template.hasAttribute(this.attributeType)) {
                int n3 = 10682905;
                String string2 = MessageHandler.getMessage(n3, stringArray[0], n);
                throw new InitializationException(n3, string2);
            }
            if (stringArray.length == 2) {
                try {
                    this.numCharacters = Integer.parseInt(stringArray[1]);
                    if (this.numCharacters < 0) {
                        int n4 = 10682906;
                        String string3 = MessageHandler.getMessage(n4, this.numCharacters, 0, this.getName(), n);
                        throw new InitializationException(n4, string3);
                    }
                    break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    int n5 = 10682907;
                    String string4 = MessageHandler.getMessage(n5, stringArray[1], this.getName(), n);
                    throw new InitializationException(n5, string4);
                }
            }
            this.numCharacters = 0;
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        TemplateValue templateValue2 = templateEntry.getValue(this.attributeType);
        if (templateValue2 == null) {
            return TagResult.SUCCESS_RESULT;
        }
        if (this.numCharacters > 0) {
            String string = templateValue2.getValue().toString();
            if (string.length() > this.numCharacters) {
                templateValue.append(string.substring(0, this.numCharacters));
            } else {
                templateValue.append(string);
            }
        } else {
            templateValue.getValue().append((CharSequence)templateValue2.getValue());
        }
        return TagResult.SUCCESS_RESULT;
    }
}

