/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.opends.server.extensions.BlindTrustManagerProvider;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.SSLConnectionException;

public class SSLConnectionFactory {
    private static final String CLASS_NAME = "org.opends.server.tools.SSLConnectionFactory";
    private SSLSocketFactory sslSocketFactory = null;

    public void init(boolean bl, String string, String string2, String string3, String string4) throws SSLConnectionException {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (bl) {
                BlindTrustManagerProvider blindTrustManagerProvider = new BlindTrustManagerProvider();
                trustManagerArray = blindTrustManagerProvider.getTrustManagers();
            } else {
                trustManagerArray = this.getTrustManagers(KeyStore.getDefaultType(), null, string3, string4);
            }
            if (string != null) {
                keyManagerArray = this.getKeyManagers(KeyStore.getDefaultType(), null, string, string2);
            }
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            this.sslSocketFactory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            int n = 10747905;
            throw new SSLConnectionException(MessageHandler.getMessage(n, exception.getMessage()), exception);
        }
    }

    public Socket createSocket(String string, int n) throws SSLConnectionException, IOException {
        if (this.sslSocketFactory == null) {
            int n2 = 10747906;
            throw new SSLConnectionException(MessageHandler.getMessage(n2));
        }
        return this.sslSocketFactory.createSocket(string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws SSLConnectionException, IOException {
        if (this.sslSocketFactory == null) {
            int n2 = 10747906;
            throw new SSLConnectionException(MessageHandler.getMessage(n2));
        }
        return this.sslSocketFactory.createSocket(socket, string, n, bl);
    }

    private KeyManager[] getKeyManagers(String string, Provider provider, String string2, String string3) throws KeyStoreException, SSLConnectionException {
        Object object;
        if (string2 == null) {
            string2 = this.getKeyStore();
        }
        if (string3 == null) {
            string3 = this.getKeyStorePIN();
        }
        KeyStore keyStore = null;
        keyStore = provider != null ? KeyStore.getInstance(string, provider) : KeyStore.getInstance(string);
        char[] cArray = null;
        if (string3 != null) {
            cArray = string3.toCharArray();
        }
        try {
            object = new FileInputStream(string2);
            keyStore.load((InputStream)object, cArray);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getKeyManagers", exception));
            int n = 10747907;
            throw new SSLConnectionException(MessageHandler.getMessage(n, string2), exception);
        }
        try {
            object = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)object);
            keyManagerFactory.init(keyStore, cArray);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getKeyManagers", exception));
            int n = 0xA40004;
            throw new SSLConnectionException(MessageHandler.getMessage(n, string2), exception);
        }
    }

    private TrustManager[] getTrustManagers(String string, Provider provider, String string2, String string3) throws KeyStoreException, SSLConnectionException {
        Object object;
        if (string2 == null && (string2 = this.getTrustStore()) == null) {
            return null;
        }
        if (string3 == null) {
            string3 = this.getTrustStorePIN();
        }
        KeyStore keyStore = null;
        keyStore = provider != null ? KeyStore.getInstance(string, provider) : KeyStore.getInstance(string);
        char[] cArray = null;
        if (string3 != null) {
            cArray = string3.toCharArray();
        }
        try {
            object = new FileInputStream(string2);
            keyStore.load((InputStream)object, cArray);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getTrustManagers", exception));
            int n = 10747909;
            throw new SSLConnectionException(MessageHandler.getMessage(n, string2), exception);
        }
        try {
            object = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)object);
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getTrustManagers", exception));
            int n = 10747910;
            throw new SSLConnectionException(MessageHandler.getMessage(n, string2), exception);
        }
    }

    private String getKeyStorePIN() {
        return System.getProperty("javax.net.ssl.keyStorePassword");
    }

    private String getTrustStorePIN() {
        return System.getProperty("javax.net.ssl.trustStorePassword");
    }

    private String getKeyStore() {
        return System.getProperty("javax.net.ssl.keyStore");
    }

    private String getTrustStore() {
        return System.getProperty("javax.net.ssl.trustStore");
    }
}

