/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.MultiChoiceArgument;
import org.opends.server.util.args.StringArgument;

public class LDIFSearch {
    private static final String CLASS_NAME = "org.opends.server.tools.LDIFSearch";
    private static final String SCOPE_STRING_BASE = "base";
    private static final String SCOPE_STRING_ONE = "one";
    private static final String SCOPE_STRING_SUB = "sub";
    private static final String SCOPE_STRING_SUBORDINATE = "subordinate";

    public static void main(String[] stringArray) {
        int n = LDIFSearch.mainSearch(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int mainSearch(String[] stringArray) {
        LDIFWriter lDIFWriter;
        LDIFReader lDIFReader;
        int n;
        long l;
        Object object4;
        Object object522;
        ArrayList<String> arrayList;
        LinkedList<String> linkedList;
        BooleanArgument booleanArgument;
        IntegerArgument integerArgument;
        IntegerArgument integerArgument2;
        BooleanArgument booleanArgument2;
        BooleanArgument booleanArgument3;
        StringArgument stringArgument;
        FileBasedArgument fileBasedArgument;
        StringArgument stringArgument2;
        StringArgument stringArgument3;
        MultiChoiceArgument multiChoiceArgument;
        StringArgument stringArgument4;
        StringArgument stringArgument5;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(4);
        linkedHashSet.add(SCOPE_STRING_BASE);
        linkedHashSet.add(SCOPE_STRING_ONE);
        linkedHashSet.add(SCOPE_STRING_SUB);
        linkedHashSet.add(SCOPE_STRING_SUBORDINATE);
        String string = MessageHandler.getMessage(10486456);
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, string, false, true, 0, 0, "[filter] [attributes ...]");
        try {
            stringArgument5 = new StringArgument("ldiffile", Character.valueOf('l'), "ldifFile", false, true, true, "{ldifFile}", null, null, 10486174, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            stringArgument4 = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", "", null, 10486175, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            multiChoiceArgument = new MultiChoiceArgument("scope", Character.valueOf('s'), "scope", false, false, true, "{scope}", SCOPE_STRING_SUB, null, linkedHashSet, false, 0xA001A0, new Object[0]);
            argumentParser.addArgument(multiChoiceArgument);
            stringArgument3 = new StringArgument("configfile", Character.valueOf('c'), "configFile", false, false, true, "{configFile}", null, null, 0xA001A1, new Object[0]);
            stringArgument3.setHidden(true);
            argumentParser.addArgument(stringArgument3);
            stringArgument2 = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 10486178, new Object[0]);
            stringArgument2.setHidden(true);
            argumentParser.addArgument(stringArgument2);
            fileBasedArgument = new FileBasedArgument("filterfile", Character.valueOf('f'), "filterFile", false, false, "{filterFile}", null, null, 10486179, new Object[0]);
            argumentParser.addArgument(fileBasedArgument);
            stringArgument = new StringArgument("outputfile", Character.valueOf('o'), "outputFile", false, false, true, "{outputFile}", null, null, 10486180, new Object[0]);
            argumentParser.addArgument(stringArgument);
            booleanArgument3 = new BooleanArgument("overwriteexisting", Character.valueOf('O'), "overwriteExisting", 10486181, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            booleanArgument2 = new BooleanArgument("dontwrap", Character.valueOf('T'), "dontWrap", 10486182, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            integerArgument2 = new IntegerArgument("sizelimit", Character.valueOf('z'), "sizeLimit", false, false, true, "{sizeLimit}", 0, null, true, 0, false, 0, 10486183, new Object[0]);
            argumentParser.addArgument(integerArgument2);
            integerArgument = new IntegerArgument("timelimit", Character.valueOf('t'), "timeLimit", false, false, true, "{timeLimit}", 0, null, true, 0, false, 0, 10486184, new Object[0]);
            argumentParser.addArgument(integerArgument);
            booleanArgument = new BooleanArgument("help", Character.valueOf('H'), "help", 10486185, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            argumentParser.setUsageArgument(booleanArgument);
        }
        catch (ArgumentException argumentException) {
            int n2 = 10748330;
            String string2 = MessageHandler.getMessage(n2, argumentException.getMessage());
            System.err.println(string2);
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n3 = 10748331;
            String string3 = MessageHandler.getMessage(n3, argumentException.getMessage());
            System.err.println(string3);
            System.err.println(argumentParser.getUsage());
            return 89;
        }
        if (booleanArgument.isPresent()) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        if (fileBasedArgument.isPresent()) {
            linkedList = fileBasedArgument.getValues();
            arrayList = argumentParser.getTrailingArguments();
            if (arrayList == null || arrayList.isEmpty()) {
                linkedList2 = new LinkedList();
            } else {
                linkedList2 = new LinkedList();
                for (Object object522 : arrayList) {
                    object4 = StaticUtils.toLowerCase(object522);
                    if (((String)object4).equals("*")) {
                        bl = true;
                        continue;
                    }
                    if (((String)object4).equals("+")) {
                        bl2 = true;
                        continue;
                    }
                    if (((String)object4).startsWith("@")) {
                        linkedList3.add(((String)object4).substring(1));
                        continue;
                    }
                    linkedList2.add(object4);
                }
            }
        } else {
            arrayList = argumentParser.getTrailingArguments();
            if (arrayList == null || arrayList.isEmpty()) {
                int n4 = 10748332;
                String string4 = MessageHandler.getMessage(n4);
                System.err.println(string4);
                return 1;
            }
            Iterator<String> iterator = arrayList.iterator();
            linkedList = new LinkedList();
            linkedList.add(iterator.next());
            linkedList2 = new LinkedList();
            while (iterator.hasNext()) {
                object522 = StaticUtils.toLowerCase(iterator.next());
                if (object522.equals("*")) {
                    bl = true;
                    continue;
                }
                if (object522.equals("+")) {
                    bl2 = true;
                    continue;
                }
                if (object522.startsWith("@")) {
                    linkedList3.add(object522.substring(1));
                    continue;
                }
                linkedList2.add(object522);
            }
        }
        if (linkedList2.isEmpty() && linkedList3.isEmpty() && !bl2) {
            bl = true;
        }
        arrayList = DirectoryServer.getInstance();
        DirectoryServer.bootstrapClient();
        boolean bl3 = stringArgument3.isPresent();
        if (bl3) {
            try {
                DirectoryServer.initializeJMX();
            }
            catch (Exception exception) {
                int n5 = 10748346;
                String string5 = MessageHandler.getMessage(n5, String.valueOf(stringArgument3.getValue()), exception.getMessage());
                System.err.println(string5);
                return 1;
            }
            try {
                ((DirectoryServer)((Object)arrayList)).initializeConfiguration(stringArgument2.getValue(), stringArgument3.getValue());
            }
            catch (Exception exception) {
                int n6 = 10748333;
                String string6 = MessageHandler.getMessage(n6, String.valueOf(stringArgument3.getValue()), exception.getMessage());
                System.err.println(string6);
                return 1;
            }
            try {
                ((DirectoryServer)((Object)arrayList)).initializeSchema();
            }
            catch (Exception exception) {
                int n7 = 10748334;
                String string7 = MessageHandler.getMessage(n7, String.valueOf(stringArgument3.getValue()), exception.getMessage());
                System.err.println(string7);
                return 1;
            }
        }
        object522 = multiChoiceArgument.isPresent() ? (((String)(object4 = StaticUtils.toLowerCase(multiChoiceArgument.getValue()))).equals(SCOPE_STRING_BASE) ? SearchScope.BASE_OBJECT : (((String)object4).equals(SCOPE_STRING_ONE) ? SearchScope.SINGLE_LEVEL : (((String)object4).equals(SCOPE_STRING_SUBORDINATE) ? SearchScope.SUBORDINATE_SUBTREE : SearchScope.WHOLE_SUBTREE))) : SearchScope.WHOLE_SUBTREE;
        object4 = new LinkedList();
        for (String object32 : linkedList) {
            try {
                ((LinkedList)object4).add(SearchFilter.createFilterFromString(object32));
            }
            catch (Exception linkedList4) {
                int object6 = 10748335;
                String string2 = MessageHandler.getMessage(object6, object32, linkedList4.getMessage());
                System.err.println(string2);
                return 1;
            }
        }
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        LinkedHashSet<AttributeType> linkedHashSet3 = new LinkedHashSet<AttributeType>();
        for (String l2 : linkedList2) {
            AttributeType attributeType = DirectoryServer.getAttributeType(l2, true);
            if (attributeType.isOperational()) {
                linkedHashSet3.add(attributeType);
                continue;
            }
            linkedHashSet2.add(attributeType);
        }
        for (String string3 : linkedList3) {
            ObjectClass objectClass = DirectoryServer.getObjectClass(string3, true);
            for (AttributeType attributeType : objectClass.getRequiredAttributeChain()) {
                if (attributeType.isOperational()) {
                    linkedHashSet3.add(attributeType);
                    continue;
                }
                linkedHashSet2.add(attributeType);
            }
            for (AttributeType attributeType : objectClass.getOptionalAttributeChain()) {
                if (attributeType.isOperational()) {
                    linkedHashSet3.add(attributeType);
                    continue;
                }
                linkedHashSet2.add(attributeType);
            }
        }
        LinkedList linkedList4 = new LinkedList();
        if (stringArgument4.isPresent()) {
            for (String string4 : stringArgument4.getValues()) {
                try {
                    linkedList4.add(DN.decode(string4));
                }
                catch (Exception exception) {
                    int n2 = 10748336;
                    String string5 = MessageHandler.getMessage(n2, string4, exception.getMessage());
                    System.err.println(string5);
                    return 1;
                }
            }
        } else {
            linkedList4.add(DN.nullDN());
        }
        try {
            l = integerArgument.isPresent() ? 1000L * (long)integerArgument.getIntValue() : 0L;
        }
        catch (Exception exception) {
            int n3 = 10748337;
            String string6 = MessageHandler.getMessage(n3, String.valueOf(exception));
            System.err.println(string6);
            return 1;
        }
        try {
            n = integerArgument2.isPresent() ? integerArgument2.getIntValue() : 0;
        }
        catch (Exception exception) {
            int n4 = 10748338;
            String string7 = MessageHandler.getMessage(n4, String.valueOf(exception));
            System.err.println(string7);
            return 1;
        }
        if (stringArgument5.isPresent()) {
            LDIFImportConfig lDIFImportConfig = new LDIFImportConfig(stringArgument5.getValues());
        } else {
            LDIFImportConfig lDIFImportConfig = new LDIFImportConfig(System.in);
        }
        LDIFExportConfig lDIFExportConfig = stringArgument.isPresent() ? (booleanArgument3.isPresent() ? new LDIFExportConfig(stringArgument.getName(), ExistingFileBehavior.OVERWRITE) : new LDIFExportConfig(stringArgument.getName(), ExistingFileBehavior.APPEND)) : new LDIFExportConfig(System.out);
        if (booleanArgument2.isPresent()) {
            lDIFExportConfig.setWrapColumn(0);
        } else {
            lDIFExportConfig.setWrapColumn(75);
        }
        try {
            void var31_73;
            lDIFReader = new LDIFReader((LDIFImportConfig)var31_73);
        }
        catch (Exception exception) {
            int n5 = 10748339;
            String string8 = MessageHandler.getMessage(n5, String.valueOf(exception));
            System.err.println(string8);
            return 1;
        }
        try {
            lDIFWriter = new LDIFWriter(lDIFExportConfig);
        }
        catch (Exception exception) {
            try {
                lDIFReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            int n6 = 10748340;
            String string9 = MessageHandler.getMessage(n6, String.valueOf(exception));
            System.err.println(string9);
            return 1;
        }
        long l3 = System.currentTimeMillis();
        long l4 = l3 + l;
        long l5 = 0L;
        int n7 = 0;
        while (true) {
            Object object;
            int n8;
            if (l > 0L && System.currentTimeMillis() > l4) {
                n7 = 3;
                int n9 = 10551733;
                String string10 = MessageHandler.getMessage(n9);
                System.err.println(string10);
                break;
            }
            try {
                Object object2;
                Object object3;
                Entry entry = lDIFReader.readEntry(bl3);
                if (entry == null) break;
                n8 = 0;
                object = linkedList4.iterator();
                while (object.hasNext()) {
                    object3 = (DN)object.next();
                    if (!entry.matchesBaseAndScope((DN)object3, (SearchScope)((Object)object522))) continue;
                    n8 = 1;
                    break;
                }
                if (n8 == 0) continue;
                boolean bl4 = false;
                object3 = ((AbstractSequentialList)object4).iterator();
                while (object3.hasNext()) {
                    object2 = (SearchFilter)object3.next();
                    if (!((SearchFilter)object2).matchesEntry(entry)) continue;
                    bl4 = true;
                    break;
                }
                if (!bl4) continue;
                if (!bl) {
                    object3 = entry.getUserAttributes().keySet().iterator();
                    while (object3.hasNext()) {
                        if (linkedHashSet2.contains(object3.next())) continue;
                        object3.remove();
                    }
                }
                if (!bl2) {
                    object3 = entry.getOperationalAttributes().keySet().iterator();
                    while (object3.hasNext()) {
                        if (linkedHashSet3.contains(object3.next())) continue;
                        object3.remove();
                    }
                }
                lDIFWriter.writeEntry(entry);
                lDIFWriter.flush();
                if (n <= 0 || ++l5 <= (long)n) continue;
                n7 = 4;
                int n10 = 10551734;
                object2 = MessageHandler.getMessage(n10);
                System.err.println((String)object2);
            }
            catch (LDIFException lDIFException) {
                if (lDIFException.canContinueReading()) {
                    n8 = 10748343;
                    object = MessageHandler.getMessage(n8, lDIFException.getMessage());
                    System.err.println((String)object);
                    continue;
                }
                n8 = 10748344;
                object = MessageHandler.getMessage(n8, lDIFException.getMessage());
                System.err.println((String)object);
                n7 = 82;
            }
            catch (Exception exception) {
                n8 = 10748345;
                object = MessageHandler.getMessage(n8, String.valueOf(exception));
                System.err.println((String)object);
                n7 = 82;
            }
            break;
        }
        try {
            lDIFReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lDIFWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n7;
    }
}

