/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.controls.AccountUsableResponseControl;
import org.opends.server.controls.EntryChangeNotificationControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.MatchedValuesFilter;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPSearchOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPSearch {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPSearch";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPSearch(AtomicInteger atomicInteger, PrintStream printStream, PrintStream printStream2) {
        this.nextMessageID = atomicInteger;
        this.out = printStream;
        this.err = printStream2;
    }

    public void executeSearch(LDAPConnection lDAPConnection, String string, ArrayList<LDAPFilter> arrayList, LinkedHashSet<String> linkedHashSet, LDAPSearchOptions lDAPSearchOptions, int n) throws IOException, LDAPException {
        for (LDAPFilter lDAPFilter : arrayList) {
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            SearchRequestProtocolOp searchRequestProtocolOp = new SearchRequestProtocolOp(aSN1OctetString, lDAPSearchOptions.getSearchScope(), lDAPSearchOptions.getDereferencePolicy(), lDAPSearchOptions.getSizeLimit(), lDAPSearchOptions.getTimeLimit(), false, lDAPFilter, linkedHashSet);
            try {
                byte by;
                boolean bl = lDAPSearchOptions.getTypesOnly();
                LDAPMessage lDAPMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), searchRequestProtocolOp, lDAPSearchOptions.getControls());
                lDAPConnection.getASN1Writer().writeElement(lDAPMessage.encode());
                do {
                    int n2 = 0;
                    String string2 = null;
                    ASN1Element aSN1Element = lDAPConnection.getASN1Reader().readElement();
                    LDAPMessage lDAPMessage2 = LDAPMessage.decode(ASN1Sequence.decodeAsSequence(aSN1Element));
                    ArrayList<LDAPControl> arrayList2 = lDAPMessage2.getControls();
                    by = lDAPMessage2.getProtocolOpType();
                    switch (by) {
                        case 100: {
                            String string3;
                            Object exception;
                            for (LDAPControl lDAPControl : arrayList2) {
                                int n3;
                                if (lDAPControl.getOID().equals("2.16.840.1.113730.3.4.7")) {
                                    try {
                                        exception = EntryChangeNotificationControl.decodeControl(lDAPControl.getControl());
                                        n3 = 10486468;
                                        this.out.println(MessageHandler.getMessage(n3, ((EntryChangeNotificationControl)exception).getChangeType().toString()));
                                        DN n5 = ((EntryChangeNotificationControl)exception).getPreviousDN();
                                        if (n5 == null) continue;
                                        n3 = 10486469;
                                        this.out.println(MessageHandler.getMessage(n3, n5.toString()));
                                    }
                                    catch (Exception exception2) {}
                                    continue;
                                }
                                if (!lDAPControl.getOID().equals("1.3.6.1.4.1.42.2.27.9.5.8")) continue;
                                try {
                                    exception = AccountUsableResponseControl.decodeControl(lDAPControl.getControl());
                                    n3 = 10486470;
                                    this.out.println(MessageHandler.getMessage(n3));
                                    if (((AccountUsableResponseControl)exception).isUsable()) {
                                        n3 = 10486471;
                                        this.out.println(MessageHandler.getMessage(n3));
                                        if (((AccountUsableResponseControl)exception).getSecondsBeforeExpiration() <= 0) continue;
                                        int n6 = ((AccountUsableResponseControl)exception).getSecondsBeforeExpiration();
                                        string3 = StaticUtils.secondsToTimeString(n6);
                                        n3 = 10486472;
                                        this.out.println(MessageHandler.getMessage(n3, string3));
                                        continue;
                                    }
                                    n3 = 10486473;
                                    this.out.println(MessageHandler.getMessage(n3));
                                    if (((AccountUsableResponseControl)exception).isInactive()) {
                                        n3 = 10486474;
                                        this.out.println(MessageHandler.getMessage(n3));
                                    }
                                    if (((AccountUsableResponseControl)exception).isReset()) {
                                        n3 = 10486475;
                                        this.out.println(MessageHandler.getMessage(n3));
                                    }
                                    if (((AccountUsableResponseControl)exception).isExpired()) {
                                        n3 = 10486476;
                                        this.out.println(MessageHandler.getMessage(n3));
                                        if (((AccountUsableResponseControl)exception).getRemainingGraceLogins() > 0) {
                                            n3 = 10486477;
                                            this.out.println(MessageHandler.getMessage(n3, ((AccountUsableResponseControl)exception).getRemainingGraceLogins()));
                                        }
                                    }
                                    if (!((AccountUsableResponseControl)exception).isLocked()) continue;
                                    n3 = 10486478;
                                    this.out.println(MessageHandler.getMessage(n3));
                                    if (((AccountUsableResponseControl)exception).getSecondsBeforeUnlock() <= 0) continue;
                                    int n4 = ((AccountUsableResponseControl)exception).getSecondsBeforeUnlock();
                                    string3 = StaticUtils.secondsToTimeString(n4);
                                    n3 = 10486479;
                                    this.out.println(MessageHandler.getMessage(n3, string3));
                                }
                                catch (Exception exception3) {}
                            }
                            SearchResultEntryProtocolOp searchResultEntryProtocolOp = lDAPMessage2.getSearchResultEntryProtocolOp();
                            StringBuilder object22 = new StringBuilder();
                            this.toLDIF(searchResultEntryProtocolOp, object22, n, bl);
                            this.out.println(object22.toString());
                            break;
                        }
                        case 115: {
                            Object exception = lDAPMessage2.getSearchResultReferenceProtocolOp();
                            this.out.println(((ProtocolOp)exception).toString());
                            break;
                        }
                        case 101: {
                            SearchResultDoneProtocolOp searchResultDoneProtocolOp = lDAPMessage2.getSearchResultDoneProtocolOp();
                            n2 = searchResultDoneProtocolOp.getResultCode();
                            string2 = searchResultDoneProtocolOp.getErrorMessage();
                            break;
                        }
                        default: {
                            int n5 = 10485870;
                            String string3 = MessageHandler.getMessage(n5, by);
                            this.err.println(StaticUtils.wrapText(string3, 79));
                        }
                    }
                    if (n2 != 0 && n2 != 10) {
                        int n7 = 10485865;
                        if (string2 == null) {
                            string2 = "Result Code:" + n2;
                        }
                        throw new LDAPException(n2, n7, string2);
                    }
                    if (string2 == null) continue;
                    this.out.println();
                    this.out.println(StaticUtils.wrapText(string2, 79));
                } while (by != 101);
            }
            catch (ASN1Exception aSN1Exception) {
                assert (Debug.debugException(CLASS_NAME, "executeSearch", aSN1Exception));
                throw new IOException(aSN1Exception.getMessage());
            }
        }
    }

    public void toLDIF(SearchResultEntryProtocolOp searchResultEntryProtocolOp, StringBuilder stringBuilder, int n, boolean bl) {
        int n2;
        String string = searchResultEntryProtocolOp.getDN().toString();
        if (StaticUtils.needsBase64Encoding(string)) {
            string = Base64.encode(StaticUtils.getBytes(string));
            stringBuilder.append("dn:: ");
            n2 = n - 5;
        } else {
            stringBuilder.append("dn: ");
            n2 = n - 4;
        }
        int n3 = string.length();
        if (n3 <= n2 || n2 <= 0) {
            stringBuilder.append(string);
            stringBuilder.append(ServerConstants.EOL);
        } else {
            stringBuilder.append(string.substring(0, n2));
            stringBuilder.append(ServerConstants.EOL);
            int n4 = n2;
            while (n3 - n4 > n - 1) {
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n4, n4 + n - 1));
                stringBuilder.append(ServerConstants.EOL);
                n4 += n - 1;
            }
            if (n4 < n3) {
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n4));
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        LinkedList<LDAPAttribute> linkedList = searchResultEntryProtocolOp.getAttributes();
        for (LDAPAttribute lDAPAttribute : linkedList) {
            String string2 = lDAPAttribute.getAttributeType();
            int n5 = string2.length();
            if (bl) {
                stringBuilder.append(string2);
                stringBuilder.append(ServerConstants.EOL);
                continue;
            }
            for (ASN1OctetString aSN1OctetString : lDAPAttribute.getValues()) {
                String string3;
                if (StaticUtils.needsBase64Encoding(aSN1OctetString.value())) {
                    string3 = Base64.encode(aSN1OctetString.value());
                    stringBuilder.append(string2);
                    stringBuilder.append(":: ");
                    n2 = n - n5 - 3;
                } else {
                    string3 = aSN1OctetString.stringValue();
                    stringBuilder.append(string2);
                    stringBuilder.append(": ");
                    n2 = n - n5 - 2;
                }
                int n6 = string3.length();
                if (n6 <= n2 || n2 <= 0) {
                    stringBuilder.append(string3);
                    stringBuilder.append(ServerConstants.EOL);
                    continue;
                }
                stringBuilder.append(string3.substring(0, n2));
                stringBuilder.append(ServerConstants.EOL);
                int n7 = n2;
                while (n6 - n7 > n - 1) {
                    stringBuilder.append(" ");
                    stringBuilder.append(string3.substring(n7, n7 + n - 1));
                    stringBuilder.append(ServerConstants.EOL);
                    n7 += n - 1;
                }
                if (n7 >= n6) continue;
                stringBuilder.append(" ");
                stringBuilder.append(string3.substring(n7));
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append(ServerConstants.EOL);
    }

    public static void main(String[] stringArray) {
        int n = LDAPSearch.mainSearch(stringArray, true, System.out, System.err);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int mainSearch(String[] stringArray) {
        return LDAPSearch.mainSearch(stringArray, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static int mainSearch(String[] stringArray, boolean bl, OutputStream outputStream, OutputStream outputStream2) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string2;
        PrintStream printStream = outputStream == null ? NullOutputStream.printStream() : new PrintStream(outputStream);
        PrintStream printStream2 = outputStream2 == null ? NullOutputStream.printStream() : new PrintStream(outputStream2);
        LDAPConnectionOptions lDAPConnectionOptions = new LDAPConnectionOptions();
        LDAPSearchOptions lDAPSearchOptions = new LDAPSearchOptions();
        LDAPConnection lDAPConnection = null;
        ArrayList<LDAPFilter> arrayList = new ArrayList<LDAPFilter>();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        BooleanArgument booleanArgument = null;
        BooleanArgument booleanArgument2 = null;
        BooleanArgument booleanArgument3 = null;
        BooleanArgument booleanArgument4 = null;
        BooleanArgument booleanArgument5 = null;
        BooleanArgument booleanArgument6 = null;
        BooleanArgument booleanArgument7 = null;
        BooleanArgument booleanArgument8 = null;
        BooleanArgument booleanArgument9 = null;
        BooleanArgument booleanArgument10 = null;
        BooleanArgument booleanArgument11 = null;
        BooleanArgument booleanArgument12 = null;
        FileBasedArgument fileBasedArgument = null;
        FileBasedArgument fileBasedArgument2 = null;
        FileBasedArgument fileBasedArgument3 = null;
        IntegerArgument integerArgument = null;
        IntegerArgument integerArgument2 = null;
        IntegerArgument integerArgument3 = null;
        IntegerArgument integerArgument4 = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        StringArgument stringArgument3 = null;
        StringArgument stringArgument4 = null;
        StringArgument stringArgument5 = null;
        StringArgument stringArgument6 = null;
        StringArgument stringArgument7 = null;
        StringArgument stringArgument8 = null;
        StringArgument stringArgument9 = null;
        StringArgument stringArgument10 = null;
        StringArgument stringArgument11 = null;
        StringArgument stringArgument12 = null;
        StringArgument stringArgument13 = null;
        StringArgument stringArgument14 = null;
        StringArgument stringArgument15 = null;
        StringArgument stringArgument16 = null;
        StringArgument stringArgument17 = null;
        StringArgument stringArgument18 = null;
        String string3 = MessageHandler.getMessage(10486453);
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, string3, false, true, 0, 0, "[filter] [attributes ...]");
        try {
            stringArgument9 = new StringArgument("host", Character.valueOf('h'), "host", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
            argumentParser.addArgument(stringArgument9);
            integerArgument = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
            argumentParser.addArgument(integerArgument);
            booleanArgument9 = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
            argumentParser.addArgument(booleanArgument9);
            booleanArgument10 = new BooleanArgument("startTLS", Character.valueOf('q'), "startTLS", 10485886, new Object[0]);
            argumentParser.addArgument(booleanArgument10);
            stringArgument3 = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 0xA00070, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            stringArgument4 = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            fileBasedArgument = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFilename}", null, null, 10485874, new Object[0]);
            argumentParser.addArgument(fileBasedArgument);
            stringArgument2 = new StringArgument("baseDN", Character.valueOf('b'), "baseDN", true, false, true, "{baseDN}", null, null, 10485891, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument16 = new StringArgument("searchScope", Character.valueOf('s'), "searchScope", false, false, true, "{searchScope}", null, null, 10485894, new Object[0]);
            argumentParser.addArgument(stringArgument16);
            stringArgument8 = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, "{filename}", null, null, 10486123, new Object[0]);
            argumentParser.addArgument(stringArgument8);
            booleanArgument5 = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", 10485887, new Object[0]);
            argumentParser.addArgument(booleanArgument5);
            stringArgument15 = new StringArgument("saslOptions", Character.valueOf('o'), "saslOptions", false, true, true, "{name=value}", null, null, 10485942, new Object[0]);
            argumentParser.addArgument(stringArgument15);
            booleanArgument7 = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
            argumentParser.addArgument(booleanArgument7);
            stringArgument10 = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
            argumentParser.addArgument(stringArgument10);
            stringArgument11 = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
            argumentParser.addArgument(stringArgument11);
            fileBasedArgument2 = new FileBasedArgument("keystorepasswordfile", null, "keyStorePasswordFile", false, false, "{path}", null, null, 10486480, new Object[0]);
            argumentParser.addArgument(fileBasedArgument2);
            stringArgument17 = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
            argumentParser.addArgument(stringArgument17);
            stringArgument18 = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486481, new Object[0]);
            argumentParser.addArgument(stringArgument18);
            fileBasedArgument3 = new FileBasedArgument("truststorepasswordfile", null, "trustStorePasswordFile", false, false, "{path}", null, null, 10486482, new Object[0]);
            argumentParser.addArgument(fileBasedArgument3);
            stringArgument13 = new StringArgument("proxy_authzid", Character.valueOf('Y'), "proxyAs", false, false, true, "{authzID}", null, null, 10486114, new Object[0]);
            argumentParser.addArgument(stringArgument13);
            booleanArgument4 = new BooleanArgument("reportauthzid", Character.valueOf('E'), "reportAuthzID", 10486121, new Object[0]);
            argumentParser.addArgument(booleanArgument4);
            booleanArgument8 = new BooleanArgument("usepwpolicycontrol", null, "usePasswordPolicyControl", 10486171, new Object[0]);
            argumentParser.addArgument(booleanArgument8);
            stringArgument14 = new StringArgument("psearchinfo", Character.valueOf('C'), "persistentSearch", false, false, true, "ps[:changetype[:changesonly[:entrychgcontrols]]]", null, null, 10486115, new Object[0]);
            argumentParser.addArgument(stringArgument14);
            stringArgument = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, "{filter}", null, null, 10486102, new Object[0]);
            argumentParser.addArgument(stringArgument);
            stringArgument12 = new StringArgument("matchedvalues", null, "matchedValuesFilter", false, true, true, "{filter}", null, null, 10486124, new Object[0]);
            argumentParser.addArgument(stringArgument12);
            stringArgument5 = new StringArgument("controls", Character.valueOf('J'), "controls", false, false, true, "{controloid[:criticality[:value|::b64value|:<fileurl]]}", null, null, 10485883, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            integerArgument4 = new IntegerArgument("version", Character.valueOf('V'), "version", false, false, true, "{version}", 3, null, 10485960, new Object[0]);
            argumentParser.addArgument(integerArgument4);
            stringArgument7 = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, "{encoding}", null, null, 10485875, new Object[0]);
            argumentParser.addArgument(stringArgument7);
            stringArgument6 = new StringArgument("derefpolicy", Character.valueOf('a'), "dereferencePolicy", false, false, true, "{dereferencePolicy}", null, null, 10485895, new Object[0]);
            argumentParser.addArgument(stringArgument6);
            booleanArgument11 = new BooleanArgument("typesOnly", Character.valueOf('A'), "typesOnly", 10486098, new Object[0]);
            argumentParser.addArgument(booleanArgument11);
            integerArgument2 = new IntegerArgument("sizeLimit", Character.valueOf('z'), "sizeLimit", false, false, true, "{sizeLimit}", 0, null, 10485892, new Object[0]);
            argumentParser.addArgument(integerArgument2);
            integerArgument3 = new IntegerArgument("timeLimit", Character.valueOf('l'), "timeLimit", false, false, true, "{timeLimit}", 0, null, 10485893, new Object[0]);
            argumentParser.addArgument(integerArgument3);
            booleanArgument2 = new BooleanArgument("dontwrap", Character.valueOf('T'), "dontWrap", 10485975, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            booleanArgument = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", 10485884, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            booleanArgument3 = new BooleanArgument("noop", Character.valueOf('n'), "noop", 10486087, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            booleanArgument12 = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            argumentParser.addArgument(booleanArgument12);
            booleanArgument6 = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
            argumentParser.addArgument(booleanArgument6);
            argumentParser.setUsageArgument(booleanArgument6, printStream);
        }
        catch (ArgumentException argumentException) {
            int n = 10747920;
            String string4 = MessageHandler.getMessage(n, argumentException.getMessage());
            printStream2.println(StaticUtils.wrapText(string4, 79));
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n = 10747921;
            String string5 = MessageHandler.getMessage(n, argumentException.getMessage());
            printStream2.println(StaticUtils.wrapText(string5, 79));
            printStream2.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument6.isPresent()) {
            return 0;
        }
        ArrayList<String> arrayList2 = argumentParser.getTrailingArguments();
        if (arrayList2.size() > 0) {
            string2 = arrayList2.remove(0);
            try {
                arrayList.add(LDAPFilter.decode(string2));
            }
            catch (LDAPException lDAPException) {
                assert (Debug.debugException(CLASS_NAME, "main", lDAPException));
                printStream2.println(StaticUtils.wrapText(lDAPException.getMessage(), 79));
                return 1;
            }
            for (String string6 : arrayList2) {
                linkedHashSet.add(string6);
            }
        }
        if (stringArgument4.isPresent() && fileBasedArgument.isPresent()) {
            int n = 10748606;
            object5 = MessageHandler.getMessage(n, stringArgument4.getLongIdentifier(), fileBasedArgument.getLongIdentifier());
            printStream2.println(StaticUtils.wrapText((String)object5, 79));
            return 1;
        }
        if (booleanArgument9.isPresent() && booleanArgument10.isPresent()) {
            int n = 10748606;
            object5 = MessageHandler.getMessage(n, booleanArgument9.getLongIdentifier(), booleanArgument10.getLongIdentifier());
            printStream2.println(StaticUtils.wrapText((String)object5, 79));
            return 1;
        }
        if (stringArgument11.isPresent() && fileBasedArgument2.isPresent()) {
            int n = 10748606;
            object5 = MessageHandler.getMessage(n, stringArgument11.getLongIdentifier(), fileBasedArgument2.getLongIdentifier());
            printStream2.println(StaticUtils.wrapText((String)object5, 79));
            return 1;
        }
        if (stringArgument18.isPresent() && fileBasedArgument3.isPresent()) {
            int n = 10748606;
            object5 = MessageHandler.getMessage(n, stringArgument18.getLongIdentifier(), fileBasedArgument3.getLongIdentifier());
            printStream2.println(StaticUtils.wrapText((String)object5, 79));
            return 1;
        }
        string2 = stringArgument9.getValue();
        int n = 389;
        try {
            n = integerArgument.getIntValue();
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            return 1;
        }
        try {
            int n2 = integerArgument4.getIntValue();
            if (n2 != 2 && n2 != 3) {
                int n3 = 10682569;
                printStream2.println(StaticUtils.wrapText(MessageHandler.getMessage(n3, n2), 79));
                return 1;
            }
            lDAPConnectionOptions.setVersionNumber(n2);
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            return 1;
        }
        lDAPConnectionOptions.setReportAuthzID(booleanArgument4.isPresent());
        lDAPConnectionOptions.setUsePasswordPolicyControl(booleanArgument8.isPresent());
        String string7 = stringArgument2.getValue();
        String string8 = stringArgument3.getValue();
        String string9 = stringArgument8.getValue();
        String string10 = stringArgument4.getValue();
        if (string10 != null && string10.equals("-")) {
            try {
                printStream.print(MessageHandler.getMessage(10485959, string8));
                object4 = PasswordReader.readPassword();
                string10 = new String((char[])object4);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "main", exception));
                printStream2.println(StaticUtils.wrapText(exception.getMessage(), 79));
                return 1;
            }
        } else if (string10 == null) {
            string10 = fileBasedArgument.getValue();
        }
        object4 = stringArgument10.getValue();
        String string11 = stringArgument17.getValue();
        String string12 = null;
        if (stringArgument11.isPresent()) {
            string12 = stringArgument11.getValue();
        } else if (fileBasedArgument2.isPresent()) {
            string12 = fileBasedArgument2.getValue();
        }
        String string13 = null;
        if (stringArgument18.isPresent()) {
            string13 = stringArgument18.getValue();
        } else if (fileBasedArgument3.isPresent()) {
            string13 = fileBasedArgument3.getValue();
        }
        lDAPSearchOptions.setTypesOnly(booleanArgument11.isPresent());
        lDAPSearchOptions.setShowOperations(booleanArgument3.isPresent());
        lDAPSearchOptions.setVerbose(booleanArgument12.isPresent());
        lDAPSearchOptions.setContinueOnError(booleanArgument.isPresent());
        lDAPSearchOptions.setEncoding(stringArgument7.getValue());
        try {
            lDAPSearchOptions.setTimeLimit(integerArgument3.getIntValue());
            lDAPSearchOptions.setSizeLimit(integerArgument2.getIntValue());
        }
        catch (ArgumentException argumentException) {
            printStream2.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            return 1;
        }
        boolean bl3 = lDAPSearchOptions.setSearchScope(stringArgument16.getValue(), printStream2);
        if (!bl3) {
            return 1;
        }
        bl3 = lDAPSearchOptions.setDereferencePolicy(stringArgument6.getValue(), printStream2);
        if (!bl3) {
            return 1;
        }
        if (stringArgument5.hasValue()) {
            object3 = stringArgument5.getValue();
            object2 = LDAPToolUtils.getControl((String)object3, printStream2);
            if (object2 == null) {
                int n4 = 10748609;
                String string14 = MessageHandler.getMessage(n4, object3);
                printStream2.println(StaticUtils.wrapText(string14, 79));
                printStream2.println(argumentParser.getUsage());
                return 1;
            }
            lDAPSearchOptions.getControls().add((LDAPControl)object2);
        }
        if (stringArgument13.isPresent()) {
            object3 = new ASN1OctetString(stringArgument13.getValue());
            object2 = new LDAPControl("2.16.840.1.113730.3.4.18", true, (ASN1OctetString)object3);
            lDAPSearchOptions.getControls().add((LDAPControl)object2);
        }
        if (stringArgument14.isPresent()) {
            void iOException;
            object3 = StaticUtils.toLowerCase(stringArgument14.getValue().trim());
            object2 = new HashSet();
            boolean bl4 = true;
            boolean bl2 = true;
            object = new StringTokenizer((String)object3, ":");
            if (!((StringTokenizer)object).hasMoreTokens()) {
                int n2 = 10682724;
                String n9 = MessageHandler.getMessage(n2);
                printStream2.println(StaticUtils.wrapText(n9, 79));
                return 1;
            }
            Object object6 = ((StringTokenizer)object).nextToken();
            if (!((String)object6).equals("ps")) {
                int n3 = 10682725;
                String string4 = MessageHandler.getMessage(n3, String.valueOf(object3));
                printStream2.println(StaticUtils.wrapText(string4, 79));
                return 1;
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                object6 = new StringTokenizer(((StringTokenizer)object).nextToken(), ", ");
                while (((StringTokenizer)object6).hasMoreTokens()) {
                    string = ((StringTokenizer)object6).nextToken();
                    if (string.equals("add")) {
                        ((HashSet)object2).add(PersistentSearchChangeType.ADD);
                        continue;
                    }
                    if (string.equals("delete") || string.equals("del")) {
                        ((HashSet)object2).add(PersistentSearchChangeType.DELETE);
                        continue;
                    }
                    if (string.equals("modify") || string.equals("mod")) {
                        ((HashSet)object2).add(PersistentSearchChangeType.MODIFY);
                        continue;
                    }
                    if (string.equals("modifydn") || string.equals("moddn") || string.equals("modrdn")) {
                        ((HashSet)object2).add(PersistentSearchChangeType.MODIFY_DN);
                        continue;
                    }
                    if (string.equals("any") || string.equals("all")) {
                        ((HashSet)object2).add(PersistentSearchChangeType.ADD);
                        ((HashSet)object2).add(PersistentSearchChangeType.DELETE);
                        ((HashSet)object2).add(PersistentSearchChangeType.MODIFY);
                        ((HashSet)object2).add(PersistentSearchChangeType.MODIFY_DN);
                        continue;
                    }
                    int n4 = 10682726;
                    String string5 = MessageHandler.getMessage(n4, String.valueOf(string));
                    printStream2.println(StaticUtils.wrapText(string5, 79));
                    return 1;
                }
            }
            if (((HashSet)object2).isEmpty()) {
                ((HashSet)object2).add(PersistentSearchChangeType.ADD);
                ((HashSet)object2).add(PersistentSearchChangeType.DELETE);
                ((HashSet)object2).add(PersistentSearchChangeType.MODIFY);
                ((HashSet)object2).add(PersistentSearchChangeType.MODIFY_DN);
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                object6 = ((StringTokenizer)object).nextToken();
                if (((String)object6).equals("1") || ((String)object6).equals("true") || ((String)object6).equals("yes")) {
                    bl4 = true;
                } else if (((String)object6).equals("0") || ((String)object6).equals("false") || ((String)object6).equals("no")) {
                    bl4 = false;
                } else {
                    int n5 = 10682727;
                    String string6 = MessageHandler.getMessage(n5, String.valueOf(object6));
                    printStream2.println(StaticUtils.wrapText(string6, 79));
                    return 1;
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                object6 = ((StringTokenizer)object).nextToken();
                if (((String)object6).equals("1") || ((String)object6).equals("true") || ((String)object6).equals("yes")) {
                    boolean string20 = true;
                } else if (((String)object6).equals("0") || ((String)object6).equals("false") || ((String)object6).equals("no")) {
                    boolean bl5 = false;
                } else {
                    int n6 = 10682728;
                    String string14 = MessageHandler.getMessage(n6, String.valueOf(object6));
                    printStream2.println(StaticUtils.wrapText(string14, 79));
                    return 1;
                }
            }
            object6 = new PersistentSearchControl((Set<PersistentSearchChangeType>)object2, bl4, (boolean)iOException);
            lDAPSearchOptions.getControls().add(new LDAPControl((Control)object6));
        }
        if (stringArgument.isPresent()) {
            object3 = stringArgument.getValue();
            try {
                object2 = LDAPFilter.decode((String)object3);
                LDAPControl lDAPControl = new LDAPControl("1.3.6.1.1.12", true, new ASN1OctetString(((LDAPFilter)object2).encode().encode()));
                lDAPSearchOptions.getControls().add(lDAPControl);
            }
            catch (LDAPException lDAPException) {
                int lDAPSearch = 10682711;
                object = MessageHandler.getMessage(lDAPSearch, lDAPException.getMessage());
                printStream2.println(StaticUtils.wrapText((String)object, 79));
                return 1;
            }
        }
        if (stringArgument12.isPresent()) {
            object3 = stringArgument12.getValues();
            object2 = new ArrayList();
            Object object7 = ((AbstractSequentialList)object3).iterator();
            while (object7.hasNext()) {
                String n17 = (String)object7.next();
                try {
                    object = LDAPFilter.decode(n17);
                    ((ArrayList)object2).add(MatchedValuesFilter.createFromLDAPFilter((LDAPFilter)object));
                }
                catch (LDAPException lDAPException) {
                    int n7 = 10682733;
                    string = MessageHandler.getMessage(n7, lDAPException.getMessage());
                    printStream2.println(StaticUtils.wrapText(string, 79));
                    return 1;
                }
            }
            object7 = new MatchedValuesControl(true, (ArrayList<MatchedValuesFilter>)object2);
            lDAPSearchOptions.getControls().add(new LDAPControl((Control)object7));
        }
        lDAPConnectionOptions.setSASLExternal(booleanArgument5.isPresent());
        if (stringArgument15.isPresent()) {
            object3 = stringArgument15.getValues();
            object2 = ((AbstractSequentialList)object3).iterator();
            while (object2.hasNext()) {
                boolean n19;
                String string21 = (String)object2.next();
                if (!(string21.startsWith("mech=") ? !(n19 = lDAPConnectionOptions.setSASLMechanism(string21)) : !(n19 = lDAPConnectionOptions.addSASLProperty(string21)))) continue;
                return 1;
            }
        }
        lDAPConnectionOptions.setUseSSL(booleanArgument9.isPresent());
        lDAPConnectionOptions.setStartTLS(booleanArgument10.isPresent());
        if (lDAPConnectionOptions.useSASLExternal()) {
            if (!lDAPConnectionOptions.useSSL() && !lDAPConnectionOptions.useStartTLS()) {
                int n11 = 10748610;
                object2 = MessageHandler.getMessage(n11);
                printStream2.println(StaticUtils.wrapText((String)object2, 79));
                return 1;
            }
            if (object4 == null) {
                int n12 = 10748611;
                object2 = MessageHandler.getMessage(n12);
                printStream2.println(StaticUtils.wrapText((String)object2, 79));
                return 1;
            }
        }
        if (string9 != null) {
            object3 = null;
            try {
                object3 = new BufferedReader(new FileReader(string9));
                object2 = null;
                while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                    if (((String)object2).trim().equals("")) continue;
                    LDAPFilter lDAPFilter = LDAPFilter.decode((String)object2);
                    arrayList.add(lDAPFilter);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "main", exception));
                printStream2.println(StaticUtils.wrapText(exception.getMessage(), 79));
                int n13 = 1;
                return n13;
            }
            finally {
                if (object3 != null) {
                    try {
                        ((BufferedReader)object3).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (arrayList.isEmpty()) {
            int n14 = 10748110;
            printStream2.println(StaticUtils.wrapText(MessageHandler.getMessage(n14), 79));
            printStream2.println(argumentParser.getUsage());
            return 1;
        }
        int n15 = 80;
        if (booleanArgument2.isPresent()) {
            n15 = 0;
        }
        try {
            if (bl) {
                DirectoryServer.bootstrapClient();
            }
            object2 = null;
            if (lDAPConnectionOptions.useSSL() || lDAPConnectionOptions.useStartTLS()) {
                object2 = new SSLConnectionFactory();
                ((SSLConnectionFactory)object2).init(booleanArgument7.isPresent(), (String)object4, string12, string11, string13);
                lDAPConnectionOptions.setSSLConnectionFactory((SSLConnectionFactory)object2);
            }
            AtomicInteger atomicInteger = new AtomicInteger(1);
            lDAPConnection = new LDAPConnection(string2, n, lDAPConnectionOptions, printStream, printStream2);
            lDAPConnection.connectToHost(string8, string10, atomicInteger);
            LDAPSearch lDAPSearch = new LDAPSearch(atomicInteger, printStream, printStream2);
            lDAPSearch.executeSearch(lDAPConnection, string7, arrayList, linkedHashSet, lDAPSearchOptions, n15);
        }
        catch (LDAPException lDAPException) {
            int n16;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPException));
            printStream2.println(StaticUtils.wrapText(lDAPException.getMessage(), 79));
            int n8 = n16 = lDAPException.getResultCode();
            return n8;
        }
        catch (LDAPConnectionException lDAPConnectionException) {
            int n18;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPConnectionException));
            printStream2.println(StaticUtils.wrapText(lDAPConnectionException.getMessage(), 79));
            int n9 = n18 = lDAPConnectionException.getErrorCode();
            return n9;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "main", exception));
            printStream2.println(StaticUtils.wrapText(exception.getMessage(), 79));
            int n20 = 1;
            return n20;
        }
        finally {
            if (lDAPConnection != null) {
                lDAPConnection.close();
            }
        }
        return 0;
    }
}

