/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPDeleteOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPDelete {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPDelete";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPDelete(AtomicInteger atomicInteger, PrintStream printStream, PrintStream printStream2) {
        this.nextMessageID = atomicInteger;
        this.out = printStream;
        this.err = printStream2;
    }

    public void readAndExecute(LDAPConnection lDAPConnection, ArrayList<String> arrayList, LDAPDeleteOptions lDAPDeleteOptions) throws IOException, LDAPException {
        for (String string : arrayList) {
            this.executeDelete(lDAPConnection, string, lDAPDeleteOptions);
        }
    }

    public void readAndExecute(LDAPConnection lDAPConnection, Reader reader, LDAPDeleteOptions lDAPDeleteOptions) throws IOException, LDAPException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            this.executeDelete(lDAPConnection, string, lDAPDeleteOptions);
        }
        bufferedReader.close();
    }

    private void executeDelete(LDAPConnection lDAPConnection, String string, LDAPDeleteOptions lDAPDeleteOptions) throws IOException, LDAPException {
        ArrayList<LDAPControl> arrayList = lDAPDeleteOptions.getControls();
        DeleteRequestProtocolOp deleteRequestProtocolOp = null;
        ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
        deleteRequestProtocolOp = new DeleteRequestProtocolOp(aSN1OctetString);
        int n = 10485864;
        this.out.println(MessageHandler.getMessage(n, "DELETE", aSN1OctetString));
        if (!lDAPDeleteOptions.showOperations()) {
            LDAPMessage lDAPMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), deleteRequestProtocolOp, arrayList);
            LDAPMessage lDAPMessage2 = null;
            try {
                int n2 = lDAPConnection.getASN1Writer().writeElement(lDAPMessage.encode());
                ASN1Element aSN1Element = lDAPConnection.getASN1Reader().readElement();
                lDAPMessage2 = LDAPMessage.decode(ASN1Sequence.decodeAsSequence(aSN1Element));
            }
            catch (ASN1Exception aSN1Exception) {
                assert (Debug.debugException(CLASS_NAME, "executeDelete", aSN1Exception));
                if (!lDAPDeleteOptions.continueOnError()) {
                    throw new IOException(aSN1Exception.getMessage());
                }
                n = 10485865;
                String string2 = MessageHandler.getMessage(n, "DELETE", string, aSN1Exception.getMessage());
                this.err.println(StaticUtils.wrapText(string2, 79));
                return;
            }
            DeleteResponseProtocolOp deleteResponseProtocolOp = lDAPMessage2.getDeleteResponseProtocolOp();
            int n3 = deleteResponseProtocolOp.getResultCode();
            String string3 = deleteResponseProtocolOp.getErrorMessage();
            if (n3 != 0 && n3 != 10 && !lDAPDeleteOptions.continueOnError()) {
                n = 10485865;
                String string4 = MessageHandler.getMessage(n, "DELETE", string, string3);
                throw new LDAPException(n3, n, string4);
            }
            if (n3 != 0 && n3 != 10) {
                n = 10485865;
                String string5 = MessageHandler.getMessage(n, "DELETE", string, string3);
                this.err.println(StaticUtils.wrapText(string5, 79));
            } else {
                n = 0xA0006A;
                String string6 = MessageHandler.getMessage(n, "DELETE", string);
                this.out.println(string6);
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = LDAPDelete.mainDelete(stringArray, true, System.out, System.err);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int mainDelete(String[] stringArray) {
        return LDAPDelete.mainDelete(stringArray, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainDelete(String[] stringArray, boolean bl, OutputStream outputStream, OutputStream outputStream2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        PrintStream printStream = outputStream == null ? NullOutputStream.printStream() : new PrintStream(outputStream);
        PrintStream printStream2 = outputStream2 == null ? NullOutputStream.printStream() : new PrintStream(outputStream2);
        LDAPConnectionOptions lDAPConnectionOptions = new LDAPConnectionOptions();
        LDAPDeleteOptions lDAPDeleteOptions = new LDAPDeleteOptions();
        LDAPConnection lDAPConnection = null;
        BooleanArgument booleanArgument = null;
        BooleanArgument booleanArgument2 = null;
        BooleanArgument booleanArgument3 = null;
        BooleanArgument booleanArgument4 = null;
        BooleanArgument booleanArgument5 = null;
        BooleanArgument booleanArgument6 = null;
        BooleanArgument booleanArgument7 = null;
        BooleanArgument booleanArgument8 = null;
        BooleanArgument booleanArgument9 = null;
        FileBasedArgument fileBasedArgument = null;
        FileBasedArgument fileBasedArgument2 = null;
        FileBasedArgument fileBasedArgument3 = null;
        IntegerArgument integerArgument = null;
        IntegerArgument integerArgument2 = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        StringArgument stringArgument3 = null;
        StringArgument stringArgument4 = null;
        StringArgument stringArgument5 = null;
        StringArgument stringArgument6 = null;
        StringArgument stringArgument7 = null;
        StringArgument stringArgument8 = null;
        StringArgument stringArgument9 = null;
        StringArgument stringArgument10 = null;
        StringArgument stringArgument11 = null;
        InputStreamReader inputStreamReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = MessageHandler.getMessage(10486450);
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, string, false, true, 0, 1, "\"DN\"");
        try {
            stringArgument6 = new StringArgument("host", Character.valueOf('h'), "host", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
            argumentParser.addArgument(stringArgument6);
            integerArgument = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
            argumentParser.addArgument(integerArgument);
            booleanArgument8 = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
            argumentParser.addArgument(booleanArgument8);
            booleanArgument6 = new BooleanArgument("startTLS", Character.valueOf('q'), "startTLS", 10485886, new Object[0]);
            argumentParser.addArgument(booleanArgument6);
            stringArgument = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 0xA00070, new Object[0]);
            argumentParser.addArgument(stringArgument);
            stringArgument2 = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            fileBasedArgument = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFilename}", null, null, 10485874, new Object[0]);
            argumentParser.addArgument(fileBasedArgument);
            stringArgument5 = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, "{filename}", null, null, 0xA00080, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            booleanArgument4 = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", 10485887, new Object[0]);
            argumentParser.addArgument(booleanArgument4);
            stringArgument9 = new StringArgument("saslOptions", Character.valueOf('o'), "saslOptions", false, true, true, "{name=value}", null, null, 10485942, new Object[0]);
            argumentParser.addArgument(stringArgument9);
            booleanArgument7 = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
            argumentParser.addArgument(booleanArgument7);
            stringArgument7 = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
            argumentParser.addArgument(stringArgument7);
            stringArgument8 = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
            argumentParser.addArgument(stringArgument8);
            fileBasedArgument2 = new FileBasedArgument("keyStorePasswordFile", null, "keyStorePasswordFile", false, false, "{path}", null, null, 10486480, new Object[0]);
            argumentParser.addArgument(fileBasedArgument2);
            stringArgument10 = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
            argumentParser.addArgument(stringArgument10);
            stringArgument11 = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486481, new Object[0]);
            argumentParser.addArgument(stringArgument11);
            fileBasedArgument3 = new FileBasedArgument("trustStorePasswordFile", null, "trustStorePasswordFile", false, false, "{path}", null, null, 10486482, new Object[0]);
            argumentParser.addArgument(fileBasedArgument3);
            booleanArgument2 = new BooleanArgument("deleteSubtree", Character.valueOf('x'), "deleteSubtree", 10485889, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            stringArgument3 = new StringArgument("controls", Character.valueOf('J'), "controls", false, false, true, "{controloid[:criticality[:value|::b64value|:<fileurl]]}", null, null, 10485883, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            integerArgument2 = new IntegerArgument("version", Character.valueOf('V'), "version", false, false, true, "{version}", 3, null, 10485960, new Object[0]);
            argumentParser.addArgument(integerArgument2);
            stringArgument4 = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, "{encoding}", null, null, 10485875, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            booleanArgument = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", 10485884, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            booleanArgument3 = new BooleanArgument("no-op", Character.valueOf('n'), "noop", 10486087, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            booleanArgument9 = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            argumentParser.addArgument(booleanArgument9);
            booleanArgument5 = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
            argumentParser.addArgument(booleanArgument5);
            argumentParser.setUsageArgument(booleanArgument5, printStream);
        }
        catch (ArgumentException argumentException) {
            int n = 10747920;
            String string2 = MessageHandler.getMessage(n, argumentException.getMessage());
            printStream2.println(StaticUtils.wrapText(string2, 79));
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n = 10747921;
            String string3 = MessageHandler.getMessage(n, argumentException.getMessage());
            printStream2.println(StaticUtils.wrapText(string3, 79));
            printStream2.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument5.isPresent()) {
            return 0;
        }
        if (stringArgument2.isPresent() && fileBasedArgument.isPresent()) {
            int n = 10748606;
            String string4 = MessageHandler.getMessage(n, stringArgument2.getLongIdentifier(), fileBasedArgument.getLongIdentifier());
            printStream2.println(StaticUtils.wrapText(string4, 79));
            return 1;
        }
        String string5 = stringArgument6.getValue();
        int n = 389;
        try {
            n = integerArgument.getIntValue();
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            return 1;
        }
        try {
            int n2 = integerArgument2.getIntValue();
            if (n2 != 2 && n2 != 3) {
                int n3 = 10682569;
                printStream2.println(StaticUtils.wrapText(MessageHandler.getMessage(n3, n2), 79));
                return 1;
            }
            lDAPConnectionOptions.setVersionNumber(n2);
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            return 1;
        }
        String string6 = stringArgument.getValue();
        String string7 = stringArgument5.getValue();
        String string8 = stringArgument2.getValue();
        if (string8 != null && string8.equals("-")) {
            try {
                printStream.print(MessageHandler.getMessage(10485959, string6));
                object5 = PasswordReader.readPassword();
                string8 = new String((char[])object5);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "main", exception));
                printStream2.println(StaticUtils.wrapText(exception.getMessage(), 79));
                return 1;
            }
        } else if (string8 == null) {
            string8 = fileBasedArgument.getValue();
        }
        object5 = stringArgument7.getValue();
        String string9 = stringArgument10.getValue();
        String string10 = null;
        if (stringArgument8.isPresent()) {
            string10 = stringArgument8.getValue();
        } else if (fileBasedArgument2.isPresent()) {
            string10 = fileBasedArgument2.getValue();
        }
        String string11 = null;
        if (stringArgument11.isPresent()) {
            string11 = stringArgument11.getValue();
        } else if (fileBasedArgument3.isPresent()) {
            string11 = fileBasedArgument3.getValue();
        }
        lDAPDeleteOptions.setShowOperations(booleanArgument3.isPresent());
        lDAPDeleteOptions.setVerbose(booleanArgument9.isPresent());
        lDAPDeleteOptions.setContinueOnError(booleanArgument.isPresent());
        lDAPDeleteOptions.setEncoding(stringArgument4.getValue());
        lDAPDeleteOptions.setDeleteSubtree(booleanArgument2.isPresent());
        if (stringArgument3.hasValue()) {
            object4 = stringArgument3.getValue();
            object3 = LDAPToolUtils.getControl((String)object4, printStream2);
            if (object3 == null) {
                int n4 = 10748609;
                String string12 = MessageHandler.getMessage(n4, object4);
                printStream2.println(StaticUtils.wrapText(string12, 79));
                printStream2.println(argumentParser.getUsage());
                return 1;
            }
            lDAPDeleteOptions.getControls().add((LDAPControl)object3);
        }
        if (lDAPDeleteOptions.getDeleteSubtree()) {
            object4 = new LDAPControl("1.2.840.113556.1.4.805");
            lDAPDeleteOptions.getControls().add((LDAPControl)object4);
        }
        object4 = argumentParser.getTrailingArguments();
        object3 = ((ArrayList)object4).iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            arrayList.add((String)object2);
        }
        lDAPConnectionOptions.setSASLExternal(booleanArgument4.isPresent());
        if (stringArgument9.isPresent()) {
            object3 = stringArgument9.getValues();
            object2 = ((AbstractSequentialList)object3).iterator();
            while (object2.hasNext()) {
                boolean bl2;
                object = (String)object2.next();
                if (!(((String)object).startsWith("mech=") ? !(bl2 = lDAPConnectionOptions.setSASLMechanism((String)object)) : !(bl2 = lDAPConnectionOptions.addSASLProperty((String)object)))) continue;
                return 1;
            }
        }
        lDAPConnectionOptions.setUseSSL(booleanArgument8.isPresent());
        lDAPConnectionOptions.setStartTLS(booleanArgument6.isPresent());
        if (lDAPConnectionOptions.useSASLExternal()) {
            if (!lDAPConnectionOptions.useSSL() && !lDAPConnectionOptions.useStartTLS()) {
                int n5 = 10748610;
                object2 = MessageHandler.getMessage(n5);
                printStream2.println(StaticUtils.wrapText((String)object2, 79));
                return 1;
            }
            if (object5 == null) {
                int n6 = 10748611;
                object2 = MessageHandler.getMessage(n6);
                printStream2.println(StaticUtils.wrapText((String)object2, 79));
                return 1;
            }
        }
        try {
            if (bl) {
                DirectoryServer.bootstrapClient();
            }
            object3 = null;
            if (lDAPConnectionOptions.useSSL() || lDAPConnectionOptions.useStartTLS()) {
                object3 = new SSLConnectionFactory();
                ((SSLConnectionFactory)object3).init(booleanArgument7.isPresent(), (String)object5, string10, string9, string11);
                lDAPConnectionOptions.setSSLConnectionFactory((SSLConnectionFactory)object3);
            }
            object2 = new AtomicInteger(1);
            lDAPConnection = new LDAPConnection(string5, n, lDAPConnectionOptions, printStream, printStream2);
            lDAPConnection.connectToHost(string6, string8, (AtomicInteger)object2);
            object = new LDAPDelete((AtomicInteger)object2, printStream, printStream2);
            if (string7 == null && arrayList.isEmpty()) {
                inputStreamReader = new InputStreamReader(System.in);
            } else if (string7 != null) {
                inputStreamReader = new FileReader(string7);
            }
            if (inputStreamReader != null) {
                ((LDAPDelete)object).readAndExecute(lDAPConnection, inputStreamReader, lDAPDeleteOptions);
            } else {
                ((LDAPDelete)object).readAndExecute(lDAPConnection, arrayList, lDAPDeleteOptions);
            }
        }
        catch (LDAPException lDAPException) {
            int n7;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPException));
            printStream2.println(StaticUtils.wrapText(lDAPException.getMessage(), 79));
            int n8 = n7 = lDAPException.getResultCode();
            return n8;
        }
        catch (LDAPConnectionException lDAPConnectionException) {
            int n9;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPConnectionException));
            printStream2.println(StaticUtils.wrapText(lDAPConnectionException.getMessage(), 79));
            int n10 = n9 = lDAPConnectionException.getErrorCode();
            return n10;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "main", exception));
            printStream2.println(StaticUtils.wrapText(exception.getMessage(), 79));
            int n11 = 1;
            return n11;
        }
        finally {
            if (lDAPConnection != null) {
                lDAPConnection.close();
            }
        }
        return 0;
    }
}

