/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.LDAPCompareOptions;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPCompare {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPCompare";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPCompare(AtomicInteger atomicInteger, PrintStream printStream, PrintStream printStream2) {
        this.nextMessageID = atomicInteger;
        this.out = printStream;
        this.err = printStream2;
    }

    public void readAndExecute(LDAPConnection lDAPConnection, String string, byte[] byArray, ArrayList<String> arrayList, LDAPCompareOptions lDAPCompareOptions) throws IOException, LDAPException {
        for (String string2 : arrayList) {
            this.executeCompare(lDAPConnection, string, byArray, string2, lDAPCompareOptions);
        }
    }

    public void readAndExecute(LDAPConnection lDAPConnection, String string, byte[] byArray, Reader reader, LDAPCompareOptions lDAPCompareOptions) throws IOException, LDAPException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            this.executeCompare(lDAPConnection, string, byArray, string2, lDAPCompareOptions);
        }
        bufferedReader.close();
    }

    private void executeCompare(LDAPConnection lDAPConnection, String string, byte[] byArray, String string2, LDAPCompareOptions lDAPCompareOptions) throws IOException, LDAPException {
        ArrayList<LDAPControl> arrayList = lDAPCompareOptions.getControls();
        ASN1OctetString aSN1OctetString = new ASN1OctetString(string2);
        ASN1OctetString aSN1OctetString2 = new ASN1OctetString(byArray);
        CompareRequestProtocolOp compareRequestProtocolOp = new CompareRequestProtocolOp(aSN1OctetString, string, aSN1OctetString2);
        int n = 10485867;
        this.out.println(MessageHandler.getMessage(n, string, aSN1OctetString2, aSN1OctetString));
        if (!lDAPCompareOptions.showOperations()) {
            Object object;
            LDAPMessage lDAPMessage = null;
            try {
                object = new LDAPMessage(this.nextMessageID.getAndIncrement(), compareRequestProtocolOp, arrayList);
                lDAPConnection.getASN1Writer().writeElement(((LDAPMessage)object).encode());
                ASN1Element aSN1Element = lDAPConnection.getASN1Reader().readElement();
                lDAPMessage = LDAPMessage.decode(ASN1Sequence.decodeAsSequence(aSN1Element));
            }
            catch (ASN1Exception aSN1Exception) {
                assert (Debug.debugException(CLASS_NAME, "executeCompare", aSN1Exception));
                if (!lDAPCompareOptions.continueOnError()) {
                    throw new IOException(aSN1Exception.getMessage());
                }
                n = 10485865;
                String string3 = MessageHandler.getMessage(n, "COMPARE", string2, aSN1Exception.getMessage());
                this.err.println(StaticUtils.wrapText(string3, 79));
                return;
            }
            object = lDAPMessage.getCompareResponseProtocolOp();
            int n2 = ((CompareResponseProtocolOp)object).getResultCode();
            String string4 = ((CompareResponseProtocolOp)object).getErrorMessage();
            if (n2 != 6 && n2 != 5 && !lDAPCompareOptions.continueOnError()) {
                n = 10485865;
                String string5 = MessageHandler.getMessage(n, "COMPARE", string2, string4);
                throw new LDAPException(n2, n, string5);
            }
            if (n2 == 5) {
                n = 10485868;
                this.out.println(MessageHandler.getMessage(n, string2));
            } else if (n2 == 6) {
                n = 10485869;
                this.out.println(MessageHandler.getMessage(n, string2));
            } else {
                n = 10485865;
                String string6 = MessageHandler.getMessage(n, "COMPARE", string2, string4);
                this.err.println(StaticUtils.wrapText(string6, 79));
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = LDAPCompare.mainCompare(stringArray, true, System.out, System.err);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int mainCompare(String[] stringArray) {
        return LDAPCompare.mainCompare(stringArray, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainCompare(String[] stringArray, boolean bl, OutputStream outputStream, OutputStream outputStream2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string9;
        PrintStream printStream = outputStream == null ? NullOutputStream.printStream() : new PrintStream(outputStream);
        PrintStream printStream2 = outputStream2 == null ? NullOutputStream.printStream() : new PrintStream(outputStream2);
        LDAPConnectionOptions lDAPConnectionOptions = new LDAPConnectionOptions();
        LDAPCompareOptions lDAPCompareOptions = new LDAPCompareOptions();
        LDAPConnection lDAPConnection = null;
        BooleanArgument booleanArgument = null;
        BooleanArgument booleanArgument2 = null;
        BooleanArgument booleanArgument3 = null;
        BooleanArgument booleanArgument4 = null;
        BooleanArgument booleanArgument5 = null;
        BooleanArgument booleanArgument6 = null;
        BooleanArgument booleanArgument7 = null;
        BooleanArgument booleanArgument8 = null;
        FileBasedArgument fileBasedArgument = null;
        FileBasedArgument fileBasedArgument2 = null;
        FileBasedArgument fileBasedArgument3 = null;
        IntegerArgument integerArgument = null;
        IntegerArgument integerArgument2 = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        StringArgument stringArgument3 = null;
        StringArgument stringArgument4 = null;
        StringArgument stringArgument5 = null;
        StringArgument stringArgument6 = null;
        StringArgument stringArgument7 = null;
        StringArgument stringArgument8 = null;
        StringArgument stringArgument9 = null;
        StringArgument stringArgument10 = null;
        StringArgument stringArgument11 = null;
        StringArgument stringArgument12 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        byte[] byArray = null;
        InputStreamReader inputStreamReader = null;
        String string3 = MessageHandler.getMessage(10486449);
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, string3, false, true, 1, 0, " 'attribute:value' \"DN\" ...");
        try {
            stringArgument7 = new StringArgument("host", Character.valueOf('h'), "host", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
            argumentParser.addArgument(stringArgument7);
            integerArgument = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
            argumentParser.addArgument(integerArgument);
            booleanArgument7 = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
            argumentParser.addArgument(booleanArgument7);
            booleanArgument5 = new BooleanArgument("startTLS", Character.valueOf('q'), "startTLS", 10485886, new Object[0]);
            argumentParser.addArgument(booleanArgument5);
            stringArgument2 = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 0xA00070, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument3 = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            fileBasedArgument = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFilename}", null, null, 10485874, new Object[0]);
            argumentParser.addArgument(fileBasedArgument);
            stringArgument6 = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, "{filename}", null, null, 10486173, new Object[0]);
            argumentParser.addArgument(stringArgument6);
            booleanArgument3 = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", 10485887, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            stringArgument10 = new StringArgument("saslOptions", Character.valueOf('o'), "saslOptions", false, true, true, "{name=value}", null, null, 10485942, new Object[0]);
            argumentParser.addArgument(stringArgument10);
            booleanArgument6 = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
            argumentParser.addArgument(booleanArgument6);
            stringArgument8 = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
            argumentParser.addArgument(stringArgument8);
            stringArgument9 = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
            argumentParser.addArgument(stringArgument9);
            fileBasedArgument2 = new FileBasedArgument("keyStorePasswordFile", null, "keyStorePasswordFile", false, false, "{path}", null, null, 10486480, new Object[0]);
            argumentParser.addArgument(fileBasedArgument2);
            stringArgument11 = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
            argumentParser.addArgument(stringArgument11);
            stringArgument12 = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486481, new Object[0]);
            argumentParser.addArgument(stringArgument12);
            fileBasedArgument3 = new FileBasedArgument("trustStorePasswordFile", null, "trustStorePasswordFile", false, false, "{path}", null, null, 10486482, new Object[0]);
            argumentParser.addArgument(fileBasedArgument3);
            stringArgument = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, "{filter}", null, null, 10486102, new Object[0]);
            argumentParser.addArgument(stringArgument);
            stringArgument4 = new StringArgument("controls", Character.valueOf('J'), "controls", false, false, true, "{controloid[:criticality[:value|::b64value|:<filePath]]}", null, null, 10485883, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            integerArgument2 = new IntegerArgument("version", Character.valueOf('V'), "version", false, false, true, "{version}", 3, null, 10485960, new Object[0]);
            argumentParser.addArgument(integerArgument2);
            stringArgument5 = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, "{encoding}", null, null, 10485875, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            booleanArgument = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", 10485884, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            booleanArgument2 = new BooleanArgument("no-op", Character.valueOf('n'), "noop", 10486087, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            booleanArgument8 = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            argumentParser.addArgument(booleanArgument8);
            booleanArgument4 = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
            argumentParser.addArgument(booleanArgument4);
            argumentParser.setUsageArgument(booleanArgument4, printStream);
        }
        catch (ArgumentException argumentException) {
            int n = 10747920;
            String string4 = MessageHandler.getMessage(n, argumentException.getMessage());
            printStream2.println(StaticUtils.wrapText(string4, 79));
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n = 10747921;
            String string5 = MessageHandler.getMessage(n, argumentException.getMessage());
            printStream2.println(StaticUtils.wrapText(string5, 79));
            printStream2.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument4.isPresent()) {
            return 0;
        }
        if (stringArgument3.isPresent() && fileBasedArgument.isPresent()) {
            int n = 10748606;
            String string6 = MessageHandler.getMessage(n, stringArgument3.getLongIdentifier(), fileBasedArgument.getLongIdentifier());
            printStream2.println(StaticUtils.wrapText(string6, 79));
            return 1;
        }
        ArrayList<String> arrayList2 = argumentParser.getTrailingArguments();
        if (arrayList2.isEmpty()) {
            int n = 10748607;
            String string7 = MessageHandler.getMessage(n);
            printStream2.println(StaticUtils.wrapText(string7, 79));
            return 1;
        }
        String string8 = arrayList2.remove(0);
        for (String string9 : arrayList2) {
            arrayList.add(string9);
        }
        if (arrayList.isEmpty()) {
            int n = 10748586;
            printStream2.println(StaticUtils.wrapText(MessageHandler.getMessage(n), 79));
            return 1;
        }
        int n = string8.indexOf(":");
        if (n == -1) {
            int n2 = 10748608;
            String string10 = MessageHandler.getMessage(n2, string8);
            printStream2.println(StaticUtils.wrapText(string10, 79));
            return 1;
        }
        string2 = string8.substring(0, n);
        string9 = string8.substring(n + 1, string8.length());
        if (string9.length() > 0) {
            String string11;
            char c = string9.charAt(0);
            if (c == ':') {
                string11 = string9.substring(1, string9.length());
                try {
                    byArray = Base64.decode(string11);
                }
                catch (ParseException parseException) {
                    assert (Debug.debugException(CLASS_NAME, "main", parseException));
                    int n3 = 10486433;
                    printStream2.println(StaticUtils.wrapText(MessageHandler.getMessage(n3), 79));
                    return 1;
                }
            } else if (c == '<') {
                try {
                    string11 = string9.substring(1, string9.length());
                    byArray = LDAPToolUtils.readBytesFromFile(string11, printStream2);
                }
                catch (Exception exception) {
                    int n4 = 0xA002A2;
                    printStream2.println(StaticUtils.wrapText(MessageHandler.getMessage(n4, String.valueOf(exception)), 79));
                    return 1;
                }
            } else {
                byArray = string9.getBytes();
            }
        } else {
            byArray = string9.getBytes();
        }
        String string12 = stringArgument7.getValue();
        int n5 = 389;
        try {
            n5 = integerArgument.getIntValue();
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            return 1;
        }
        try {
            int n6 = integerArgument2.getIntValue();
            if (n6 != 2 && n6 != 3) {
                int n7 = 10682569;
                printStream2.println(StaticUtils.wrapText(MessageHandler.getMessage(n7, n6), 79));
                return 1;
            }
            lDAPConnectionOptions.setVersionNumber(n6);
        }
        catch (ArgumentException argumentException) {
            assert (Debug.debugException(CLASS_NAME, "main", argumentException));
            printStream2.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            return 1;
        }
        String string13 = stringArgument2.getValue();
        String string14 = stringArgument6.getValue();
        String string15 = stringArgument3.getValue();
        if (string15 != null && string15.equals("-")) {
            try {
                printStream.print(MessageHandler.getMessage(10485959, string13));
                object4 = PasswordReader.readPassword();
                string15 = new String((char[])object4);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "main", exception));
                printStream2.println(StaticUtils.wrapText(exception.getMessage(), 79));
                return 1;
            }
        } else if (string15 == null) {
            string15 = fileBasedArgument.getValue();
        }
        object4 = stringArgument8.getValue();
        String string16 = stringArgument11.getValue();
        String string17 = null;
        if (stringArgument9.isPresent()) {
            string17 = stringArgument9.getValue();
        } else if (fileBasedArgument2.isPresent()) {
            string17 = fileBasedArgument2.getValue();
        }
        String string18 = null;
        if (stringArgument12.isPresent()) {
            string18 = stringArgument12.getValue();
        } else if (fileBasedArgument3.isPresent()) {
            string18 = fileBasedArgument3.getValue();
        }
        lDAPCompareOptions.setShowOperations(booleanArgument2.isPresent());
        lDAPCompareOptions.setVerbose(booleanArgument8.isPresent());
        lDAPCompareOptions.setContinueOnError(booleanArgument.isPresent());
        lDAPCompareOptions.setEncoding(stringArgument5.getValue());
        if (stringArgument4.hasValue()) {
            object3 = stringArgument4.getValue();
            object2 = LDAPToolUtils.getControl((String)object3, printStream2);
            if (object2 == null) {
                int n8 = 10748609;
                String string19 = MessageHandler.getMessage(n8, object3);
                printStream2.println(StaticUtils.wrapText(string19, 79));
                printStream2.println(argumentParser.getUsage());
                return 1;
            }
            lDAPCompareOptions.getControls().add((LDAPControl)object2);
        }
        if (stringArgument.isPresent()) {
            object3 = stringArgument.getValue();
            try {
                object2 = LDAPFilter.decode((String)object3);
                object = new LDAPControl("1.3.6.1.1.12", true, new ASN1OctetString(((LDAPFilter)object2).encode().encode()));
                lDAPCompareOptions.getControls().add((LDAPControl)object);
            }
            catch (LDAPException lDAPException) {
                int n9 = 10682711;
                String string20 = MessageHandler.getMessage(n9, lDAPException.getMessage());
                printStream2.println(StaticUtils.wrapText(string20, 79));
                return 1;
            }
        }
        lDAPConnectionOptions.setSASLExternal(booleanArgument3.isPresent());
        if (stringArgument10.isPresent()) {
            object3 = stringArgument10.getValues();
            object2 = ((AbstractSequentialList)object3).iterator();
            while (object2.hasNext()) {
                boolean bl2;
                object = (String)object2.next();
                if (!(((String)object).startsWith("mech=") ? !(bl2 = lDAPConnectionOptions.setSASLMechanism((String)object)) : !(bl2 = lDAPConnectionOptions.addSASLProperty((String)object)))) continue;
                return 1;
            }
        }
        lDAPConnectionOptions.setUseSSL(booleanArgument7.isPresent());
        lDAPConnectionOptions.setStartTLS(booleanArgument5.isPresent());
        if (lDAPConnectionOptions.useSASLExternal()) {
            if (!lDAPConnectionOptions.useSSL() && !lDAPConnectionOptions.useStartTLS()) {
                int n10 = 10748610;
                object2 = MessageHandler.getMessage(n10);
                printStream2.println(StaticUtils.wrapText((String)object2, 79));
                return 1;
            }
            if (object4 == null) {
                int n11 = 10748611;
                object2 = MessageHandler.getMessage(n11);
                printStream2.println(StaticUtils.wrapText((String)object2, 79));
                return 1;
            }
        }
        try {
            if (bl) {
                DirectoryServer.bootstrapClient();
            }
            object3 = null;
            if (lDAPConnectionOptions.useSSL() || lDAPConnectionOptions.useStartTLS()) {
                object3 = new SSLConnectionFactory();
                ((SSLConnectionFactory)object3).init(booleanArgument6.isPresent(), (String)object4, string17, string16, string18);
                lDAPConnectionOptions.setSSLConnectionFactory((SSLConnectionFactory)object3);
            }
            object2 = new AtomicInteger(1);
            lDAPConnection = new LDAPConnection(string12, n5, lDAPConnectionOptions, printStream, printStream2);
            lDAPConnection.connectToHost(string13, string15, (AtomicInteger)object2);
            object = new LDAPCompare((AtomicInteger)object2, printStream, printStream2);
            if (string14 == null && arrayList.isEmpty()) {
                inputStreamReader = new InputStreamReader(System.in);
            } else if (string14 != null) {
                inputStreamReader = new FileReader(string14);
            }
            if (inputStreamReader != null) {
                ((LDAPCompare)object).readAndExecute(lDAPConnection, string2, byArray, inputStreamReader, lDAPCompareOptions);
            } else {
                ((LDAPCompare)object).readAndExecute(lDAPConnection, string2, byArray, arrayList, lDAPCompareOptions);
            }
        }
        catch (LDAPException lDAPException) {
            int n12;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPException));
            printStream2.println(StaticUtils.wrapText(lDAPException.getMessage(), 79));
            int n13 = n12 = lDAPException.getResultCode();
            return n13;
        }
        catch (LDAPConnectionException lDAPConnectionException) {
            int n14;
            assert (Debug.debugException(CLASS_NAME, "main", lDAPConnectionException));
            printStream2.println(StaticUtils.wrapText(lDAPConnectionException.getMessage(), 79));
            int n15 = n14 = lDAPConnectionException.getErrorCode();
            return n15;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "main", exception));
            printStream2.println(StaticUtils.wrapText(exception.getMessage(), 79));
            int n16 = 1;
            return n16;
        }
        finally {
            if (lDAPConnection != null) {
                lDAPConnection.close();
            }
        }
        return 0;
    }
}

