/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.LinkedList;
import org.opends.server.api.ConfigHandler;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.extensions.SaltedSHA512PasswordStorageScheme;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class ConfigureDS {
    private static final String CLASS_NAME = "org.opends.server.tools.ConfigureDS";
    private static final String DN_JE_BACKEND = "ds-cfg-backend-id=userRoot,cn=Backends,cn=config";
    private static final String DN_LDAP_CONNECTION_HANDLER = "cn=LDAP Connection Handler,cn=Connection Handlers,cn=config";
    private static final String DN_ROOT_USER = "cn=Directory Manager,cn=Root DNs,cn=config";

    public static void main(String[] stringArray) {
        int n = ConfigureDS.configMain(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int configMain(String[] stringArray) {
        BooleanArgument booleanArgument;
        FileBasedArgument fileBasedArgument;
        StringArgument stringArgument;
        StringArgument stringArgument2;
        StringArgument stringArgument3;
        IntegerArgument integerArgument;
        StringArgument stringArgument4;
        StringArgument stringArgument5;
        String string = MessageHandler.getMessage(10486444);
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, string, false);
        try {
            stringArgument5 = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, "{configFile}", null, null, 10486222, new Object[0]);
            stringArgument5.setHidden(true);
            argumentParser.addArgument(stringArgument5);
            stringArgument4 = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 10486223, new Object[0]);
            stringArgument4.setHidden(true);
            argumentParser.addArgument(stringArgument4);
            integerArgument = new IntegerArgument("ldapport", Character.valueOf('p'), "ldapPort", false, false, true, "{ldapPort}", 389, null, true, 1, true, 65535, 10486224, new Object[0]);
            argumentParser.addArgument(integerArgument);
            stringArgument3 = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", "dc=example,dc=com", null, 10486225, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            stringArgument2 = new StringArgument("rootdn", Character.valueOf('D'), "rootDN", false, false, true, "{rootUserDN}", "cn=Directory Manager", null, 10486226, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument = new StringArgument("rootpw", Character.valueOf('w'), "rootPassword", false, false, true, "{rootUserPW}", null, null, 10486227, new Object[0]);
            argumentParser.addArgument(stringArgument);
            fileBasedArgument = new FileBasedArgument("rootpwfile", Character.valueOf('W'), "rootPasswordFile", false, false, "{filename}", null, null, 10486228, new Object[0]);
            argumentParser.addArgument(fileBasedArgument);
            booleanArgument = new BooleanArgument("showusage", Character.valueOf('H'), "help", 10486229, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            argumentParser.setUsageArgument(booleanArgument);
        }
        catch (ArgumentException argumentException) {
            int n = 10748374;
            String string2 = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(StaticUtils.wrapText(string2, 79));
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n = 10748375;
            String string3 = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(StaticUtils.wrapText(string3, 79));
            System.err.println(argumentParser.getUsage());
            return 89;
        }
        if (booleanArgument.isPresent()) {
            return 0;
        }
        if (!(stringArgument3.isPresent() || integerArgument.isPresent() || stringArgument2.isPresent())) {
            int n = 10748387;
            String string4 = MessageHandler.getMessage(n);
            System.err.println(StaticUtils.wrapText(string4, 79));
            System.err.println(argumentParser.getUsage());
            return 1;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapClient();
        try {
            directoryServer.initializeJMX();
        }
        catch (Exception exception) {
            int n = 10748377;
            String string5 = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string5, 79));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(stringArgument4.getValue(), stringArgument5.getValue());
        }
        catch (Exception exception) {
            int n = 10748378;
            String string6 = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string6, 79));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (Exception exception) {
            int n = 10748379;
            String string7 = MessageHandler.getMessage(n, String.valueOf(stringArgument5.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string7, 79));
            return 1;
        }
        String string8 = LockFileManager.getServerLockFileName();
        StringBuilder stringBuilder = new StringBuilder();
        if (!LockFileManager.acquireExclusiveLock(string8, stringBuilder)) {
            int n = 10748376;
            String string9 = MessageHandler.getMessage(n, String.valueOf(string8), String.valueOf(stringBuilder));
            System.err.println(StaticUtils.wrapText(string9, 79));
            return 1;
        }
        try {
            ConfigAttribute configAttribute;
            int n;
            Object object;
            DN dN;
            String string102;
            LinkedList<DN> linkedList = null;
            if (stringArgument3.isPresent()) {
                linkedList = new LinkedList<DN>();
                for (String string102 : stringArgument3.getValues()) {
                    try {
                        linkedList.add(DN.decode(string102));
                    }
                    catch (DirectoryException directoryException) {
                        int n2 = 10748380;
                        String string11 = MessageHandler.getMessage(n2, String.valueOf(string102), directoryException.getErrorMessage());
                        System.err.println(StaticUtils.wrapText(string11, 79));
                        int n3 = 1;
                        LockFileManager.releaseLock(string8, stringBuilder);
                        return n3;
                    }
                }
            }
            Object object2 = null;
            string102 = null;
            if (stringArgument2.isPresent()) {
                try {
                    object2 = DN.decode(stringArgument2.getValue());
                }
                catch (DirectoryException directoryException) {
                    int n4 = 10748381;
                    String string12 = MessageHandler.getMessage(n4, String.valueOf(stringArgument2.getValue()), directoryException.getErrorMessage());
                    System.err.println(StaticUtils.wrapText(string12, 79));
                    int n5 = 1;
                    LockFileManager.releaseLock(string8, stringBuilder);
                    return n5;
                }
                if (stringArgument.isPresent()) {
                    string102 = stringArgument.getValue();
                } else if (fileBasedArgument.isPresent()) {
                    string102 = fileBasedArgument.getValue();
                } else {
                    int n6 = 10748382;
                    String string13 = MessageHandler.getMessage(n6);
                    System.err.println(StaticUtils.wrapText(string13, 79));
                    int n7 = 1;
                    return n7;
                }
            }
            ConfigHandler configHandler = directoryServer.getConfigHandler();
            if (linkedList != null) {
                try {
                    dN = DN.decode(DN_JE_BACKEND);
                    object = configHandler.getConfigEntry(dN);
                    n = 0x300131;
                    configAttribute = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n), true, true, false, linkedList);
                    ((ConfigEntry)object).putConfigAttribute(configAttribute);
                }
                catch (Exception exception) {
                    int n8 = 10748383;
                    String string14 = MessageHandler.getMessage(n8, String.valueOf(exception));
                    System.err.println(StaticUtils.wrapText(string14, 79));
                    int n9 = 1;
                    LockFileManager.releaseLock(string8, stringBuilder);
                    return n9;
                }
            }
            if (integerArgument.isPresent()) {
                try {
                    dN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                    object = configHandler.getConfigEntry(dN);
                    n = 2097368;
                    configAttribute = new IntegerConfigAttribute("ds-cfg-listen-port", MessageHandler.getMessage(n), true, false, true, true, 1L, true, 65535L, integerArgument.getIntValue());
                    ((ConfigEntry)object).putConfigAttribute(configAttribute);
                }
                catch (Exception exception) {
                    int n10 = 10748384;
                    String string15 = MessageHandler.getMessage(n10, String.valueOf(exception));
                    System.err.println(StaticUtils.wrapText(string15, 79));
                    int n11 = 1;
                    LockFileManager.releaseLock(string8, stringBuilder);
                    return n11;
                }
            }
            if (object2 != null) {
                try {
                    dN = DN.decode(DN_ROOT_USER);
                    object = configHandler.getConfigEntry(dN);
                    n = 3146268;
                    configAttribute = new DNConfigAttribute("ds-cfg-alternate-bind-dn", MessageHandler.getMessage(n), false, true, false, (DN)object2);
                    ((ConfigEntry)object).putConfigAttribute(configAttribute);
                    byte[] byArray = StaticUtils.getBytes(string102);
                    String string16 = SaltedSHA512PasswordStorageScheme.encodeOffline(byArray);
                    StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("userpassword", "", false, false, false, string16);
                    ((ConfigEntry)object).putConfigAttribute(stringConfigAttribute);
                }
                catch (Exception exception) {
                    int n12 = 10748385;
                    String string17 = MessageHandler.getMessage(n12, String.valueOf(exception));
                    System.err.println(StaticUtils.wrapText(string17, 79));
                    int n13 = 1;
                    LockFileManager.releaseLock(string8, stringBuilder);
                    return n13;
                }
            }
            try {
                configHandler.writeUpdatedConfig();
                int n14 = 10486244;
                object = MessageHandler.getMessage(n14);
                System.out.println(StaticUtils.wrapText((String)object, 79));
            }
            catch (DirectoryException directoryException) {
                int n15 = 10748386;
                String string18 = MessageHandler.getMessage(n15, directoryException.getErrorMessage());
                System.err.println(StaticUtils.wrapText(string18, 79));
                int n16 = 1;
                LockFileManager.releaseLock(string8, stringBuilder);
                return n16;
            }
        }
        finally {
            LockFileManager.releaseLock(string8, stringBuilder);
        }
        return 0;
    }
}

