/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.synchronization.AckMessage;
import org.opends.server.synchronization.AddMsg;
import org.opends.server.synchronization.ChangelogStartMessage;
import org.opends.server.synchronization.DeleteMsg;
import org.opends.server.synchronization.ModifyDNMsg;
import org.opends.server.synchronization.ModifyMsg;
import org.opends.server.synchronization.ServerStartMessage;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.synchronization.WindowMessage;

public abstract class SynchronizationMessage
implements Serializable {
    static final byte MSG_TYPE_MODIFY_REQUEST = 1;
    static final byte MSG_TYPE_ADD_REQUEST = 2;
    static final byte MSG_TYPE_DELETE_REQUEST = 3;
    static final byte MSG_TYPE_MODIFYDN_REQUEST = 4;
    static final byte MSG_TYPE_ACK = 5;
    static final byte MSG_TYPE_SERVER_START = 6;
    static final byte MSG_TYPE_CHANGELOG_START = 7;
    static final byte MSG_TYPE_WINDOW = 8;

    public abstract UpdateMessage processReceive(SynchronizationDomain var1);

    public abstract byte[] getBytes();

    public static SynchronizationMessage generateMsg(byte[] byArray) throws DataFormatException, UnsupportedEncodingException {
        SynchronizationMessage synchronizationMessage = null;
        switch (byArray[0]) {
            case 1: {
                synchronizationMessage = new ModifyMsg(byArray);
                break;
            }
            case 2: {
                synchronizationMessage = new AddMsg(byArray);
                break;
            }
            case 3: {
                synchronizationMessage = new DeleteMsg(byArray);
                break;
            }
            case 4: {
                synchronizationMessage = new ModifyDNMsg(byArray);
                break;
            }
            case 5: {
                synchronizationMessage = new AckMessage(byArray);
                break;
            }
            case 6: {
                synchronizationMessage = new ServerStartMessage(byArray);
                break;
            }
            case 7: {
                synchronizationMessage = new ChangelogStartMessage(byArray);
                break;
            }
            case 8: {
                synchronizationMessage = new WindowMessage(byArray);
                break;
            }
            default: {
                throw new DataFormatException("received message with unknown type");
            }
        }
        return synchronizationMessage;
    }

    protected int addByteArray(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray2[n] = byArray[n2];
            ++n2;
            ++n;
        }
        byArray2[n++] = 0;
        return n;
    }

    protected int getNextLength(byte[] byArray, int n) throws DataFormatException {
        int n2 = n;
        int n3 = 0;
        while (byArray[n2++] != 0) {
            if (n2 >= byArray.length) {
                throw new DataFormatException("byte[] is not a valid modify msg");
            }
            ++n3;
        }
        return n3;
    }
}

