/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public class UserPasswordEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.UserPasswordEqualityMatchingRule";

    public UserPasswordEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "ds-mr-user-password-equality";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.26027.1.4.3";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "user password matching rule";
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.26027.1.3.1";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        byte[] byArray = byteString.value();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return new ASN1OctetString(byArray2);
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }

    public ConditionResult valuesMatch(ByteString byteString, ByteString byteString2) {
        String[] stringArray;
        assert (Debug.debugEnter(CLASS_NAME, "valuesMatch", String.valueOf(byteString), String.valueOf(byteString2)));
        try {
            stringArray = UserPasswordSyntax.decodeUserPassword(byteString.stringValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "valuesMatch", exception));
            return ConditionResult.FALSE;
        }
        PasswordStorageScheme passwordStorageScheme = DirectoryServer.getPasswordStorageScheme(stringArray[0]);
        if (passwordStorageScheme == null) {
            return ConditionResult.FALSE;
        }
        if (passwordStorageScheme.passwordMatches(byteString2, new ASN1OctetString(stringArray[1]))) {
            return ConditionResult.TRUE;
        }
        return ConditionResult.FALSE;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "generateHashCode", String.valueOf(attributeValue)));
        return 1;
    }
}

