/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class UniqueMemberEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.UniqueMemberEqualityMatchingRule";

    public UniqueMemberEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "uniqueMemberMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.23";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.34";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        int n;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        String string = byteString.stringValue().trim();
        int n3 = n2 = string.length();
        int n4 = -1;
        if ((string.endsWith("'B") || string.endsWith("'b")) && (n4 = string.lastIndexOf("#'")) > 0) {
            n3 = n4;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        try {
            DN dN = DN.decode(string.substring(0, n3));
            dN.toNormalizedString(stringBuilder);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "normalizeValue", exception));
            n = 6488257;
            String string2 = MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n);
                }
                case WARN: {
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string2, n);
                    stringBuilder.append(StaticUtils.toLowerCase(string).substring(0, n3));
                    break;
                }
                default: {
                    stringBuilder.append(StaticUtils.toLowerCase(string).substring(0, n3));
                }
            }
        }
        if (n4 > 0) {
            stringBuilder.append("#'");
            int n5 = n2 - 2;
            n = 0;
            block10: for (int i = n4 + 2; i < n5; ++i) {
                char c = string.charAt(i);
                if (c == '0' || c == '1') {
                    stringBuilder.append(c);
                    continue;
                }
                int n6 = 6488258;
                String string3 = MessageHandler.getMessage(n6, string, Character.valueOf(c), i);
                switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                    case REJECT: {
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n6);
                    }
                    case WARN: {
                        if (n != 0) continue block10;
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string3, n6);
                        n = 1;
                    }
                }
            }
            stringBuilder.append("'B");
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }
}

