/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

public class ObjectIdentifierFirstComponentEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.ObjectIdentifierFirstComponentEqualityMatchingRule";

    public ObjectIdentifierFirstComponentEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "objectIdentifierFirstComponentMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.30";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.38";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        StringBuilder stringBuilder = new StringBuilder();
        StaticUtils.toLowerCase(byteString.value(), stringBuilder, true);
        int n = stringBuilder.length();
        if (n == 0) {
            if (byteString.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int i = n - 1; i > 0; --i) {
            if (stringBuilder.charAt(i) != ' ' || stringBuilder.charAt(i - 1) != ' ') continue;
            stringBuilder.delete(i, i + 1);
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        String string;
        char c;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        String string2 = byteString.stringValue();
        int n2 = string2.length();
        if (n2 == 0 || string2.charAt(0) != '(') {
            return false;
        }
        for (n = 1; n < n2 && (c = string2.charAt(n)) == ' '; ++n) {
        }
        if (n >= n2) {
            return false;
        }
        int n3 = n++;
        while (n < n2 && (c = string2.charAt(n)) != ' ') {
            ++n;
        }
        if (n >= n2) {
            return false;
        }
        String string3 = string2.substring(n3, n);
        if (string3.equals(string = byteString2.stringValue())) {
            return true;
        }
        AttributeType attributeType = DirectoryServer.getAttributeType(string3);
        if (attributeType != null) {
            AttributeType attributeType2 = DirectoryServer.getAttributeType(string);
            if (attributeType2 == null) {
                return false;
            }
            return attributeType.equals(attributeType2);
        }
        ObjectClass objectClass = DirectoryServer.getObjectClass(string3);
        if (objectClass != null) {
            ObjectClass objectClass2 = DirectoryServer.getObjectClass(string);
            if (objectClass2 == null) {
                return false;
            }
            return objectClass.equals(objectClass2);
        }
        AttributeSyntax attributeSyntax = DirectoryServer.getAttributeSyntax(string3, false);
        if (attributeSyntax != null) {
            AttributeSyntax attributeSyntax2 = DirectoryServer.getAttributeSyntax(string, false);
            if (attributeSyntax2 == null) {
                return false;
            }
            return attributeSyntax.equals(attributeSyntax2);
        }
        MatchingRule matchingRule = DirectoryServer.getMatchingRule(string3);
        if (matchingRule != null) {
            MatchingRule matchingRule2 = DirectoryServer.getMatchingRule(string);
            if (matchingRule2 == null) {
                return false;
            }
            return matchingRule.equals(matchingRule2);
        }
        NameForm nameForm = DirectoryServer.getNameForm(string3);
        if (nameForm != null) {
            NameForm nameForm2 = DirectoryServer.getNameForm(string);
            if (nameForm2 == null) {
                return false;
            }
            return nameForm.equals(nameForm2);
        }
        return false;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "generateHashCode", String.valueOf(attributeValue)));
        return 1;
    }
}

